# Generated by default/object.tt
package Paws::MediaLive::TransferringInputDeviceSummary;
  use Moose;
  has Id => (is => 'ro', isa => 'Str', request_name => 'id', traits => ['NameInRequest']);
  has Message => (is => 'ro', isa => 'Str', request_name => 'message', traits => ['NameInRequest']);
  has TargetCustomerId => (is => 'ro', isa => 'Str', request_name => 'targetCustomerId', traits => ['NameInRequest']);
  has TransferType => (is => 'ro', isa => 'Str', request_name => 'transferType', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::MediaLive::TransferringInputDeviceSummary

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::MediaLive::TransferringInputDeviceSummary object:

  $service_obj->Method(Att1 => { Id => $value, ..., TransferType => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::MediaLive::TransferringInputDeviceSummary object:

  $result = $service_obj->Method(...);
  $result->Att1->Id

=head1 DESCRIPTION

Details about the input device that is being transferred.

=head1 ATTRIBUTES


=head2 Id => Str

The unique ID of the input device.


=head2 Message => Str

The optional message that the sender has attached to the transfer.


=head2 TargetCustomerId => Str

The AWS account ID for the recipient of the input device transfer.


=head2 TransferType => Str

The type (direction) of the input device transfer.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::MediaLive>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

