# Generated by default/object.tt
package Paws::IoT::MetricDimension;
  use Moose;
  has DimensionName => (is => 'ro', isa => 'Str', request_name => 'dimensionName', traits => ['NameInRequest'], required => 1);
  has Operator => (is => 'ro', isa => 'Str', request_name => 'operator', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::IoT::MetricDimension

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::IoT::MetricDimension object:

  $service_obj->Method(Att1 => { DimensionName => $value, ..., Operator => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::IoT::MetricDimension object:

  $result = $service_obj->Method(...);
  $result->Att1->DimensionName

=head1 DESCRIPTION

The dimension of a metric.

=head1 ATTRIBUTES


=head2 B<REQUIRED> DimensionName => Str

A unique identifier for the dimension.


=head2 Operator => Str

Defines how the C<dimensionValues> of a dimension are interpreted. For
example, for dimension type TOPIC_FILTER, the C<IN> operator, a message
will be counted only if its topic matches one of the topic filters.
With C<NOT_IN> operator, a message will be counted only if it doesn't
match any of the topic filters. The operator is optional: if it's not
provided (is C<null>), it will be interpreted as C<IN>.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::IoT>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

