# Generated by default/object.tt
package Paws::Connect::Queue;
  use Moose;
  has Description => (is => 'ro', isa => 'Str');
  has HoursOfOperationId => (is => 'ro', isa => 'Str');
  has MaxContacts => (is => 'ro', isa => 'Int');
  has Name => (is => 'ro', isa => 'Str');
  has OutboundCallerConfig => (is => 'ro', isa => 'Paws::Connect::OutboundCallerConfig');
  has QueueArn => (is => 'ro', isa => 'Str');
  has QueueId => (is => 'ro', isa => 'Str');
  has Status => (is => 'ro', isa => 'Str');
  has Tags => (is => 'ro', isa => 'Paws::Connect::TagMap');

1;

### main pod documentation begin ###

=head1 NAME

Paws::Connect::Queue

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Connect::Queue object:

  $service_obj->Method(Att1 => { Description => $value, ..., Tags => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Connect::Queue object:

  $result = $service_obj->Method(...);
  $result->Att1->Description

=head1 DESCRIPTION

Contains information about a queue.

=head1 ATTRIBUTES


=head2 Description => Str

The description of the queue.


=head2 HoursOfOperationId => Str

The identifier for the hours of operation.


=head2 MaxContacts => Int

The maximum number of contacts that can be in the queue before it is
considered full.


=head2 Name => Str

The name of the queue.


=head2 OutboundCallerConfig => L<Paws::Connect::OutboundCallerConfig>

The outbound caller ID name, number, and outbound whisper flow.


=head2 QueueArn => Str

The Amazon Resource Name (ARN) for the queue.


=head2 QueueId => Str

The identifier for the queue.


=head2 Status => Str

The status of the queue.


=head2 Tags => L<Paws::Connect::TagMap>

One or more tags.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Connect>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

