# Generated by default/object.tt
package Paws::Appflow::ExecutionDetails;
  use Moose;
  has MostRecentExecutionMessage => (is => 'ro', isa => 'Str', request_name => 'mostRecentExecutionMessage', traits => ['NameInRequest']);
  has MostRecentExecutionStatus => (is => 'ro', isa => 'Str', request_name => 'mostRecentExecutionStatus', traits => ['NameInRequest']);
  has MostRecentExecutionTime => (is => 'ro', isa => 'Str', request_name => 'mostRecentExecutionTime', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Appflow::ExecutionDetails

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Appflow::ExecutionDetails object:

  $service_obj->Method(Att1 => { MostRecentExecutionMessage => $value, ..., MostRecentExecutionTime => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Appflow::ExecutionDetails object:

  $result = $service_obj->Method(...);
  $result->Att1->MostRecentExecutionMessage

=head1 DESCRIPTION

Describes the details of the flow run, including the timestamp, status,
and message.

=head1 ATTRIBUTES


=head2 MostRecentExecutionMessage => Str

Describes the details of the most recent flow run.


=head2 MostRecentExecutionStatus => Str

Specifies the status of the most recent flow run.


=head2 MostRecentExecutionTime => Str

Specifies the time of the most recent flow run.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Appflow>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

