package CPAN::Audit::DB;

use strict;
use warnings;

sub db {
    {
          'dists' => {
                       'Apache-AuthCAS' => {
                                             'advisories' => [
                                                               {
                                                                 'affected_versions' => '<0.5',
                                                                 'cves' => [
                                                                             'CVE-2007-6342'
                                                                           ],
                                                                 'description' => 'A tainted cookie could be sent by a malicious user and it would be used in an SQL query without protection against SQL injection.
',
                                                                 'distribution' => 'Apache-AuthCAS',
                                                                 'fixed_versions' => '>=0.5',
                                                                 'id' => 'CPANSA-Apache-AuthCAS-2007-01',
                                                                 'references' => [
                                                                                   'https://metacpan.org/changes/distribution/Apache-AuthCAS',
                                                                                   'https://cxsecurity.com/issue/WLB-2007120031'
                                                                                 ],
                                                                 'reported' => '2007-12-13',
                                                                 'severity' => 'high'
                                                               }
                                                             ],
                                             'main_module' => 'Apache::AuthCAS',
                                             'versions' => [
                                                             {
                                                               'date' => '2004-09-15T19:17:43',
                                                               'version' => '0.1'
                                                             },
                                                             {
                                                               'date' => '2004-09-15T20:11:40',
                                                               'version' => '0.2'
                                                             },
                                                             {
                                                               'date' => '2004-10-05T22:51:50',
                                                               'version' => '0.3'
                                                             },
                                                             {
                                                               'date' => '2004-10-13T00:45:52',
                                                               'version' => '0.4'
                                                             },
                                                             {
                                                               'date' => '2008-03-23T23:03:16',
                                                               'version' => '0.5'
                                                             }
                                                           ]
                                           },
                       'Apache-SessionX' => {
                                              'advisories' => [
                                                                {
                                                                  'affected_versions' => '<2.01',
                                                                  'description' => 'Problem in session_id validation, which allows createtion of session with invalid ids.
',
                                                                  'distribution' => 'Apache-SessionX',
                                                                  'fixed_versions' => '>=2.01',
                                                                  'id' => 'CPANSA-Apache-SessionX-2005-01',
                                                                  'references' => [
                                                                                    'https://metacpan.org/changes/distribution/Apache-SessionX'
                                                                                  ],
                                                                  'reported' => '2005-11-15'
                                                                }
                                                              ],
                                              'main_module' => 'Apache::SessionX',
                                              'versions' => [
                                                              {
                                                                'date' => '2001-11-20T15:36:53',
                                                                'version' => '2.00'
                                                              },
                                                              {
                                                                'date' => '2003-03-02T14:18:57',
                                                                'version' => '2.00'
                                                              },
                                                              {
                                                                'date' => '2005-11-15T05:21:49',
                                                                'version' => '2.01'
                                                              }
                                                            ]
                                            },
                       'App-Github-Email' => {
                                               'advisories' => [
                                                                 {
                                                                   'affected_versions' => '<0.3.3',
                                                                   'cves' => [
                                                                               'CVE-2015-7686'
                                                                             ],
                                                                   'description' => 'Insecure dependency on Email::Address.
',
                                                                   'distribution' => 'App-Github-Email',
                                                                   'fixed_versions' => '>=0.3.3',
                                                                   'id' => 'CPANSA-App-Github-Email-2018-01',
                                                                   'references' => [
                                                                                     'https://metacpan.org/changes/distribution/App-Github-Email',
                                                                                     'https://github.com/faraco/App-Github-Email/commit/b7f052280d1c8ae97bdefc106ca3cbba4aea7213'
                                                                                   ],
                                                                   'reported' => '2018-01-20'
                                                                 }
                                                               ],
                                               'main_module' => 'App::Github::Email',
                                               'versions' => [
                                                               {
                                                                 'date' => '2017-01-16T08:03:02',
                                                                 'version' => '0.0.1'
                                                               },
                                                               {
                                                                 'date' => '2017-01-16T12:56:51',
                                                                 'version' => '0.0.2'
                                                               },
                                                               {
                                                                 'date' => '2017-01-16T17:38:16',
                                                                 'version' => '0.0.3'
                                                               },
                                                               {
                                                                 'date' => '2017-03-11T10:45:23',
                                                                 'version' => '0.0.4'
                                                               },
                                                               {
                                                                 'date' => '2017-04-05T11:19:02',
                                                                 'version' => '0.0.5'
                                                               },
                                                               {
                                                                 'date' => '2017-04-15T17:35:18',
                                                                 'version' => '0.0.6'
                                                               },
                                                               {
                                                                 'date' => '2017-05-19T05:05:24',
                                                                 'version' => '0.0.7'
                                                               },
                                                               {
                                                                 'date' => '2017-12-18T14:11:19',
                                                                 'version' => '0.1.0'
                                                               },
                                                               {
                                                                 'date' => '2017-12-21T08:24:12',
                                                                 'version' => '0.1.1'
                                                               },
                                                               {
                                                                 'date' => '2018-01-15T03:18:05',
                                                                 'version' => '0.2.0'
                                                               },
                                                               {
                                                                 'date' => '2018-01-20T12:55:34',
                                                                 'version' => '0.2.1'
                                                               },
                                                               {
                                                                 'date' => '2018-08-30T16:07:18',
                                                                 'version' => '0.3.1'
                                                               },
                                                               {
                                                                 'date' => '2018-08-30T16:13:54',
                                                                 'version' => '0.3.2'
                                                               },
                                                               {
                                                                 'date' => '2018-08-31T03:49:31',
                                                                 'version' => '0.3.3'
                                                               }
                                                             ]
                                             },
                       'Archive-Tar' => {
                                          'advisories' => [
                                                            {
                                                              'affected_versions' => '<2.28',
                                                              'cves' => [
                                                                          'CVE-2018-12015'
                                                                        ],
                                                              'description' => 'In Perl through 5.26.2, the Archive::Tar module allows remote attackers to bypass a directory-traversal protection mechanism, and overwrite arbitrary files, via an archive file containing a symlink and a regular file with the same name.
',
                                                              'distribution' => 'Archive-Tar',
                                                              'id' => 'CPANSA-Archive-Tar-2018-01',
                                                              'references' => [
                                                                                'https://security-tracker.debian.org/tracker/CVE-2018-12015',
                                                                                'https://github.com/jib/archive-tar-new/commit/ae65651eab053fc6dc4590dbb863a268215c1fc5'
                                                                              ],
                                                              'reported' => '2018-06-12',
                                                              'severity' => 'medium'
                                                            }
                                                          ],
                                          'main_module' => 'Archive::Tar',
                                          'versions' => [
                                                          {
                                                            'date' => '1998-02-02T06:13:59',
                                                            'version' => '0.071'
                                                          },
                                                          {
                                                            'date' => '1998-04-10T17:07:35',
                                                            'version' => '0.072'
                                                          },
                                                          {
                                                            'date' => '1998-07-30T00:56:03',
                                                            'version' => '0.08'
                                                          },
                                                          {
                                                            'date' => '1999-01-10T02:22:23',
                                                            'version' => '0.20'
                                                          },
                                                          {
                                                            'date' => '1999-02-02T19:01:41',
                                                            'version' => '0.21'
                                                          },
                                                          {
                                                            'date' => '2000-04-28T00:37:46',
                                                            'version' => '0.22'
                                                          },
                                                          {
                                                            'date' => '2003-01-21T23:07:30',
                                                            'version' => '0.23'
                                                          },
                                                          {
                                                            'date' => '2003-03-18T17:08:50',
                                                            'version' => '0.99_01'
                                                          },
                                                          {
                                                            'date' => '2003-03-26T14:57:35',
                                                            'version' => '0.99_02'
                                                          },
                                                          {
                                                            'date' => '2003-04-28T16:01:24',
                                                            'version' => '0.99_03'
                                                          },
                                                          {
                                                            'date' => '2003-04-28T16:57:58',
                                                            'version' => '0.99_04'
                                                          },
                                                          {
                                                            'date' => '2003-04-30T12:52:19',
                                                            'version' => '0.99_05'
                                                          },
                                                          {
                                                            'date' => '2003-05-05T12:06:35',
                                                            'version' => '0.99_06'
                                                          },
                                                          {
                                                            'date' => '2003-05-31T09:27:33',
                                                            'version' => '1.00'
                                                          },
                                                          {
                                                            'date' => '2003-06-08T10:46:56',
                                                            'version' => '1.01'
                                                          },
                                                          {
                                                            'date' => '2003-06-12T09:47:58',
                                                            'version' => '1.02'
                                                          },
                                                          {
                                                            'date' => '2003-06-26T12:52:19',
                                                            'version' => '1.03'
                                                          },
                                                          {
                                                            'date' => '2003-07-27T17:07:50',
                                                            'version' => '1.04'
                                                          },
                                                          {
                                                            'date' => '2003-08-25T13:38:44',
                                                            'version' => '1.05'
                                                          },
                                                          {
                                                            'date' => '2003-10-15T14:35:12',
                                                            'version' => '1.06'
                                                          },
                                                          {
                                                            'date' => '2003-10-17T11:42:14',
                                                            'version' => '1.07'
                                                          },
                                                          {
                                                            'date' => '2004-01-05T12:59:23',
                                                            'version' => '1.08'
                                                          },
                                                          {
                                                            'date' => '2004-05-22T12:32:02',
                                                            'version' => '1.09'
                                                          },
                                                          {
                                                            'date' => '2004-06-11T19:24:06',
                                                            'version' => '1.10'
                                                          },
                                                          {
                                                            'date' => '2004-11-09T16:12:40',
                                                            'version' => '1.20'
                                                          },
                                                          {
                                                            'date' => '2004-11-10T16:04:13',
                                                            'version' => '1.21'
                                                          },
                                                          {
                                                            'date' => '2004-11-21T10:09:52',
                                                            'version' => '1.22'
                                                          },
                                                          {
                                                            'date' => '2004-12-03T15:53:06',
                                                            'version' => '1.23'
                                                          },
                                                          {
                                                            'date' => '2005-05-03T13:11:19',
                                                            'version' => '1.24'
                                                          },
                                                          {
                                                            'date' => '2005-08-20T10:14:40',
                                                            'version' => '1.25'
                                                          },
                                                          {
                                                            'date' => '2005-08-22T09:29:53',
                                                            'version' => '1.26'
                                                          },
                                                          {
                                                            'date' => '2006-01-19T13:31:53',
                                                            'version' => '1.28'
                                                          },
                                                          {
                                                            'date' => '2006-03-03T13:56:20',
                                                            'version' => '1.29'
                                                          },
                                                          {
                                                            'date' => '2006-08-02T15:00:41',
                                                            'version' => '1.30'
                                                          },
                                                          {
                                                            'date' => '2007-05-18T12:18:49',
                                                            'version' => '1.31'
                                                          },
                                                          {
                                                            'date' => '2007-05-25T09:32:48',
                                                            'version' => '1.32'
                                                          },
                                                          {
                                                            'date' => '2007-08-15T14:20:33',
                                                            'version' => '1.34'
                                                          },
                                                          {
                                                            'date' => '2007-09-16T09:13:21',
                                                            'version' => '1.36'
                                                          },
                                                          {
                                                            'date' => '2007-11-11T11:59:00',
                                                            'version' => '1.37_01'
                                                          },
                                                          {
                                                            'date' => '2007-12-24T11:02:07',
                                                            'version' => '1.38'
                                                          },
                                                          {
                                                            'date' => '2008-08-22T16:33:49',
                                                            'version' => '1.39_01'
                                                          },
                                                          {
                                                            'date' => '2008-08-25T03:56:58',
                                                            'version' => '1.39_02'
                                                          },
                                                          {
                                                            'date' => '2008-08-25T22:07:56',
                                                            'version' => '1.39_03'
                                                          },
                                                          {
                                                            'date' => '2008-09-08T12:14:37',
                                                            'version' => '1.39_04'
                                                          },
                                                          {
                                                            'date' => '2008-10-13T13:42:10',
                                                            'version' => '1.40'
                                                          },
                                                          {
                                                            'date' => '2008-12-13T17:10:15',
                                                            'version' => '1.42'
                                                          },
                                                          {
                                                            'date' => '2009-01-19T17:08:08',
                                                            'version' => '1.44'
                                                          },
                                                          {
                                                            'date' => '2009-03-05T16:10:06',
                                                            'version' => '1.46'
                                                          },
                                                          {
                                                            'date' => '2009-04-20T17:07:30',
                                                            'version' => '1.48'
                                                          },
                                                          {
                                                            'date' => '2009-06-12T12:01:54',
                                                            'version' => '1.50'
                                                          },
                                                          {
                                                            'date' => '2009-06-13T11:29:50',
                                                            'version' => '1.52'
                                                          },
                                                          {
                                                            'date' => '2009-09-10T12:13:03',
                                                            'version' => '1.54'
                                                          },
                                                          {
                                                            'date' => '2010-02-03T14:40:15',
                                                            'version' => '1.56'
                                                          },
                                                          {
                                                            'date' => '2010-02-17T21:47:16',
                                                            'version' => '1.58'
                                                          },
                                                          {
                                                            'date' => '2010-04-23T14:12:31',
                                                            'version' => '1.60'
                                                          },
                                                          {
                                                            'date' => '2010-06-28T21:02:59',
                                                            'version' => '1.62'
                                                          },
                                                          {
                                                            'date' => '2010-07-09T11:04:45',
                                                            'version' => '1.64'
                                                          },
                                                          {
                                                            'date' => '2010-07-26T08:44:00',
                                                            'version' => '1.66'
                                                          },
                                                          {
                                                            'date' => '2010-08-17T16:06:19',
                                                            'version' => '1.68'
                                                          },
                                                          {
                                                            'date' => '2010-11-15T22:02:53',
                                                            'version' => '1.70'
                                                          },
                                                          {
                                                            'date' => '2010-11-18T19:22:01',
                                                            'version' => '1.72'
                                                          },
                                                          {
                                                            'date' => '2010-12-18T21:19:51',
                                                            'version' => '1.74'
                                                          },
                                                          {
                                                            'date' => '2011-01-07T22:27:40',
                                                            'version' => '1.76'
                                                          },
                                                          {
                                                            'date' => '2011-09-08T22:13:33',
                                                            'version' => '1.78'
                                                          },
                                                          {
                                                            'date' => '2011-10-13T10:25:39',
                                                            'version' => '1.80'
                                                          },
                                                          {
                                                            'date' => '2011-11-21T12:14:43',
                                                            'version' => '1.82'
                                                          },
                                                          {
                                                            'date' => '2012-03-03T00:00:05',
                                                            'version' => '1.84'
                                                          },
                                                          {
                                                            'date' => '2012-05-24T11:38:09',
                                                            'version' => '1.86'
                                                          },
                                                          {
                                                            'date' => '2012-06-01T11:06:25',
                                                            'version' => '1.88'
                                                          },
                                                          {
                                                            'date' => '2012-09-05T18:19:00',
                                                            'version' => '1.90'
                                                          },
                                                          {
                                                            'date' => '2013-06-18T15:13:27',
                                                            'version' => '1.92'
                                                          },
                                                          {
                                                            'date' => '2013-10-22T14:28:22',
                                                            'version' => '0.93_01'
                                                          },
                                                          {
                                                            'date' => '2013-10-22T14:36:08',
                                                            'version' => '1.93_02'
                                                          },
                                                          {
                                                            'date' => '2013-10-24T18:02:48',
                                                            'version' => '1.94'
                                                          },
                                                          {
                                                            'date' => '2013-10-24T19:10:34',
                                                            'version' => '1.96'
                                                          },
                                                          {
                                                            'date' => '2014-06-14T17:12:02',
                                                            'version' => '1.98'
                                                          },
                                                          {
                                                            'date' => '2014-06-15T14:59:24',
                                                            'version' => '2.00'
                                                          },
                                                          {
                                                            'date' => '2014-09-14T18:03:23',
                                                            'version' => '2.02'
                                                          },
                                                          {
                                                            'date' => '2014-12-14T20:13:33',
                                                            'version' => '2.04'
                                                          },
                                                          {
                                                            'date' => '2016-04-24T14:05:11',
                                                            'version' => '2.06'
                                                          },
                                                          {
                                                            'date' => '2016-05-12T08:57:35',
                                                            'version' => '2.08'
                                                          },
                                                          {
                                                            'date' => '2016-07-27T12:40:29',
                                                            'version' => '2.10'
                                                          },
                                                          {
                                                            'date' => '2016-10-16T11:27:58',
                                                            'version' => '2.12'
                                                          },
                                                          {
                                                            'date' => '2016-10-20T12:38:57',
                                                            'version' => '2.14'
                                                          },
                                                          {
                                                            'date' => '2016-11-01T19:19:36',
                                                            'version' => '2.16'
                                                          },
                                                          {
                                                            'date' => '2016-11-07T13:36:15',
                                                            'version' => '2.18'
                                                          },
                                                          {
                                                            'date' => '2016-12-15T10:54:40',
                                                            'version' => '2.20'
                                                          },
                                                          {
                                                            'date' => '2016-12-16T09:46:28',
                                                            'version' => '2.22'
                                                          },
                                                          {
                                                            'date' => '2016-12-16T15:27:38',
                                                            'version' => '2.24'
                                                          },
                                                          {
                                                            'date' => '2017-05-12T12:46:05',
                                                            'version' => '2.26'
                                                          },
                                                          {
                                                            'date' => '2018-06-08T10:57:04',
                                                            'version' => '2.28'
                                                          },
                                                          {
                                                            'date' => '2018-06-19T11:55:28',
                                                            'version' => '2.30'
                                                          },
                                                          {
                                                            'date' => '2018-09-13T07:17:10',
                                                            'version' => '2.32'
                                                          }
                                                        ]
                                        },
                       'Archive-Zip' => {
                                          'advisories' => [
                                                            {
                                                              'affected_versions' => '<1.61',
                                                              'cves' => [
                                                                          'CVE-2018-10860'
                                                                        ],
                                                              'description' => 'perl-archive-zip is vulnerable to a directory traversal in Archive::Zip. It was found that the Archive::Zip module did not properly sanitize paths while extracting zip files. An attacker able to provide a specially crafted archive for processing could use this flaw to write or overwrite arbitrary files in the context of the perl interpreter.
',
                                                              'distribution' => 'Archive-Zip',
                                                              'id' => 'CPANSA-Archive-Zip-2018-01',
                                                              'references' => [
                                                                                'https://security-tracker.debian.org/tracker/CVE-2018-10860',
                                                                                'https://github.com/redhotpenguin/perl-Archive-Zip/pull/33'
                                                                              ],
                                                              'reported' => '2018-06-28',
                                                              'severity' => 'medium'
                                                            }
                                                          ],
                                          'main_module' => 'Archive::Zip',
                                          'versions' => [
                                                          {
                                                            'date' => '2000-03-22T00:10:21',
                                                            'version' => '0.06'
                                                          },
                                                          {
                                                            'date' => '2000-03-29T17:03:46',
                                                            'version' => '0.07'
                                                          },
                                                          {
                                                            'date' => '2000-06-16T16:48:41',
                                                            'version' => '0.09'
                                                          },
                                                          {
                                                            'date' => '2000-08-08T20:56:31',
                                                            'version' => '0.10'
                                                          },
                                                          {
                                                            'date' => '2001-01-17T08:06:58',
                                                            'version' => '0.11'
                                                          },
                                                          {
                                                            'date' => '2002-04-22T15:32:49',
                                                            'version' => '1.00'
                                                          },
                                                          {
                                                            'date' => '2002-05-11T02:45:20',
                                                            'version' => '1.01'
                                                          },
                                                          {
                                                            'date' => '2002-08-24T00:19:19',
                                                            'version' => '1.02'
                                                          },
                                                          {
                                                            'date' => '2002-09-03T04:40:33',
                                                            'version' => '1.03'
                                                          },
                                                          {
                                                            'date' => '2002-09-11T15:17:37',
                                                            'version' => '1.04'
                                                          },
                                                          {
                                                            'date' => '2002-09-11T19:35:26',
                                                            'version' => '1.05'
                                                          },
                                                          {
                                                            'date' => '2003-07-17T18:18:14',
                                                            'version' => '1.06'
                                                          },
                                                          {
                                                            'date' => '2003-10-20T13:59:00',
                                                            'version' => '1.07'
                                                          },
                                                          {
                                                            'date' => '2003-10-21T17:04:03',
                                                            'version' => '1.08'
                                                          },
                                                          {
                                                            'date' => '2003-11-27T18:02:03',
                                                            'version' => '1.09'
                                                          },
                                                          {
                                                            'date' => '2004-03-25T14:39:05',
                                                            'version' => '1.10'
                                                          },
                                                          {
                                                            'date' => '2004-07-05T23:25:19',
                                                            'version' => '1_11'
                                                          },
                                                          {
                                                            'date' => '2004-07-08T17:31:27',
                                                            'version' => '1.11'
                                                          },
                                                          {
                                                            'date' => '2004-07-08T19:14:46',
                                                            'version' => '1.12'
                                                          },
                                                          {
                                                            'date' => '2004-07-27T22:50:39',
                                                            'version' => '1.12_02'
                                                          },
                                                          {
                                                            'date' => '2004-07-29T15:15:49',
                                                            'version' => '1.12_03'
                                                          },
                                                          {
                                                            'date' => '2004-08-23T15:39:23',
                                                            'version' => '1.13'
                                                          },
                                                          {
                                                            'date' => '2004-10-21T15:28:12',
                                                            'version' => '1.14'
                                                          },
                                                          {
                                                            'date' => '2005-03-10T04:34:04',
                                                            'version' => '1.15_01'
                                                          },
                                                          {
                                                            'date' => '2005-03-12T15:29:48',
                                                            'version' => '1.15_02'
                                                          },
                                                          {
                                                            'date' => '2005-06-22T18:29:34',
                                                            'version' => '1.15'
                                                          },
                                                          {
                                                            'date' => '2005-07-04T17:55:17',
                                                            'version' => '1.16'
                                                          },
                                                          {
                                                            'date' => '2006-04-30T03:53:15',
                                                            'version' => '1.17_01'
                                                          },
                                                          {
                                                            'date' => '2006-05-07T02:49:30',
                                                            'version' => '1.17_02'
                                                          },
                                                          {
                                                            'date' => '2006-09-15T15:56:10',
                                                            'version' => '1.17_03'
                                                          },
                                                          {
                                                            'date' => '2006-10-24T15:06:32',
                                                            'version' => '1.17_05'
                                                          },
                                                          {
                                                            'date' => '2006-10-25T12:24:52',
                                                            'version' => '1.18'
                                                          },
                                                          {
                                                            'date' => '2007-06-05T01:50:42',
                                                            'version' => '1.20'
                                                          },
                                                          {
                                                            'date' => '2007-11-01T02:59:20',
                                                            'version' => '1.21'
                                                          },
                                                          {
                                                            'date' => '2007-11-02T01:52:47',
                                                            'version' => '1.22'
                                                          },
                                                          {
                                                            'date' => '2007-11-07T13:04:41',
                                                            'version' => '1.23'
                                                          },
                                                          {
                                                            'date' => '2008-08-23T23:35:50',
                                                            'version' => '1.24'
                                                          },
                                                          {
                                                            'date' => '2008-10-10T05:28:17',
                                                            'version' => '1.25'
                                                          },
                                                          {
                                                            'date' => '2008-10-12T14:13:05',
                                                            'version' => '1.26'
                                                          },
                                                          {
                                                            'date' => '2008-12-16T13:23:21',
                                                            'version' => '1.27_01'
                                                          },
                                                          {
                                                            'date' => '2009-06-16T10:09:03',
                                                            'version' => '1.28'
                                                          },
                                                          {
                                                            'date' => '2009-06-29T13:27:17',
                                                            'version' => '1.29'
                                                          },
                                                          {
                                                            'date' => '2009-06-30T14:13:29',
                                                            'version' => '1.30'
                                                          },
                                                          {
                                                            'date' => '2010-03-05T05:11:20',
                                                            'version' => '1.31_01'
                                                          },
                                                          {
                                                            'date' => '2011-03-08T15:52:02',
                                                            'version' => '1.31_02'
                                                          },
                                                          {
                                                            'date' => '2011-08-23T03:42:14',
                                                            'version' => '1.31_03'
                                                          },
                                                          {
                                                            'date' => '2012-01-23T06:28:16',
                                                            'version' => '1.31_04'
                                                          },
                                                          {
                                                            'date' => '2013-11-09T00:05:06',
                                                            'version' => '1.32'
                                                          },
                                                          {
                                                            'date' => '2013-11-10T03:50:45',
                                                            'version' => '1.33'
                                                          },
                                                          {
                                                            'date' => '2013-12-02T22:16:54',
                                                            'version' => '1.34'
                                                          },
                                                          {
                                                            'date' => '2013-12-30T19:16:52',
                                                            'version' => '1.35'
                                                          },
                                                          {
                                                            'date' => '2013-12-30T22:12:14',
                                                            'version' => '1.36'
                                                          },
                                                          {
                                                            'date' => '2014-01-13T18:32:19',
                                                            'version' => '1.37'
                                                          },
                                                          {
                                                            'date' => '2014-09-02T23:23:11',
                                                            'version' => '1.38'
                                                          },
                                                          {
                                                            'date' => '2014-10-22T04:17:15',
                                                            'version' => '1.39'
                                                          },
                                                          {
                                                            'date' => '2015-01-05T05:58:46',
                                                            'version' => '1.40'
                                                          },
                                                          {
                                                            'date' => '2015-01-10T02:47:42',
                                                            'version' => '1.41'
                                                          },
                                                          {
                                                            'date' => '2015-01-12T00:46:36',
                                                            'version' => '1.42'
                                                          },
                                                          {
                                                            'date' => '2015-01-15T06:37:32',
                                                            'version' => '1.43'
                                                          },
                                                          {
                                                            'date' => '2015-01-24T06:12:21',
                                                            'version' => '1.44'
                                                          },
                                                          {
                                                            'date' => '2015-01-27T07:51:17',
                                                            'version' => '1.45'
                                                          },
                                                          {
                                                            'date' => '2015-03-25T05:19:23',
                                                            'version' => '1.46'
                                                          },
                                                          {
                                                            'date' => '2015-06-17T18:26:02',
                                                            'version' => '1.47'
                                                          },
                                                          {
                                                            'date' => '2015-06-18T21:13:37',
                                                            'version' => '1.48'
                                                          },
                                                          {
                                                            'date' => '2015-07-31T19:01:40',
                                                            'version' => '1.49'
                                                          },
                                                          {
                                                            'date' => '2015-08-26T00:11:35',
                                                            'version' => '1.50'
                                                          },
                                                          {
                                                            'date' => '2015-09-22T06:03:54',
                                                            'version' => '1.51'
                                                          },
                                                          {
                                                            'date' => '2015-09-23T17:43:44',
                                                            'version' => '1.53'
                                                          },
                                                          {
                                                            'date' => '2015-12-04T19:36:41',
                                                            'version' => '1.55'
                                                          },
                                                          {
                                                            'date' => '2015-12-17T18:29:06',
                                                            'version' => '1.56'
                                                          },
                                                          {
                                                            'date' => '2016-04-01T18:06:36',
                                                            'version' => '1.57'
                                                          },
                                                          {
                                                            'date' => '2016-08-02T17:50:20',
                                                            'version' => '1.58'
                                                          },
                                                          {
                                                            'date' => '2016-08-11T20:09:16',
                                                            'version' => '1.59'
                                                          },
                                                          {
                                                            'date' => '2017-12-19T18:44:16',
                                                            'version' => '1.60'
                                                          },
                                                          {
                                                            'date' => '2018-08-19T03:35:10',
                                                            'version' => '1.61'
                                                          },
                                                          {
                                                            'date' => '2018-08-20T03:29:01',
                                                            'version' => '1.62'
                                                          },
                                                          {
                                                            'date' => '2018-08-22T15:42:15',
                                                            'version' => '1.63'
                                                          },
                                                          {
                                                            'date' => '2018-09-12T15:50:29',
                                                            'version' => '1.64'
                                                          }
                                                        ]
                                        },
                       'CGI' => {
                                  'advisories' => [
                                                    {
                                                      'affected_versions' => '<3.63',
                                                      'description' => 'CR escaping for Set-Cookie and P3P headers, a potential for newline injection.
',
                                                      'distribution' => 'CGI',
                                                      'fixed_versions' => '>=3.63',
                                                      'id' => 'CPANSA-CGI-2012-01',
                                                      'reported' => '2012-11-12'
                                                    },
                                                    {
                                                      'affected_versions' => '<3.56',
                                                      'cves' => [
                                                                  'CVE-2011-2766'
                                                                ],
                                                      'description' => 'Usage of deprecated FCGI.pm API.
',
                                                      'distribution' => 'CGI',
                                                      'fixed_versions' => '>=3.56',
                                                      'id' => 'CPANSA-CGI-2011-01',
                                                      'references' => [
                                                                        'https://rt.cpan.org/Public/Bug/Display.html?id=68380',
                                                                        'http://web.nvd.nist.gov/view/vuln/detail?vulnId=CVE-2011-2766'
                                                                      ],
                                                      'reported' => '2011-11-08'
                                                    },
                                                    {
                                                      'affected_versions' => '<3.50',
                                                      'description' => 'Non-random MIME boundary.
',
                                                      'distribution' => 'CGI',
                                                      'fixed_versions' => '>=3.50',
                                                      'id' => 'CPANSA-CGI-2010-02',
                                                      'reported' => '2010-11-08'
                                                    },
                                                    {
                                                      'affected_versions' => '<3.49',
                                                      'description' => 'Newlines in headers.
',
                                                      'distribution' => 'CGI',
                                                      'fixed_versions' => '>=3.49',
                                                      'id' => 'CPANSA-CGI-2010-01',
                                                      'reported' => '2010-02-05'
                                                    }
                                                  ],
                                  'main_module' => 'CGI',
                                  'versions' => [
                                                  {
                                                    'date' => '1995-11-25T09:21:00',
                                                    'version' => '2.10'
                                                  },
                                                  {
                                                    'date' => '1995-12-28T09:08:00',
                                                    'version' => '2.13'
                                                  },
                                                  {
                                                    'date' => '1996-05-22T22:30:00',
                                                    'version' => '2.20'
                                                  },
                                                  {
                                                    'date' => '1996-05-31T05:31:00',
                                                    'version' => '2.21'
                                                  },
                                                  {
                                                    'date' => '1996-08-07T09:24:00',
                                                    'version' => '2.22'
                                                  },
                                                  {
                                                    'date' => '1996-08-14T08:17:00',
                                                    'version' => '2.23'
                                                  },
                                                  {
                                                    'date' => '1996-08-21T09:09:00',
                                                    'version' => '2.24'
                                                  },
                                                  {
                                                    'date' => '1996-09-10T14:23:00',
                                                    'version' => '2.25'
                                                  },
                                                  {
                                                    'date' => '1996-10-22T11:17:00',
                                                    'version' => '2.26'
                                                  },
                                                  {
                                                    'date' => '1996-10-24T18:21:00',
                                                    'version' => '2.27'
                                                  },
                                                  {
                                                    'date' => '1996-12-02T11:48:00',
                                                    'version' => '2.28'
                                                  },
                                                  {
                                                    'date' => '1996-12-09T13:39:00',
                                                    'version' => '2.29'
                                                  },
                                                  {
                                                    'date' => '1997-01-02T16:40:00',
                                                    'version' => '2.30'
                                                  },
                                                  {
                                                    'date' => '1997-02-15T15:36:00',
                                                    'version' => '2.31'
                                                  },
                                                  {
                                                    'date' => '1997-03-25T08:58:00',
                                                    'version' => '2.32'
                                                  },
                                                  {
                                                    'date' => '1997-04-04T20:45:00',
                                                    'version' => '2.33'
                                                  },
                                                  {
                                                    'date' => '1997-04-10T15:41:00',
                                                    'version' => '2.34'
                                                  },
                                                  {
                                                    'date' => '1997-04-20T18:29:00',
                                                    'version' => '2.35'
                                                  },
                                                  {
                                                    'date' => '1997-05-09T09:33:00',
                                                    'version' => '2.36'
                                                  },
                                                  {
                                                    'date' => '1997-08-29T04:42:00',
                                                    'version' => '2.37'
                                                  },
                                                  {
                                                    'date' => '1997-09-15T17:51:00',
                                                    'version' => '2.37'
                                                  },
                                                  {
                                                    'date' => '1997-10-01T04:15:00',
                                                    'version' => '2.37'
                                                  },
                                                  {
                                                    'date' => '1997-10-12T07:10:00',
                                                    'version' => '2.37'
                                                  },
                                                  {
                                                    'date' => '1997-11-23T11:37:00',
                                                    'version' => '2.37'
                                                  },
                                                  {
                                                    'date' => '1997-12-20T09:57:00',
                                                    'version' => '2.37'
                                                  },
                                                  {
                                                    'date' => '1998-01-16T12:22:00',
                                                    'version' => '2.37'
                                                  },
                                                  {
                                                    'date' => '1998-01-19T11:34:00',
                                                    'version' => '2.37'
                                                  },
                                                  {
                                                    'date' => '1998-01-26T11:00:00',
                                                    'version' => '2.37'
                                                  },
                                                  {
                                                    'date' => '1998-01-29T19:48:00',
                                                    'version' => '2.37'
                                                  },
                                                  {
                                                    'date' => '1998-02-02T13:37:00',
                                                    'version' => '2.37'
                                                  },
                                                  {
                                                    'date' => '1998-02-05T08:25:00',
                                                    'version' => '2.37'
                                                  },
                                                  {
                                                    'date' => '1998-02-09T13:58:00',
                                                    'version' => '2.37'
                                                  },
                                                  {
                                                    'date' => '1998-02-16T16:21:00',
                                                    'version' => '2.37'
                                                  },
                                                  {
                                                    'date' => '1998-02-23T08:33:00',
                                                    'version' => '2.37'
                                                  },
                                                  {
                                                    'date' => '1998-02-24T16:52:00',
                                                    'version' => '2.37'
                                                  },
                                                  {
                                                    'date' => '1998-03-13T15:33:00',
                                                    'version' => '2.37'
                                                  },
                                                  {
                                                    'date' => '1998-03-22T21:12:00',
                                                    'version' => '2.38'
                                                  },
                                                  {
                                                    'date' => '1998-03-24T22:37:08',
                                                    'version' => '2.39'
                                                  },
                                                  {
                                                    'date' => '1998-05-20T09:17:00',
                                                    'version' => '2.40'
                                                  },
                                                  {
                                                    'date' => '1998-05-28T15:03:00',
                                                    'version' => '2.41'
                                                  },
                                                  {
                                                    'date' => '1998-06-09T09:00:00',
                                                    'version' => '2.42'
                                                  },
                                                  {
                                                    'date' => '1998-10-14T19:06:31',
                                                    'version' => '2.43'
                                                  },
                                                  {
                                                    'date' => '1998-11-24T19:41:41',
                                                    'version' => '2.44'
                                                  },
                                                  {
                                                    'date' => '1998-11-26T11:07:27',
                                                    'version' => '2.45'
                                                  },
                                                  {
                                                    'date' => '1998-12-06T10:22:46',
                                                    'version' => '2.46'
                                                  },
                                                  {
                                                    'date' => '1999-02-18T03:50:16',
                                                    'version' => '2.47'
                                                  },
                                                  {
                                                    'date' => '1999-02-19T14:10:25',
                                                    'version' => '2.48'
                                                  },
                                                  {
                                                    'date' => '1999-02-23T22:00:33',
                                                    'version' => '2.49'
                                                  },
                                                  {
                                                    'date' => '1999-06-08T15:13:15',
                                                    'version' => '2.52'
                                                  },
                                                  {
                                                    'date' => '1999-06-09T14:56:06',
                                                    'version' => '2.53'
                                                  },
                                                  {
                                                    'date' => '1999-08-09T14:18:33',
                                                    'version' => '2.54'
                                                  },
                                                  {
                                                    'date' => '1999-08-31T17:11:00',
                                                    'version' => '2.55'
                                                  },
                                                  {
                                                    'date' => '1999-09-13T21:11:51',
                                                    'version' => '2.56'
                                                  },
                                                  {
                                                    'date' => '2000-03-23T23:00:12',
                                                    'version' => '2.58'
                                                  },
                                                  {
                                                    'date' => '2000-03-24T12:31:52',
                                                    'version' => '2.59'
                                                  },
                                                  {
                                                    'date' => '2000-03-27T22:11:34',
                                                    'version' => '2.60'
                                                  },
                                                  {
                                                    'date' => '2000-03-28T02:50:18',
                                                    'version' => '2.61'
                                                  },
                                                  {
                                                    'date' => '2000-03-28T21:38:03',
                                                    'version' => '2.62'
                                                  },
                                                  {
                                                    'date' => '2000-04-10T15:19:54',
                                                    'version' => '2.63'
                                                  },
                                                  {
                                                    'date' => '2000-04-11T15:25:13',
                                                    'version' => '2.64'
                                                  },
                                                  {
                                                    'date' => '2000-04-11T15:55:40',
                                                    'version' => '2.65'
                                                  },
                                                  {
                                                    'date' => '2000-04-12T20:16:46',
                                                    'version' => '2.66'
                                                  },
                                                  {
                                                    'date' => '2000-05-16T01:38:08',
                                                    'version' => '2.67'
                                                  },
                                                  {
                                                    'date' => '2000-05-18T17:55:55',
                                                    'version' => '2.68'
                                                  },
                                                  {
                                                    'date' => '2000-07-28T03:06:11',
                                                    'version' => '2.69'
                                                  },
                                                  {
                                                    'date' => '2000-08-04T19:37:27',
                                                    'version' => '2.70'
                                                  },
                                                  {
                                                    'date' => '2000-08-13T16:09:25',
                                                    'version' => '2.71'
                                                  },
                                                  {
                                                    'date' => '2000-08-20T17:35:50',
                                                    'version' => '2.72'
                                                  },
                                                  {
                                                    'date' => '2000-08-24T13:33:37',
                                                    'version' => '3.'
                                                  },
                                                  {
                                                    'date' => '2000-09-13T02:55:51',
                                                    'version' => '2.73'
                                                  },
                                                  {
                                                    'date' => '2000-09-13T16:35:14',
                                                    'version' => '2.74'
                                                  },
                                                  {
                                                    'date' => '2001-02-02T15:43:07',
                                                    'version' => '2.75'
                                                  },
                                                  {
                                                    'date' => '2001-02-02T15:50:53',
                                                    'version' => '2.751'
                                                  },
                                                  {
                                                    'date' => '2001-02-04T23:49:27',
                                                    'version' => '2.752'
                                                  },
                                                  {
                                                    'date' => '2001-03-12T17:00:13',
                                                    'version' => '2.753'
                                                  },
                                                  {
                                                    'date' => '2001-06-15T15:33:28',
                                                    'version' => '3.02'
                                                  },
                                                  {
                                                    'date' => '2001-06-29T14:47:39',
                                                    'version' => '3.02_'
                                                  },
                                                  {
                                                    'date' => '2001-07-05T16:13:55',
                                                    'version' => '3.03_01'
                                                  },
                                                  {
                                                    'date' => '2001-07-26T21:29:22',
                                                    'version' => '2.76'
                                                  },
                                                  {
                                                    'date' => '2001-08-07T12:33:22',
                                                    'version' => '2.77'
                                                  },
                                                  {
                                                    'date' => '2001-09-26T02:26:36',
                                                    'version' => '2.78'
                                                  },
                                                  {
                                                    'date' => '2001-12-09T21:39:11',
                                                    'version' => '2.79'
                                                  },
                                                  {
                                                    'date' => '2002-01-12T02:47:17',
                                                    'version' => '2.80'
                                                  },
                                                  {
                                                    'date' => '2002-04-10T19:39:49',
                                                    'version' => '2.81'
                                                  },
                                                  {
                                                    'date' => '2002-09-11T12:27:48',
                                                    'version' => '2.84'
                                                  },
                                                  {
                                                    'date' => '2002-09-11T14:01:02',
                                                    'version' => '2.85'
                                                  },
                                                  {
                                                    'date' => '2002-09-12T03:58:40',
                                                    'version' => '2.86'
                                                  },
                                                  {
                                                    'date' => '2002-10-07T02:00:58',
                                                    'version' => '2.87'
                                                  },
                                                  {
                                                    'date' => '2002-10-14T13:58:09',
                                                    'version' => '2.88'
                                                  },
                                                  {
                                                    'date' => '2002-10-16T17:50:26',
                                                    'version' => '2.89'
                                                  },
                                                  {
                                                    'date' => '2002-11-22T23:03:39',
                                                    'version' => 0
                                                  },
                                                  {
                                                    'date' => '2003-02-10T20:11:57',
                                                    'version' => '2.90'
                                                  },
                                                  {
                                                    'date' => '2003-02-11T14:15:15',
                                                    'version' => '2.91'
                                                  },
                                                  {
                                                    'date' => '2003-04-28T00:44:10',
                                                    'version' => '2.92'
                                                  },
                                                  {
                                                    'date' => '2003-04-28T13:37:43',
                                                    'version' => '2.93'
                                                  },
                                                  {
                                                    'date' => '2003-06-09T12:15:29',
                                                    'version' => '2.94'
                                                  },
                                                  {
                                                    'date' => '2003-06-13T02:35:42',
                                                    'version' => '2.95'
                                                  },
                                                  {
                                                    'date' => '2003-06-16T18:42:38',
                                                    'version' => '2.96'
                                                  },
                                                  {
                                                    'date' => '2003-06-17T23:32:52',
                                                    'version' => '2.97'
                                                  },
                                                  {
                                                    'date' => '2003-07-16T17:06:29',
                                                    'version' => '2.98'
                                                  },
                                                  {
                                                    'date' => '2003-08-01T14:43:54',
                                                    'version' => '2.99'
                                                  },
                                                  {
                                                    'date' => '2003-08-18T17:51:48',
                                                    'version' => '3.00'
                                                  },
                                                  {
                                                    'date' => '2003-12-10T17:05:47',
                                                    'version' => '3.01'
                                                  },
                                                  {
                                                    'date' => '2004-01-13T16:34:47',
                                                    'version' => '3.03'
                                                  },
                                                  {
                                                    'date' => '2004-01-19T12:44:30',
                                                    'version' => '3.04'
                                                  },
                                                  {
                                                    'date' => '2004-04-12T20:39:57',
                                                    'version' => '3.05'
                                                  },
                                                  {
                                                    'date' => '2005-03-09T21:06:46',
                                                    'version' => '3.06'
                                                  },
                                                  {
                                                    'date' => '2005-03-14T16:34:03',
                                                    'version' => '3.07'
                                                  },
                                                  {
                                                    'date' => '2005-04-20T15:31:11',
                                                    'version' => '3.08'
                                                  },
                                                  {
                                                    'date' => '2005-05-05T20:16:55',
                                                    'version' => '3.09'
                                                  },
                                                  {
                                                    'date' => '2005-05-13T21:48:46',
                                                    'version' => '3.10'
                                                  },
                                                  {
                                                    'date' => '2005-08-03T21:17:14',
                                                    'version' => '3.11'
                                                  },
                                                  {
                                                    'date' => '2005-12-04T16:46:53',
                                                    'version' => '3.12'
                                                  },
                                                  {
                                                    'date' => '2005-12-05T13:54:26',
                                                    'version' => '3.13'
                                                  },
                                                  {
                                                    'date' => '2005-12-06T22:14:19',
                                                    'version' => '3.14'
                                                  },
                                                  {
                                                    'date' => '2005-12-07T20:16:49',
                                                    'version' => '3.15'
                                                  },
                                                  {
                                                    'date' => '2006-02-08T18:50:56',
                                                    'version' => '3.16'
                                                  },
                                                  {
                                                    'date' => '2006-02-24T19:04:58',
                                                    'version' => '3.17'
                                                  },
                                                  {
                                                    'date' => '2006-04-17T13:56:06',
                                                    'version' => '3.19'
                                                  },
                                                  {
                                                    'date' => '2006-04-23T14:27:55',
                                                    'version' => '3.20'
                                                  },
                                                  {
                                                    'date' => '2006-08-21T19:12:36',
                                                    'version' => '3.21'
                                                  },
                                                  {
                                                    'date' => '2006-08-23T15:24:41',
                                                    'version' => '3.22'
                                                  },
                                                  {
                                                    'date' => '2006-08-24T11:53:26',
                                                    'version' => '3.23'
                                                  },
                                                  {
                                                    'date' => '2006-09-28T17:09:45',
                                                    'version' => '3.25'
                                                  },
                                                  {
                                                    'date' => '2007-02-27T15:42:54',
                                                    'version' => '3.27'
                                                  },
                                                  {
                                                    'date' => '2007-03-29T15:38:01',
                                                    'version' => '3.28'
                                                  },
                                                  {
                                                    'date' => '2007-04-16T17:00:18',
                                                    'version' => '3.29'
                                                  },
                                                  {
                                                    'date' => '2007-11-30T19:06:19',
                                                    'version' => '3.31'
                                                  },
                                                  {
                                                    'date' => '2007-12-27T18:41:32',
                                                    'version' => '3.32'
                                                  },
                                                  {
                                                    'date' => '2008-01-03T15:03:17',
                                                    'version' => '3.33'
                                                  },
                                                  {
                                                    'date' => '2008-03-18T16:04:41',
                                                    'version' => '3.34'
                                                  },
                                                  {
                                                    'date' => '2008-03-27T14:26:48',
                                                    'version' => '3.35'
                                                  },
                                                  {
                                                    'date' => '2008-04-23T13:09:44',
                                                    'version' => '3.37'
                                                  },
                                                  {
                                                    'date' => '2008-06-25T14:58:32',
                                                    'version' => '3.38'
                                                  },
                                                  {
                                                    'date' => '2008-07-29T15:01:52',
                                                    'version' => '3.39'
                                                  },
                                                  {
                                                    'date' => '2008-08-06T18:21:51',
                                                    'version' => '3.40'
                                                  },
                                                  {
                                                    'date' => '2008-08-26T13:56:27',
                                                    'version' => '3.41'
                                                  },
                                                  {
                                                    'date' => '2008-09-08T14:15:41',
                                                    'version' => '3.42'
                                                  },
                                                  {
                                                    'date' => '2009-04-06T18:35:19',
                                                    'version' => '3.43'
                                                  },
                                                  {
                                                    'date' => '2009-07-30T16:34:17',
                                                    'version' => '3.44'
                                                  },
                                                  {
                                                    'date' => '2009-08-14T13:37:12',
                                                    'version' => '3.45'
                                                  },
                                                  {
                                                    'date' => '2009-09-09T15:39:42',
                                                    'version' => '3.46'
                                                  },
                                                  {
                                                    'date' => '2009-09-09T20:03:01',
                                                    'version' => '3.47'
                                                  },
                                                  {
                                                    'date' => '2009-09-25T15:07:03',
                                                    'version' => '3.48'
                                                  },
                                                  {
                                                    'date' => '2010-02-05T16:24:53',
                                                    'version' => '3.49'
                                                  },
                                                  {
                                                    'date' => '2010-11-08T21:53:26',
                                                    'version' => '3.50'
                                                  },
                                                  {
                                                    'date' => '2011-01-05T18:28:41',
                                                    'version' => '3.51'
                                                  },
                                                  {
                                                    'date' => '2011-01-25T04:30:05',
                                                    'version' => '3.52'
                                                  },
                                                  {
                                                    'date' => '2011-04-25T23:01:21',
                                                    'version' => '3.53'
                                                  },
                                                  {
                                                    'date' => '2011-04-28T14:36:41',
                                                    'version' => '3.54'
                                                  },
                                                  {
                                                    'date' => '2011-06-03T15:39:16',
                                                    'version' => '3.55'
                                                  },
                                                  {
                                                    'date' => '2011-11-09T02:00:20',
                                                    'version' => '3.56'
                                                  },
                                                  {
                                                    'date' => '2011-11-09T15:59:18',
                                                    'version' => '3.57'
                                                  },
                                                  {
                                                    'date' => '2011-11-12T03:36:07',
                                                    'version' => '3.58'
                                                  },
                                                  {
                                                    'date' => '2011-12-30T13:35:35',
                                                    'version' => '3.59'
                                                  },
                                                  {
                                                    'date' => '2012-08-16T03:21:13',
                                                    'version' => '3.60'
                                                  },
                                                  {
                                                    'date' => '2012-11-03T02:10:42',
                                                    'version' => '3.61'
                                                  },
                                                  {
                                                    'date' => '2012-11-10T01:40:50',
                                                    'version' => '3.62'
                                                  },
                                                  {
                                                    'date' => '2012-11-14T23:45:29',
                                                    'version' => '3.63'
                                                  },
                                                  {
                                                    'date' => '2013-11-24T01:22:00',
                                                    'version' => '3.64'
                                                  },
                                                  {
                                                    'date' => '2014-02-12T03:13:58',
                                                    'version' => '3.65'
                                                  },
                                                  {
                                                    'date' => '2014-05-15T12:59:58',
                                                    'version' => '3.65_01'
                                                  },
                                                  {
                                                    'date' => '2014-05-16T11:43:33',
                                                    'version' => '3.65_02'
                                                  },
                                                  {
                                                    'date' => '2014-05-20T12:31:46',
                                                    'version' => '3.65_03'
                                                  },
                                                  {
                                                    'date' => '2014-05-22T19:58:14',
                                                    'version' => '4.00'
                                                  },
                                                  {
                                                    'date' => '2014-05-27T13:13:51',
                                                    'version' => '4.01'
                                                  },
                                                  {
                                                    'date' => '2014-06-09T13:55:49',
                                                    'version' => '4.02'
                                                  },
                                                  {
                                                    'date' => '2014-07-02T14:53:06',
                                                    'version' => '4.03'
                                                  },
                                                  {
                                                    'date' => '2014-07-28T18:30:34',
                                                    'version' => '4.03_01'
                                                  },
                                                  {
                                                    'date' => '2014-07-30T14:26:40',
                                                    'version' => '4.03_02'
                                                  },
                                                  {
                                                    'date' => '2014-08-13T11:40:14',
                                                    'version' => '4.03_03'
                                                  },
                                                  {
                                                    'date' => '2014-09-04T14:42:14',
                                                    'version' => '4.04'
                                                  },
                                                  {
                                                    'date' => '2014-09-20T16:08:55',
                                                    'version' => '4.04_01'
                                                  },
                                                  {
                                                    'date' => '2014-09-28T19:57:05',
                                                    'version' => '4.04_02'
                                                  },
                                                  {
                                                    'date' => '2014-09-29T09:50:07',
                                                    'version' => '4.04_03'
                                                  },
                                                  {
                                                    'date' => '2014-10-06T12:01:14',
                                                    'version' => '4.04_04'
                                                  },
                                                  {
                                                    'date' => '2014-10-06T12:24:10',
                                                    'version' => '4.04_05'
                                                  },
                                                  {
                                                    'date' => '2014-10-08T07:42:49',
                                                    'version' => '4.05'
                                                  },
                                                  {
                                                    'date' => '2014-10-10T11:35:49',
                                                    'version' => '4.06'
                                                  },
                                                  {
                                                    'date' => '2014-10-12T16:29:35',
                                                    'version' => '4.07'
                                                  },
                                                  {
                                                    'date' => '2014-10-18T11:00:38',
                                                    'version' => '4.08'
                                                  },
                                                  {
                                                    'date' => '2014-10-21T07:33:36',
                                                    'version' => '4.09'
                                                  },
                                                  {
                                                    'date' => '2014-11-25T21:06:50',
                                                    'version' => '4.09_01'
                                                  },
                                                  {
                                                    'date' => '2014-11-27T12:53:51',
                                                    'version' => '4.10'
                                                  },
                                                  {
                                                    'date' => '2014-11-30T12:12:26',
                                                    'version' => '4.10_01'
                                                  },
                                                  {
                                                    'date' => '2014-12-03T07:25:15',
                                                    'version' => '4.11'
                                                  },
                                                  {
                                                    'date' => '2014-12-18T08:35:52',
                                                    'version' => '4.12'
                                                  },
                                                  {
                                                    'date' => '2014-12-18T09:21:52',
                                                    'version' => '4.13'
                                                  },
                                                  {
                                                    'date' => '2015-02-12T14:19:13',
                                                    'version' => '4.13_01'
                                                  },
                                                  {
                                                    'date' => '2015-02-13T08:01:29',
                                                    'version' => '4.13_02'
                                                  },
                                                  {
                                                    'date' => '2015-03-01T13:28:25',
                                                    'version' => '4.13_03'
                                                  },
                                                  {
                                                    'date' => '2015-03-08T16:09:21',
                                                    'version' => '4.13_04'
                                                  },
                                                  {
                                                    'date' => '2015-03-25T17:55:15',
                                                    'version' => '4.13_05'
                                                  },
                                                  {
                                                    'date' => '2015-04-01T06:51:57',
                                                    'version' => '4.14'
                                                  },
                                                  {
                                                    'date' => '2015-04-17T14:27:39',
                                                    'version' => '4.14_01'
                                                  },
                                                  {
                                                    'date' => '2015-04-20T07:15:45',
                                                    'version' => '4.15'
                                                  },
                                                  {
                                                    'date' => '2015-05-29T14:48:42',
                                                    'version' => '4.20'
                                                  },
                                                  {
                                                    'date' => '2015-06-22T07:50:02',
                                                    'version' => '4.21'
                                                  },
                                                  {
                                                    'date' => '2015-10-16T09:46:31',
                                                    'version' => '4.22'
                                                  },
                                                  {
                                                    'date' => '2015-12-20T18:33:35',
                                                    'version' => '4.24'
                                                  },
                                                  {
                                                    'date' => '2015-12-21T09:29:19',
                                                    'version' => '4.25'
                                                  },
                                                  {
                                                    'date' => '2016-02-04T16:37:12',
                                                    'version' => '4.26'
                                                  },
                                                  {
                                                    'date' => '2016-03-02T08:03:46',
                                                    'version' => '4.27'
                                                  },
                                                  {
                                                    'date' => '2016-03-14T07:21:48',
                                                    'version' => '4.28'
                                                  },
                                                  {
                                                    'date' => '2016-05-22T12:23:19',
                                                    'version' => '4.28_01'
                                                  },
                                                  {
                                                    'date' => '2016-05-22T12:54:23',
                                                    'version' => '4.28_02'
                                                  },
                                                  {
                                                    'date' => '2016-05-23T08:25:25',
                                                    'version' => '4.28_03'
                                                  },
                                                  {
                                                    'date' => '2016-06-09T12:01:20',
                                                    'version' => '4.29'
                                                  },
                                                  {
                                                    'date' => '2016-06-09T12:11:54',
                                                    'version' => '4.30'
                                                  },
                                                  {
                                                    'date' => '2016-06-14T07:14:00',
                                                    'version' => '4.31'
                                                  },
                                                  {
                                                    'date' => '2016-07-19T07:05:46',
                                                    'version' => '4.32'
                                                  },
                                                  {
                                                    'date' => '2016-09-16T09:47:49',
                                                    'version' => '4.33'
                                                  },
                                                  {
                                                    'date' => '2016-10-13T11:58:55',
                                                    'version' => '4.34'
                                                  },
                                                  {
                                                    'date' => '2016-10-13T13:56:21',
                                                    'version' => '4.35'
                                                  },
                                                  {
                                                    'date' => '2017-03-29T08:56:26',
                                                    'version' => '4.35_01'
                                                  },
                                                  {
                                                    'date' => '2017-04-06T14:42:12',
                                                    'version' => '4.36'
                                                  },
                                                  {
                                                    'date' => '2017-11-01T10:17:40',
                                                    'version' => '4.37'
                                                  },
                                                  {
                                                    'date' => '2017-12-01T08:41:02',
                                                    'version' => '4.38'
                                                  },
                                                  {
                                                    'date' => '2018-08-13T15:57:52',
                                                    'version' => '4.39'
                                                  },
                                                  {
                                                    'date' => '2018-08-15T08:39:39',
                                                    'version' => '4.40'
                                                  }
                                                ]
                                },
                       'CGI-Application-Dispatch' => {
                                                       'advisories' => [
                                                                         {
                                                                           'affected_versions' => '<1.02',
                                                                           'description' => 'Untainted module names.
',
                                                                           'distribution' => 'CGI-Application-Dispatch',
                                                                           'fixed_versions' => '>=1.02',
                                                                           'id' => 'CPANSA-CGI-Application-Dispatch-2005-001',
                                                                           'references' => [
                                                                                             'https://metacpan.org/changes/distribution/CGI-Application-Dispatch'
                                                                                           ],
                                                                           'reported' => '2005-01-20'
                                                                         }
                                                                       ],
                                                       'main_module' => 'CGI::Application::Dispatch',
                                                       'versions' => [
                                                                       {
                                                                         'date' => '2004-09-13T01:35:58',
                                                                         'version' => '0.01'
                                                                       },
                                                                       {
                                                                         'date' => '2004-10-19T18:26:01',
                                                                         'version' => '0.02'
                                                                       },
                                                                       {
                                                                         'date' => '2004-10-29T16:53:40',
                                                                         'version' => '0.03'
                                                                       },
                                                                       {
                                                                         'date' => '2005-01-06T15:34:49',
                                                                         'version' => '1.00'
                                                                       },
                                                                       {
                                                                         'date' => '2005-01-08T12:42:00',
                                                                         'version' => '1.01'
                                                                       },
                                                                       {
                                                                         'date' => '2005-01-20T14:43:28',
                                                                         'version' => '1.02'
                                                                       },
                                                                       {
                                                                         'date' => '2005-03-04T16:28:16',
                                                                         'version' => '1.03'
                                                                       },
                                                                       {
                                                                         'date' => '2005-07-12T21:44:54',
                                                                         'version' => '1.04'
                                                                       },
                                                                       {
                                                                         'date' => '2006-01-12T15:56:53',
                                                                         'version' => '2.00_02'
                                                                       },
                                                                       {
                                                                         'date' => '2006-02-06T15:50:52',
                                                                         'version' => '2.00_03'
                                                                       },
                                                                       {
                                                                         'date' => '2006-02-14T15:41:25',
                                                                         'version' => '2.00_04'
                                                                       },
                                                                       {
                                                                         'date' => '2006-04-12T14:18:22',
                                                                         'version' => '2.00_05'
                                                                       },
                                                                       {
                                                                         'date' => '2006-06-27T04:29:04',
                                                                         'version' => '2.00_06'
                                                                       },
                                                                       {
                                                                         'date' => '2006-07-03T15:52:12',
                                                                         'version' => '2.00'
                                                                       },
                                                                       {
                                                                         'date' => '2006-08-14T14:14:10',
                                                                         'version' => '2.01'
                                                                       },
                                                                       {
                                                                         'date' => '2006-08-17T14:57:55',
                                                                         'version' => '2.02'
                                                                       },
                                                                       {
                                                                         'date' => '2006-09-30T02:13:40',
                                                                         'version' => '2.03'
                                                                       },
                                                                       {
                                                                         'date' => '2007-01-03T18:12:57',
                                                                         'version' => '2.10_01'
                                                                       },
                                                                       {
                                                                         'date' => '2007-01-11T18:55:41',
                                                                         'version' => '2.10_02'
                                                                       },
                                                                       {
                                                                         'date' => '2007-01-15T14:08:30',
                                                                         'version' => '2.10'
                                                                       },
                                                                       {
                                                                         'date' => '2007-12-28T20:23:49',
                                                                         'version' => '2.11'
                                                                       },
                                                                       {
                                                                         'date' => '2007-12-31T20:43:51',
                                                                         'version' => '2.12_01'
                                                                       },
                                                                       {
                                                                         'date' => '2008-01-03T14:39:57',
                                                                         'version' => '2.12'
                                                                       },
                                                                       {
                                                                         'date' => '2008-03-08T18:33:34',
                                                                         'version' => '2.13_01'
                                                                       },
                                                                       {
                                                                         'date' => '2008-03-11T16:41:27',
                                                                         'version' => '2.13_02'
                                                                       },
                                                                       {
                                                                         'date' => '2008-09-17T00:44:02',
                                                                         'version' => '2.13'
                                                                       },
                                                                       {
                                                                         'date' => '2008-11-03T01:33:21',
                                                                         'version' => '2.14'
                                                                       },
                                                                       {
                                                                         'date' => '2008-12-04T16:00:05',
                                                                         'version' => '2.15'
                                                                       },
                                                                       {
                                                                         'date' => '2009-03-24T02:03:51',
                                                                         'version' => '2.16'
                                                                       },
                                                                       {
                                                                         'date' => '2009-12-30T19:06:27',
                                                                         'version' => '2.17'
                                                                       },
                                                                       {
                                                                         'date' => '2011-01-05T03:42:59',
                                                                         'version' => '2.18'
                                                                       },
                                                                       {
                                                                         'date' => '2011-06-16T17:42:14',
                                                                         'version' => '3.00'
                                                                       },
                                                                       {
                                                                         'date' => '2011-06-24T02:53:20',
                                                                         'version' => '3.01'
                                                                       },
                                                                       {
                                                                         'date' => '2011-06-24T22:33:01',
                                                                         'version' => '3.02'
                                                                       },
                                                                       {
                                                                         'date' => '2011-06-26T03:52:14',
                                                                         'version' => '3.03'
                                                                       },
                                                                       {
                                                                         'date' => '2011-06-29T13:45:53',
                                                                         'version' => '3.04'
                                                                       },
                                                                       {
                                                                         'date' => '2011-09-07T22:21:15',
                                                                         'version' => '3.05'
                                                                       },
                                                                       {
                                                                         'date' => '2011-09-09T15:29:58',
                                                                         'version' => '3.06'
                                                                       },
                                                                       {
                                                                         'date' => '2011-09-09T17:32:11',
                                                                         'version' => '3.07'
                                                                       },
                                                                       {
                                                                         'date' => '2012-09-03T04:04:19',
                                                                         'version' => '3.10'
                                                                       },
                                                                       {
                                                                         'date' => '2012-09-14T01:02:58',
                                                                         'version' => '3.11'
                                                                       },
                                                                       {
                                                                         'date' => '2012-09-14T01:19:52',
                                                                         'version' => '3.12'
                                                                       }
                                                                     ]
                                                     },
                       'CGI-Application-Plugin-AutoRunmode' => {
                                                                 'advisories' => [
                                                                                   {
                                                                                     'affected_versions' => '<0.04',
                                                                                     'description' => 'Non-word characters are allowed in runmode name.
',
                                                                                     'distribution' => 'CGI-Application-Plugin-AutoRunmode',
                                                                                     'fixed_versions' => '>=0.04',
                                                                                     'id' => 'CPANSA-CGI-Application-Plugin-AutoRunmode-2005-01',
                                                                                     'references' => [
                                                                                                       'https://metacpan.org/changes/distribution/CGI-Application-Plugin-AutoRunmode'
                                                                                                     ],
                                                                                     'reported' => '2005-03-04'
                                                                                   }
                                                                                 ],
                                                                 'main_module' => 'CGI::Application::Plugin::AutoRunmode',
                                                                 'versions' => [
                                                                                 {
                                                                                   'date' => '2005-03-04T06:59:51',
                                                                                   'version' => '0.04'
                                                                                 },
                                                                                 {
                                                                                   'date' => '2005-03-10T07:22:55',
                                                                                   'version' => '0.05'
                                                                                 },
                                                                                 {
                                                                                   'date' => '2005-06-15T10:20:17',
                                                                                   'version' => '0.06'
                                                                                 },
                                                                                 {
                                                                                   'date' => '2005-06-18T02:09:08',
                                                                                   'version' => '0.07'
                                                                                 },
                                                                                 {
                                                                                   'date' => '2005-07-17T00:49:10',
                                                                                   'version' => '0.08'
                                                                                 },
                                                                                 {
                                                                                   'date' => '2005-09-22T12:31:22',
                                                                                   'version' => '0.09'
                                                                                 },
                                                                                 {
                                                                                   'date' => '2005-10-16T00:17:47',
                                                                                   'version' => '0.10'
                                                                                 },
                                                                                 {
                                                                                   'date' => '2005-10-18T13:23:50',
                                                                                   'version' => '0.11'
                                                                                 },
                                                                                 {
                                                                                   'date' => '2005-11-03T01:10:37',
                                                                                   'version' => '0.12'
                                                                                 },
                                                                                 {
                                                                                   'date' => '2006-04-08T07:18:44',
                                                                                   'version' => '0.13'
                                                                                 },
                                                                                 {
                                                                                   'date' => '2006-05-21T05:04:48',
                                                                                   'version' => '0.14'
                                                                                 },
                                                                                 {
                                                                                   'date' => '2006-12-17T07:46:24',
                                                                                   'version' => '0.15'
                                                                                 },
                                                                                 {
                                                                                   'date' => '2009-02-14T09:16:39',
                                                                                   'version' => '0.16'
                                                                                 },
                                                                                 {
                                                                                   'date' => '2010-05-21T04:24:45',
                                                                                   'version' => '0.17'
                                                                                 },
                                                                                 {
                                                                                   'date' => '2011-02-18T09:23:15',
                                                                                   'version' => '0.18'
                                                                                 }
                                                                               ]
                                                               },
                       'CGI-Application-Plugin-RunmodeDeclare' => {
                                                                    'advisories' => [
                                                                                      {
                                                                                        'affected_versions' => '<0.03',
                                                                                        'description' => 'Wrong order of arguments.
',
                                                                                        'distribution' => 'CGI-Application-Plugin-RunmodeDeclare',
                                                                                        'fixed_versions' => '>=0.03',
                                                                                        'id' => 'CPANSA-CGI-Application-Plugin-RunmodeDeclare-2008-01',
                                                                                        'references' => [
                                                                                                          'https://metacpan.org/changes/distribution/CGI-Application-Plugin-RunmodeDeclare'
                                                                                                        ],
                                                                                        'reported' => '2008-10-20'
                                                                                      }
                                                                                    ],
                                                                    'main_module' => 'CGI::Application::Plugin::RunmodeDeclare',
                                                                    'versions' => [
                                                                                    {
                                                                                      'date' => '2008-09-26T19:59:14',
                                                                                      'version' => '0.01'
                                                                                    },
                                                                                    {
                                                                                      'date' => '2008-09-26T21:37:11',
                                                                                      'version' => '0.02'
                                                                                    },
                                                                                    {
                                                                                      'date' => '2008-10-19T23:22:06',
                                                                                      'version' => '0.03'
                                                                                    },
                                                                                    {
                                                                                      'date' => '2008-10-23T14:18:23',
                                                                                      'version' => '0.03_01'
                                                                                    },
                                                                                    {
                                                                                      'date' => '2008-10-24T13:32:43',
                                                                                      'version' => '0.03_02'
                                                                                    },
                                                                                    {
                                                                                      'date' => '2008-10-24T16:20:27',
                                                                                      'version' => '0.03_03'
                                                                                    },
                                                                                    {
                                                                                      'date' => '2008-10-25T10:54:25',
                                                                                      'version' => '0.04'
                                                                                    },
                                                                                    {
                                                                                      'date' => '2008-10-25T11:46:28',
                                                                                      'version' => '0.05'
                                                                                    },
                                                                                    {
                                                                                      'date' => '2008-10-25T16:39:34',
                                                                                      'version' => '0.06'
                                                                                    },
                                                                                    {
                                                                                      'date' => '2009-01-10T02:32:39',
                                                                                      'version' => '0.07'
                                                                                    },
                                                                                    {
                                                                                      'date' => '2009-05-17T22:29:18',
                                                                                      'version' => '0.08'
                                                                                    },
                                                                                    {
                                                                                      'date' => '2010-01-07T13:24:09',
                                                                                      'version' => '0.09'
                                                                                    },
                                                                                    {
                                                                                      'date' => '2012-02-10T00:53:54',
                                                                                      'version' => '0.10'
                                                                                    }
                                                                                  ]
                                                                  },
                       'CGI-Auth-Basic' => {
                                             'advisories' => [
                                                               {
                                                                 'affected_versions' => '<1.11',
                                                                 'description' => 'TBD
',
                                                                 'distribution' => 'CGI-Auth-Basic',
                                                                 'fixed_versions' => '>=1.11',
                                                                 'id' => 'CPANSA-CGI-Auth-Basic-2007-01',
                                                                 'references' => [
                                                                                   'https://metacpan.org/changes/distribution/CGI-Auth-Basic'
                                                                                 ],
                                                                 'reported' => '2007-12-30'
                                                               }
                                                             ],
                                             'main_module' => 'CGI::Auth::Basic',
                                             'versions' => [
                                                             {
                                                               'date' => '2004-02-21T14:58:09',
                                                               'version' => '1.0'
                                                             },
                                                             {
                                                               'date' => '2004-08-31T13:29:28',
                                                               'version' => '1.01'
                                                             },
                                                             {
                                                               'date' => '2004-11-07T03:34:32',
                                                               'version' => '1.02'
                                                             },
                                                             {
                                                               'date' => '2006-06-18T01:12:15',
                                                               'version' => '1.10'
                                                             },
                                                             {
                                                               'date' => '2007-12-30T20:53:33',
                                                               'version' => '1.11'
                                                             },
                                                             {
                                                               'date' => '2009-04-18T04:22:51',
                                                               'version' => '1.20'
                                                             },
                                                             {
                                                               'date' => '2009-04-23T17:00:50',
                                                               'version' => '1.21'
                                                             },
                                                             {
                                                               'date' => '2009-04-24T15:07:48',
                                                               'version' => '1.21'
                                                             },
                                                             {
                                                               'date' => '2012-08-27T01:50:53',
                                                               'version' => '1.22'
                                                             },
                                                             {
                                                               'date' => '2015-01-21T00:26:01',
                                                               'version' => '1.23'
                                                             },
                                                             {
                                                               'date' => '2018-12-23T21:03:03',
                                                               'version' => '1.24'
                                                             }
                                                           ]
                                           },
                       'CGI-Simple' => {
                                         'advisories' => [
                                                           {
                                                             'affected_versions' => '<1.113',
                                                             'cves' => [
                                                                         'CVE-2010-4410'
                                                                       ],
                                                             'description' => 'Newlines in headers, which could lead to header injection attacks.
',
                                                             'distribution' => 'CGI-Simple',
                                                             'fixed_versions' => '>=1.113',
                                                             'id' => 'CPANSA-CGI-Simple-2010-02',
                                                             'references' => [
                                                                               'https://metacpan.org/changes/distribution/CGI-Simple'
                                                                             ],
                                                             'reported' => '2010-12-27'
                                                           },
                                                           {
                                                             'affected_versions' => '<1.113',
                                                             'description' => 'Non-random multipart boundary.
',
                                                             'distribution' => 'CGI-Simple',
                                                             'fixed_versions' => '>=1.113',
                                                             'id' => 'CPANSA-CGI-Simple-2010-01',
                                                             'references' => [
                                                                               'https://metacpan.org/changes/distribution/CGI-Simple'
                                                                             ],
                                                             'reported' => '2010-12-27'
                                                           }
                                                         ],
                                         'main_module' => 'CGI::Simple',
                                         'versions' => [
                                                         {
                                                           'date' => '2007-01-09T22:31:27',
                                                           'version' => '0.078'
                                                         },
                                                         {
                                                           'date' => '2007-02-23T16:22:19',
                                                           'version' => '0.079'
                                                         },
                                                         {
                                                           'date' => '2007-03-30T20:15:35',
                                                           'version' => '0.080'
                                                         },
                                                         {
                                                           'date' => '2007-05-20T19:19:40',
                                                           'version' => '0.081'
                                                         },
                                                         {
                                                           'date' => '2007-05-22T18:43:01',
                                                           'version' => '0.082'
                                                         },
                                                         {
                                                           'date' => '2007-05-22T18:54:06',
                                                           'version' => '0.83'
                                                         },
                                                         {
                                                           'date' => '2007-05-24T03:15:01',
                                                           'version' => '1.0'
                                                         },
                                                         {
                                                           'date' => '2007-07-13T18:58:16',
                                                           'version' => '1.1'
                                                         },
                                                         {
                                                           'date' => '2007-07-31T01:57:01',
                                                           'version' => '1.1.1'
                                                         },
                                                         {
                                                           'date' => '2007-07-31T02:04:25',
                                                           'version' => '1.1.2'
                                                         },
                                                         {
                                                           'date' => '2007-07-31T02:10:47',
                                                           'version' => '1.103'
                                                         },
                                                         {
                                                           'date' => '2008-05-13T15:46:18',
                                                           'version' => '1.104'
                                                         },
                                                         {
                                                           'date' => '2008-05-16T14:37:31',
                                                           'version' => '1.105'
                                                         },
                                                         {
                                                           'date' => '2008-09-14T13:29:51',
                                                           'version' => '1.106'
                                                         },
                                                         {
                                                           'date' => '2009-03-07T21:24:59',
                                                           'version' => '1.107'
                                                         },
                                                         {
                                                           'date' => '2009-03-13T14:06:24',
                                                           'version' => '1.108'
                                                         },
                                                         {
                                                           'date' => '2009-04-16T17:54:13',
                                                           'version' => '1.109'
                                                         },
                                                         {
                                                           'date' => '2009-05-24T21:25:22',
                                                           'version' => '1.110'
                                                         },
                                                         {
                                                           'date' => '2009-05-28T18:02:08',
                                                           'version' => '1.111'
                                                         },
                                                         {
                                                           'date' => '2009-05-31T10:43:56',
                                                           'version' => '1.112'
                                                         },
                                                         {
                                                           'date' => '2010-12-27T13:11:56',
                                                           'version' => '1.113'
                                                         },
                                                         {
                                                           'date' => '2014-10-19T12:53:24',
                                                           'version' => '1.115'
                                                         },
                                                         {
                                                           'date' => '2018-03-01T15:09:42',
                                                           'version' => '1.13'
                                                         },
                                                         {
                                                           'date' => '2018-03-03T10:42:06',
                                                           'version' => '1.14'
                                                         },
                                                         {
                                                           'date' => '2018-03-04T03:42:20',
                                                           'version' => '1.15'
                                                         },
                                                         {
                                                           'date' => '2018-07-25T15:17:39',
                                                           'version' => '1.16'
                                                         },
                                                         {
                                                           'date' => '2018-10-02T09:48:08',
                                                           'version' => '1.17'
                                                         },
                                                         {
                                                           'date' => '2018-10-03T14:21:12',
                                                           'version' => '1.18'
                                                         },
                                                         {
                                                           'date' => '2018-10-04T12:05:58',
                                                           'version' => '1.19'
                                                         },
                                                         {
                                                           'date' => '2018-10-05T11:30:05',
                                                           'version' => '1.20'
                                                         },
                                                         {
                                                           'date' => '2018-10-06T07:21:31',
                                                           'version' => '1.21'
                                                         }
                                                       ]
                                       },
                       'CGI-apacheSSI' => {
                                            'advisories' => [
                                                              {
                                                                'affected_versions' => '<0.95',
                                                                'description' => 'Security and parsing problems with "include" calls.
',
                                                                'distribution' => 'CGI-apacheSSI',
                                                                'fixed_versions' => '>=0.95',
                                                                'id' => 'CPANSA-CGI-apacheSSI-2016-01',
                                                                'references' => [
                                                                                  'https://metacpan.org/changes/distribution/CGI-apacheSSI'
                                                                                ],
                                                                'reported' => '2016-01-31'
                                                              }
                                                            ],
                                            'main_module' => 'CGI::apacheSSI',
                                            'versions' => [
                                                            {
                                                              'date' => '2014-08-20T22:55:20',
                                                              'version' => '0.93'
                                                            },
                                                            {
                                                              'date' => '2016-01-30T12:57:47',
                                                              'version' => '0.94'
                                                            },
                                                            {
                                                              'date' => '2016-01-31T22:48:55',
                                                              'version' => '0.95'
                                                            },
                                                            {
                                                              'date' => '2016-02-01T00:36:49',
                                                              'version' => '0.96'
                                                            }
                                                          ]
                                          },
                       'CPAN' => {
                                   'advisories' => [
                                                     {
                                                       'affected_versions' => '<1.93',
                                                       'description' => 'Archive::Tar preserves permissions in the tarball; extracted file permissions will be set from users umask instead.
',
                                                       'distribution' => 'CPAN',
                                                       'fixed_versions' => '>=1.93',
                                                       'id' => 'CPANSA-CPAN-2009-01',
                                                       'references' => [
                                                                         'https://github.com/andk/cpanpm/commit/079fa2e7ee77d626eab8bb06d0465c6a05f6c8b6'
                                                                       ],
                                                       'reported' => '2009-09-23'
                                                     }
                                                   ],
                                   'main_module' => 'CPAN',
                                   'versions' => [
                                                   {
                                                     'date' => '1996-09-10T17:13:59',
                                                     'version' => '0.17'
                                                   },
                                                   {
                                                     'date' => '1996-09-10T20:51:00',
                                                     'version' => '0.20'
                                                   },
                                                   {
                                                     'date' => '1996-09-12T05:53:35',
                                                     'version' => '0.26'
                                                   },
                                                   {
                                                     'date' => '1996-09-12T14:01:39',
                                                     'version' => '0.27'
                                                   },
                                                   {
                                                     'date' => '1996-09-16T20:18:59',
                                                     'version' => '0.28'
                                                   },
                                                   {
                                                     'date' => '1996-09-17T17:14:51',
                                                     'version' => '0.29'
                                                   },
                                                   {
                                                     'date' => '1996-09-19T05:24:17',
                                                     'version' => '0.30'
                                                   },
                                                   {
                                                     'date' => '1996-09-20T10:40:01',
                                                     'version' => '0.31'
                                                   },
                                                   {
                                                     'date' => '1996-09-22T19:30:33',
                                                     'version' => '0.35'
                                                   },
                                                   {
                                                     'date' => '1996-09-23T12:55:23',
                                                     'version' => '0.36'
                                                   },
                                                   {
                                                     'date' => '1996-09-23T14:05:44',
                                                     'version' => '0.37'
                                                   },
                                                   {
                                                     'date' => '1996-09-27T12:52:07',
                                                     'version' => '0.39'
                                                   },
                                                   {
                                                     'date' => '1996-09-28T20:51:31',
                                                     'version' => '0.40'
                                                   },
                                                   {
                                                     'date' => '1996-10-01T21:14:27',
                                                     'version' => '0.41'
                                                   },
                                                   {
                                                     'date' => '1996-11-17T07:56:02',
                                                     'version' => '0.42'
                                                   },
                                                   {
                                                     'date' => '1996-11-17T14:51:59',
                                                     'version' => '0.43'
                                                   },
                                                   {
                                                     'date' => '1996-11-30T17:04:28',
                                                     'version' => '0.44'
                                                   },
                                                   {
                                                     'date' => '1996-12-01T12:19:19',
                                                     'version' => '0.45'
                                                   },
                                                   {
                                                     'date' => '1996-12-01T18:24:17',
                                                     'version' => '0.46'
                                                   },
                                                   {
                                                     'date' => '1996-12-10T00:58:25',
                                                     'version' => '1.00'
                                                   },
                                                   {
                                                     'date' => '1996-12-10T10:17:15',
                                                     'version' => '1.01'
                                                   },
                                                   {
                                                     'date' => '1996-12-11T01:31:55',
                                                     'version' => '1.02'
                                                   },
                                                   {
                                                     'date' => '1996-12-21T03:10:23',
                                                     'version' => '1.03'
                                                   },
                                                   {
                                                     'date' => '1996-12-21T20:08:49',
                                                     'version' => '1.04'
                                                   },
                                                   {
                                                     'date' => '1996-12-22T13:04:58',
                                                     'version' => '1.05'
                                                   },
                                                   {
                                                     'date' => '1996-12-22T14:16:08',
                                                     'version' => '1.06'
                                                   },
                                                   {
                                                     'date' => '1996-12-23T04:05:01',
                                                     'version' => '1.07'
                                                   },
                                                   {
                                                     'date' => '1996-12-23T13:18:01',
                                                     'version' => '1.08'
                                                   },
                                                   {
                                                     'date' => '1996-12-24T00:46:19',
                                                     'version' => '1.09'
                                                   },
                                                   {
                                                     'date' => '1997-01-17T02:29:49',
                                                     'version' => '1.09_01'
                                                   },
                                                   {
                                                     'date' => '1997-01-21T01:06:40',
                                                     'version' => '1.10'
                                                   },
                                                   {
                                                     'date' => '1997-01-22T18:50:00',
                                                     'version' => '1.11'
                                                   },
                                                   {
                                                     'date' => '1997-01-23T00:07:58',
                                                     'version' => '1.12'
                                                   },
                                                   {
                                                     'date' => '1997-01-24T01:07:44',
                                                     'version' => '1.14'
                                                   },
                                                   {
                                                     'date' => '1997-01-24T12:32:12',
                                                     'version' => '1.15'
                                                   },
                                                   {
                                                     'date' => '1997-02-02T13:51:48',
                                                     'version' => '1.16_01'
                                                   },
                                                   {
                                                     'date' => '1997-02-02T21:05:12',
                                                     'version' => '1.17'
                                                   },
                                                   {
                                                     'date' => '1997-02-03T00:38:36',
                                                     'version' => '1.18'
                                                   },
                                                   {
                                                     'date' => '1997-02-03T09:13:48',
                                                     'version' => '1.19'
                                                   },
                                                   {
                                                     'date' => '1997-02-05T09:38:00',
                                                     'version' => '1.20'
                                                   },
                                                   {
                                                     'date' => '1997-02-11T06:32:42',
                                                     'version' => '1.21'
                                                   },
                                                   {
                                                     'date' => '1997-03-13T23:14:59',
                                                     'version' => '1.22_01'
                                                   },
                                                   {
                                                     'date' => '1997-03-31T12:03:55',
                                                     'version' => '1.23'
                                                   },
                                                   {
                                                     'date' => '1997-03-31T22:47:11',
                                                     'version' => '1.24'
                                                   },
                                                   {
                                                     'date' => '1997-06-30T18:13:23',
                                                     'version' => '1.25'
                                                   },
                                                   {
                                                     'date' => '1997-07-28T13:58:09',
                                                     'version' => '1.27'
                                                   },
                                                   {
                                                     'date' => '1997-08-04T06:09:33',
                                                     'version' => '1.28'
                                                   },
                                                   {
                                                     'date' => '1997-08-11T23:33:58',
                                                     'version' => '1.29'
                                                   },
                                                   {
                                                     'date' => '1997-08-29T14:34:37',
                                                     'version' => '1.30'
                                                   },
                                                   {
                                                     'date' => '1997-09-21T08:53:03',
                                                     'version' => '1.31'
                                                   },
                                                   {
                                                     'date' => '1997-09-23T18:45:50',
                                                     'version' => '1.3101'
                                                   },
                                                   {
                                                     'date' => '1998-01-02T18:22:35',
                                                     'version' => '1.32'
                                                   },
                                                   {
                                                     'date' => '1998-01-10T18:24:23',
                                                     'version' => '1.33'
                                                   },
                                                   {
                                                     'date' => '1998-02-03T18:06:41',
                                                     'version' => '1.35'
                                                   },
                                                   {
                                                     'date' => '1998-02-08T08:55:55',
                                                     'version' => '1.36'
                                                   },
                                                   {
                                                     'date' => '1998-06-12T06:51:25',
                                                     'version' => '1.37'
                                                   },
                                                   {
                                                     'date' => '1998-06-14T20:18:08',
                                                     'version' => '1.38'
                                                   },
                                                   {
                                                     'date' => '1998-07-24T20:13:41',
                                                     'version' => '1.40'
                                                   },
                                                   {
                                                     'date' => '1998-12-01T02:20:32',
                                                     'version' => '1.41'
                                                   },
                                                   {
                                                     'date' => '1998-12-01T07:58:35',
                                                     'version' => '1.42'
                                                   },
                                                   {
                                                     'date' => '1998-12-01T22:16:27',
                                                     'version' => '1.43'
                                                   },
                                                   {
                                                     'date' => '1998-12-03T17:07:54',
                                                     'version' => '1.43'
                                                   },
                                                   {
                                                     'date' => '1999-01-09T18:38:33',
                                                     'version' => '1.44'
                                                   },
                                                   {
                                                     'date' => '1999-01-10T19:38:27',
                                                     'version' => '1.44_51'
                                                   },
                                                   {
                                                     'date' => '1999-01-13T12:15:42',
                                                     'version' => '1.44_52'
                                                   },
                                                   {
                                                     'date' => '1999-01-15T09:26:40',
                                                     'version' => '1.44_53'
                                                   },
                                                   {
                                                     'date' => '1999-01-15T09:27:45',
                                                     'version' => '1.44_54'
                                                   },
                                                   {
                                                     'date' => '1999-01-23T14:56:16',
                                                     'version' => '1.45'
                                                   },
                                                   {
                                                     'date' => '1999-01-25T01:43:42',
                                                     'version' => '1.46'
                                                   },
                                                   {
                                                     'date' => '1999-01-25T13:11:23',
                                                     'version' => '1.47'
                                                   },
                                                   {
                                                     'date' => '1999-03-06T19:34:54',
                                                     'version' => '1.48'
                                                   },
                                                   {
                                                     'date' => '1999-05-22T16:45:00',
                                                     'version' => '1.49'
                                                   },
                                                   {
                                                     'date' => '1999-05-23T14:32:20',
                                                     'version' => '1.50'
                                                   },
                                                   {
                                                     'date' => '1999-10-23T03:06:39',
                                                     'version' => '1.50_01'
                                                   },
                                                   {
                                                     'date' => '1999-12-29T22:30:22',
                                                     'version' => '1.51'
                                                   },
                                                   {
                                                     'date' => '2000-01-08T15:32:55',
                                                     'version' => '1.52'
                                                   },
                                                   {
                                                     'date' => '2000-03-23T23:39:41',
                                                     'version' => '1.53'
                                                   },
                                                   {
                                                     'date' => '2000-03-25T22:51:15',
                                                     'version' => '1.54'
                                                   },
                                                   {
                                                     'date' => '2000-07-30T11:15:04',
                                                     'version' => '1.55'
                                                   },
                                                   {
                                                     'date' => '2000-08-01T20:47:09',
                                                     'version' => '1.56'
                                                   },
                                                   {
                                                     'date' => '2000-08-16T12:54:07',
                                                     'version' => '1.57'
                                                   },
                                                   {
                                                     'date' => '2000-08-21T19:44:18',
                                                     'version' => '1.57_51'
                                                   },
                                                   {
                                                     'date' => '2000-08-27T22:09:36',
                                                     'version' => '1.57_53'
                                                   },
                                                   {
                                                     'date' => '2000-08-30T16:54:50',
                                                     'version' => '1.57_54'
                                                   },
                                                   {
                                                     'date' => '2000-08-31T08:11:01',
                                                     'version' => '1.57_55'
                                                   },
                                                   {
                                                     'date' => '2000-08-31T22:16:21',
                                                     'version' => '1.57_56'
                                                   },
                                                   {
                                                     'date' => '2000-09-01T12:18:43',
                                                     'version' => '1.57_57'
                                                   },
                                                   {
                                                     'date' => '2000-09-03T22:19:20',
                                                     'version' => '1.57_58'
                                                   },
                                                   {
                                                     'date' => '2000-09-05T09:44:05',
                                                     'version' => '1.57_59'
                                                   },
                                                   {
                                                     'date' => '2000-09-05T19:55:34',
                                                     'version' => '1.57_60'
                                                   },
                                                   {
                                                     'date' => '2000-09-06T10:54:07',
                                                     'version' => '1.57_61'
                                                   },
                                                   {
                                                     'date' => '2000-09-08T02:19:06',
                                                     'version' => '1.57_62'
                                                   },
                                                   {
                                                     'date' => '2000-09-10T08:54:37',
                                                     'version' => '1.57_65'
                                                   },
                                                   {
                                                     'date' => '2000-09-12T08:46:40',
                                                     'version' => '1.57_66'
                                                   },
                                                   {
                                                     'date' => '2000-09-17T10:24:31',
                                                     'version' => '1.57_67'
                                                   },
                                                   {
                                                     'date' => '2000-10-08T14:25:04',
                                                     'version' => '1.57_68'
                                                   },
                                                   {
                                                     'date' => '2000-10-18T14:53:45',
                                                     'version' => '1.58'
                                                   },
                                                   {
                                                     'date' => '2000-10-21T14:21:06',
                                                     'version' => '1.58_51'
                                                   },
                                                   {
                                                     'date' => '2000-10-25T07:05:38',
                                                     'version' => '1.58_52'
                                                   },
                                                   {
                                                     'date' => '2000-10-26T11:03:29',
                                                     'version' => '1.58_53'
                                                   },
                                                   {
                                                     'date' => '2000-10-26T15:34:21',
                                                     'version' => '1.58_54'
                                                   },
                                                   {
                                                     'date' => '2000-10-27T07:59:03',
                                                     'version' => '1.58_55'
                                                   },
                                                   {
                                                     'date' => '2000-11-04T09:36:53',
                                                     'version' => '1.58_56'
                                                   },
                                                   {
                                                     'date' => '2000-11-06T19:30:27',
                                                     'version' => '1.58_57'
                                                   },
                                                   {
                                                     'date' => '2000-11-08T08:10:51',
                                                     'version' => '1.58_90'
                                                   },
                                                   {
                                                     'date' => '2000-11-13T10:26:38',
                                                     'version' => '1.58_91'
                                                   },
                                                   {
                                                     'date' => '2000-11-14T18:24:18',
                                                     'version' => '1.58_92'
                                                   },
                                                   {
                                                     'date' => '2000-11-15T07:19:56',
                                                     'version' => '1.58_93'
                                                   },
                                                   {
                                                     'date' => '2000-12-01T06:05:58',
                                                     'version' => '1.59'
                                                   },
                                                   {
                                                     'date' => '2000-12-01T08:19:58',
                                                     'version' => '1.59_51'
                                                   },
                                                   {
                                                     'date' => '2000-12-26T13:54:06',
                                                     'version' => '1.59_52'
                                                   },
                                                   {
                                                     'date' => '2001-01-02T16:37:24',
                                                     'version' => '1.59_53'
                                                   },
                                                   {
                                                     'date' => '2001-02-09T21:44:55',
                                                     'version' => '1.59_54'
                                                   },
                                                   {
                                                     'date' => '2002-04-19T13:29:54',
                                                     'version' => '1.60'
                                                   },
                                                   {
                                                     'date' => '2002-04-20T02:18:41',
                                                     'version' => '1.60'
                                                   },
                                                   {
                                                     'date' => '2002-04-21T11:31:25',
                                                     'version' => '1.60'
                                                   },
                                                   {
                                                     'date' => '2002-05-07T10:38:54',
                                                     'version' => '1.61'
                                                   },
                                                   {
                                                     'date' => '2002-07-28T10:51:47',
                                                     'version' => '1.62'
                                                   },
                                                   {
                                                     'date' => '2002-08-30T08:58:10',
                                                     'version' => '1.63'
                                                   },
                                                   {
                                                     'date' => '2003-02-06T10:04:06',
                                                     'version' => '1.64'
                                                   },
                                                   {
                                                     'date' => '2003-02-08T17:10:13',
                                                     'version' => '1.65'
                                                   },
                                                   {
                                                     'date' => '2003-03-04T19:38:21',
                                                     'version' => '1.70'
                                                   },
                                                   {
                                                     'date' => '2003-04-11T04:33:18',
                                                     'version' => '1.70_52'
                                                   },
                                                   {
                                                     'date' => '2003-04-13T12:43:40',
                                                     'version' => '1.70_53'
                                                   },
                                                   {
                                                     'date' => '2003-05-15T21:04:52',
                                                     'version' => '1.70_54'
                                                   },
                                                   {
                                                     'date' => '2003-07-04T09:48:08',
                                                     'version' => '1.71'
                                                   },
                                                   {
                                                     'date' => '2003-07-27T20:35:05',
                                                     'version' => '1.72'
                                                   },
                                                   {
                                                     'date' => '2003-07-28T08:21:47',
                                                     'version' => '1.73'
                                                   },
                                                   {
                                                     'date' => '2003-07-28T22:58:08',
                                                     'version' => '1.74'
                                                   },
                                                   {
                                                     'date' => '2003-07-29T15:14:13',
                                                     'version' => '1.75'
                                                   },
                                                   {
                                                     'date' => '2003-07-31T15:14:02',
                                                     'version' => '1.76'
                                                   },
                                                   {
                                                     'date' => '2003-09-21T21:25:41',
                                                     'version' => '1.76_01'
                                                   },
                                                   {
                                                     'date' => '2005-09-19T06:37:38',
                                                     'version' => '1.76_51'
                                                   },
                                                   {
                                                     'date' => '2005-09-22T07:02:02',
                                                     'version' => '1.76_52'
                                                   },
                                                   {
                                                     'date' => '2005-09-22T07:09:48',
                                                     'version' => '1.76_53'
                                                   },
                                                   {
                                                     'date' => '2005-10-01T08:23:38',
                                                     'version' => '1.76_54'
                                                   },
                                                   {
                                                     'date' => '2005-10-19T06:10:58',
                                                     'version' => '1.76_55'
                                                   },
                                                   {
                                                     'date' => '2005-10-21T04:59:36',
                                                     'version' => '1.76_56'
                                                   },
                                                   {
                                                     'date' => '2005-10-27T07:08:29',
                                                     'version' => '1.76_57'
                                                   },
                                                   {
                                                     'date' => '2005-11-02T04:03:28',
                                                     'version' => '1.76_58'
                                                   },
                                                   {
                                                     'date' => '2005-11-03T06:37:52',
                                                     'version' => '1.76_59'
                                                   },
                                                   {
                                                     'date' => '2005-11-03T07:38:40',
                                                     'version' => '1.76_60'
                                                   },
                                                   {
                                                     'date' => '2005-11-06T10:36:53',
                                                     'version' => '1.76_61'
                                                   },
                                                   {
                                                     'date' => '2005-11-07T04:22:19',
                                                     'version' => '1.76_62'
                                                   },
                                                   {
                                                     'date' => '2005-11-07T04:47:05',
                                                     'version' => '1.76_63'
                                                   },
                                                   {
                                                     'date' => '2005-11-07T21:58:06',
                                                     'version' => '1.76_64'
                                                   },
                                                   {
                                                     'date' => '2005-11-07T22:18:44',
                                                     'version' => '1.76_65'
                                                   },
                                                   {
                                                     'date' => '2005-12-03T10:12:08',
                                                     'version' => '1.80'
                                                   },
                                                   {
                                                     'date' => '2005-12-18T11:29:26',
                                                     'version' => '1.80_51'
                                                   },
                                                   {
                                                     'date' => '2005-12-21T12:13:15',
                                                     'version' => '1.80_53'
                                                   },
                                                   {
                                                     'date' => '2005-12-22T08:42:59',
                                                     'version' => '1.80_54'
                                                   },
                                                   {
                                                     'date' => '2005-12-24T07:25:34',
                                                     'version' => '1.80_55'
                                                   },
                                                   {
                                                     'date' => '2005-12-24T09:59:47',
                                                     'version' => '1.80_56'
                                                   },
                                                   {
                                                     'date' => '2005-12-31T11:58:10',
                                                     'version' => '1.80_57'
                                                   },
                                                   {
                                                     'date' => '2006-01-01T09:01:43',
                                                     'version' => '1.80_58'
                                                   },
                                                   {
                                                     'date' => '2006-01-02T23:15:15',
                                                     'version' => '1.81'
                                                   },
                                                   {
                                                     'date' => '2006-01-04T07:47:25',
                                                     'version' => '1.82'
                                                   },
                                                   {
                                                     'date' => '2006-01-05T08:03:36',
                                                     'version' => '1.83'
                                                   },
                                                   {
                                                     'date' => '2006-01-08T13:35:16',
                                                     'version' => '1.83_51'
                                                   },
                                                   {
                                                     'date' => '2006-01-10T05:00:26',
                                                     'version' => '1.83_52'
                                                   },
                                                   {
                                                     'date' => '2006-01-12T07:54:36',
                                                     'version' => '1.83_53'
                                                   },
                                                   {
                                                     'date' => '2006-01-13T08:20:42',
                                                     'version' => '1.83_54'
                                                   },
                                                   {
                                                     'date' => '2006-01-14T11:34:47',
                                                     'version' => '1.83_55'
                                                   },
                                                   {
                                                     'date' => '2006-01-18T06:03:44',
                                                     'version' => '1.83_56'
                                                   },
                                                   {
                                                     'date' => '2006-01-19T08:00:02',
                                                     'version' => '1.83_57'
                                                   },
                                                   {
                                                     'date' => '2006-01-22T12:05:01',
                                                     'version' => '1.83_58'
                                                   },
                                                   {
                                                     'date' => '2006-01-25T13:10:20',
                                                     'version' => '1.83_59'
                                                   },
                                                   {
                                                     'date' => '2006-01-30T10:35:47',
                                                     'version' => '1.83_60'
                                                   },
                                                   {
                                                     'date' => '2006-01-30T23:18:09',
                                                     'version' => '1.83_61'
                                                   },
                                                   {
                                                     'date' => '2006-01-31T10:28:57',
                                                     'version' => '1.83_62'
                                                   },
                                                   {
                                                     'date' => '2006-02-01T07:49:36',
                                                     'version' => '1.83_63'
                                                   },
                                                   {
                                                     'date' => '2006-02-02T09:17:39',
                                                     'version' => '1.83_64'
                                                   },
                                                   {
                                                     'date' => '2006-02-04T11:20:05',
                                                     'version' => '1.83_65'
                                                   },
                                                   {
                                                     'date' => '2006-02-04T17:05:00',
                                                     'version' => '1.83_66'
                                                   },
                                                   {
                                                     'date' => '2006-02-06T00:46:27',
                                                     'version' => '1.83_67'
                                                   },
                                                   {
                                                     'date' => '2006-02-08T07:43:36',
                                                     'version' => '1.83_68'
                                                   },
                                                   {
                                                     'date' => '2006-02-14T08:17:55',
                                                     'version' => '1.83_69'
                                                   },
                                                   {
                                                     'date' => '2006-02-15T07:01:02',
                                                     'version' => '1.84'
                                                   },
                                                   {
                                                     'date' => '2006-02-19T17:05:36',
                                                     'version' => '1.85'
                                                   },
                                                   {
                                                     'date' => '2006-02-20T08:36:51',
                                                     'version' => '1.86'
                                                   },
                                                   {
                                                     'date' => '2006-02-21T06:05:05',
                                                     'version' => '1.86_51'
                                                   },
                                                   {
                                                     'date' => '2006-02-22T22:29:54',
                                                     'version' => '1.86_52'
                                                   },
                                                   {
                                                     'date' => '2006-02-24T08:24:09',
                                                     'version' => '1.86_53'
                                                   },
                                                   {
                                                     'date' => '2006-02-27T07:01:10',
                                                     'version' => '1.87'
                                                   },
                                                   {
                                                     'date' => '2006-03-06T08:02:28',
                                                     'version' => '1.87_51'
                                                   },
                                                   {
                                                     'date' => '2006-07-21T22:33:11',
                                                     'version' => '1.87_52'
                                                   },
                                                   {
                                                     'date' => '2006-07-22T18:55:13',
                                                     'version' => '1.87_53'
                                                   },
                                                   {
                                                     'date' => '2006-07-23T21:37:11',
                                                     'version' => '1.87_54'
                                                   },
                                                   {
                                                     'date' => '2006-07-29T19:36:50',
                                                     'version' => '1.87_55'
                                                   },
                                                   {
                                                     'date' => '2006-08-24T05:57:41',
                                                     'version' => '1.87_56'
                                                   },
                                                   {
                                                     'date' => '2006-08-26T17:05:56',
                                                     'version' => '1.87_57'
                                                   },
                                                   {
                                                     'date' => '2006-08-31T06:50:49',
                                                     'version' => '1.87_58'
                                                   },
                                                   {
                                                     'date' => '2006-09-03T21:05:29',
                                                     'version' => '1.87_59'
                                                   },
                                                   {
                                                     'date' => '2006-09-10T11:57:33',
                                                     'version' => '1.87_61'
                                                   },
                                                   {
                                                     'date' => '2006-09-11T21:24:18',
                                                     'version' => '1.87_62'
                                                   },
                                                   {
                                                     'date' => '2006-09-13T05:44:15',
                                                     'version' => '1.87_63'
                                                   },
                                                   {
                                                     'date' => '2006-09-16T11:02:25',
                                                     'version' => '1.87_64'
                                                   },
                                                   {
                                                     'date' => '2006-09-19T03:44:51',
                                                     'version' => '1.87_65'
                                                   },
                                                   {
                                                     'date' => '2006-09-21T20:30:41',
                                                     'version' => '1.88'
                                                   },
                                                   {
                                                     'date' => '2006-09-22T20:40:40',
                                                     'version' => '1.8801'
                                                   },
                                                   {
                                                     'date' => '2006-09-30T10:41:20',
                                                     'version' => '1.88_51'
                                                   },
                                                   {
                                                     'date' => '2006-10-03T09:51:49',
                                                     'version' => '1.88_52'
                                                   },
                                                   {
                                                     'date' => '2006-10-09T19:31:56',
                                                     'version' => '1.88_53'
                                                   },
                                                   {
                                                     'date' => '2006-10-14T09:37:15',
                                                     'version' => '1.88_54'
                                                   },
                                                   {
                                                     'date' => '2006-10-16T06:59:27',
                                                     'version' => '1.88_55'
                                                   },
                                                   {
                                                     'date' => '2006-10-22T10:34:16',
                                                     'version' => '1.88_56'
                                                   },
                                                   {
                                                     'date' => '2006-10-23T07:17:30',
                                                     'version' => '1.8802'
                                                   },
                                                   {
                                                     'date' => '2006-10-24T07:18:16',
                                                     'version' => '1.88_57'
                                                   },
                                                   {
                                                     'date' => '2006-10-28T15:00:07',
                                                     'version' => '1.88_58'
                                                   },
                                                   {
                                                     'date' => '2006-11-05T21:24:52',
                                                     'version' => '1.88_59'
                                                   },
                                                   {
                                                     'date' => '2006-11-10T08:39:55',
                                                     'version' => '1.88_61'
                                                   },
                                                   {
                                                     'date' => '2006-11-13T07:44:27',
                                                     'version' => '1.88_62'
                                                   },
                                                   {
                                                     'date' => '2006-11-29T08:11:50',
                                                     'version' => '1.88_63'
                                                   },
                                                   {
                                                     'date' => '2006-12-04T07:53:37',
                                                     'version' => '1.88_64'
                                                   },
                                                   {
                                                     'date' => '2006-12-11T21:36:04',
                                                     'version' => '1.88_65'
                                                   },
                                                   {
                                                     'date' => '2006-12-19T08:21:17',
                                                     'version' => '1.88_66'
                                                   },
                                                   {
                                                     'date' => '2006-12-31T17:18:53',
                                                     'version' => '1.88_67'
                                                   },
                                                   {
                                                     'date' => '2007-01-07T21:22:12',
                                                     'version' => '1.88_68'
                                                   },
                                                   {
                                                     'date' => '2007-01-08T03:42:56',
                                                     'version' => '1.88_69'
                                                   },
                                                   {
                                                     'date' => '2007-01-27T16:57:49',
                                                     'version' => '1.88_71'
                                                   },
                                                   {
                                                     'date' => '2007-01-31T07:11:33',
                                                     'version' => '1.88_72'
                                                   },
                                                   {
                                                     'date' => '2007-02-13T05:24:13',
                                                     'version' => '1.88_73'
                                                   },
                                                   {
                                                     'date' => '2007-02-15T07:12:17',
                                                     'version' => '1.88_74'
                                                   },
                                                   {
                                                     'date' => '2007-02-18T16:52:49',
                                                     'version' => '1.88_75'
                                                   },
                                                   {
                                                     'date' => '2007-02-19T06:20:20',
                                                     'version' => '1.88_76'
                                                   },
                                                   {
                                                     'date' => '2007-02-19T21:26:47',
                                                     'version' => '1.88_77'
                                                   },
                                                   {
                                                     'date' => '2007-03-05T23:26:57',
                                                     'version' => '1.88_78'
                                                   },
                                                   {
                                                     'date' => '2007-03-16T01:54:55',
                                                     'version' => '1.88_79'
                                                   },
                                                   {
                                                     'date' => '2007-04-07T07:41:18',
                                                     'version' => '1.90'
                                                   },
                                                   {
                                                     'date' => '2007-04-19T07:03:03',
                                                     'version' => '1.91'
                                                   },
                                                   {
                                                     'date' => '2007-04-23T00:09:11',
                                                     'version' => '1.9101'
                                                   },
                                                   {
                                                     'date' => '2007-05-08T20:35:04',
                                                     'version' => '1.9102'
                                                   },
                                                   {
                                                     'date' => '2007-07-07T16:15:40',
                                                     'version' => '1.91_51'
                                                   },
                                                   {
                                                     'date' => '2007-07-14T18:45:58',
                                                     'version' => '1.91_52'
                                                   },
                                                   {
                                                     'date' => '2007-08-09T06:49:38',
                                                     'version' => '1.91_53'
                                                   },
                                                   {
                                                     'date' => '2007-09-14T21:18:33',
                                                     'version' => '1.91_54'
                                                   },
                                                   {
                                                     'date' => '2007-09-15T07:14:26',
                                                     'version' => '1.91_55'
                                                   },
                                                   {
                                                     'date' => '2007-09-23T11:15:08',
                                                     'version' => '1.92'
                                                   },
                                                   {
                                                     'date' => '2007-09-27T07:11:10',
                                                     'version' => '1.9201'
                                                   },
                                                   {
                                                     'date' => '2007-09-28T06:58:04',
                                                     'version' => '1.9202'
                                                   },
                                                   {
                                                     'date' => '2007-09-28T07:13:26',
                                                     'version' => '1.9203'
                                                   },
                                                   {
                                                     'date' => '2007-11-04T23:04:18',
                                                     'version' => '1.92_51'
                                                   },
                                                   {
                                                     'date' => '2007-11-05T23:30:06',
                                                     'version' => '1.9204'
                                                   },
                                                   {
                                                     'date' => '2007-11-11T11:27:20',
                                                     'version' => '1.92_52'
                                                   },
                                                   {
                                                     'date' => '2007-11-11T18:49:37',
                                                     'version' => '1.9205'
                                                   },
                                                   {
                                                     'date' => '2007-12-09T23:27:18',
                                                     'version' => '1.92_53'
                                                   },
                                                   {
                                                     'date' => '2007-12-27T04:57:34',
                                                     'version' => '1.92_54'
                                                   },
                                                   {
                                                     'date' => '2007-12-30T15:24:13',
                                                     'version' => '1.92_55'
                                                   },
                                                   {
                                                     'date' => '2008-02-04T21:56:28',
                                                     'version' => '1.92_56'
                                                   },
                                                   {
                                                     'date' => '2008-02-27T05:13:49',
                                                     'version' => '1.92_57'
                                                   },
                                                   {
                                                     'date' => '2008-03-12T07:56:18',
                                                     'version' => '1.92_58'
                                                   },
                                                   {
                                                     'date' => '2008-03-16T18:57:04',
                                                     'version' => '1.92_59'
                                                   },
                                                   {
                                                     'date' => '2008-03-26T07:53:08',
                                                     'version' => '1.92_60'
                                                   },
                                                   {
                                                     'date' => '2008-04-25T04:47:52',
                                                     'version' => '1.92_61'
                                                   },
                                                   {
                                                     'date' => '2008-05-23T04:07:04',
                                                     'version' => '1.92_62'
                                                   },
                                                   {
                                                     'date' => '2008-06-19T06:42:18',
                                                     'version' => '1.92_63'
                                                   },
                                                   {
                                                     'date' => '2008-09-03T05:27:35',
                                                     'version' => '1.92_64'
                                                   },
                                                   {
                                                     'date' => '2008-09-14T09:54:03',
                                                     'version' => '1.92_65'
                                                   },
                                                   {
                                                     'date' => '2008-09-29T23:15:10',
                                                     'version' => '1.92_66'
                                                   },
                                                   {
                                                     'date' => '2008-10-12T16:07:51',
                                                     'version' => '1.93'
                                                   },
                                                   {
                                                     'date' => '2008-10-13T19:37:43',
                                                     'version' => '1.9301'
                                                   },
                                                   {
                                                     'date' => '2009-01-11T22:07:01',
                                                     'version' => '1.93_02'
                                                   },
                                                   {
                                                     'date' => '2009-02-01T12:38:23',
                                                     'version' => '1.93_03'
                                                   },
                                                   {
                                                     'date' => '2009-02-01T21:06:21',
                                                     'version' => '1.93_51'
                                                   },
                                                   {
                                                     'date' => '2009-02-28T15:58:39',
                                                     'version' => '1.9304'
                                                   },
                                                   {
                                                     'date' => '2009-04-13T19:24:43',
                                                     'version' => '1.93_52'
                                                   },
                                                   {
                                                     'date' => '2009-05-04T06:11:28',
                                                     'version' => '1.93_53'
                                                   },
                                                   {
                                                     'date' => '2009-05-07T20:13:16',
                                                     'version' => '1.93_54'
                                                   },
                                                   {
                                                     'date' => '2009-05-24T05:37:28',
                                                     'version' => '1.94'
                                                   },
                                                   {
                                                     'date' => '2009-06-14T19:53:52',
                                                     'version' => '1.94_01'
                                                   },
                                                   {
                                                     'date' => '2009-06-27T02:55:22',
                                                     'version' => '1.9402'
                                                   },
                                                   {
                                                     'date' => '2009-09-14T02:47:24',
                                                     'version' => '1.94_51'
                                                   },
                                                   {
                                                     'date' => '2009-10-15T19:33:19',
                                                     'version' => '1.94_52'
                                                   },
                                                   {
                                                     'date' => '2009-12-18T07:00:09',
                                                     'version' => '1.94_53'
                                                   },
                                                   {
                                                     'date' => '2010-01-14T08:01:42',
                                                     'version' => '1.94_54'
                                                   },
                                                   {
                                                     'date' => '2010-02-03T03:43:49',
                                                     'version' => '1.94_55'
                                                   },
                                                   {
                                                     'date' => '2010-02-17T13:39:33',
                                                     'version' => '1.94_56'
                                                   },
                                                   {
                                                     'date' => '2010-05-24T19:33:41',
                                                     'version' => '1.94_57'
                                                   },
                                                   {
                                                     'date' => '2010-06-24T06:34:13',
                                                     'version' => '1.94_58'
                                                   },
                                                   {
                                                     'date' => '2010-09-26T20:23:30',
                                                     'version' => '1.94_59'
                                                   },
                                                   {
                                                     'date' => '2010-09-28T20:44:58',
                                                     'version' => '1.94_60'
                                                   },
                                                   {
                                                     'date' => '2010-10-03T17:29:37',
                                                     'version' => '1.94_61'
                                                   },
                                                   {
                                                     'date' => '2010-10-26T06:43:51',
                                                     'version' => '1.94_62'
                                                   },
                                                   {
                                                     'date' => '2011-01-16T17:58:10',
                                                     'version' => '1.94_63'
                                                   },
                                                   {
                                                     'date' => '2011-01-21T04:58:35',
                                                     'version' => '1.94_64'
                                                   },
                                                   {
                                                     'date' => '2011-02-14T12:10:12',
                                                     'version' => '1.94_65'
                                                   },
                                                   {
                                                     'date' => '2011-03-12T11:30:03',
                                                     'version' => '1.9600'
                                                   },
                                                   {
                                                     'date' => '2011-06-27T06:56:01',
                                                     'version' => '1.97_51'
                                                   },
                                                   {
                                                     'date' => '2011-08-07T09:40:33',
                                                     'version' => '1.9800'
                                                   },
                                                   {
                                                     'date' => '2012-10-16T21:42:49',
                                                     'version' => '1.99_51'
                                                   },
                                                   {
                                                     'date' => '2013-02-06T07:41:54',
                                                     'version' => '2.00-TRIAL'
                                                   },
                                                   {
                                                     'date' => '2013-04-12T16:57:44',
                                                     'version' => '2.00'
                                                   },
                                                   {
                                                     'date' => '2013-06-22T20:27:32',
                                                     'version' => '2.01-TRIAL'
                                                   },
                                                   {
                                                     'date' => '2013-06-23T07:33:40',
                                                     'version' => '2.02-TRIAL'
                                                   },
                                                   {
                                                     'date' => '2013-09-15T09:42:33',
                                                     'version' => '2.03-TRIAL'
                                                   },
                                                   {
                                                     'date' => '2014-03-18T22:33:22',
                                                     'version' => '2.04-TRIAL'
                                                   },
                                                   {
                                                     'date' => '2014-03-31T20:55:24',
                                                     'version' => '2.05-TRIAL'
                                                   },
                                                   {
                                                     'date' => '2014-04-04T02:07:20',
                                                     'version' => '2.05-TRIAL2'
                                                   },
                                                   {
                                                     'date' => '2014-04-18T13:35:51',
                                                     'version' => '2.05'
                                                   },
                                                   {
                                                     'date' => '2014-08-06T19:32:53',
                                                     'version' => '2.06-TRIAL'
                                                   },
                                                   {
                                                     'date' => '2015-01-04T18:54:54',
                                                     'version' => '2.06-TRIAL'
                                                   },
                                                   {
                                                     'date' => '2015-01-05T06:31:55',
                                                     'version' => '2.08-TRIAL'
                                                   },
                                                   {
                                                     'date' => '2015-02-02T04:41:02',
                                                     'version' => '2.09-TRIAL'
                                                   },
                                                   {
                                                     'date' => '2015-02-22T15:57:42',
                                                     'version' => '2.10-TRIAL'
                                                   },
                                                   {
                                                     'date' => '2015-03-13T07:45:04',
                                                     'version' => '2.10'
                                                   },
                                                   {
                                                     'date' => '2015-12-31T11:00:08',
                                                     'version' => '2.12-TRIAL'
                                                   },
                                                   {
                                                     'date' => '2016-05-16T09:56:01',
                                                     'version' => '2.13-TRIAL'
                                                   },
                                                   {
                                                     'date' => '2016-06-04T14:41:28',
                                                     'version' => '2.14-TRIAL'
                                                   },
                                                   {
                                                     'date' => '2016-06-25T04:32:45',
                                                     'version' => '2.14'
                                                   },
                                                   {
                                                     'date' => '2016-07-17T12:10:30',
                                                     'version' => '2.15-TRIAL'
                                                   },
                                                   {
                                                     'date' => '2017-01-16T16:20:27',
                                                     'version' => '2.16-TRIAL'
                                                   },
                                                   {
                                                     'date' => '2017-01-16T21:27:06',
                                                     'version' => '2.16-TRIAL2'
                                                   },
                                                   {
                                                     'date' => '2017-02-14T16:22:20',
                                                     'version' => '2.16'
                                                   },
                                                   {
                                                     'date' => '2017-02-15T09:37:10',
                                                     'version' => '2.17-TRIAL'
                                                   },
                                                   {
                                                     'date' => '2017-02-16T09:48:46',
                                                     'version' => '2.17-TRIAL2'
                                                   },
                                                   {
                                                     'date' => '2017-03-30T21:38:23',
                                                     'version' => '2.18-TRIAL'
                                                   },
                                                   {
                                                     'date' => '2017-11-04T23:27:47',
                                                     'version' => '2.19-TRIAL'
                                                   },
                                                   {
                                                     'date' => '2017-11-26T22:10:39',
                                                     'version' => '2.20-TRIAL'
                                                   },
                                                   {
                                                     'date' => '2018-09-22T20:46:35',
                                                     'version' => '2.21-TRIAL'
                                                   },
                                                   {
                                                     'date' => '2018-12-16T10:35:04',
                                                     'version' => '2.22-TRIAL'
                                                   },
                                                   {
                                                     'date' => '2018-12-23T09:11:29',
                                                     'version' => '2.22'
                                                   }
                                                 ]
                                 },
                       'Catalyst-Authentication-Store-LDAP' => {
                                                                 'advisories' => [
                                                                                   {
                                                                                     'affected_versions' => '<1.013',
                                                                                     'description' => 'Incorrect password check binds to the unauthenticated user.
',
                                                                                     'distribution' => 'Catalyst-Authentication-Store-LDAP',
                                                                                     'fixed_versions' => '>=1.013',
                                                                                     'id' => 'CPANSA-Catalyst-Authentication-Store-LDAP-2012-01',
                                                                                     'references' => [
                                                                                                       'https://rt.cpan.org/Public/Bug/Display.html?id=81908'
                                                                                                     ],
                                                                                     'reported' => '2012-12-11',
                                                                                     'severity' => 'high'
                                                                                   }
                                                                                 ],
                                                                 'main_module' => 'Catalyst::Authentication::Store::LDAP',
                                                                 'versions' => [
                                                                                 {
                                                                                   'date' => '2008-02-05T18:18:24',
                                                                                   'version' => '0.1000'
                                                                                 },
                                                                                 {
                                                                                   'date' => '2008-04-10T02:06:58',
                                                                                   'version' => '0.1001'
                                                                                 },
                                                                                 {
                                                                                   'date' => '2008-07-09T20:45:43',
                                                                                   'version' => '0.1002'
                                                                                 },
                                                                                 {
                                                                                   'date' => '2008-09-10T13:21:33',
                                                                                   'version' => '0.1003'
                                                                                 },
                                                                                 {
                                                                                   'date' => '2008-10-22T01:57:27',
                                                                                   'version' => '0.1003'
                                                                                 },
                                                                                 {
                                                                                   'date' => '2009-05-01T02:34:18',
                                                                                   'version' => '0.1005'
                                                                                 },
                                                                                 {
                                                                                   'date' => '2009-12-11T18:54:26',
                                                                                   'version' => '1.006'
                                                                                 },
                                                                                 {
                                                                                   'date' => '2010-03-19T10:07:13',
                                                                                   'version' => '1.007'
                                                                                 },
                                                                                 {
                                                                                   'date' => '2010-04-03T03:04:13',
                                                                                   'version' => '1.008'
                                                                                 },
                                                                                 {
                                                                                   'date' => '2010-05-15T07:14:41',
                                                                                   'version' => '1.009'
                                                                                 },
                                                                                 {
                                                                                   'date' => '2010-07-06T21:39:55',
                                                                                   'version' => '1.010'
                                                                                 },
                                                                                 {
                                                                                   'date' => '2010-07-07T20:41:22',
                                                                                   'version' => '1.011'
                                                                                 },
                                                                                 {
                                                                                   'date' => '2010-10-05T08:11:56',
                                                                                   'version' => '1.012'
                                                                                 },
                                                                                 {
                                                                                   'date' => '2013-01-09T14:58:46',
                                                                                   'version' => '1.013'
                                                                                 },
                                                                                 {
                                                                                   'date' => '2013-04-26T19:51:28',
                                                                                   'version' => '1.014'
                                                                                 },
                                                                                 {
                                                                                   'date' => '2015-02-20T18:07:31',
                                                                                   'version' => '1.015'
                                                                                 },
                                                                                 {
                                                                                   'date' => '2016-02-11T17:50:52',
                                                                                   'version' => '1.016'
                                                                                 }
                                                                               ]
                                                               },
                       'Catalyst-Controller-Combine' => {
                                                          'advisories' => [
                                                                            {
                                                                              'affected_versions' => '<0.12',
                                                                              'description' => 'Allows to use url-encoded path-parts to crawl along the file system and read files outside the intended directory.
',
                                                                              'distribution' => 'Catalyst-Controller-Combine',
                                                                              'fixed_versions' => '>=0.12',
                                                                              'id' => 'CPANSA-Catalyst-Controller-Combine-2010-01',
                                                                              'references' => [
                                                                                                'https://metacpan.org/changes/distribution/Catalyst-Controller-Combine'
                                                                                              ],
                                                                              'reported' => '2010-05-21'
                                                                            }
                                                                          ],
                                                          'main_module' => 'Catalyst::Controller::Combine',
                                                          'versions' => [
                                                                          {
                                                                            'date' => '2009-07-11T17:58:25',
                                                                            'version' => '0.06'
                                                                          },
                                                                          {
                                                                            'date' => '2009-07-13T06:49:00',
                                                                            'version' => '0.07'
                                                                          },
                                                                          {
                                                                            'date' => '2009-10-24T12:48:21',
                                                                            'version' => '0.08'
                                                                          },
                                                                          {
                                                                            'date' => '2010-03-13T19:31:13',
                                                                            'version' => '0.09'
                                                                          },
                                                                          {
                                                                            'date' => '2010-03-27T18:44:05',
                                                                            'version' => '0.10'
                                                                          },
                                                                          {
                                                                            'date' => '2010-06-21T20:47:02',
                                                                            'version' => '0.12'
                                                                          },
                                                                          {
                                                                            'date' => '2011-07-28T19:53:12',
                                                                            'version' => '0.13'
                                                                          },
                                                                          {
                                                                            'date' => '2012-02-20T20:59:00',
                                                                            'version' => '0.14'
                                                                          },
                                                                          {
                                                                            'date' => '2012-05-04T10:43:12',
                                                                            'version' => '0.15'
                                                                          }
                                                                        ]
                                                        },
                       'Catalyst-Plugin-Static' => {
                                                     'advisories' => [
                                                                       {
                                                                         'affected_versions' => '<0.10',
                                                                         'description' => 'Serving files outside of $config->{root} directory.
',
                                                                         'distribution' => 'Catalyst-Plugin-Static',
                                                                         'fixed_versions' => '>=0.10',
                                                                         'id' => 'CPANSA-Catalyst-Plugin-Static-2005-01',
                                                                         'reported' => '2005-11-14'
                                                                       }
                                                                     ],
                                                     'main_module' => 'Catalyst::Plugin::Static',
                                                     'versions' => [
                                                                     {
                                                                       'date' => '2005-01-29T00:00:20',
                                                                       'version' => '0.01'
                                                                     },
                                                                     {
                                                                       'date' => '2005-02-19T20:28:50',
                                                                       'version' => '0.02'
                                                                     },
                                                                     {
                                                                       'date' => '2005-03-17T01:01:03',
                                                                       'version' => '0.03'
                                                                     },
                                                                     {
                                                                       'date' => '2005-03-17T19:10:36',
                                                                       'version' => '0.04'
                                                                     },
                                                                     {
                                                                       'date' => '2005-03-21T13:34:27',
                                                                       'version' => '0.05'
                                                                     },
                                                                     {
                                                                       'date' => '2005-03-23T06:48:05',
                                                                       'version' => '0.05'
                                                                     },
                                                                     {
                                                                       'date' => '2005-04-15T16:58:18',
                                                                       'version' => '0.06'
                                                                     },
                                                                     {
                                                                       'date' => '2005-04-17T14:50:45',
                                                                       'version' => '0.07'
                                                                     },
                                                                     {
                                                                       'date' => '2005-09-06T13:42:42',
                                                                       'version' => '0.08'
                                                                     },
                                                                     {
                                                                       'date' => '2005-11-14T08:38:35',
                                                                       'version' => '0.09'
                                                                     },
                                                                     {
                                                                       'date' => '2005-11-14T10:26:31',
                                                                       'version' => '0.10'
                                                                     },
                                                                     {
                                                                       'date' => '2009-10-18T18:13:00',
                                                                       'version' => '0.11'
                                                                     }
                                                                   ]
                                                   },
                       'Catalyst-Runtime' => {
                                               'advisories' => [
                                                                 {
                                                                   'affected_versions' => '<5.90020',
                                                                   'description' => 'Passing a special host to the redirect page link makes it vulnerable to XSS attack.
',
                                                                   'distribution' => 'Catalyst-Runtime',
                                                                   'fixed_versions' => '>=5.90020',
                                                                   'id' => 'CPANSA-Catalyst-Runtime-2013-01',
                                                                   'references' => [
                                                                                     'http://git.shadowcat.co.uk/gitweb/gitweb.cgi?p=catagits/Catalyst-Runtime.git;a=commitdiff;h=7af54927870a7c6f89323ac1876d49f92e7841f5'
                                                                                   ],
                                                                   'reported' => '2013-01-23'
                                                                 },
                                                                 {
                                                                   'affected_versions' => '<5.58',
                                                                   'description' => 'Path traversal in Static::Simple plugin.
',
                                                                   'distribution' => 'Catalyst-Runtime',
                                                                   'fixed_versions' => '>=5.58',
                                                                   'id' => 'CPANSA-Catalyst-Runtime-2005-01',
                                                                   'reported' => '2005-11-24'
                                                                 }
                                                               ],
                                               'main_module' => 'Catalyst::Runtime',
                                               'versions' => [
                                                               {
                                                                 'date' => '2006-06-25T19:20:53',
                                                                 'version' => '5.70_01'
                                                               },
                                                               {
                                                                 'date' => '2006-06-27T18:10:20',
                                                                 'version' => '5.70_02'
                                                               },
                                                               {
                                                                 'date' => '2006-06-28T21:50:30',
                                                                 'version' => '5.70_03'
                                                               },
                                                               {
                                                                 'date' => '2006-07-07T22:47:30',
                                                                 'version' => '5.7000'
                                                               },
                                                               {
                                                                 'date' => '2006-07-20T06:00:58',
                                                                 'version' => '5.7001'
                                                               },
                                                               {
                                                                 'date' => '2006-09-19T07:36:29',
                                                                 'version' => '5.7002'
                                                               },
                                                               {
                                                                 'date' => '2006-09-23T17:43:12',
                                                                 'version' => '5.7003'
                                                               },
                                                               {
                                                                 'date' => '2006-11-06T23:28:40',
                                                                 'version' => '5.7004'
                                                               },
                                                               {
                                                                 'date' => '2006-11-07T19:43:56',
                                                                 'version' => '5.7005'
                                                               },
                                                               {
                                                                 'date' => '2006-11-15T08:27:59',
                                                                 'version' => '5.7006'
                                                               },
                                                               {
                                                                 'date' => '2007-03-14T11:13:37',
                                                                 'version' => '5.7007'
                                                               },
                                                               {
                                                                 'date' => '2007-08-13T06:36:11',
                                                                 'version' => '5.7008'
                                                               },
                                                               {
                                                                 'date' => '2007-08-21T22:23:53',
                                                                 'version' => '5.7009'
                                                               },
                                                               {
                                                                 'date' => '2007-08-22T05:51:41',
                                                                 'version' => '5.7010'
                                                               },
                                                               {
                                                                 'date' => '2007-10-18T18:11:24',
                                                                 'version' => '5.7011'
                                                               },
                                                               {
                                                                 'date' => '2007-12-17T08:19:28',
                                                                 'version' => '5.7012'
                                                               },
                                                               {
                                                                 'date' => '2008-05-17T12:41:13',
                                                                 'version' => '5.7013'
                                                               },
                                                               {
                                                                 'date' => '2008-05-25T21:16:45',
                                                                 'version' => '5.7013'
                                                               },
                                                               {
                                                                 'date' => '2008-06-25T20:43:41',
                                                                 'version' => '5.7099_01'
                                                               },
                                                               {
                                                                 'date' => '2008-07-18T11:41:25',
                                                                 'version' => '5.7099_02'
                                                               },
                                                               {
                                                                 'date' => '2008-07-20T08:15:02',
                                                                 'version' => '5.7099_02'
                                                               },
                                                               {
                                                                 'date' => '2008-10-13T20:55:41',
                                                                 'version' => '5.7099_02'
                                                               },
                                                               {
                                                                 'date' => '2008-10-14T06:06:06',
                                                                 'version' => '5.7099_02'
                                                               },
                                                               {
                                                                 'date' => '2008-10-15T21:44:15',
                                                                 'version' => '5.7015'
                                                               },
                                                               {
                                                                 'date' => '2008-10-17T12:42:53',
                                                                 'version' => '5.8000_03'
                                                               },
                                                               {
                                                                 'date' => '2008-12-05T15:11:14',
                                                                 'version' => '5.8000_04'
                                                               },
                                                               {
                                                                 'date' => '2009-01-12T15:46:59',
                                                                 'version' => '5.7099_04'
                                                               },
                                                               {
                                                                 'date' => '2009-01-19T17:36:04',
                                                                 'version' => '5.71000'
                                                               },
                                                               {
                                                                 'date' => '2009-01-29T08:56:09',
                                                                 'version' => '5.8000_05'
                                                               },
                                                               {
                                                                 'date' => '2009-02-04T20:08:22',
                                                                 'version' => '5.8000_06'
                                                               },
                                                               {
                                                                 'date' => '2009-03-27T09:21:12',
                                                                 'version' => '5.71001'
                                                               },
                                                               {
                                                                 'date' => '2009-04-13T19:03:36',
                                                                 'version' => '5.8000_07'
                                                               },
                                                               {
                                                                 'date' => '2009-04-18T20:26:00',
                                                                 'version' => '5.80001'
                                                               },
                                                               {
                                                                 'date' => '2009-04-21T23:45:45',
                                                                 'version' => '5.80002'
                                                               },
                                                               {
                                                                 'date' => '2009-04-29T14:39:21',
                                                                 'version' => '5.80003'
                                                               },
                                                               {
                                                                 'date' => '2009-05-18T15:16:38',
                                                                 'version' => '5.80004'
                                                               },
                                                               {
                                                                 'date' => '2009-06-06T12:49:15',
                                                                 'version' => '5.80005'
                                                               },
                                                               {
                                                                 'date' => '2009-06-29T22:11:48',
                                                                 'version' => '5.80006'
                                                               },
                                                               {
                                                                 'date' => '2009-06-30T22:11:36',
                                                                 'version' => '5.80007'
                                                               },
                                                               {
                                                                 'date' => '2009-08-21T16:14:33',
                                                                 'version' => '5.80008'
                                                               },
                                                               {
                                                                 'date' => '2009-08-21T20:29:33',
                                                                 'version' => '5.80009'
                                                               },
                                                               {
                                                                 'date' => '2009-08-21T21:42:08',
                                                                 'version' => '5.80010'
                                                               },
                                                               {
                                                                 'date' => '2009-08-23T11:57:26',
                                                                 'version' => '5.80011'
                                                               },
                                                               {
                                                                 'date' => '2009-09-09T18:01:32',
                                                                 'version' => '5.80012'
                                                               },
                                                               {
                                                                 'date' => '2009-09-17T09:35:20',
                                                                 'version' => '5.80013'
                                                               },
                                                               {
                                                                 'date' => '2009-11-21T02:32:20',
                                                                 'version' => '5.80014'
                                                               },
                                                               {
                                                                 'date' => '2009-11-22T20:24:47',
                                                                 'version' => '5.80014_01'
                                                               },
                                                               {
                                                                 'date' => '2009-12-01T01:14:00',
                                                                 'version' => '5.80014_02'
                                                               },
                                                               {
                                                                 'date' => '2009-12-02T15:42:50',
                                                                 'version' => '5.80015'
                                                               },
                                                               {
                                                                 'date' => '2009-12-11T23:37:44',
                                                                 'version' => '5.80016'
                                                               },
                                                               {
                                                                 'date' => '2010-01-10T02:01:50',
                                                                 'version' => '5.80017'
                                                               },
                                                               {
                                                                 'date' => '2010-01-12T21:39:47',
                                                                 'version' => '5.80018'
                                                               },
                                                               {
                                                                 'date' => '2010-01-29T00:18:07',
                                                                 'version' => '5.80019'
                                                               },
                                                               {
                                                                 'date' => '2010-02-04T06:19:31',
                                                                 'version' => '5.80020'
                                                               },
                                                               {
                                                                 'date' => '2010-03-03T23:16:29',
                                                                 'version' => '5.80021'
                                                               },
                                                               {
                                                                 'date' => '2010-03-28T19:25:48',
                                                                 'version' => '5.80022'
                                                               },
                                                               {
                                                                 'date' => '2010-05-07T22:07:08',
                                                                 'version' => '5.80023'
                                                               },
                                                               {
                                                                 'date' => '2010-05-15T09:57:52',
                                                                 'version' => '5.80024'
                                                               },
                                                               {
                                                                 'date' => '2010-07-29T00:59:16',
                                                                 'version' => '5.80025'
                                                               },
                                                               {
                                                                 'date' => '2010-09-01T15:10:42',
                                                                 'version' => '5.80026'
                                                               },
                                                               {
                                                                 'date' => '2010-09-02T11:33:03',
                                                                 'version' => '5.80027'
                                                               },
                                                               {
                                                                 'date' => '2010-09-28T20:14:11',
                                                                 'version' => '5.80028'
                                                               },
                                                               {
                                                                 'date' => '2010-10-03T16:24:08',
                                                                 'version' => '5.80029'
                                                               },
                                                               {
                                                                 'date' => '2011-01-04T12:56:30',
                                                                 'version' => '5.80030'
                                                               },
                                                               {
                                                                 'date' => '2011-01-24T10:50:27',
                                                                 'version' => '5.89000'
                                                               },
                                                               {
                                                                 'date' => '2011-01-31T08:25:21',
                                                                 'version' => '5.80031'
                                                               },
                                                               {
                                                                 'date' => '2011-02-23T08:28:58',
                                                                 'version' => '5.80032'
                                                               },
                                                               {
                                                                 'date' => '2011-03-01T14:56:37',
                                                                 'version' => '5.89001'
                                                               },
                                                               {
                                                                 'date' => '2011-03-02T10:37:42',
                                                                 'version' => '5.89002'
                                                               },
                                                               {
                                                                 'date' => '2011-07-24T15:58:37',
                                                                 'version' => '5.80033'
                                                               },
                                                               {
                                                                 'date' => '2011-07-28T20:05:01',
                                                                 'version' => '5.89003'
                                                               },
                                                               {
                                                                 'date' => '2011-08-15T21:35:34',
                                                                 'version' => '5.9000'
                                                               },
                                                               {
                                                                 'date' => '2011-08-15T21:59:58',
                                                                 'version' => '5.90001'
                                                               },
                                                               {
                                                                 'date' => '2011-08-22T20:55:10',
                                                                 'version' => '5.90002'
                                                               },
                                                               {
                                                                 'date' => '2011-10-05T07:48:57',
                                                                 'version' => '5.90003'
                                                               },
                                                               {
                                                                 'date' => '2011-10-11T15:19:05',
                                                                 'version' => '5.90004'
                                                               },
                                                               {
                                                                 'date' => '2011-10-22T21:01:24',
                                                                 'version' => '5.90005'
                                                               },
                                                               {
                                                                 'date' => '2011-10-25T17:54:34',
                                                                 'version' => '5.90006'
                                                               },
                                                               {
                                                                 'date' => '2011-11-22T20:40:44',
                                                                 'version' => '5.90007'
                                                               },
                                                               {
                                                                 'date' => '2012-02-06T21:08:28',
                                                                 'version' => '5.90008'
                                                               },
                                                               {
                                                                 'date' => '2012-02-16T09:29:44',
                                                                 'version' => '5.90009'
                                                               },
                                                               {
                                                                 'date' => '2012-02-18T00:49:30',
                                                                 'version' => '5.90010'
                                                               },
                                                               {
                                                                 'date' => '2012-03-08T21:53:00',
                                                                 'version' => '5.90011'
                                                               },
                                                               {
                                                                 'date' => '2012-05-19T07:13:21',
                                                                 'version' => '5.90012'
                                                               },
                                                               {
                                                                 'date' => '2012-06-08T00:37:40',
                                                                 'version' => '5.90013'
                                                               },
                                                               {
                                                                 'date' => '2012-06-21T20:41:41',
                                                                 'version' => '5.90013'
                                                               },
                                                               {
                                                                 'date' => '2012-06-26T14:34:56',
                                                                 'version' => '5.90014'
                                                               },
                                                               {
                                                                 'date' => '2012-06-30T18:00:53',
                                                                 'version' => '5.90015'
                                                               },
                                                               {
                                                                 'date' => '2012-08-17T01:39:42',
                                                                 'version' => '5.90016'
                                                               },
                                                               {
                                                                 'date' => '2012-10-19T21:51:54',
                                                                 'version' => '5.90017'
                                                               },
                                                               {
                                                                 'date' => '2012-10-24T01:01:44',
                                                                 'version' => '5.90018'
                                                               },
                                                               {
                                                                 'date' => '2012-12-04T22:04:19',
                                                                 'version' => '5.90019'
                                                               },
                                                               {
                                                                 'date' => '2013-02-22T14:05:39',
                                                                 'version' => '5.90020'
                                                               },
                                                               {
                                                                 'date' => '2013-04-12T17:09:27',
                                                                 'version' => '5.90030'
                                                               },
                                                               {
                                                                 'date' => '2013-06-12T21:26:14',
                                                                 'version' => '5.90040'
                                                               },
                                                               {
                                                                 'date' => '2013-06-15T02:10:17',
                                                                 'version' => '5.90041'
                                                               },
                                                               {
                                                                 'date' => '2013-06-16T01:57:47',
                                                                 'version' => '5.90042'
                                                               },
                                                               {
                                                                 'date' => '2013-07-26T19:13:01',
                                                                 'version' => '5.90049_001'
                                                               },
                                                               {
                                                                 'date' => '2013-08-21T02:39:45',
                                                                 'version' => '5.90049_002'
                                                               },
                                                               {
                                                                 'date' => '2013-09-20T19:03:54',
                                                                 'version' => '5.90049_003'
                                                               },
                                                               {
                                                                 'date' => '2013-10-18T22:19:33',
                                                                 'version' => '5.90049_004'
                                                               },
                                                               {
                                                                 'date' => '2013-10-31T20:48:42',
                                                                 'version' => '5.90049_005'
                                                               },
                                                               {
                                                                 'date' => '2013-11-05T03:25:31',
                                                                 'version' => '5.90049_006'
                                                               },
                                                               {
                                                                 'date' => '2013-11-05T22:35:22',
                                                                 'version' => '5.90050'
                                                               },
                                                               {
                                                                 'date' => '2013-11-07T17:14:35',
                                                                 'version' => '5.90051'
                                                               },
                                                               {
                                                                 'date' => '2013-12-18T20:03:22',
                                                                 'version' => '5.90052'
                                                               },
                                                               {
                                                                 'date' => '2013-12-19T14:33:08',
                                                                 'version' => '5.90059_001'
                                                               },
                                                               {
                                                                 'date' => '2013-12-22T16:18:16',
                                                                 'version' => '5.90053'
                                                               },
                                                               {
                                                                 'date' => '2013-12-22T16:34:11',
                                                                 'version' => '5.90059_002'
                                                               },
                                                               {
                                                                 'date' => '2013-12-27T02:27:08',
                                                                 'version' => '5.90059_003'
                                                               },
                                                               {
                                                                 'date' => '2014-01-27T17:20:51',
                                                                 'version' => '5.90059_004'
                                                               },
                                                               {
                                                                 'date' => '2014-01-28T19:36:58',
                                                                 'version' => '5.90059_005'
                                                               },
                                                               {
                                                                 'date' => '2014-02-06T20:41:25',
                                                                 'version' => '5.90059_006'
                                                               },
                                                               {
                                                                 'date' => '2014-02-08T03:11:11',
                                                                 'version' => '5.90060'
                                                               },
                                                               {
                                                                 'date' => '2014-03-10T14:46:10',
                                                                 'version' => '5.90061'
                                                               },
                                                               {
                                                                 'date' => '2014-04-14T18:53:26',
                                                                 'version' => '5.90062'
                                                               },
                                                               {
                                                                 'date' => '2014-05-02T00:15:16',
                                                                 'version' => '5.90063'
                                                               },
                                                               {
                                                                 'date' => '2014-05-05T14:55:25',
                                                                 'version' => '5.90064'
                                                               },
                                                               {
                                                                 'date' => '2014-05-27T18:08:08',
                                                                 'version' => '5.90069_001'
                                                               },
                                                               {
                                                                 'date' => '2014-06-05T12:44:59',
                                                                 'version' => '5.90065'
                                                               },
                                                               {
                                                                 'date' => '2014-06-10T00:22:42',
                                                                 'version' => '5.90069_002'
                                                               },
                                                               {
                                                                 'date' => '2014-08-06T15:09:29',
                                                                 'version' => '5.90069_003'
                                                               },
                                                               {
                                                                 'date' => '2014-08-07T15:59:15',
                                                                 'version' => '5.90069_004'
                                                               },
                                                               {
                                                                 'date' => '2014-08-07T21:49:59',
                                                                 'version' => '5.90070'
                                                               },
                                                               {
                                                                 'date' => '2014-08-10T13:15:52',
                                                                 'version' => '5.90071'
                                                               },
                                                               {
                                                                 'date' => '2014-09-15T16:30:58',
                                                                 'version' => '5.90072'
                                                               },
                                                               {
                                                                 'date' => '2014-09-23T17:24:54',
                                                                 'version' => '5.90073'
                                                               },
                                                               {
                                                                 'date' => '2014-10-01T21:45:12',
                                                                 'version' => '5.90074'
                                                               },
                                                               {
                                                                 'date' => '2014-10-07T00:07:51',
                                                                 'version' => '5.90075'
                                                               },
                                                               {
                                                                 'date' => '2014-11-14T00:20:16',
                                                                 'version' => '5.90076'
                                                               },
                                                               {
                                                                 'date' => '2014-11-19T00:28:27',
                                                                 'version' => '5.90077'
                                                               },
                                                               {
                                                                 'date' => '2014-12-02T21:50:30',
                                                                 'version' => '5.90079_001'
                                                               },
                                                               {
                                                                 'date' => '2014-12-02T23:22:07',
                                                                 'version' => '5.90079_002'
                                                               },
                                                               {
                                                                 'date' => '2014-12-03T19:45:16',
                                                                 'version' => '5.90079_003'
                                                               },
                                                               {
                                                                 'date' => '2014-12-26T23:05:46',
                                                                 'version' => '5.90079_004'
                                                               },
                                                               {
                                                                 'date' => '2014-12-31T16:26:20',
                                                                 'version' => '5.90078'
                                                               },
                                                               {
                                                                 'date' => '2014-12-31T21:04:56',
                                                                 'version' => '5.90079_005'
                                                               },
                                                               {
                                                                 'date' => '2015-01-02T15:11:55',
                                                                 'version' => '5.90079_006'
                                                               },
                                                               {
                                                                 'date' => '2015-01-02T18:11:38',
                                                                 'version' => '5.90079'
                                                               },
                                                               {
                                                                 'date' => '2015-01-07T20:01:40',
                                                                 'version' => '5.90079_007'
                                                               },
                                                               {
                                                                 'date' => '2015-01-07T23:26:17',
                                                                 'version' => '5.90079_008'
                                                               },
                                                               {
                                                                 'date' => '2015-01-09T17:04:47',
                                                                 'version' => '5.90080'
                                                               },
                                                               {
                                                                 'date' => '2015-01-10T22:39:56',
                                                                 'version' => '5.90081'
                                                               },
                                                               {
                                                                 'date' => '2015-01-10T23:33:56',
                                                                 'version' => '5.90082'
                                                               },
                                                               {
                                                                 'date' => '2015-02-17T02:29:50',
                                                                 'version' => '5.90083'
                                                               },
                                                               {
                                                                 'date' => '2015-02-23T22:24:50',
                                                                 'version' => '5.90084'
                                                               },
                                                               {
                                                                 'date' => '2015-03-25T18:58:11',
                                                                 'version' => '5.90085'
                                                               },
                                                               {
                                                                 'date' => '2015-03-26T21:30:15',
                                                                 'version' => '5.90089_001'
                                                               },
                                                               {
                                                                 'date' => '2015-04-17T21:32:30',
                                                                 'version' => '5.90089_002'
                                                               },
                                                               {
                                                                 'date' => '2015-04-27T20:20:40',
                                                                 'version' => '5.90089_003'
                                                               },
                                                               {
                                                                 'date' => '2015-04-28T18:24:12',
                                                                 'version' => '5.90089_004'
                                                               },
                                                               {
                                                                 'date' => '2015-04-29T14:04:24',
                                                                 'version' => '5.90090'
                                                               },
                                                               {
                                                                 'date' => '2015-05-08T20:36:59',
                                                                 'version' => '5.90091'
                                                               },
                                                               {
                                                                 'date' => '2015-05-19T16:48:30',
                                                                 'version' => '5.90092'
                                                               },
                                                               {
                                                                 'date' => '2015-05-29T17:06:23',
                                                                 'version' => '5.90093'
                                                               },
                                                               {
                                                                 'date' => '2015-07-24T20:17:46',
                                                                 'version' => '5.90094'
                                                               },
                                                               {
                                                                 'date' => '2015-07-27T14:32:30',
                                                                 'version' => '5.90095'
                                                               },
                                                               {
                                                                 'date' => '2015-07-27T15:44:59',
                                                                 'version' => '5.90096'
                                                               },
                                                               {
                                                                 'date' => '2015-07-28T20:33:41',
                                                                 'version' => '5.90097'
                                                               },
                                                               {
                                                                 'date' => '2015-08-24T16:30:12',
                                                                 'version' => '5.90100'
                                                               },
                                                               {
                                                                 'date' => '2015-09-04T22:57:40',
                                                                 'version' => '5.90101'
                                                               },
                                                               {
                                                                 'date' => '2015-10-29T19:39:24',
                                                                 'version' => '5.90102'
                                                               },
                                                               {
                                                                 'date' => '2015-11-12T10:19:42',
                                                                 'version' => '5.90103'
                                                               },
                                                               {
                                                                 'date' => '2016-04-04T17:18:38',
                                                                 'version' => '5.90104'
                                                               },
                                                               {
                                                                 'date' => '2016-06-08T20:06:53',
                                                                 'version' => '5.90105'
                                                               },
                                                               {
                                                                 'date' => '2016-07-06T01:21:42',
                                                                 'version' => '5.90106'
                                                               },
                                                               {
                                                                 'date' => '2016-07-20T19:12:32',
                                                                 'version' => '5.90110'
                                                               },
                                                               {
                                                                 'date' => '2016-07-20T20:07:16',
                                                                 'version' => '5.90111'
                                                               },
                                                               {
                                                                 'date' => '2016-07-25T21:03:05',
                                                                 'version' => '5.90112'
                                                               },
                                                               {
                                                                 'date' => '2016-12-15T21:35:30',
                                                                 'version' => '5.90113'
                                                               },
                                                               {
                                                                 'date' => '2016-12-19T16:54:08',
                                                                 'version' => '5.90114'
                                                               },
                                                               {
                                                                 'date' => '2017-05-01T16:42:46',
                                                                 'version' => '5.90115'
                                                               },
                                                               {
                                                                 'date' => '2018-01-19T20:55:15',
                                                                 'version' => '5.90116'
                                                               },
                                                               {
                                                                 'date' => '2018-01-21T23:47:21',
                                                                 'version' => '5.90117'
                                                               },
                                                               {
                                                                 'date' => '2018-05-01T09:59:20',
                                                                 'version' => '5.90118'
                                                               },
                                                               {
                                                                 'date' => '2018-09-24T00:25:48',
                                                                 'version' => '5.90119'
                                                               },
                                                               {
                                                                 'date' => '2018-10-19T06:13:58',
                                                                 'version' => '5.90120'
                                                               },
                                                               {
                                                                 'date' => '2018-10-22T20:39:48',
                                                                 'version' => '5.90_121'
                                                               },
                                                               {
                                                                 'date' => '2018-11-03T14:52:06',
                                                                 'version' => '5.90122'
                                                               },
                                                               {
                                                                 'date' => '2018-11-27T15:39:35',
                                                                 'version' => '5.90123'
                                                               },
                                                               {
                                                                 'date' => '2019-01-18T22:36:07',
                                                                 'version' => '5.90124'
                                                               }
                                                             ]
                                             },
                       'Cmd-Dwarf' => {
                                        'advisories' => [
                                                          {
                                                            'affected_versions' => '<1.20',
                                                            'description' => 'JSON highjacking possibility.
',
                                                            'distribution' => 'Cmd-Dwarf',
                                                            'fixed_versions' => '>=1.20',
                                                            'id' => 'CPANSA-Cmd-Dwarf-2014-01',
                                                            'references' => [
                                                                              'https://github.com/seagirl/dwarf/commit/14cf7a1d55db635a07f4838e16f3d9a28e63f529',
                                                                              'https://metacpan.org/changes/distribution/Cmd-Dwarf'
                                                                            ],
                                                            'reported' => '2014-12-03'
                                                          }
                                                        ],
                                        'main_module' => 'Cmd::Dwarf',
                                        'versions' => [
                                                        {
                                                          'date' => '2015-07-30T06:48:35',
                                                          'version' => '1.27'
                                                        },
                                                        {
                                                          'date' => '2015-08-26T13:27:51',
                                                          'version' => '1.28'
                                                        },
                                                        {
                                                          'date' => '2015-08-28T08:58:33',
                                                          'version' => '1.29'
                                                        },
                                                        {
                                                          'date' => '2015-09-17T08:17:32',
                                                          'version' => '1.30'
                                                        },
                                                        {
                                                          'date' => '2016-01-20T06:39:15',
                                                          'version' => '1.31'
                                                        },
                                                        {
                                                          'date' => '2016-10-25T05:56:33',
                                                          'version' => '1.41'
                                                        },
                                                        {
                                                          'date' => '2017-03-29T04:42:05',
                                                          'version' => '1.42'
                                                        },
                                                        {
                                                          'date' => '2017-06-21T07:06:05',
                                                          'version' => '1.50'
                                                        },
                                                        {
                                                          'date' => '2017-10-05T08:08:01',
                                                          'version' => '1.60'
                                                        },
                                                        {
                                                          'date' => '2018-03-17T07:35:19',
                                                          'version' => '1.70'
                                                        },
                                                        {
                                                          'date' => '2018-08-18T11:43:10',
                                                          'version' => '1.80'
                                                        }
                                                      ]
                                      },
                       'Compress-LZ4' => {
                                           'advisories' => [
                                                             {
                                                               'affected_versions' => '<0.20',
                                                               'description' => 'Outdated LZ4 source code with security issue on 32bit systems.
',
                                                               'distribution' => 'Compress-LZ4',
                                                               'fixed_versions' => '>=0.20',
                                                               'id' => 'CPANSA-Compress-LZ4-2014-01',
                                                               'references' => [
                                                                                 'https://metacpan.org/changes/distribution/Compress-LZ4',
                                                                                 'https://github.com/gray/compress-lz4/commit/fc503812b4cbba16429658e1dfe20ad8bbfd77a0'
                                                                               ],
                                                               'reported' => '2014-07-07'
                                                             }
                                                           ],
                                           'main_module' => 'Compress::LZ4',
                                           'versions' => [
                                                           {
                                                             'date' => '2012-02-11T16:33:26',
                                                             'version' => '0.01'
                                                           },
                                                           {
                                                             'date' => '2012-02-20T21:26:48',
                                                             'version' => '0.02'
                                                           },
                                                           {
                                                             'date' => '2012-03-02T04:47:50',
                                                             'version' => '0.03'
                                                           },
                                                           {
                                                             'date' => '2012-03-18T07:09:30',
                                                             'version' => '0.04'
                                                           },
                                                           {
                                                             'date' => '2012-03-18T19:45:25',
                                                             'version' => '0.05'
                                                           },
                                                           {
                                                             'date' => '2012-03-22T09:23:45',
                                                             'version' => '0.06'
                                                           },
                                                           {
                                                             'date' => '2012-03-22T16:12:43',
                                                             'version' => '0.07'
                                                           },
                                                           {
                                                             'date' => '2012-03-23T16:29:14',
                                                             'version' => '0.08'
                                                           },
                                                           {
                                                             'date' => '2012-03-23T17:27:12',
                                                             'version' => '0.09'
                                                           },
                                                           {
                                                             'date' => '2012-03-26T11:28:24',
                                                             'version' => '0.10'
                                                           },
                                                           {
                                                             'date' => '2012-04-03T21:36:24',
                                                             'version' => '0.11'
                                                           },
                                                           {
                                                             'date' => '2012-04-04T12:55:22',
                                                             'version' => '0.12'
                                                           },
                                                           {
                                                             'date' => '2012-06-01T18:55:41',
                                                             'version' => '0.13'
                                                           },
                                                           {
                                                             'date' => '2012-08-10T00:21:56',
                                                             'version' => '0.14'
                                                           },
                                                           {
                                                             'date' => '2012-08-11T16:37:53',
                                                             'version' => '0.15'
                                                           },
                                                           {
                                                             'date' => '2012-09-08T18:18:41',
                                                             'version' => '0.16'
                                                           },
                                                           {
                                                             'date' => '2013-03-19T00:39:07',
                                                             'version' => '0.17'
                                                           },
                                                           {
                                                             'date' => '2013-11-19T00:56:57',
                                                             'version' => '0.18'
                                                           },
                                                           {
                                                             'date' => '2014-02-08T00:35:09',
                                                             'version' => '0.19'
                                                           },
                                                           {
                                                             'date' => '2014-07-07T21:08:49',
                                                             'version' => '0.20'
                                                           },
                                                           {
                                                             'date' => '2015-05-12T19:01:36',
                                                             'version' => '0.21'
                                                           },
                                                           {
                                                             'date' => '2015-05-20T06:16:53',
                                                             'version' => '0.22'
                                                           },
                                                           {
                                                             'date' => '2016-07-25T20:45:05',
                                                             'version' => '0.23'
                                                           },
                                                           {
                                                             'date' => '2017-03-23T04:34:45',
                                                             'version' => '0.24'
                                                           },
                                                           {
                                                             'date' => '2017-04-06T16:38:31',
                                                             'version' => '0.25'
                                                           }
                                                         ]
                                         },
                       'Compress-Raw-Bzip2' => {
                                                 'advisories' => [
                                                                   {
                                                                     'affected_versions' => '<2.031',
                                                                     'cves' => [
                                                                                 'VE-2010-0405'
                                                                               ],
                                                                     'description' => 'Integer overflow in the BZ2_decompress function in decompress.c in bzip2 and libbzip2 before 1.0.6 allows context-dependent attackers to cause a denial of service (application crash) or possibly execute arbitrary code via a crafted compressed file.
',
                                                                     'distribution' => 'Compress-Raw-Bzip2',
                                                                     'fixed_versions' => '>=2.031',
                                                                     'id' => 'CPANSA-Compress-Raw-Bzip2-2010-01',
                                                                     'references' => [
                                                                                       'https://metacpan.org/changes/distribution/Compress-Raw-Bzip2'
                                                                                     ],
                                                                     'reported' => '2010-01-27'
                                                                   }
                                                                 ],
                                                 'main_module' => 'Compress::Raw::Bzip2',
                                                 'versions' => [
                                                                 {
                                                                   'date' => '2006-03-13T16:14:00',
                                                                   'version' => '2.000_10'
                                                                 },
                                                                 {
                                                                   'date' => '2006-04-15T21:23:09',
                                                                   'version' => '2.000_11'
                                                                 },
                                                                 {
                                                                   'date' => '2006-05-17T12:43:30',
                                                                   'version' => '2.000_12'
                                                                 },
                                                                 {
                                                                   'date' => '2006-06-20T12:43:47',
                                                                   'version' => '2.000_13'
                                                                 },
                                                                 {
                                                                   'date' => '2006-10-26T14:15:45',
                                                                   'version' => '2.000_14'
                                                                 },
                                                                 {
                                                                   'date' => '2006-11-01T10:35:27',
                                                                   'version' => '2.001'
                                                                 },
                                                                 {
                                                                   'date' => '2006-12-29T20:40:23',
                                                                   'version' => '2.002'
                                                                 },
                                                                 {
                                                                   'date' => '2007-01-02T13:03:45',
                                                                   'version' => '2.003'
                                                                 },
                                                                 {
                                                                   'date' => '2007-03-03T15:50:04',
                                                                   'version' => '2.004'
                                                                 },
                                                                 {
                                                                   'date' => '2007-07-01T00:06:51',
                                                                   'version' => '2.005'
                                                                 },
                                                                 {
                                                                   'date' => '2007-09-01T19:44:48',
                                                                   'version' => '2.006'
                                                                 },
                                                                 {
                                                                   'date' => '2007-11-10T11:59:25',
                                                                   'version' => '2.008'
                                                                 },
                                                                 {
                                                                   'date' => '2008-04-20T14:41:25',
                                                                   'version' => '2.009'
                                                                 },
                                                                 {
                                                                   'date' => '2008-05-05T17:18:15',
                                                                   'version' => '2.010'
                                                                 },
                                                                 {
                                                                   'date' => '2008-05-17T11:16:17',
                                                                   'version' => '2.011'
                                                                 },
                                                                 {
                                                                   'date' => '2008-07-15T22:23:56',
                                                                   'version' => '2.012'
                                                                 },
                                                                 {
                                                                   'date' => '2008-09-02T20:20:05',
                                                                   'version' => '2.014'
                                                                 },
                                                                 {
                                                                   'date' => '2008-09-03T20:47:15',
                                                                   'version' => '2.015'
                                                                 },
                                                                 {
                                                                   'date' => '2009-04-04T09:47:36',
                                                                   'version' => '2.017'
                                                                 },
                                                                 {
                                                                   'date' => '2009-05-03T16:26:57',
                                                                   'version' => '2.018'
                                                                 },
                                                                 {
                                                                   'date' => '2009-05-04T09:42:06',
                                                                   'version' => '2.019'
                                                                 },
                                                                 {
                                                                   'date' => '2009-06-03T17:48:18',
                                                                   'version' => '2.020'
                                                                 },
                                                                 {
                                                                   'date' => '2009-08-30T20:25:24',
                                                                   'version' => '2.021'
                                                                 },
                                                                 {
                                                                   'date' => '2009-11-09T23:25:19',
                                                                   'version' => '2.023'
                                                                 },
                                                                 {
                                                                   'date' => '2010-01-09T17:56:12',
                                                                   'version' => '2.024'
                                                                 },
                                                                 {
                                                                   'date' => '2010-03-28T12:56:33',
                                                                   'version' => '2.025'
                                                                 },
                                                                 {
                                                                   'date' => '2010-04-07T19:49:29',
                                                                   'version' => '2.026'
                                                                 },
                                                                 {
                                                                   'date' => '2010-04-24T19:15:32',
                                                                   'version' => '2.027'
                                                                 },
                                                                 {
                                                                   'date' => '2010-07-24T14:29:17',
                                                                   'version' => '2.030'
                                                                 },
                                                                 {
                                                                   'date' => '2010-09-21T19:44:52',
                                                                   'version' => '2.031'
                                                                 },
                                                                 {
                                                                   'date' => '2011-01-06T11:26:00',
                                                                   'version' => '2.032'
                                                                 },
                                                                 {
                                                                   'date' => '2011-01-11T14:02:05',
                                                                   'version' => '2.033'
                                                                 },
                                                                 {
                                                                   'date' => '2011-05-02T21:50:15',
                                                                   'version' => '2.034'
                                                                 },
                                                                 {
                                                                   'date' => '2011-05-07T08:30:09',
                                                                   'version' => '2.035'
                                                                 },
                                                                 {
                                                                   'date' => '2011-06-18T21:45:13',
                                                                   'version' => '2.036'
                                                                 },
                                                                 {
                                                                   'date' => '2011-06-22T07:17:56',
                                                                   'version' => '2.037'
                                                                 },
                                                                 {
                                                                   'date' => '2011-10-28T14:27:59',
                                                                   'version' => '2.039'
                                                                 },
                                                                 {
                                                                   'date' => '2011-10-28T22:18:59',
                                                                   'version' => '2.040'
                                                                 },
                                                                 {
                                                                   'date' => '2011-11-17T23:44:58',
                                                                   'version' => '2.042'
                                                                 },
                                                                 {
                                                                   'date' => '2011-11-20T21:31:34',
                                                                   'version' => '2.043'
                                                                 },
                                                                 {
                                                                   'date' => '2011-12-03T22:48:47',
                                                                   'version' => '2.044'
                                                                 },
                                                                 {
                                                                   'date' => '2011-12-04T19:19:58',
                                                                   'version' => '2.045'
                                                                 },
                                                                 {
                                                                   'date' => '2012-01-28T23:26:44',
                                                                   'version' => '2.047'
                                                                 },
                                                                 {
                                                                   'date' => '2012-01-29T16:58:55',
                                                                   'version' => '2.048'
                                                                 },
                                                                 {
                                                                   'date' => '2012-02-18T15:56:34',
                                                                   'version' => '2.049'
                                                                 },
                                                                 {
                                                                   'date' => '2012-04-29T12:40:06',
                                                                   'version' => '2.052'
                                                                 },
                                                                 {
                                                                   'date' => '2012-08-05T20:35:37',
                                                                   'version' => '2.055'
                                                                 },
                                                                 {
                                                                   'date' => '2012-11-10T19:08:29',
                                                                   'version' => '2.057'
                                                                 },
                                                                 {
                                                                   'date' => '2012-11-12T22:14:16',
                                                                   'version' => '2.058'
                                                                 },
                                                                 {
                                                                   'date' => '2012-11-25T13:38:19',
                                                                   'version' => '2.059'
                                                                 },
                                                                 {
                                                                   'date' => '2013-01-07T20:02:08',
                                                                   'version' => '2.060'
                                                                 },
                                                                 {
                                                                   'date' => '2013-05-27T09:54:30',
                                                                   'version' => '2.061'
                                                                 },
                                                                 {
                                                                   'date' => '2013-08-12T19:06:20',
                                                                   'version' => '2.062'
                                                                 },
                                                                 {
                                                                   'date' => '2013-11-02T17:14:54',
                                                                   'version' => '2.063'
                                                                 },
                                                                 {
                                                                   'date' => '2014-02-01T23:19:50',
                                                                   'version' => '2.064'
                                                                 },
                                                                 {
                                                                   'date' => '2014-09-21T12:40:58',
                                                                   'version' => '2.066'
                                                                 },
                                                                 {
                                                                   'date' => '2014-12-08T15:12:21',
                                                                   'version' => '2.067'
                                                                 },
                                                                 {
                                                                   'date' => '2014-12-23T17:44:34',
                                                                   'version' => '2.068'
                                                                 },
                                                                 {
                                                                   'date' => '2015-09-27T14:33:57',
                                                                   'version' => '2.069'
                                                                 },
                                                                 {
                                                                   'date' => '2016-12-28T23:07:42',
                                                                   'version' => '2.070'
                                                                 },
                                                                 {
                                                                   'date' => '2017-02-12T20:39:20',
                                                                   'version' => '2.072'
                                                                 },
                                                                 {
                                                                   'date' => '2017-02-19T20:35:17',
                                                                   'version' => '2.073'
                                                                 },
                                                                 {
                                                                   'date' => '2017-02-19T22:11:17',
                                                                   'version' => '2.074'
                                                                 },
                                                                 {
                                                                   'date' => '2018-04-03T18:20:04',
                                                                   'version' => '2.080'
                                                                 },
                                                                 {
                                                                   'date' => '2018-04-08T15:01:21',
                                                                   'version' => '2.081'
                                                                 },
                                                                 {
                                                                   'date' => '2018-12-30T22:38:05',
                                                                   'version' => '2.083'
                                                                 },
                                                                 {
                                                                   'date' => '2019-01-06T08:56:52',
                                                                   'version' => '2.084'
                                                                 }
                                                               ]
                                               },
                       'Compress-Raw-Zlib' => {
                                                'advisories' => [
                                                                  {
                                                                    'affected_versions' => '<2.075',
                                                                    'cves' => [
                                                                                'CVE-2016-9843',
                                                                                'CVE-2016-9841',
                                                                                'CVE-2016-9840',
                                                                                'CVE-2016-9842'
                                                                              ],
                                                                    'description' => 'Zlib vulnerabilities.
',
                                                                    'distribution' => 'Compress-Raw-Zlib',
                                                                    'fixed_versions' => '>=2.075',
                                                                    'id' => 'CPANSA-Compress-Raw-Zlib-2017-01',
                                                                    'references' => [
                                                                                      'https://metacpan.org/changes/distribution/Compress-Raw-Zlib'
                                                                                    ],
                                                                    'reported' => '2017-11-14'
                                                                  }
                                                                ],
                                                'main_module' => 'Compress::Raw::Zlib',
                                                'versions' => [
                                                                {
                                                                  'date' => '2006-03-03T23:06:38',
                                                                  'version' => '2.000_09'
                                                                },
                                                                {
                                                                  'date' => '2006-03-13T16:14:20',
                                                                  'version' => '2.000_10'
                                                                },
                                                                {
                                                                  'date' => '2006-04-15T21:23:24',
                                                                  'version' => '2.000_11'
                                                                },
                                                                {
                                                                  'date' => '2006-05-17T12:43:41',
                                                                  'version' => '2.000_12'
                                                                },
                                                                {
                                                                  'date' => '2006-06-20T12:45:30',
                                                                  'version' => '2.000_13'
                                                                },
                                                                {
                                                                  'date' => '2006-10-26T14:15:34',
                                                                  'version' => '2.000_09'
                                                                },
                                                                {
                                                                  'date' => '2006-11-01T10:35:38',
                                                                  'version' => '2.001'
                                                                },
                                                                {
                                                                  'date' => '2006-12-29T20:40:35',
                                                                  'version' => '2.002'
                                                                },
                                                                {
                                                                  'date' => '2007-01-02T13:03:57',
                                                                  'version' => '2.003'
                                                                },
                                                                {
                                                                  'date' => '2007-03-03T15:50:15',
                                                                  'version' => '2.004'
                                                                },
                                                                {
                                                                  'date' => '2007-07-01T00:07:02',
                                                                  'version' => '2.005'
                                                                },
                                                                {
                                                                  'date' => '2007-09-01T19:44:59',
                                                                  'version' => '2.006'
                                                                },
                                                                {
                                                                  'date' => '2007-11-10T11:59:36',
                                                                  'version' => '2.008'
                                                                },
                                                                {
                                                                  'date' => '2008-04-20T14:42:52',
                                                                  'version' => '2.009'
                                                                },
                                                                {
                                                                  'date' => '2008-05-05T17:18:27',
                                                                  'version' => '2.010'
                                                                },
                                                                {
                                                                  'date' => '2008-05-17T11:16:28',
                                                                  'version' => '2.011'
                                                                },
                                                                {
                                                                  'date' => '2008-07-15T22:24:07',
                                                                  'version' => '2.012'
                                                                },
                                                                {
                                                                  'date' => '2008-09-02T20:20:16',
                                                                  'version' => '2.014'
                                                                },
                                                                {
                                                                  'date' => '2008-09-03T20:47:27',
                                                                  'version' => '2.015'
                                                                },
                                                                {
                                                                  'date' => '2009-04-04T09:49:03',
                                                                  'version' => '2.017'
                                                                },
                                                                {
                                                                  'date' => '2009-05-03T16:27:08',
                                                                  'version' => '2.018'
                                                                },
                                                                {
                                                                  'date' => '2009-05-04T09:42:17',
                                                                  'version' => '2.019'
                                                                },
                                                                {
                                                                  'date' => '2009-06-03T17:48:30',
                                                                  'version' => '2.020'
                                                                },
                                                                {
                                                                  'date' => '2009-08-30T20:25:35',
                                                                  'version' => '2.021'
                                                                },
                                                                {
                                                                  'date' => '2009-11-09T23:26:59',
                                                                  'version' => '2.023'
                                                                },
                                                                {
                                                                  'date' => '2010-01-09T17:56:35',
                                                                  'version' => '2.024'
                                                                },
                                                                {
                                                                  'date' => '2010-03-28T12:57:08',
                                                                  'version' => '2.025'
                                                                },
                                                                {
                                                                  'date' => '2010-04-07T19:51:09',
                                                                  'version' => '2.026'
                                                                },
                                                                {
                                                                  'date' => '2010-04-24T19:15:54',
                                                                  'version' => '2.027'
                                                                },
                                                                {
                                                                  'date' => '2010-07-24T14:31:01',
                                                                  'version' => '2.030'
                                                                },
                                                                {
                                                                  'date' => '2011-01-06T11:23:45',
                                                                  'version' => '2.032'
                                                                },
                                                                {
                                                                  'date' => '2011-01-11T14:03:45',
                                                                  'version' => '2.033'
                                                                },
                                                                {
                                                                  'date' => '2011-05-02T22:05:37',
                                                                  'version' => '2.034'
                                                                },
                                                                {
                                                                  'date' => '2011-05-07T08:31:57',
                                                                  'version' => '2.035'
                                                                },
                                                                {
                                                                  'date' => '2011-06-18T21:45:36',
                                                                  'version' => '2.036'
                                                                },
                                                                {
                                                                  'date' => '2011-06-22T07:18:22',
                                                                  'version' => '2.037'
                                                                },
                                                                {
                                                                  'date' => '2011-10-28T14:28:35',
                                                                  'version' => '2.039'
                                                                },
                                                                {
                                                                  'date' => '2011-10-28T22:20:38',
                                                                  'version' => '2.040'
                                                                },
                                                                {
                                                                  'date' => '2011-11-17T23:45:21',
                                                                  'version' => '2.042'
                                                                },
                                                                {
                                                                  'date' => '2011-11-20T21:33:33',
                                                                  'version' => '2.043'
                                                                },
                                                                {
                                                                  'date' => '2011-12-03T22:49:10',
                                                                  'version' => '2.044'
                                                                },
                                                                {
                                                                  'date' => '2011-12-04T19:21:36',
                                                                  'version' => '2.045'
                                                                },
                                                                {
                                                                  'date' => '2012-01-28T23:28:28',
                                                                  'version' => '2.047'
                                                                },
                                                                {
                                                                  'date' => '2012-01-29T17:00:33',
                                                                  'version' => '2.048'
                                                                },
                                                                {
                                                                  'date' => '2012-02-18T15:58:12',
                                                                  'version' => '2.049'
                                                                },
                                                                {
                                                                  'date' => '2012-02-21T19:35:18',
                                                                  'version' => '2.050'
                                                                },
                                                                {
                                                                  'date' => '2012-02-22T20:43:23',
                                                                  'version' => '2.051'
                                                                },
                                                                {
                                                                  'date' => '2012-04-29T12:41:57',
                                                                  'version' => '2.052'
                                                                },
                                                                {
                                                                  'date' => '2012-05-06T08:40:06',
                                                                  'version' => '2.053'
                                                                },
                                                                {
                                                                  'date' => '2012-05-08T19:22:47',
                                                                  'version' => '2.054'
                                                                },
                                                                {
                                                                  'date' => '2012-08-05T20:36:06',
                                                                  'version' => '2.055'
                                                                },
                                                                {
                                                                  'date' => '2012-08-10T22:20:09',
                                                                  'version' => '2.056'
                                                                },
                                                                {
                                                                  'date' => '2012-11-10T19:08:56',
                                                                  'version' => '2.057'
                                                                },
                                                                {
                                                                  'date' => '2012-11-12T22:14:42',
                                                                  'version' => '2.058'
                                                                },
                                                                {
                                                                  'date' => '2012-11-25T13:38:42',
                                                                  'version' => '2.059'
                                                                },
                                                                {
                                                                  'date' => '2013-01-07T20:02:22',
                                                                  'version' => '2.060'
                                                                },
                                                                {
                                                                  'date' => '2013-05-27T09:54:54',
                                                                  'version' => '2.061'
                                                                },
                                                                {
                                                                  'date' => '2013-08-12T19:08:05',
                                                                  'version' => '2.062'
                                                                },
                                                                {
                                                                  'date' => '2013-11-02T17:15:17',
                                                                  'version' => '2.063'
                                                                },
                                                                {
                                                                  'date' => '2014-02-01T23:21:28',
                                                                  'version' => '2.064'
                                                                },
                                                                {
                                                                  'date' => '2014-02-03T20:23:00',
                                                                  'version' => '2.065'
                                                                },
                                                                {
                                                                  'date' => '2014-09-21T12:42:35',
                                                                  'version' => '2.066'
                                                                },
                                                                {
                                                                  'date' => '2014-12-08T15:14:00',
                                                                  'version' => '2.067'
                                                                },
                                                                {
                                                                  'date' => '2014-12-23T17:44:57',
                                                                  'version' => '2.068'
                                                                },
                                                                {
                                                                  'date' => '2015-09-26T18:41:58',
                                                                  'version' => '2.069'
                                                                },
                                                                {
                                                                  'date' => '2016-12-28T23:09:21',
                                                                  'version' => '2.070'
                                                                },
                                                                {
                                                                  'date' => '2016-12-30T22:58:08',
                                                                  'version' => '2.071'
                                                                },
                                                                {
                                                                  'date' => '2017-02-12T20:41:25',
                                                                  'version' => '2.072'
                                                                },
                                                                {
                                                                  'date' => '2017-02-19T20:37:20',
                                                                  'version' => '2.073'
                                                                },
                                                                {
                                                                  'date' => '2017-02-19T22:11:41',
                                                                  'version' => '2.074'
                                                                },
                                                                {
                                                                  'date' => '2017-11-14T15:43:26',
                                                                  'version' => '2.075'
                                                                },
                                                                {
                                                                  'date' => '2017-11-21T22:29:23',
                                                                  'version' => '2.076'
                                                                },
                                                                {
                                                                  'date' => '2018-04-03T18:22:06',
                                                                  'version' => '2.080'
                                                                },
                                                                {
                                                                  'date' => '2018-04-08T15:02:55',
                                                                  'version' => '2.081'
                                                                },
                                                                {
                                                                  'date' => '2018-12-30T22:40:08',
                                                                  'version' => '2.083'
                                                                },
                                                                {
                                                                  'date' => '2019-01-06T08:57:15',
                                                                  'version' => '2.084'
                                                                }
                                                              ]
                                              },
                       'Config-Model' => {
                                           'advisories' => [
                                                             {
                                                               'affected_versions' => '<2.102',
                                                               'cves' => [
                                                                           'CVE-2017-0373'
                                                                         ],
                                                               'description' => 'The gen_class_pod implementation in lib/Config/Model/Utils/GenClassPod.pm in Config-Model (aka libconfig-model-perl) before 2.102 has a dangerous "use lib" line, which allows remote attackers to have an unspecified impact via a crafted Debian package file.
',
                                                               'distribution' => 'Config-Model',
                                                               'fixed_versions' => '>=2.102',
                                                               'id' => 'CPANSA-Config-Model-2017-03',
                                                               'references' => [
                                                                                 'https://metacpan.org/changes/distribution/Config-Model',
                                                                                 'https://github.com/dod38fr/config-model/commit/9bd64d9ec6c0939166a2216a37d58dd19a725951'
                                                                               ],
                                                               'reported' => '2017-05-10'
                                                             },
                                                             {
                                                               'affected_versions' => '<2.102',
                                                               'cves' => [
                                                                           'CVE-2017-0374'
                                                                         ],
                                                               'description' => 'Loads models from a local directory, making it possible to substitute the model.
',
                                                               'distribution' => 'Config-Model',
                                                               'fixed_versions' => '>=2.102',
                                                               'id' => 'CPANSA-Config-Model-2017-02',
                                                               'references' => [
                                                                                 'https://metacpan.org/changes/distribution/Config-Model',
                                                                                 'https://github.com/dod38fr/config-model/commit/4d37c75b0c4f9633b67999f8260b08027a6bc524'
                                                                               ],
                                                               'reported' => '2017-05-10'
                                                             },
                                                             {
                                                               'affected_versions' => '<2.102',
                                                               'description' => 'YAML or YAML::XS can be loaded automatically making it possible to run arbitrary code loading a specially crafted YAML file.
',
                                                               'distribution' => 'Config-Model',
                                                               'fixed_versions' => '>=2.102',
                                                               'id' => 'CPANSA-Config-Model-2017-01',
                                                               'references' => [
                                                                                 'https://metacpan.org/changes/distribution/Config-Model',
                                                                                 'https://github.com/dod38fr/config-model/commit/01d212348bfbadf31bd74aadd26b1e391ff2fd92'
                                                                               ],
                                                               'reported' => '2017-05-10'
                                                             }
                                                           ],
                                           'main_module' => 'Config::Model',
                                           'versions' => [
                                                           {
                                                             'date' => '2006-04-21T12:27:44',
                                                             'version' => '0.505'
                                                           },
                                                           {
                                                             'date' => '2006-05-19T13:32:14',
                                                             'version' => '0.506'
                                                           },
                                                           {
                                                             'date' => '2006-06-15T12:10:38',
                                                             'version' => '0.507'
                                                           },
                                                           {
                                                             'date' => '2006-07-20T12:28:36',
                                                             'version' => '0.601'
                                                           },
                                                           {
                                                             'date' => '2006-09-07T12:06:17',
                                                             'version' => '0.602'
                                                           },
                                                           {
                                                             'date' => '2006-10-19T11:24:40',
                                                             'version' => '0.603'
                                                           },
                                                           {
                                                             'date' => '2006-12-06T12:58:35',
                                                             'version' => '0.604'
                                                           },
                                                           {
                                                             'date' => '2007-01-08T13:16:42',
                                                             'version' => '0.605'
                                                           },
                                                           {
                                                             'date' => '2007-01-11T12:42:09',
                                                             'version' => '0.606'
                                                           },
                                                           {
                                                             'date' => '2007-01-12T13:06:38',
                                                             'version' => '0.607'
                                                           },
                                                           {
                                                             'date' => '2007-02-23T13:00:34',
                                                             'version' => '0.608'
                                                           },
                                                           {
                                                             'date' => '2007-05-14T11:41:18',
                                                             'version' => '0.609'
                                                           },
                                                           {
                                                             'date' => '2007-06-06T12:28:06',
                                                             'version' => '0.610'
                                                           },
                                                           {
                                                             'date' => '2007-07-03T15:35:21',
                                                             'version' => '0.611'
                                                           },
                                                           {
                                                             'date' => '2007-07-27T11:38:57',
                                                             'version' => '0.612'
                                                           },
                                                           {
                                                             'date' => '2007-10-01T15:52:56',
                                                             'version' => '0.613'
                                                           },
                                                           {
                                                             'date' => '2007-10-23T16:10:29',
                                                             'version' => '0.614'
                                                           },
                                                           {
                                                             'date' => '2007-11-15T12:36:18',
                                                             'version' => '0.615'
                                                           },
                                                           {
                                                             'date' => '2007-12-04T12:41:22',
                                                             'version' => '0.616'
                                                           },
                                                           {
                                                             'date' => '2008-01-28T11:55:50',
                                                             'version' => '0.617'
                                                           },
                                                           {
                                                             'date' => '2008-02-14T12:56:25',
                                                             'version' => '0.618'
                                                           },
                                                           {
                                                             'date' => '2008-02-29T12:08:41',
                                                             'version' => '0.619'
                                                           },
                                                           {
                                                             'date' => '2008-03-18T17:40:57',
                                                             'version' => '0.620'
                                                           },
                                                           {
                                                             'date' => '2008-03-20T07:49:00',
                                                             'version' => '0.6201'
                                                           },
                                                           {
                                                             'date' => '2008-04-04T11:38:49',
                                                             'version' => '0.621'
                                                           },
                                                           {
                                                             'date' => '2008-04-25T16:23:31',
                                                             'version' => '0.622'
                                                           },
                                                           {
                                                             'date' => '2008-05-19T11:47:46',
                                                             'version' => '0.623'
                                                           },
                                                           {
                                                             'date' => '2008-07-25T11:35:07',
                                                             'version' => '0.624'
                                                           },
                                                           {
                                                             'date' => '2008-07-30T12:02:43',
                                                             'version' => '0.625'
                                                           },
                                                           {
                                                             'date' => '2008-09-22T12:20:00',
                                                             'version' => '0.626'
                                                           },
                                                           {
                                                             'date' => '2008-09-23T11:05:58',
                                                             'version' => '0.627'
                                                           },
                                                           {
                                                             'date' => '2008-09-29T12:35:05',
                                                             'version' => '0.628'
                                                           },
                                                           {
                                                             'date' => '2008-10-13T15:09:27',
                                                             'version' => '0.629'
                                                           },
                                                           {
                                                             'date' => '2008-10-21T11:59:27',
                                                             'version' => '0.630'
                                                           },
                                                           {
                                                             'date' => '2008-11-10T14:37:44',
                                                             'version' => '0.631'
                                                           },
                                                           {
                                                             'date' => '2008-12-16T13:32:26',
                                                             'version' => '0.632'
                                                           },
                                                           {
                                                             'date' => '2008-12-23T15:36:48',
                                                             'version' => '0.633'
                                                           },
                                                           {
                                                             'date' => '2009-03-05T13:06:32',
                                                             'version' => '0.634'
                                                           },
                                                           {
                                                             'date' => '2009-04-20T12:21:46',
                                                             'version' => '0.635'
                                                           },
                                                           {
                                                             'date' => '2009-05-30T16:19:54',
                                                             'version' => '0.636'
                                                           },
                                                           {
                                                             'date' => '2009-06-23T12:07:41',
                                                             'version' => '0.637'
                                                           },
                                                           {
                                                             'date' => '2009-06-30T11:31:35',
                                                             'version' => '0.638'
                                                           },
                                                           {
                                                             'date' => '2009-09-08T11:35:25',
                                                             'version' => '0.639'
                                                           },
                                                           {
                                                             'date' => '2009-09-09T16:10:41',
                                                             'version' => '0.640'
                                                           },
                                                           {
                                                             'date' => '2010-01-20T17:30:14',
                                                             'version' => '0.641'
                                                           },
                                                           {
                                                             'date' => '2010-01-21T17:17:34',
                                                             'version' => '0.642'
                                                           },
                                                           {
                                                             'date' => '2010-02-25T13:04:52',
                                                             'version' => '0.643'
                                                           },
                                                           {
                                                             'date' => '2010-03-12T15:24:45',
                                                             'version' => '0.644'
                                                           },
                                                           {
                                                             'date' => '2010-03-28T14:53:46',
                                                             'version' => '1.001'
                                                           },
                                                           {
                                                             'date' => '2010-04-22T12:22:00',
                                                             'version' => '1.202'
                                                           },
                                                           {
                                                             'date' => '2010-06-03T11:09:45',
                                                             'version' => '1.203'
                                                           },
                                                           {
                                                             'date' => '2010-06-03T11:20:09',
                                                             'version' => '1.204'
                                                           },
                                                           {
                                                             'date' => '2010-06-07T16:04:03',
                                                             'version' => '1.205'
                                                           },
                                                           {
                                                             'date' => '2010-08-13T10:53:09',
                                                             'version' => '1.206'
                                                           },
                                                           {
                                                             'date' => '2010-09-14T16:14:40',
                                                             'version' => '1.207'
                                                           },
                                                           {
                                                             'date' => '2010-09-16T11:46:11',
                                                             'version' => '1.208'
                                                           },
                                                           {
                                                             'date' => '2010-09-20T12:29:12',
                                                             'version' => '1.209'
                                                           },
                                                           {
                                                             'date' => '2010-09-30T16:34:27',
                                                             'version' => '1.210'
                                                           },
                                                           {
                                                             'date' => '2010-10-08T10:46:45',
                                                             'version' => '1.211'
                                                           },
                                                           {
                                                             'date' => '2010-10-15T11:08:52',
                                                             'version' => '1.212'
                                                           },
                                                           {
                                                             'date' => '2010-10-19T12:29:03',
                                                             'version' => '1.213'
                                                           },
                                                           {
                                                             'date' => '2010-10-19T15:17:01',
                                                             'version' => '1.214'
                                                           },
                                                           {
                                                             'date' => '2010-10-19T15:28:56',
                                                             'version' => '1.215'
                                                           },
                                                           {
                                                             'date' => '2010-10-26T12:16:51',
                                                             'version' => '1.216'
                                                           },
                                                           {
                                                             'date' => '2010-10-30T12:44:11',
                                                             'version' => '1.217'
                                                           },
                                                           {
                                                             'date' => '2010-11-05T11:53:14',
                                                             'version' => '1.218'
                                                           },
                                                           {
                                                             'date' => '2010-11-09T13:20:51',
                                                             'version' => '1.219'
                                                           },
                                                           {
                                                             'date' => '2010-11-10T08:41:22',
                                                             'version' => '1.220'
                                                           },
                                                           {
                                                             'date' => '2010-11-21T17:40:10',
                                                             'version' => '1.221'
                                                           },
                                                           {
                                                             'date' => '2010-11-22T14:01:55',
                                                             'version' => '1.222'
                                                           },
                                                           {
                                                             'date' => '2010-11-28T17:34:03',
                                                             'version' => '1.223'
                                                           },
                                                           {
                                                             'date' => '2010-12-06T13:18:53',
                                                             'version' => '1.224'
                                                           },
                                                           {
                                                             'date' => '2010-12-07T08:01:43',
                                                             'version' => '1.225'
                                                           },
                                                           {
                                                             'date' => '2010-12-08T18:48:08',
                                                             'version' => '1.226'
                                                           },
                                                           {
                                                             'date' => '2011-01-07T18:12:45',
                                                             'version' => '1.227'
                                                           },
                                                           {
                                                             'date' => '2011-01-09T12:27:15',
                                                             'version' => '1.228'
                                                           },
                                                           {
                                                             'date' => '2011-01-10T19:57:53',
                                                             'version' => '1.229'
                                                           },
                                                           {
                                                             'date' => '2011-01-20T16:47:27',
                                                             'version' => '1.230'
                                                           },
                                                           {
                                                             'date' => '2011-01-30T11:30:23',
                                                             'version' => '1.231'
                                                           },
                                                           {
                                                             'date' => '2011-01-30T13:51:34',
                                                             'version' => '1.232'
                                                           },
                                                           {
                                                             'date' => '2011-02-11T12:25:32',
                                                             'version' => '1.233'
                                                           },
                                                           {
                                                             'date' => '2011-02-21T17:11:22',
                                                             'version' => '1.234'
                                                           },
                                                           {
                                                             'date' => '2011-03-01T13:06:28',
                                                             'version' => '1.235'
                                                           },
                                                           {
                                                             'date' => '2011-04-01T14:09:03',
                                                             'version' => '1.236'
                                                           },
                                                           {
                                                             'date' => '2011-04-04T12:57:04',
                                                             'version' => '1.237'
                                                           },
                                                           {
                                                             'date' => '2011-04-05T14:45:45',
                                                             'version' => '1.238'
                                                           },
                                                           {
                                                             'date' => '2011-04-05T17:40:17',
                                                             'version' => '1.240'
                                                           },
                                                           {
                                                             'date' => '2011-04-07T18:09:49',
                                                             'version' => '1.241'
                                                           },
                                                           {
                                                             'date' => '2011-04-25T15:28:14',
                                                             'version' => '1.242'
                                                           },
                                                           {
                                                             'date' => '2011-05-02T12:33:33',
                                                             'version' => '1.243'
                                                           },
                                                           {
                                                             'date' => '2011-05-16T15:52:46',
                                                             'version' => '1.244'
                                                           },
                                                           {
                                                             'date' => '2011-06-17T12:10:22',
                                                             'version' => '1.245'
                                                           },
                                                           {
                                                             'date' => '2011-06-20T12:32:24',
                                                             'version' => '1.246'
                                                           },
                                                           {
                                                             'date' => '2011-06-27T14:14:52',
                                                             'version' => '1.247'
                                                           },
                                                           {
                                                             'date' => '2011-07-05T15:48:52',
                                                             'version' => '1.248'
                                                           },
                                                           {
                                                             'date' => '2011-07-12T09:54:39',
                                                             'version' => '1.249'
                                                           },
                                                           {
                                                             'date' => '2011-07-22T12:40:47',
                                                             'version' => '1.250'
                                                           },
                                                           {
                                                             'date' => '2011-08-30T12:16:32',
                                                             'version' => '1.251'
                                                           },
                                                           {
                                                             'date' => '2011-09-01T16:06:19',
                                                             'version' => '1.252'
                                                           },
                                                           {
                                                             'date' => '2011-09-02T16:03:35',
                                                             'version' => '1.253'
                                                           },
                                                           {
                                                             'date' => '2011-09-04T15:21:52',
                                                             'version' => '1.254'
                                                           },
                                                           {
                                                             'date' => '2011-09-15T15:23:39',
                                                             'version' => '1.255'
                                                           },
                                                           {
                                                             'date' => '2011-09-16T12:28:51',
                                                             'version' => '1.256'
                                                           },
                                                           {
                                                             'date' => '2011-09-23T10:52:00',
                                                             'version' => '1.257'
                                                           },
                                                           {
                                                             'date' => '2011-10-14T14:45:06',
                                                             'version' => '1.258'
                                                           },
                                                           {
                                                             'date' => '2011-10-16T10:17:53',
                                                             'version' => '1.259'
                                                           },
                                                           {
                                                             'date' => '2011-10-28T13:28:02',
                                                             'version' => '1.260'
                                                           },
                                                           {
                                                             'date' => '2011-11-18T17:02:26',
                                                             'version' => '1.261'
                                                           },
                                                           {
                                                             'date' => '2011-11-19T11:55:30',
                                                             'version' => '1.262'
                                                           },
                                                           {
                                                             'date' => '2011-11-29T15:43:38',
                                                             'version' => '1.263'
                                                           },
                                                           {
                                                             'date' => '2011-11-30T07:50:25',
                                                             'version' => '1.264'
                                                           },
                                                           {
                                                             'date' => '2011-12-06T18:26:54',
                                                             'version' => '1.265'
                                                           },
                                                           {
                                                             'date' => '2012-02-06T11:55:29',
                                                             'version' => '2.001'
                                                           },
                                                           {
                                                             'date' => '2012-02-08T09:49:49',
                                                             'version' => '2.002'
                                                           },
                                                           {
                                                             'date' => '2012-02-08T13:14:22',
                                                             'version' => '2.003'
                                                           },
                                                           {
                                                             'date' => '2012-02-09T11:28:18',
                                                             'version' => '2.004'
                                                           },
                                                           {
                                                             'date' => '2012-02-23T18:25:32',
                                                             'version' => '2.005'
                                                           },
                                                           {
                                                             'date' => '2012-02-25T11:30:41',
                                                             'version' => '2.006'
                                                           },
                                                           {
                                                             'date' => '2012-02-26T16:34:50',
                                                             'version' => '2.007'
                                                           },
                                                           {
                                                             'date' => '2012-03-01T12:40:23',
                                                             'version' => '2.008'
                                                           },
                                                           {
                                                             'date' => '2012-03-13T13:11:49',
                                                             'version' => '2.009'
                                                           },
                                                           {
                                                             'date' => '2012-03-13T13:15:03',
                                                             'version' => '2.010'
                                                           },
                                                           {
                                                             'date' => '2012-03-19T21:41:44',
                                                             'version' => '2.011'
                                                           },
                                                           {
                                                             'date' => '2012-04-05T11:41:54',
                                                             'version' => '2.012'
                                                           },
                                                           {
                                                             'date' => '2012-04-06T12:10:46',
                                                             'version' => '2.013'
                                                           },
                                                           {
                                                             'date' => '2012-05-04T13:57:13',
                                                             'version' => '2.014'
                                                           },
                                                           {
                                                             'date' => '2012-05-14T10:06:13',
                                                             'version' => '2.015'
                                                           },
                                                           {
                                                             'date' => '2012-05-20T08:38:36',
                                                             'version' => '2.016'
                                                           },
                                                           {
                                                             'date' => '2012-05-21T10:56:35',
                                                             'version' => '2.017'
                                                           },
                                                           {
                                                             'date' => '2012-05-29T13:53:06',
                                                             'version' => '2.018'
                                                           },
                                                           {
                                                             'date' => '2012-06-05T12:34:15',
                                                             'version' => '2.019'
                                                           },
                                                           {
                                                             'date' => '2012-06-18T08:34:26',
                                                             'version' => '2.020'
                                                           },
                                                           {
                                                             'date' => '2012-06-27T14:44:55',
                                                             'version' => '2.021_01'
                                                           },
                                                           {
                                                             'date' => '2012-06-28T15:30:52',
                                                             'version' => '2.021'
                                                           },
                                                           {
                                                             'date' => '2012-07-03T14:47:31',
                                                             'version' => '2.022'
                                                           },
                                                           {
                                                             'date' => '2012-07-04T13:50:37',
                                                             'version' => '2.023'
                                                           },
                                                           {
                                                             'date' => '2012-09-04T11:30:02',
                                                             'version' => '2.024'
                                                           },
                                                           {
                                                             'date' => '2012-09-10T10:52:02',
                                                             'version' => '2.025'
                                                           },
                                                           {
                                                             'date' => '2012-09-20T17:12:09',
                                                             'version' => '2.026_1'
                                                           },
                                                           {
                                                             'date' => '2012-09-21T10:38:47',
                                                             'version' => '2.026_2'
                                                           },
                                                           {
                                                             'date' => '2012-09-27T11:53:42',
                                                             'version' => '2.026'
                                                           },
                                                           {
                                                             'date' => '2012-10-30T12:48:16',
                                                             'version' => '2.027'
                                                           },
                                                           {
                                                             'date' => '2012-11-27T12:44:55',
                                                             'version' => '2.028'
                                                           },
                                                           {
                                                             'date' => '2012-11-28T13:31:04',
                                                             'version' => '2.029'
                                                           },
                                                           {
                                                             'date' => '2013-02-27T18:37:05',
                                                             'version' => '2.030_01'
                                                           },
                                                           {
                                                             'date' => '2013-03-23T09:47:53',
                                                             'version' => '2.030'
                                                           },
                                                           {
                                                             'date' => '2013-04-03T17:22:28',
                                                             'version' => '2.031'
                                                           },
                                                           {
                                                             'date' => '2013-04-15T11:28:33',
                                                             'version' => '2.032'
                                                           },
                                                           {
                                                             'date' => '2013-04-15T19:27:14',
                                                             'version' => '2.033'
                                                           },
                                                           {
                                                             'date' => '2013-04-17T19:29:52',
                                                             'version' => '2.034'
                                                           },
                                                           {
                                                             'date' => '2013-04-27T15:05:09',
                                                             'version' => '2.035'
                                                           },
                                                           {
                                                             'date' => '2013-05-25T17:53:04',
                                                             'version' => '2.036'
                                                           },
                                                           {
                                                             'date' => '2013-06-15T17:46:45',
                                                             'version' => '2.037'
                                                           },
                                                           {
                                                             'date' => '2013-07-03T19:30:32',
                                                             'version' => '2.038'
                                                           },
                                                           {
                                                             'date' => '2013-07-18T18:12:07',
                                                             'version' => '2.039'
                                                           },
                                                           {
                                                             'date' => '2013-07-20T09:46:11',
                                                             'version' => '2.040'
                                                           },
                                                           {
                                                             'date' => '2013-08-14T17:58:40',
                                                             'version' => '2.041'
                                                           },
                                                           {
                                                             'date' => '2013-09-15T17:41:45',
                                                             'version' => '2.042'
                                                           },
                                                           {
                                                             'date' => '2013-09-20T17:35:06',
                                                             'version' => '2.043'
                                                           },
                                                           {
                                                             'date' => '2013-10-13T16:02:40',
                                                             'version' => '2.044'
                                                           },
                                                           {
                                                             'date' => '2013-10-18T17:48:15',
                                                             'version' => '2.045'
                                                           },
                                                           {
                                                             'date' => '2013-12-15T13:07:37',
                                                             'version' => '2.046'
                                                           },
                                                           {
                                                             'date' => '2014-01-25T15:54:37',
                                                             'version' => '2.047'
                                                           },
                                                           {
                                                             'date' => '2014-02-23T18:02:19',
                                                             'version' => '2.048'
                                                           },
                                                           {
                                                             'date' => '2014-02-26T19:45:44',
                                                             'version' => '2.049'
                                                           },
                                                           {
                                                             'date' => '2014-02-27T18:12:32',
                                                             'version' => '2.050'
                                                           },
                                                           {
                                                             'date' => '2014-03-06T18:23:11',
                                                             'version' => '2.051'
                                                           },
                                                           {
                                                             'date' => '2014-03-23T16:20:43',
                                                             'version' => '2.052'
                                                           },
                                                           {
                                                             'date' => '2014-03-25T19:11:57',
                                                             'version' => '2.053'
                                                           },
                                                           {
                                                             'date' => '2014-04-01T17:51:50',
                                                             'version' => '2.054'
                                                           },
                                                           {
                                                             'date' => '2014-05-02T11:33:28',
                                                             'version' => '2.055'
                                                           },
                                                           {
                                                             'date' => '2014-05-18T19:34:53',
                                                             'version' => '2.056'
                                                           },
                                                           {
                                                             'date' => '2014-06-12T19:32:47',
                                                             'version' => '2.057'
                                                           },
                                                           {
                                                             'date' => '2014-06-19T19:43:18',
                                                             'version' => '2.058'
                                                           },
                                                           {
                                                             'date' => '2014-06-29T15:08:02',
                                                             'version' => '2.059'
                                                           },
                                                           {
                                                             'date' => '2014-08-19T12:43:59',
                                                             'version' => '2.060'
                                                           },
                                                           {
                                                             'date' => '2014-09-23T19:21:04',
                                                             'version' => '2.061'
                                                           },
                                                           {
                                                             'date' => '2014-11-23T19:45:05',
                                                             'version' => '2.062'
                                                           },
                                                           {
                                                             'date' => '2014-11-28T17:55:21',
                                                             'version' => '2.063'
                                                           },
                                                           {
                                                             'date' => '2014-12-04T18:47:05',
                                                             'version' => '2.064'
                                                           },
                                                           {
                                                             'date' => '2015-01-06T20:16:15',
                                                             'version' => '2.065'
                                                           },
                                                           {
                                                             'date' => '2015-02-15T16:13:00',
                                                             'version' => '2.066'
                                                           },
                                                           {
                                                             'date' => '2015-03-01T18:38:28',
                                                             'version' => '2.067'
                                                           },
                                                           {
                                                             'date' => '2015-03-29T13:39:56',
                                                             'version' => '2.068'
                                                           },
                                                           {
                                                             'date' => '2015-04-25T19:29:15',
                                                             'version' => '2.069'
                                                           },
                                                           {
                                                             'date' => '2015-05-03T14:00:52',
                                                             'version' => '2.070'
                                                           },
                                                           {
                                                             'date' => '2015-05-23T11:15:16',
                                                             'version' => '2.071'
                                                           },
                                                           {
                                                             'date' => '2015-07-18T19:31:43',
                                                             'version' => '2.072'
                                                           },
                                                           {
                                                             'date' => '2015-07-19T07:35:51',
                                                             'version' => '2.073'
                                                           },
                                                           {
                                                             'date' => '2015-09-30T18:56:39',
                                                             'version' => '2.074'
                                                           },
                                                           {
                                                             'date' => '2015-11-22T20:11:19',
                                                             'version' => '2.075'
                                                           },
                                                           {
                                                             'date' => '2016-01-14T18:13:20',
                                                             'version' => '2.076'
                                                           },
                                                           {
                                                             'date' => '2016-01-20T19:55:36',
                                                             'version' => '2.077'
                                                           },
                                                           {
                                                             'date' => '2016-01-24T18:48:46',
                                                             'version' => '2.078'
                                                           },
                                                           {
                                                             'date' => '2016-02-12T20:44:28',
                                                             'version' => '2.079'
                                                           },
                                                           {
                                                             'date' => '2016-02-27T17:59:55',
                                                             'version' => '2.080'
                                                           },
                                                           {
                                                             'date' => '2016-02-29T19:01:45',
                                                             'version' => '2.081'
                                                           },
                                                           {
                                                             'date' => '2016-03-29T18:22:30',
                                                             'version' => '2.082'
                                                           },
                                                           {
                                                             'date' => '2016-04-20T18:32:29',
                                                             'version' => '2.083'
                                                           },
                                                           {
                                                             'date' => '2016-05-26T17:35:53',
                                                             'version' => '2.084'
                                                           },
                                                           {
                                                             'date' => '2016-05-29T17:13:14',
                                                             'version' => '2.085'
                                                           },
                                                           {
                                                             'date' => '2016-06-04T19:28:08',
                                                             'version' => '2.086'
                                                           },
                                                           {
                                                             'date' => '2016-06-29T17:35:35',
                                                             'version' => '2.087'
                                                           },
                                                           {
                                                             'date' => '2016-07-09T18:06:03',
                                                             'version' => '2.088'
                                                           },
                                                           {
                                                             'date' => '2016-09-04T13:17:52',
                                                             'version' => '2.089'
                                                           },
                                                           {
                                                             'date' => '2016-09-10T16:07:07',
                                                             'version' => '2.090'
                                                           },
                                                           {
                                                             'date' => '2016-09-13T17:05:56',
                                                             'version' => '2.091'
                                                           },
                                                           {
                                                             'date' => '2016-09-23T17:46:04',
                                                             'version' => '2.092'
                                                           },
                                                           {
                                                             'date' => '2016-11-08T18:33:39',
                                                             'version' => '2.093'
                                                           },
                                                           {
                                                             'date' => '2016-11-09T18:23:05',
                                                             'version' => '2.094'
                                                           },
                                                           {
                                                             'date' => '2016-12-06T18:01:00',
                                                             'version' => '2.095'
                                                           },
                                                           {
                                                             'date' => '2016-12-11T20:28:14',
                                                             'version' => '2.096'
                                                           },
                                                           {
                                                             'date' => '2016-12-22T17:35:34',
                                                             'version' => '2.097'
                                                           },
                                                           {
                                                             'date' => '2017-02-26T18:58:23',
                                                             'version' => '2.098'
                                                           },
                                                           {
                                                             'date' => '2017-03-05T17:09:37',
                                                             'version' => '2.099'
                                                           },
                                                           {
                                                             'date' => '2017-03-18T12:06:34',
                                                             'version' => '2.100'
                                                           },
                                                           {
                                                             'date' => '2017-04-28T17:40:56',
                                                             'version' => '2.101'
                                                           },
                                                           {
                                                             'date' => '2017-05-14T19:10:40',
                                                             'version' => '2.102'
                                                           },
                                                           {
                                                             'date' => '2017-05-25T08:15:17',
                                                             'version' => '2.103'
                                                           },
                                                           {
                                                             'date' => '2017-06-03T13:23:33',
                                                             'version' => '2.104'
                                                           },
                                                           {
                                                             'date' => '2017-06-09T17:26:55',
                                                             'version' => '2.105'
                                                           },
                                                           {
                                                             'date' => '2017-07-16T14:07:23',
                                                             'version' => '2.106'
                                                           },
                                                           {
                                                             'date' => '2017-08-30T19:12:10',
                                                             'version' => '2.107'
                                                           },
                                                           {
                                                             'date' => '2017-08-31T17:23:43',
                                                             'version' => '2.108'
                                                           },
                                                           {
                                                             'date' => '2017-09-18T17:52:57',
                                                             'version' => '2.109'
                                                           },
                                                           {
                                                             'date' => '2017-09-21T19:12:32',
                                                             'version' => '2.110'
                                                           },
                                                           {
                                                             'date' => '2017-09-22T18:41:04',
                                                             'version' => '2.111'
                                                           },
                                                           {
                                                             'date' => '2017-10-01T09:12:45',
                                                             'version' => '2.112'
                                                           },
                                                           {
                                                             'date' => '2017-10-12T19:07:46',
                                                             'version' => '2.113'
                                                           },
                                                           {
                                                             'date' => '2017-11-11T16:35:03',
                                                             'version' => '2.114'
                                                           },
                                                           {
                                                             'date' => '2017-12-14T18:03:18',
                                                             'version' => '2.115'
                                                           },
                                                           {
                                                             'date' => '2017-12-16T09:52:09',
                                                             'version' => '2.116'
                                                           },
                                                           {
                                                             'date' => '2018-02-03T18:09:35',
                                                             'version' => '2.117'
                                                           },
                                                           {
                                                             'date' => '2018-03-26T18:33:19',
                                                             'version' => '2.118'
                                                           },
                                                           {
                                                             'date' => '2018-04-02T16:55:50',
                                                             'version' => '2.119'
                                                           },
                                                           {
                                                             'date' => '2018-04-08T07:56:03',
                                                             'version' => '2.120'
                                                           },
                                                           {
                                                             'date' => '2018-04-15T17:08:18',
                                                             'version' => '2.121'
                                                           },
                                                           {
                                                             'date' => '2018-04-17T17:20:14',
                                                             'version' => '2.122'
                                                           },
                                                           {
                                                             'date' => '2018-05-01T17:18:09',
                                                             'version' => '2.123'
                                                           },
                                                           {
                                                             'date' => '2018-06-09T17:16:59',
                                                             'version' => '2.124'
                                                           },
                                                           {
                                                             'date' => '2018-06-24T12:47:24',
                                                             'version' => '2.125'
                                                           },
                                                           {
                                                             'date' => '2018-08-20T13:10:09',
                                                             'version' => '2.126'
                                                           },
                                                           {
                                                             'date' => '2018-09-30T16:44:13',
                                                             'version' => '2.127'
                                                           },
                                                           {
                                                             'date' => '2018-11-21T19:33:41',
                                                             'version' => '2.128'
                                                           },
                                                           {
                                                             'date' => '2018-12-05T18:44:58',
                                                             'version' => '2.129'
                                                           },
                                                           {
                                                             'date' => '2018-12-07T19:02:10',
                                                             'version' => '2.130'
                                                           },
                                                           {
                                                             'date' => '2018-12-16T18:32:58',
                                                             'version' => '2.131'
                                                           },
                                                           {
                                                             'date' => '2018-12-22T17:50:27',
                                                             'version' => '2.132'
                                                           },
                                                           {
                                                             'date' => '2019-01-13T20:17:07',
                                                             'version' => '2.133'
                                                           }
                                                         ]
                                         },
                       'Cpanel-JSON-XS' => {
                                             'advisories' => [
                                                               {
                                                                 'affected_versions' => '<3.0225',
                                                                 'description' => 'Overflow during processing of ill-formed UTF-8 strings.
',
                                                                 'distribution' => 'Cpanel-JSON-XS',
                                                                 'fixed_versions' => '>=3.0225',
                                                                 'id' => 'CPANSA-Cpanel-JSON-XS-2016-02',
                                                                 'references' => [
                                                                                   'https://metacpan.org/changes/distribution/Cpanel-JSON-XS',
                                                                                   'https://github.com/rurban/Cpanel-JSON-XS/commit/f71768984ba7f50b0476c17a4f3b3f2ca88a6951',
                                                                                   'https://github.com/dankogai/p5-encode/issues/64'
                                                                                 ],
                                                                 'reported' => '2016-11-23'
                                                               },
                                                               {
                                                                 'affected_versions' => '<3.0218',
                                                                 'description' => 'Possible overflows in av and hv length types.
',
                                                                 'distribution' => 'Cpanel-JSON-XS',
                                                                 'fixed_versions' => '>=3.0218',
                                                                 'id' => 'CPANSA-Cpanel-JSON-XS-2016-01',
                                                                 'references' => [
                                                                                   'https://metacpan.org/changes/distribution/Cpanel-JSON-XS',
                                                                                   'https://github.com/rurban/Cpanel-JSON-XS/commit/6554531b39fac236321d8601d35eaaa75ae45e20'
                                                                                 ],
                                                                 'reported' => '2016-10-06'
                                                               }
                                                             ],
                                             'main_module' => 'Cpanel::JSON::XS',
                                             'versions' => [
                                                             {
                                                               'date' => '2013-03-01T00:52:41',
                                                               'version' => '2.33_03'
                                                             },
                                                             {
                                                               'date' => '2013-03-01T22:07:06',
                                                               'version' => '2.33_04'
                                                             },
                                                             {
                                                               'date' => '2013-03-27T16:53:34',
                                                               'version' => '2.3305'
                                                             },
                                                             {
                                                               'date' => '2013-03-27T17:17:51',
                                                               'version' => '2.3306'
                                                             },
                                                             {
                                                               'date' => '2013-03-27T22:58:47',
                                                               'version' => '2.3307'
                                                             },
                                                             {
                                                               'date' => '2013-03-28T14:28:56',
                                                               'version' => '2.3308'
                                                             },
                                                             {
                                                               'date' => '2013-03-28T15:12:42',
                                                               'version' => '2.3309'
                                                             },
                                                             {
                                                               'date' => '2013-03-28T17:33:21',
                                                               'version' => '2.3310'
                                                             },
                                                             {
                                                               'date' => '2013-06-26T16:24:40',
                                                               'version' => '2.3313'
                                                             },
                                                             {
                                                               'date' => '2013-09-09T05:54:40',
                                                               'version' => '2.3314'
                                                             },
                                                             {
                                                               'date' => '2013-10-02T20:06:47',
                                                               'version' => '2.3401'
                                                             },
                                                             {
                                                               'date' => '2013-11-02T14:42:20',
                                                               'version' => '2.3402'
                                                             },
                                                             {
                                                               'date' => '2013-11-02T15:17:41',
                                                               'version' => '2.3403'
                                                             },
                                                             {
                                                               'date' => '2014-01-30T15:58:58',
                                                               'version' => '2.3404'
                                                             },
                                                             {
                                                               'date' => '2014-04-15T21:17:11',
                                                               'version' => '3.0101'
                                                             },
                                                             {
                                                               'date' => '2014-04-17T18:37:34',
                                                               'version' => '3.0102'
                                                             },
                                                             {
                                                               'date' => '2014-04-21T17:49:09',
                                                               'version' => '3.0103'
                                                             },
                                                             {
                                                               'date' => '2014-04-26T16:04:39',
                                                               'version' => '3.0104'
                                                             },
                                                             {
                                                               'date' => '2014-11-06T10:38:31',
                                                               'version' => '3.0105'
                                                             },
                                                             {
                                                               'date' => '2014-11-11T21:57:49',
                                                               'version' => '3.0106'
                                                             },
                                                             {
                                                               'date' => '2014-11-28T12:16:29',
                                                               'version' => '3.0107'
                                                             },
                                                             {
                                                               'date' => '2014-12-11T17:02:07',
                                                               'version' => '3.0108'
                                                             },
                                                             {
                                                               'date' => '2014-12-12T10:24:33',
                                                               'version' => '3.0109'
                                                             },
                                                             {
                                                               'date' => '2014-12-12T22:35:37',
                                                               'version' => '3.0110'
                                                             },
                                                             {
                                                               'date' => '2014-12-13T18:40:06',
                                                               'version' => '3.0111'
                                                             },
                                                             {
                                                               'date' => '2014-12-14T16:34:01',
                                                               'version' => '3.0112'
                                                             },
                                                             {
                                                               'date' => '2014-12-15T12:23:32',
                                                               'version' => '3.0113'
                                                             },
                                                             {
                                                               'date' => '2015-01-04T14:06:03',
                                                               'version' => '3.0114'
                                                             },
                                                             {
                                                               'date' => '2015-01-31T21:42:51',
                                                               'version' => '3.0115'
                                                             },
                                                             {
                                                               'date' => '2015-11-26T08:58:33',
                                                               'version' => '3.0201'
                                                             },
                                                             {
                                                               'date' => '2015-11-26T13:16:40',
                                                               'version' => '3.0202'
                                                             },
                                                             {
                                                               'date' => '2015-11-26T13:42:02',
                                                               'version' => '3.0203'
                                                             },
                                                             {
                                                               'date' => '2015-11-26T22:30:26',
                                                               'version' => '3.0204'
                                                             },
                                                             {
                                                               'date' => '2015-11-29T14:09:00',
                                                               'version' => '3.0205'
                                                             },
                                                             {
                                                               'date' => '2015-11-30T16:16:48',
                                                               'version' => '3.0206'
                                                             },
                                                             {
                                                               'date' => '2015-12-02T16:34:35',
                                                               'version' => '3.0207'
                                                             },
                                                             {
                                                               'date' => '2015-12-02T22:46:58',
                                                               'version' => '3.0208'
                                                             },
                                                             {
                                                               'date' => '2015-12-03T09:45:04',
                                                               'version' => '3.0209'
                                                             },
                                                             {
                                                               'date' => '2015-12-03T11:59:24',
                                                               'version' => '3.0210'
                                                             },
                                                             {
                                                               'date' => '2016-01-10T17:38:25',
                                                               'version' => '3.0211'
                                                             },
                                                             {
                                                               'date' => '2016-02-27T13:30:04',
                                                               'version' => '3.0212'
                                                             },
                                                             {
                                                               'date' => '2016-03-02T10:28:37',
                                                               'version' => '3.0213'
                                                             },
                                                             {
                                                               'date' => '2016-04-12T08:40:05',
                                                               'version' => '3.0213_01'
                                                             },
                                                             {
                                                               'date' => '2016-04-13T10:40:03',
                                                               'version' => '3.0213_02'
                                                             },
                                                             {
                                                               'date' => '2016-06-02T16:18:51',
                                                               'version' => '3.0214'
                                                             },
                                                             {
                                                               'date' => '2016-06-06T13:28:49',
                                                               'version' => '3.0215'
                                                             },
                                                             {
                                                               'date' => '2016-06-12T12:14:20',
                                                               'version' => '3.0216'
                                                             },
                                                             {
                                                               'date' => '2016-06-18T09:59:27',
                                                               'version' => '3.0217'
                                                             },
                                                             {
                                                               'date' => '2016-10-04T10:11:33',
                                                               'version' => '3.0217_01'
                                                             },
                                                             {
                                                               'date' => '2016-10-04T14:47:29',
                                                               'version' => '3.0217_02'
                                                             },
                                                             {
                                                               'date' => '2016-10-06T08:46:17',
                                                               'version' => '3.0217_03'
                                                             },
                                                             {
                                                               'date' => '2016-10-07T12:11:03',
                                                               'version' => '3.0217_04'
                                                             },
                                                             {
                                                               'date' => '2016-10-07T17:22:48',
                                                               'version' => '3.0217_05'
                                                             },
                                                             {
                                                               'date' => '2016-10-08T08:01:50',
                                                               'version' => '3.0217_06'
                                                             },
                                                             {
                                                               'date' => '2016-10-13T12:47:31',
                                                               'version' => '3.0218'
                                                             },
                                                             {
                                                               'date' => '2016-10-26T11:45:35',
                                                               'version' => '3.0219'
                                                             },
                                                             {
                                                               'date' => '2016-10-28T08:34:28',
                                                               'version' => '3.0220'
                                                             },
                                                             {
                                                               'date' => '2016-10-30T12:27:36',
                                                               'version' => '3.0221'
                                                             },
                                                             {
                                                               'date' => '2016-10-30T15:04:32',
                                                               'version' => '3.0222'
                                                             },
                                                             {
                                                               'date' => '2016-11-16T11:47:38',
                                                               'version' => '3.0223'
                                                             },
                                                             {
                                                               'date' => '2016-11-20T11:31:34',
                                                               'version' => '3.0224'
                                                             },
                                                             {
                                                               'date' => '2016-11-23T18:43:00',
                                                               'version' => '3.0225'
                                                             },
                                                             {
                                                               'date' => '2017-02-11T13:24:48',
                                                               'version' => '3.0226'
                                                             },
                                                             {
                                                               'date' => '2017-02-13T10:57:06',
                                                               'version' => '3.0227'
                                                             },
                                                             {
                                                               'date' => '2017-03-07T23:57:39',
                                                               'version' => '3.0228'
                                                             },
                                                             {
                                                               'date' => '2017-03-10T14:08:07',
                                                               'version' => '3.0229'
                                                             },
                                                             {
                                                               'date' => '2017-03-12T09:52:13',
                                                               'version' => '3.0230'
                                                             },
                                                             {
                                                               'date' => '2017-03-29T09:51:51',
                                                               'version' => '3.0231'
                                                             },
                                                             {
                                                               'date' => '2017-05-01T05:35:12',
                                                               'version' => '3.0232'
                                                             },
                                                             {
                                                               'date' => '2017-05-01T14:54:56',
                                                               'version' => '3.0233'
                                                             },
                                                             {
                                                               'date' => '2017-07-27T15:43:41',
                                                               'version' => '3.0234'
                                                             },
                                                             {
                                                               'date' => '2017-07-27T16:21:47',
                                                               'version' => '3.0235'
                                                             },
                                                             {
                                                               'date' => '2017-07-27T20:15:25',
                                                               'version' => '3.0236'
                                                             },
                                                             {
                                                               'date' => '2017-07-28T11:15:05',
                                                               'version' => '3.0237'
                                                             },
                                                             {
                                                               'date' => '2017-08-25T20:53:56',
                                                               'version' => '3.0238'
                                                             },
                                                             {
                                                               'date' => '2017-08-28T20:48:37',
                                                               'version' => '3.0239'
                                                             },
                                                             {
                                                               'date' => '2018-01-30T11:52:27',
                                                               'version' => '3.99_01'
                                                             },
                                                             {
                                                               'date' => '2018-01-31T12:58:24',
                                                               'version' => '3.99_02'
                                                             },
                                                             {
                                                               'date' => '2018-01-31T17:18:58',
                                                               'version' => '3.99_03'
                                                             },
                                                             {
                                                               'date' => '2018-02-02T01:57:54',
                                                               'version' => '4.00'
                                                             },
                                                             {
                                                               'date' => '2018-02-03T11:50:36',
                                                               'version' => '4.01'
                                                             },
                                                             {
                                                               'date' => '2018-02-27T16:08:55',
                                                               'version' => '4.02'
                                                             },
                                                             {
                                                               'date' => '2018-06-21T11:16:14',
                                                               'version' => '4.03'
                                                             },
                                                             {
                                                               'date' => '2018-06-22T17:37:07',
                                                               'version' => '4.04'
                                                             },
                                                             {
                                                               'date' => '2018-08-19T16:55:22',
                                                               'version' => '4.05'
                                                             },
                                                             {
                                                               'date' => '2018-08-23T07:50:22',
                                                               'version' => '4.06'
                                                             },
                                                             {
                                                               'date' => '2018-11-02T09:51:34',
                                                               'version' => '4.07'
                                                             },
                                                             {
                                                               'date' => '2018-11-28T14:26:40',
                                                               'version' => '4.08'
                                                             }
                                                           ]
                                           },
                       'Crypt-CBC' => {
                                        'advisories' => [
                                                          {
                                                            'affected_versions' => '<2.17',
                                                            'description' => 'Incorrect use of using 8 byte IVs when generating the old-style RandomIV style header. This affects data encrypted using the Rijndael algorithm, which has a 16 byte blocksize, and is a significant security issue.
',
                                                            'distribution' => 'Crypt-CBC',
                                                            'fixed_versions' => '>=2.17',
                                                            'id' => 'CPANSA-Crypt-CBC-2006-01',
                                                            'references' => [
                                                                              'https://metacpan.org/changes/distribution/Crypt-CBC'
                                                                            ],
                                                            'reported' => '2006-01-09',
                                                            'severity' => 'high'
                                                          }
                                                        ],
                                        'main_module' => 'Crypt::CBC',
                                        'versions' => [
                                                        {
                                                          'date' => '1998-06-19T19:48:52',
                                                          'version' => '1.00'
                                                        },
                                                        {
                                                          'date' => '1998-09-22T18:30:35',
                                                          'version' => '1.10'
                                                        },
                                                        {
                                                          'date' => '1998-12-20T23:36:49',
                                                          'version' => '1.20'
                                                        },
                                                        {
                                                          'date' => '2000-01-27T00:27:56',
                                                          'version' => '1.22'
                                                        },
                                                        {
                                                          'date' => '2000-02-22T15:20:56',
                                                          'version' => '1.23'
                                                        },
                                                        {
                                                          'date' => '2000-06-07T18:55:59',
                                                          'version' => '1.24'
                                                        },
                                                        {
                                                          'date' => '2000-06-08T15:59:07',
                                                          'version' => '1.25'
                                                        },
                                                        {
                                                          'date' => '2001-12-10T17:16:25',
                                                          'version' => '2.01'
                                                        },
                                                        {
                                                          'date' => '2002-01-24T05:30:16',
                                                          'version' => '2.02'
                                                        },
                                                        {
                                                          'date' => '2002-06-02T18:40:15',
                                                          'version' => '2.03'
                                                        },
                                                        {
                                                          'date' => '2002-06-12T02:20:51',
                                                          'version' => '2.04'
                                                        },
                                                        {
                                                          'date' => '2002-06-22T13:02:09',
                                                          'version' => '2.05'
                                                        },
                                                        {
                                                          'date' => '2002-08-08T18:47:49',
                                                          'version' => '2.07'
                                                        },
                                                        {
                                                          'date' => '2002-09-11T12:17:23',
                                                          'version' => '2.08'
                                                        },
                                                        {
                                                          'date' => '2004-05-27T15:20:52',
                                                          'version' => '2.09'
                                                        },
                                                        {
                                                          'date' => '2004-05-29T17:29:19',
                                                          'version' => '2.10'
                                                        },
                                                        {
                                                          'date' => '2004-06-03T16:22:32',
                                                          'version' => '2.11'
                                                        },
                                                        {
                                                          'date' => '2004-06-17T15:55:19',
                                                          'version' => '2.11'
                                                        },
                                                        {
                                                          'date' => '2005-05-05T20:11:50',
                                                          'version' => '2.14'
                                                        },
                                                        {
                                                          'date' => '2005-08-01T14:02:45',
                                                          'version' => '2.15'
                                                        },
                                                        {
                                                          'date' => '2006-02-16T14:08:57',
                                                          'version' => '2.17'
                                                        },
                                                        {
                                                          'date' => '2006-06-06T23:22:02',
                                                          'version' => '2.18'
                                                        },
                                                        {
                                                          'date' => '2006-08-12T19:52:11',
                                                          'version' => '2.19'
                                                        },
                                                        {
                                                          'date' => '2006-10-16T23:40:13',
                                                          'version' => '2.21'
                                                        },
                                                        {
                                                          'date' => '2006-10-29T21:55:34',
                                                          'version' => '2.22'
                                                        },
                                                        {
                                                          'date' => '2007-09-28T15:25:53',
                                                          'version' => '2.24'
                                                        },
                                                        {
                                                          'date' => '2008-03-28T14:17:29',
                                                          'version' => '2.27'
                                                        },
                                                        {
                                                          'date' => '2008-03-31T14:56:52',
                                                          'version' => '2.28'
                                                        },
                                                        {
                                                          'date' => '2008-04-22T14:27:07',
                                                          'version' => '2.29'
                                                        },
                                                        {
                                                          'date' => '2008-09-30T15:17:58',
                                                          'version' => '2.30'
                                                        },
                                                        {
                                                          'date' => '2012-10-30T11:08:06',
                                                          'version' => '2.31'
                                                        },
                                                        {
                                                          'date' => '2012-12-14T19:30:14',
                                                          'version' => '2.32'
                                                        },
                                                        {
                                                          'date' => '2013-07-30T20:03:53',
                                                          'version' => '2.33'
                                                        }
                                                      ]
                                      },
                       'Crypt-OpenSSL-DSA' => {
                                                'advisories' => [
                                                                  {
                                                                    'affected_versions' => '<0.14',
                                                                    'cves' => [
                                                                                'CVE-2009-0129'
                                                                              ],
                                                                    'description' => 'Missing error check in do_verify, which might allow remote attackers to bypass validation of the certificate chain via a malformed SSL/TLS signature.
',
                                                                    'distribution' => 'Crypt-OpenSSL-DSA',
                                                                    'fixed_versions' => '>=0.14',
                                                                    'id' => 'CPANSA-Crypt-OpenSSL-DSA-2009-01',
                                                                    'references' => [
                                                                                      'https://metacpan.org/changes/distribution/Crypt-OpenSSL-DSA',
                                                                                      'https://www.openwall.com/lists/oss-security/2009/01/12/4',
                                                                                      'https://bugs.debian.org/cgi-bin/bugreport.cgi?bug=511519'
                                                                                    ],
                                                                    'reported' => '2009-01-15'
                                                                  }
                                                                ],
                                                'main_module' => 'Crypt::OpenSSL::DSA',
                                                'versions' => [
                                                                {
                                                                  'date' => '2001-09-19T04:45:14',
                                                                  'version' => '0.01'
                                                                },
                                                                {
                                                                  'date' => '2001-09-24T17:32:49',
                                                                  'version' => '0.02'
                                                                },
                                                                {
                                                                  'date' => '2002-02-07T05:57:36',
                                                                  'version' => '0.03'
                                                                },
                                                                {
                                                                  'date' => '2002-09-24T04:52:06',
                                                                  'version' => '0.04'
                                                                },
                                                                {
                                                                  'date' => '2002-09-26T00:21:17',
                                                                  'version' => '0.10'
                                                                },
                                                                {
                                                                  'date' => '2003-01-06T19:08:08',
                                                                  'version' => '0.11'
                                                                },
                                                                {
                                                                  'date' => '2005-05-23T01:44:36',
                                                                  'version' => '0.12'
                                                                },
                                                                {
                                                                  'date' => '2005-10-15T21:37:10',
                                                                  'version' => '0.13'
                                                                },
                                                                {
                                                                  'date' => '2012-10-16T22:55:16',
                                                                  'version' => '0.14'
                                                                },
                                                                {
                                                                  'date' => '2015-02-03T21:57:37',
                                                                  'version' => '0.15'
                                                                },
                                                                {
                                                                  'date' => '2016-10-27T11:25:18',
                                                                  'version' => '0.16'
                                                                },
                                                                {
                                                                  'date' => '2016-10-27T18:54:42',
                                                                  'version' => '0.17'
                                                                },
                                                                {
                                                                  'date' => '2016-11-17T10:33:35',
                                                                  'version' => '0.18'
                                                                },
                                                                {
                                                                  'date' => '2017-01-13T08:24:56',
                                                                  'version' => '0.19'
                                                                }
                                                              ]
                                              },
                       'Crypt-Passwd-XS' => {
                                              'advisories' => [
                                                                {
                                                                  'affected_versions' => '<0.601',
                                                                  'cves' => [
                                                                              'CVE-2012-2143'
                                                                            ],
                                                                  'description' => 'The crypt_des (aka DES-based crypt) function does not process the complete cleartext password if this password contains a 0x80 character, which makes it easier for context-dependent attackers to obtain access via an authentication attempt with an initial substring of the intended password, as demonstrated by a Unicode password.
',
                                                                  'distribution' => 'Crypt-Passwd-XS',
                                                                  'fixed_versions' => '>=0.601',
                                                                  'id' => 'CPANSA-Crypt-Passwd-XS-2012-01',
                                                                  'references' => [
                                                                                    'https://metacpan.org/changes/distribution/Crypt-Passwd-XS'
                                                                                  ],
                                                                  'reported' => '2012-05-07'
                                                                }
                                                              ],
                                              'main_module' => 'Crypt::Passwd::XS',
                                              'versions' => [
                                                              {
                                                                'date' => '2010-11-14T21:18:18',
                                                                'version' => '0.4'
                                                              },
                                                              {
                                                                'date' => '2010-11-17T02:03:54',
                                                                'version' => '0.501'
                                                              },
                                                              {
                                                                'date' => '2010-11-17T23:25:17',
                                                                'version' => '0.503'
                                                              },
                                                              {
                                                                'date' => '2010-11-20T00:37:33',
                                                                'version' => '0.504'
                                                              },
                                                              {
                                                                'date' => '2010-11-24T00:59:34',
                                                                'version' => '0.505'
                                                              },
                                                              {
                                                                'date' => '2011-03-09T16:18:01',
                                                                'version' => '0.506'
                                                              },
                                                              {
                                                                'date' => '2011-03-09T21:40:38',
                                                                'version' => '0.507'
                                                              },
                                                              {
                                                                'date' => '2011-07-26T16:37:20',
                                                                'version' => '0.600'
                                                              },
                                                              {
                                                                'date' => '2012-12-06T19:57:57',
                                                                'version' => '0.601'
                                                              }
                                                            ]
                                            },
                       'DBD-MariaDB' => {
                                          'advisories' => [
                                                            {
                                                              'affected_versions' => '<1.00',
                                                              'cves' => [
                                                                          'CVE-2018-2767'
                                                                        ],
                                                              'description' => 'SSL problems of MySQL and MariaDB clients.
',
                                                              'distribution' => 'DBD-MariaDB',
                                                              'fixed_versions' => '>=1.00',
                                                              'id' => 'CPANSA-DBD-MariaDB-2018-01',
                                                              'references' => [
                                                                                'https://metacpan.org/changes/distribution/DBD-MariaDB'
                                                                              ],
                                                              'reported' => '2017-07-01'
                                                            },
                                                            {
                                                              'affected_versions' => '<1.00',
                                                              'cves' => [
                                                                          'CVE-2017-10788'
                                                                        ],
                                                              'description' => 'Use-after-free after calling mysql_stmt_close().
',
                                                              'distribution' => 'DBD-MariaDB',
                                                              'fixed_versions' => '>=1.00',
                                                              'id' => 'CPANSA-DBD-MariaDB-2017-02',
                                                              'references' => [
                                                                                'https://metacpan.org/changes/distribution/DBD-MariaDB'
                                                                              ],
                                                              'reported' => '2017-07-01'
                                                            },
                                                            {
                                                              'affected_versions' => '<1.00',
                                                              'cves' => [
                                                                          'CVE-2017-3302'
                                                                        ],
                                                              'description' => 'Leaking dangling pointers.
',
                                                              'distribution' => 'DBD-MariaDB',
                                                              'fixed_versions' => '>=1.00',
                                                              'id' => 'CPANSA-DBD-MariaDB-2017-01',
                                                              'references' => [
                                                                                'https://metacpan.org/changes/distribution/DBD-MariaDB'
                                                                              ],
                                                              'reported' => '2017-07-01'
                                                            }
                                                          ],
                                          'main_module' => 'DBD::MariaDB',
                                          'versions' => [
                                                          {
                                                            'date' => '2018-06-26T14:23:29',
                                                            'version' => '0.90_01'
                                                          },
                                                          {
                                                            'date' => '2018-07-12T13:36:05',
                                                            'version' => '1.00'
                                                          },
                                                          {
                                                            'date' => '2018-12-05T12:21:26',
                                                            'version' => '1.10'
                                                          },
                                                          {
                                                            'date' => '2019-01-02T15:38:57',
                                                            'version' => '1.11'
                                                          }
                                                        ]
                                        },
                       'DBD-mysql' => {
                                        'advisories' => [
                                                          {
                                                            'affected_versions' => '<4.044',
                                                            'cves' => [
                                                                        'CVE-2017-10788'
                                                                      ],
                                                            'description' => 'The DBD::mysql module through 4.043 for Perl allows remote attackers to cause a denial of service (use-after-free and application crash) or possibly have unspecified other impact by triggering (1) certain error responses from a MySQL server or (2) a loss of a network connection to a MySQL server. The use-after-free defect was introduced by relying on incorrect Oracle mysql_stmt_close documentation and code examples.
',
                                                            'distribution' => 'DBD-mysql',
                                                            'fixed_versions' => '>=4.044',
                                                            'id' => 'CPANSA-DBD-mysql-2017-02',
                                                            'references' => [
                                                                              'https://github.com/perl5-dbi/DBD-mysql/issues/120'
                                                                            ],
                                                            'reported' => '2017-04-13'
                                                          },
                                                          {
                                                            'affected_versions' => '<4.044',
                                                            'cves' => [
                                                                        'CVE-2017-10789'
                                                                      ],
                                                            'description' => 'The DBD::mysql module through 4.043 for Perl uses the mysql_ssl=1 setting to mean that SSL is optional (even though this setting\'s documentation has a "your communication with the server will be encrypted" statement), which allows man-in-the-middle attackers to spoof servers via a cleartext-downgrade attack, a related issue to CVE-2015-3152.
',
                                                            'distribution' => 'DBD-mysql',
                                                            'fixed_versions' => '>=4.044',
                                                            'id' => 'CPANSA-DBD-mysql-2017-01',
                                                            'references' => [
                                                                              'https://github.com/perl5-dbi/DBD-mysql/pull/114'
                                                                            ],
                                                            'reported' => '2017-03-23'
                                                          },
                                                          {
                                                            'affected_versions' => '>=2.9003, <4.039',
                                                            'cves' => [
                                                                        'CVE-2016-1249'
                                                                      ],
                                                            'description' => 'Out-of-bounds read.
',
                                                            'distribution' => 'DBD-mysql',
                                                            'fixed_versions' => '<2.9003, >=4.039',
                                                            'id' => 'CPANSA-DBD-mysql-2016-03',
                                                            'references' => [
                                                                              'https://github.com/perl5-dbi/DBD-mysql/commit/793b72b1a0baa5070adacaac0e12fd995a6fbabe'
                                                                            ],
                                                            'reported' => '2016-11-16'
                                                          },
                                                          {
                                                            'affected_versions' => '<4.037',
                                                            'cves' => [
                                                                        'CVE-2016-1246'
                                                                      ],
                                                            'description' => 'Buffer overflow in the DBD::mysql module before 4.037 for Perl allows context-dependent attackers to cause a denial of service (crash) via vectors related to an error message.
',
                                                            'distribution' => 'DBD-mysql',
                                                            'fixed_versions' => '>=4.037',
                                                            'id' => 'CPANSA-DBD-mysql-2016-02',
                                                            'references' => [
                                                                              'https://github.com/perl5-dbi/DBD-mysql/commit/7c164a0c86cec6ee95df1d141e67b0e85dfdefd2',
                                                                              'http://blogs.perl.org/users/mike_b/2016/10/security-release---buffer-overflow-in-dbdmysql-perl-library.html'
                                                                            ],
                                                            'reported' => '2016-10-02'
                                                          },
                                                          {
                                                            'affected_versions' => '<4.034',
                                                            'cves' => [
                                                                        'CVE-2015-8949'
                                                                      ],
                                                            'description' => 'Use-after-free vulnerability in the my_login function in DBD::mysql before 4.033_01 allows attackers to have unspecified impact by leveraging a call to mysql_errno after a failure of my_login.
',
                                                            'distribution' => 'DBD-mysql',
                                                            'fixed_versions' => '>=4.034',
                                                            'id' => 'CPANSA-DBD-mysql-2016-01',
                                                            'references' => [
                                                                              'https://github.com/perl5-dbi/DBD-mysql/commit/cf0aa7751f6ef8445e9310a64b14dc81460ca156'
                                                                            ],
                                                            'reported' => '2016-08-19'
                                                          },
                                                          {
                                                            'affected_versions' => '<4.041',
                                                            'cves' => [
                                                                        'CVE-2016-1251'
                                                                      ],
                                                            'description' => 'There is a vulnerability of type use-after-free affecting DBD::mysql (aka DBD-mysql or the Database Interface (DBI) MySQL driver for Perl) 3.x and 4.x before 4.041 when used with mysql_server_prepare=1.
',
                                                            'distribution' => 'DBD-mysql',
                                                            'fixed_versions' => '>=4.041',
                                                            'id' => 'CPANSA-DBD-mysql-2015-01',
                                                            'references' => [
                                                                              'https://github.com/perl5-dbi/DBD-mysql/commit/3619c170461a3107a258d1fd2d00ed4832adb1b1'
                                                                            ],
                                                            'reported' => '2015-12-27'
                                                          },
                                                          {
                                                            'affected_versions' => '<4.028',
                                                            'cves' => [
                                                                        'CVE-2014-9906'
                                                                      ],
                                                            'description' => 'Use-after-free vulnerability in DBD::mysql before 4.029 allows attackers to cause a denial of service (program crash) or possibly execute arbitrary code via vectors related to a lost server connection.
',
                                                            'distribution' => 'DBD-mysql',
                                                            'fixed_versions' => '>=4.028',
                                                            'id' => 'CPANSA-DBD-mysql-2014-01',
                                                            'references' => [
                                                                              'https://github.com/perl5-dbi/DBD-mysql/commit/a56ae87a4c1c1fead7d09c3653905841ccccf1cc',
                                                                              'https://rt.cpan.org/Public/Bug/Display.html?id=97625'
                                                                            ],
                                                            'reported' => '2014-07-30'
                                                          }
                                                        ],
                                        'main_module' => 'DBD::mysql',
                                        'versions' => [
                                                        {
                                                          'date' => '2000-04-15T20:17:36',
                                                          'version' => 'v1.2212.'
                                                        },
                                                        {
                                                          'date' => '2001-05-06T21:47:46',
                                                          'version' => '2.0900'
                                                        },
                                                        {
                                                          'date' => '2001-05-25T21:24:45',
                                                          'version' => '2.0901'
                                                        },
                                                        {
                                                          'date' => '2001-07-09T21:10:17',
                                                          'version' => '2.0902'
                                                        },
                                                        {
                                                          'date' => '2001-10-28T22:53:19',
                                                          'version' => '2.0903'
                                                        },
                                                        {
                                                          'date' => '2001-10-31T04:01:07',
                                                          'version' => '2.1000'
                                                        },
                                                        {
                                                          'date' => '2001-11-04T17:55:04',
                                                          'version' => '2.1001'
                                                        },
                                                        {
                                                          'date' => '2001-11-04T18:22:30',
                                                          'version' => '2.1002'
                                                        },
                                                        {
                                                          'date' => '2001-11-05T20:14:34',
                                                          'version' => '2.1003'
                                                        },
                                                        {
                                                          'date' => '2001-11-13T01:24:26',
                                                          'version' => '2.1004'
                                                        },
                                                        {
                                                          'date' => '2001-12-13T09:07:53',
                                                          'version' => '2.1005'
                                                        },
                                                        {
                                                          'date' => '2001-12-27T18:10:04',
                                                          'version' => '2.1007'
                                                        },
                                                        {
                                                          'date' => '2001-12-27T18:10:21',
                                                          'version' => '2.1006'
                                                        },
                                                        {
                                                          'date' => '2001-12-28T17:06:05',
                                                          'version' => '2.1008'
                                                        },
                                                        {
                                                          'date' => '2002-01-01T20:02:26',
                                                          'version' => '2.1009'
                                                        },
                                                        {
                                                          'date' => '2002-01-07T21:33:21',
                                                          'version' => '2.1010'
                                                        },
                                                        {
                                                          'date' => '2002-02-12T11:09:53',
                                                          'version' => '2.1011'
                                                        },
                                                        {
                                                          'date' => '2002-04-12T07:21:06',
                                                          'version' => '2.1012'
                                                        },
                                                        {
                                                          'date' => '2002-04-15T07:49:36',
                                                          'version' => '2.1013'
                                                        },
                                                        {
                                                          'date' => '2002-04-17T21:24:26',
                                                          'version' => '2.1014'
                                                        },
                                                        {
                                                          'date' => '2002-04-29T20:53:41',
                                                          'version' => '2.1015'
                                                        },
                                                        {
                                                          'date' => '2002-05-01T20:07:05',
                                                          'version' => '2.1016'
                                                        },
                                                        {
                                                          'date' => '2002-05-02T20:59:04',
                                                          'version' => '2.1017'
                                                        },
                                                        {
                                                          'date' => '2002-08-13T17:52:25',
                                                          'version' => '2.1018'
                                                        },
                                                        {
                                                          'date' => '2002-09-16T18:42:20',
                                                          'version' => '2.1019'
                                                        },
                                                        {
                                                          'date' => '2002-09-23T20:42:50',
                                                          'version' => '2.1020'
                                                        },
                                                        {
                                                          'date' => '2002-12-17T20:46:14',
                                                          'version' => '2.1021'
                                                        },
                                                        {
                                                          'date' => '2003-01-03T02:46:24',
                                                          'version' => '2.1022'
                                                        },
                                                        {
                                                          'date' => '2003-01-19T21:19:03',
                                                          'version' => '2.1023'
                                                        },
                                                        {
                                                          'date' => '2003-01-20T12:08:27',
                                                          'version' => '2.1024'
                                                        },
                                                        {
                                                          'date' => '2003-02-07T21:09:44',
                                                          'version' => '2.1025'
                                                        },
                                                        {
                                                          'date' => '2003-03-03T20:46:27',
                                                          'version' => '2.1026'
                                                        },
                                                        {
                                                          'date' => '2003-05-31T18:08:15',
                                                          'version' => '2.1027'
                                                        },
                                                        {
                                                          'date' => '2003-06-25T16:12:36',
                                                          'version' => '2.1028'
                                                        },
                                                        {
                                                          'date' => '2003-06-27T04:32:05',
                                                          'version' => '2.9002'
                                                        },
                                                        {
                                                          'date' => '2003-09-12T17:04:42',
                                                          'version' => '2.9003_1'
                                                        },
                                                        {
                                                          'date' => '2003-10-27T03:39:04',
                                                          'version' => '2.9003'
                                                        },
                                                        {
                                                          'date' => '2004-07-01T03:24:14',
                                                          'version' => '2.9004_2'
                                                        },
                                                        {
                                                          'date' => '2004-07-14T03:07:34',
                                                          'version' => '2.9004'
                                                        },
                                                        {
                                                          'date' => '2004-10-20T17:27:25',
                                                          'version' => '2.9005_1'
                                                        },
                                                        {
                                                          'date' => '2004-10-28T00:39:25',
                                                          'version' => '2.9005_3'
                                                        },
                                                        {
                                                          'date' => '2005-03-29T02:43:14',
                                                          'version' => '2.9005'
                                                        },
                                                        {
                                                          'date' => '2005-04-04T04:27:00',
                                                          'version' => '2.9006'
                                                        },
                                                        {
                                                          'date' => '2005-04-27T00:13:49',
                                                          'version' => '2.9015_3'
                                                        },
                                                        {
                                                          'date' => '2005-04-27T00:14:06',
                                                          'version' => '2.9007'
                                                        },
                                                        {
                                                          'date' => '2005-06-06T01:39:20',
                                                          'version' => '2.9008'
                                                        },
                                                        {
                                                          'date' => '2005-07-01T01:48:20',
                                                          'version' => '3.0000'
                                                        },
                                                        {
                                                          'date' => '2005-07-03T21:56:11',
                                                          'version' => '3.0000_0'
                                                        },
                                                        {
                                                          'date' => '2005-07-04T15:53:40',
                                                          'version' => '3.0001_0'
                                                        },
                                                        {
                                                          'date' => '2005-07-04T16:16:00',
                                                          'version' => '3.0001_1'
                                                        },
                                                        {
                                                          'date' => '2005-07-07T01:14:17',
                                                          'version' => '3.0001'
                                                        },
                                                        {
                                                          'date' => '2005-07-07T01:22:39',
                                                          'version' => '3.0001_2'
                                                        },
                                                        {
                                                          'date' => '2005-07-08T05:37:13',
                                                          'version' => '3.0001_3'
                                                        },
                                                        {
                                                          'date' => '2005-07-11T16:49:47',
                                                          'version' => '3.0002'
                                                        },
                                                        {
                                                          'date' => '2005-08-04T02:50:35',
                                                          'version' => '3.0002_1'
                                                        },
                                                        {
                                                          'date' => '2005-09-26T23:22:57',
                                                          'version' => '3.0002_2'
                                                        },
                                                        {
                                                          'date' => '2005-09-28T18:58:55',
                                                          'version' => '3.0002_3'
                                                        },
                                                        {
                                                          'date' => '2005-11-06T21:47:29',
                                                          'version' => '3.0002_4'
                                                        },
                                                        {
                                                          'date' => '2006-02-01T23:20:01',
                                                          'version' => '3.0002_5'
                                                        },
                                                        {
                                                          'date' => '2006-05-04T17:49:06',
                                                          'version' => '3.0003'
                                                        },
                                                        {
                                                          'date' => '2006-05-04T17:49:23',
                                                          'version' => '3.0003_1'
                                                        },
                                                        {
                                                          'date' => '2006-05-21T17:28:22',
                                                          'version' => '3.0004'
                                                        },
                                                        {
                                                          'date' => '2006-05-21T17:28:33',
                                                          'version' => '3.0004_1'
                                                        },
                                                        {
                                                          'date' => '2006-06-10T01:21:49',
                                                          'version' => '3.0005_1'
                                                        },
                                                        {
                                                          'date' => '2006-06-10T01:22:01',
                                                          'version' => '3.0005'
                                                        },
                                                        {
                                                          'date' => '2006-06-11T17:05:25',
                                                          'version' => '3.0006'
                                                        },
                                                        {
                                                          'date' => '2006-06-11T17:05:36',
                                                          'version' => '3.0006_1'
                                                        },
                                                        {
                                                          'date' => '2006-09-08T23:12:02',
                                                          'version' => '3.0007'
                                                        },
                                                        {
                                                          'date' => '2006-09-08T23:13:45',
                                                          'version' => '3.0007_1'
                                                        },
                                                        {
                                                          'date' => '2006-10-07T12:59:23',
                                                          'version' => '3.0007_2'
                                                        },
                                                        {
                                                          'date' => '2006-10-16T13:42:13',
                                                          'version' => '3.0008'
                                                        },
                                                        {
                                                          'date' => '2006-10-16T13:42:24',
                                                          'version' => '3.0008_1'
                                                        },
                                                        {
                                                          'date' => '2006-12-24T14:11:04',
                                                          'version' => '4.00'
                                                        },
                                                        {
                                                          'date' => '2007-01-08T01:11:12',
                                                          'version' => '4.001'
                                                        },
                                                        {
                                                          'date' => '2007-03-02T03:32:59',
                                                          'version' => '4.002'
                                                        },
                                                        {
                                                          'date' => '2007-03-02T14:13:37',
                                                          'version' => '4.003'
                                                        },
                                                        {
                                                          'date' => '2007-03-22T22:31:22',
                                                          'version' => '4.004'
                                                        },
                                                        {
                                                          'date' => '2007-06-08T15:33:34',
                                                          'version' => '4.005'
                                                        },
                                                        {
                                                          'date' => '2007-12-26T22:50:48',
                                                          'version' => '4.006'
                                                        },
                                                        {
                                                          'date' => '2008-05-11T15:56:07',
                                                          'version' => '4.007'
                                                        },
                                                        {
                                                          'date' => '2008-08-15T14:06:50',
                                                          'version' => '4.008'
                                                        },
                                                        {
                                                          'date' => '2008-10-22T01:05:54',
                                                          'version' => '4.009'
                                                        },
                                                        {
                                                          'date' => '2008-10-24T14:00:41',
                                                          'version' => '4.010'
                                                        },
                                                        {
                                                          'date' => '2009-04-14T02:40:31',
                                                          'version' => '4.011'
                                                        },
                                                        {
                                                          'date' => '2009-06-19T02:08:06',
                                                          'version' => '4.012'
                                                        },
                                                        {
                                                          'date' => '2009-09-16T18:37:29',
                                                          'version' => '4.013'
                                                        },
                                                        {
                                                          'date' => '2010-04-15T03:17:58',
                                                          'version' => '4.014'
                                                        },
                                                        {
                                                          'date' => '2010-07-09T19:48:58',
                                                          'version' => '4.015'
                                                        },
                                                        {
                                                          'date' => '2010-07-10T16:50:49',
                                                          'version' => '4.016'
                                                        },
                                                        {
                                                          'date' => '2010-08-12T05:50:17',
                                                          'version' => '4.017'
                                                        },
                                                        {
                                                          'date' => '2010-10-26T16:59:27',
                                                          'version' => '4.018'
                                                        },
                                                        {
                                                          'date' => '2011-05-09T01:28:25',
                                                          'version' => '4.019'
                                                        },
                                                        {
                                                          'date' => '2011-08-20T18:45:49',
                                                          'version' => '4.020'
                                                        },
                                                        {
                                                          'date' => '2012-04-28T14:18:16',
                                                          'version' => '4.021'
                                                        },
                                                        {
                                                          'date' => '2012-08-30T02:00:19',
                                                          'version' => '4.022'
                                                        },
                                                        {
                                                          'date' => '2013-04-12T21:48:10',
                                                          'version' => '4.023'
                                                        },
                                                        {
                                                          'date' => '2013-09-17T16:04:11',
                                                          'version' => '4.024'
                                                        },
                                                        {
                                                          'date' => '2013-11-04T18:29:18',
                                                          'version' => '4.025'
                                                        },
                                                        {
                                                          'date' => '2014-01-16T01:33:03',
                                                          'version' => '4.026'
                                                        },
                                                        {
                                                          'date' => '2014-03-19T14:25:36',
                                                          'version' => '4.027'
                                                        },
                                                        {
                                                          'date' => '2014-08-01T19:59:28',
                                                          'version' => '4.028'
                                                        },
                                                        {
                                                          'date' => '2014-12-09T02:39:44',
                                                          'version' => '4.029'
                                                        },
                                                        {
                                                          'date' => '2015-01-28T03:53:42',
                                                          'version' => '4.030_01'
                                                        },
                                                        {
                                                          'date' => '2015-03-02T20:44:31',
                                                          'version' => '4.030_02'
                                                        },
                                                        {
                                                          'date' => '2015-03-06T20:12:05',
                                                          'version' => '4.031'
                                                        },
                                                        {
                                                          'date' => '2015-04-16T22:28:43',
                                                          'version' => '4.032_01'
                                                        },
                                                        {
                                                          'date' => '2015-07-21T12:15:24',
                                                          'version' => '4.032'
                                                        },
                                                        {
                                                          'date' => '2015-10-25T19:59:17',
                                                          'version' => '4.032_03'
                                                        },
                                                        {
                                                          'date' => '2015-10-27T03:37:29',
                                                          'version' => '4.033'
                                                        },
                                                        {
                                                          'date' => '2015-12-15T07:16:36',
                                                          'version' => '4.033_01'
                                                        },
                                                        {
                                                          'date' => '2015-12-18T07:00:41',
                                                          'version' => '4.033_02'
                                                        },
                                                        {
                                                          'date' => '2016-07-04T19:32:50',
                                                          'version' => '4.033_03'
                                                        },
                                                        {
                                                          'date' => '2016-07-06T06:32:05',
                                                          'version' => '4.034'
                                                        },
                                                        {
                                                          'date' => '2016-07-09T05:50:13',
                                                          'version' => '4.035'
                                                        },
                                                        {
                                                          'date' => '2016-08-01T06:29:25',
                                                          'version' => '4.035_01'
                                                        },
                                                        {
                                                          'date' => '2016-08-11T08:11:18',
                                                          'version' => '4.035_02'
                                                        },
                                                        {
                                                          'date' => '2016-08-19T15:52:10',
                                                          'version' => '4.035_03'
                                                        },
                                                        {
                                                          'date' => '2016-08-23T05:59:26',
                                                          'version' => '4.036'
                                                        },
                                                        {
                                                          'date' => '2016-10-03T07:00:29',
                                                          'version' => '4.037'
                                                        },
                                                        {
                                                          'date' => '2016-10-14T20:56:49',
                                                          'version' => '4.037_01'
                                                        },
                                                        {
                                                          'date' => '2016-10-19T19:37:55',
                                                          'version' => '4.037_02'
                                                        },
                                                        {
                                                          'date' => '2016-10-20T02:33:04',
                                                          'version' => '4.038'
                                                        },
                                                        {
                                                          'date' => '2016-10-30T08:45:31',
                                                          'version' => '4.038_01'
                                                        },
                                                        {
                                                          'date' => '2016-11-16T03:57:57',
                                                          'version' => '4.039'
                                                        },
                                                        {
                                                          'date' => '2016-11-19T19:56:51',
                                                          'version' => '4.040'
                                                        },
                                                        {
                                                          'date' => '2016-11-28T20:40:41',
                                                          'version' => '4.041'
                                                        },
                                                        {
                                                          'date' => '2016-12-13T06:59:09',
                                                          'version' => '4.041_01'
                                                        },
                                                        {
                                                          'date' => '2017-02-28T20:57:20',
                                                          'version' => '4.041_02'
                                                        },
                                                        {
                                                          'date' => '2017-03-08T20:32:52',
                                                          'version' => '4.042'
                                                        },
                                                        {
                                                          'date' => '2017-06-29T21:12:09',
                                                          'version' => '4.043'
                                                        },
                                                        {
                                                          'date' => '2018-01-23T01:53:30',
                                                          'version' => '4.044'
                                                        },
                                                        {
                                                          'date' => '2018-02-07T21:43:00',
                                                          'version' => '4.044'
                                                        },
                                                        {
                                                          'date' => '2018-02-08T20:30:55',
                                                          'version' => '4.045'
                                                        },
                                                        {
                                                          'date' => '2018-02-08T20:48:11',
                                                          'version' => '4.046'
                                                        },
                                                        {
                                                          'date' => '2018-03-09T20:27:44',
                                                          'version' => '4.046_01'
                                                        },
                                                        {
                                                          'date' => '2018-09-09T03:02:20',
                                                          'version' => '4.047'
                                                        },
                                                        {
                                                          'date' => '2018-09-15T12:46:51',
                                                          'version' => '4.048'
                                                        },
                                                        {
                                                          'date' => '2018-11-17T18:58:09',
                                                          'version' => '4.049'
                                                        },
                                                        {
                                                          'date' => '2019-01-09T09:07:15',
                                                          'version' => '4.050'
                                                        }
                                                      ]
                                      },
                       'DBD-mysqlPP' => {
                                          'advisories' => [
                                                            {
                                                              'affected_versions' => '<0.93',
                                                              'description' => 'SQL injection.
',
                                                              'distribution' => 'DBD-mysqlPP',
                                                              'fixed_versions' => '>=0.03',
                                                              'id' => 'CPANSA-DBD-mysqlPP-2011-01',
                                                              'references' => [
                                                                                'https://metacpan.org/changes/distribution/DBD-mysqlPP',
                                                                                'https://jvn.jp/en/jp/JVN51216285/index.html'
                                                                              ],
                                                              'reported' => '2011-10-14',
                                                              'severity' => 'high'
                                                            }
                                                          ],
                                          'main_module' => 'DBD::mysqlPP',
                                          'versions' => [
                                                          {
                                                            'date' => '2002-04-04T07:20:36',
                                                            'version' => '0.02'
                                                          },
                                                          {
                                                            'date' => '2002-04-15T10:26:39',
                                                            'version' => '0.03'
                                                          },
                                                          {
                                                            'date' => '2003-01-24T11:14:14',
                                                            'version' => '0.04'
                                                          },
                                                          {
                                                            'date' => '2011-10-21T23:07:07',
                                                            'version' => '0.05'
                                                          },
                                                          {
                                                            'date' => '2011-10-26T22:17:22',
                                                            'version' => '0.06'
                                                          },
                                                          {
                                                            'date' => '2011-11-17T22:24:50',
                                                            'version' => '0.07'
                                                          }
                                                        ]
                                        },
                       'DBI' => {
                                  'advisories' => [
                                                    {
                                                      'affected_versions' => '<1.632',
                                                      'description' => 'DBD::File drivers open files from folders other than specifically passed using the f_dir attribute.
',
                                                      'distribution' => 'DBI',
                                                      'fixed_versions' => '>=1.632',
                                                      'id' => 'CPANSA-DBI-2014-01',
                                                      'references' => [
                                                                        'https://metacpan.org/changes/distribution/DBI',
                                                                        'https://rt.cpan.org/Public/Bug/Display.html?id=99508'
                                                                      ],
                                                      'reported' => '2014-10-15',
                                                      'severity' => 'high'
                                                    },
                                                    {
                                                      'affected_versions' => '<1.47',
                                                      'cves' => [
                                                                  'CVE-2005-0077'
                                                                ],
                                                      'description' => 'Allows local users to overwrite arbitrary files via a symlink attack on a temporary PID file.
',
                                                      'distribution' => 'DBI',
                                                      'fixed_versions' => '>=1.47',
                                                      'id' => 'CPANSA-DBI-2005-01',
                                                      'references' => [
                                                                        'https://metacpan.org/changes/distribution/DBI'
                                                                      ],
                                                      'reported' => '2005-05-02'
                                                    }
                                                  ],
                                  'main_module' => 'DBI',
                                  'versions' => [
                                                  {
                                                    'date' => '1995-10-27T08:14:00',
                                                    'version' => '0.64'
                                                  },
                                                  {
                                                    'date' => '1996-02-15T22:07:00',
                                                    'version' => '0.67'
                                                  },
                                                  {
                                                    'date' => '1996-04-22T10:22:00',
                                                    'version' => '0.68'
                                                  },
                                                  {
                                                    'date' => '1996-05-07T19:46:00',
                                                    'version' => '0.69'
                                                  },
                                                  {
                                                    'date' => '1996-06-16T21:08:00',
                                                    'version' => '0.70'
                                                  },
                                                  {
                                                    'date' => '1996-07-10T00:49:00',
                                                    'version' => '0.71'
                                                  },
                                                  {
                                                    'date' => '1996-09-23T16:33:00',
                                                    'version' => '0.72'
                                                  },
                                                  {
                                                    'date' => '1996-10-15T00:58:00',
                                                    'version' => '0.73'
                                                  },
                                                  {
                                                    'date' => '1997-01-14T16:59:00',
                                                    'version' => '0.74'
                                                  },
                                                  {
                                                    'date' => '1997-01-27T21:59:00',
                                                    'version' => '0.75'
                                                  },
                                                  {
                                                    'date' => '1997-02-03T18:54:00',
                                                    'version' => '0.76'
                                                  },
                                                  {
                                                    'date' => '1997-02-21T14:27:00',
                                                    'version' => '0.77'
                                                  },
                                                  {
                                                    'date' => '1997-03-28T14:36:00',
                                                    'version' => '0.78'
                                                  },
                                                  {
                                                    'date' => '1997-04-07T18:28:00',
                                                    'version' => '0.79'
                                                  },
                                                  {
                                                    'date' => '1997-05-07T11:45:00',
                                                    'version' => '0.80'
                                                  },
                                                  {
                                                    'date' => '1997-05-07T14:05:00',
                                                    'version' => '0.81'
                                                  },
                                                  {
                                                    'date' => '1997-05-23T15:56:00',
                                                    'version' => '0.82'
                                                  },
                                                  {
                                                    'date' => '1997-06-11T21:40:00',
                                                    'version' => '0.83'
                                                  },
                                                  {
                                                    'date' => '1997-06-20T15:36:00',
                                                    'version' => '0.84'
                                                  },
                                                  {
                                                    'date' => '1997-06-25T10:25:00',
                                                    'version' => '0.85'
                                                  },
                                                  {
                                                    'date' => '1997-07-16T16:38:00',
                                                    'version' => '0.001'
                                                  },
                                                  {
                                                    'date' => '1997-07-18T11:27:00',
                                                    'version' => '0.87'
                                                  },
                                                  {
                                                    'date' => '1997-07-22T21:27:00',
                                                    'version' => '0.88'
                                                  },
                                                  {
                                                    'date' => '1997-07-25T13:46:55',
                                                    'version' => '0.89'
                                                  },
                                                  {
                                                    'date' => '1997-09-05T19:38:52',
                                                    'version' => '0.90'
                                                  },
                                                  {
                                                    'date' => '1997-12-10T17:15:14',
                                                    'version' => '0.91'
                                                  },
                                                  {
                                                    'date' => '1998-02-05T20:45:45',
                                                    'version' => '0.92'
                                                  },
                                                  {
                                                    'date' => '1998-02-13T15:21:52',
                                                    'version' => '0.93'
                                                  },
                                                  {
                                                    'date' => '1998-08-10T03:23:46',
                                                    'version' => '0.94'
                                                  },
                                                  {
                                                    'date' => '1998-08-11T13:21:19',
                                                    'version' => '0.95'
                                                  },
                                                  {
                                                    'date' => '1998-08-14T20:38:42',
                                                    'version' => '1.00'
                                                  },
                                                  {
                                                    'date' => '1998-09-02T14:59:47',
                                                    'version' => '1.01'
                                                  },
                                                  {
                                                    'date' => '1998-09-04T12:29:52',
                                                    'version' => '1.02'
                                                  },
                                                  {
                                                    'date' => '1999-01-18T21:52:15',
                                                    'version' => '1.06'
                                                  },
                                                  {
                                                    'date' => '1999-05-13T01:49:11',
                                                    'version' => '1.08'
                                                  },
                                                  {
                                                    'date' => '1999-06-02T13:44:40',
                                                    'version' => '1.08'
                                                  },
                                                  {
                                                    'date' => '1999-06-09T20:57:59',
                                                    'version' => '1.09'
                                                  },
                                                  {
                                                    'date' => '1999-06-13T23:52:03',
                                                    'version' => '1.10'
                                                  },
                                                  {
                                                    'date' => '1999-06-17T13:22:36',
                                                    'version' => '1.11'
                                                  },
                                                  {
                                                    'date' => '1999-06-29T23:07:41',
                                                    'version' => '1.12'
                                                  },
                                                  {
                                                    'date' => '1999-07-12T03:28:41',
                                                    'version' => '1.13'
                                                  },
                                                  {
                                                    'date' => '2000-06-11T02:39:59',
                                                    'version' => '1.03_80'
                                                  },
                                                  {
                                                    'date' => '2000-06-14T20:30:57',
                                                    'version' => '1.14'
                                                  },
                                                  {
                                                    'date' => '2001-03-30T15:03:31',
                                                    'version' => '1.15'
                                                  },
                                                  {
                                                    'date' => '2001-05-29T23:25:57',
                                                    'version' => '1.16'
                                                  },
                                                  {
                                                    'date' => '2001-06-04T17:12:30',
                                                    'version' => '1.17'
                                                  },
                                                  {
                                                    'date' => '2001-06-04T19:00:37',
                                                    'version' => '1.18'
                                                  },
                                                  {
                                                    'date' => '2001-07-20T22:29:24',
                                                    'version' => '1.19'
                                                  },
                                                  {
                                                    'date' => '2001-08-24T23:32:10',
                                                    'version' => '1.20'
                                                  },
                                                  {
                                                    'date' => '2002-01-10T15:25:45',
                                                    'version' => '1.201'
                                                  },
                                                  {
                                                    'date' => '2002-02-07T03:30:16',
                                                    'version' => '1.21'
                                                  },
                                                  {
                                                    'date' => '2002-03-13T14:18:00',
                                                    'version' => '1.21'
                                                  },
                                                  {
                                                    'date' => '2002-05-22T13:42:15',
                                                    'version' => '1.22'
                                                  },
                                                  {
                                                    'date' => '2002-05-25T17:38:03',
                                                    'version' => '1.23'
                                                  },
                                                  {
                                                    'date' => '2002-06-05T03:32:38',
                                                    'version' => '1.24'
                                                  },
                                                  {
                                                    'date' => '2002-06-05T22:42:04',
                                                    'version' => '1.25'
                                                  },
                                                  {
                                                    'date' => '2002-06-13T12:30:47',
                                                    'version' => '1.26'
                                                  },
                                                  {
                                                    'date' => '2002-06-13T15:19:06',
                                                    'version' => '1.27'
                                                  },
                                                  {
                                                    'date' => '2002-06-14T13:13:53',
                                                    'version' => '1.28'
                                                  },
                                                  {
                                                    'date' => '2002-06-26T09:34:24',
                                                    'version' => '1.28'
                                                  },
                                                  {
                                                    'date' => '2002-07-15T11:24:40',
                                                    'version' => '1.29'
                                                  },
                                                  {
                                                    'date' => '2002-07-18T14:27:25',
                                                    'version' => '1.30'
                                                  },
                                                  {
                                                    'date' => '2002-11-30T00:49:54',
                                                    'version' => '1.31'
                                                  },
                                                  {
                                                    'date' => '2002-12-01T23:01:26',
                                                    'version' => '1.32'
                                                  },
                                                  {
                                                    'date' => '2002-12-20T16:23:29',
                                                    'version' => '1.32'
                                                  },
                                                  {
                                                    'date' => '2003-02-26T18:01:24',
                                                    'version' => '1.32_90'
                                                  },
                                                  {
                                                    'date' => '2003-02-27T00:25:32',
                                                    'version' => '1.33'
                                                  },
                                                  {
                                                    'date' => '2003-02-28T17:53:35',
                                                    'version' => '1.34'
                                                  },
                                                  {
                                                    'date' => '2003-03-07T22:02:20',
                                                    'version' => '1.35'
                                                  },
                                                  {
                                                    'date' => '2003-05-14T11:13:39',
                                                    'version' => '1.36'
                                                  },
                                                  {
                                                    'date' => '2003-05-15T18:02:26',
                                                    'version' => '1.37'
                                                  },
                                                  {
                                                    'date' => '2003-08-25T20:36:26',
                                                    'version' => '1.38'
                                                  },
                                                  {
                                                    'date' => '2003-11-27T23:46:40',
                                                    'version' => '1.39'
                                                  },
                                                  {
                                                    'date' => '2004-01-08T14:04:59',
                                                    'version' => '1.39'
                                                  },
                                                  {
                                                    'date' => '2004-02-23T14:54:21',
                                                    'version' => '1.41'
                                                  },
                                                  {
                                                    'date' => '2004-03-12T16:40:08',
                                                    'version' => '1.41'
                                                  },
                                                  {
                                                    'date' => '2004-07-05T10:02:05',
                                                    'version' => '1.43'
                                                  },
                                                  {
                                                    'date' => '2004-10-05T21:27:23',
                                                    'version' => '1.44'
                                                  },
                                                  {
                                                    'date' => '2004-10-06T13:49:20',
                                                    'version' => '1.45'
                                                  },
                                                  {
                                                    'date' => '2004-11-16T12:38:32',
                                                    'version' => '1.46'
                                                  },
                                                  {
                                                    'date' => '2005-02-02T11:28:46',
                                                    'version' => '1.47'
                                                  },
                                                  {
                                                    'date' => '2005-03-14T17:03:33',
                                                    'version' => '1.48'
                                                  },
                                                  {
                                                    'date' => '2005-11-29T19:59:40',
                                                    'version' => '1.49'
                                                  },
                                                  {
                                                    'date' => '2005-12-14T16:55:16',
                                                    'version' => '1.50'
                                                  },
                                                  {
                                                    'date' => '2006-04-19T15:56:38',
                                                    'version' => '1.45'
                                                  },
                                                  {
                                                    'date' => '2006-06-06T12:08:36',
                                                    'version' => '1.51'
                                                  },
                                                  {
                                                    'date' => '2006-08-08T21:13:32',
                                                    'version' => '1.52'
                                                  },
                                                  {
                                                    'date' => '2006-11-02T00:38:01',
                                                    'version' => '1.53'
                                                  },
                                                  {
                                                    'date' => '2007-02-23T17:15:23',
                                                    'version' => '1.54'
                                                  },
                                                  {
                                                    'date' => '2007-05-04T14:56:38',
                                                    'version' => '1.55'
                                                  },
                                                  {
                                                    'date' => '2007-05-10T14:04:04',
                                                    'version' => '1.56'
                                                  },
                                                  {
                                                    'date' => '2007-05-13T22:00:58',
                                                    'version' => '1.56'
                                                  },
                                                  {
                                                    'date' => '2007-06-13T16:45:34',
                                                    'version' => '1.57'
                                                  },
                                                  {
                                                    'date' => '2007-06-15T17:06:42',
                                                    'version' => '1.57'
                                                  },
                                                  {
                                                    'date' => '2007-06-18T15:15:31',
                                                    'version' => '1.57'
                                                  },
                                                  {
                                                    'date' => '2007-06-25T22:11:47',
                                                    'version' => '1.58'
                                                  },
                                                  {
                                                    'date' => '2007-08-22T17:02:10',
                                                    'version' => '1.59'
                                                  },
                                                  {
                                                    'date' => '2007-08-23T12:22:26',
                                                    'version' => '1.59'
                                                  },
                                                  {
                                                    'date' => '2007-08-23T13:59:53',
                                                    'version' => '1.59'
                                                  },
                                                  {
                                                    'date' => '2007-08-24T09:19:29',
                                                    'version' => '1.59'
                                                  },
                                                  {
                                                    'date' => '2007-10-16T13:12:55',
                                                    'version' => '1.601'
                                                  },
                                                  {
                                                    'date' => '2007-10-21T22:12:52',
                                                    'version' => '1.601'
                                                  },
                                                  {
                                                    'date' => '2008-02-09T22:06:13',
                                                    'version' => '1.602'
                                                  },
                                                  {
                                                    'date' => '2008-03-22T00:11:03',
                                                    'version' => '1.603'
                                                  },
                                                  {
                                                    'date' => '2008-03-24T14:11:41',
                                                    'version' => '1.604'
                                                  },
                                                  {
                                                    'date' => '2008-06-16T19:19:43',
                                                    'version' => '1.605'
                                                  },
                                                  {
                                                    'date' => '2008-07-22T21:01:09',
                                                    'version' => '1.606'
                                                  },
                                                  {
                                                    'date' => '2008-07-22T21:50:54',
                                                    'version' => '1.607'
                                                  },
                                                  {
                                                    'date' => '2009-05-02T22:58:48',
                                                    'version' => '1.608'
                                                  },
                                                  {
                                                    'date' => '2009-05-05T12:05:19',
                                                    'version' => '1.608'
                                                  },
                                                  {
                                                    'date' => '2009-06-05T22:57:34',
                                                    'version' => '1.609'
                                                  },
                                                  {
                                                    'date' => '2009-06-08T10:29:18',
                                                    'version' => '1.609'
                                                  },
                                                  {
                                                    'date' => '2010-03-02T21:26:39',
                                                    'version' => '1.611'
                                                  },
                                                  {
                                                    'date' => '2010-04-22T11:06:31',
                                                    'version' => '1.611'
                                                  },
                                                  {
                                                    'date' => '2010-04-27T15:13:32',
                                                    'version' => '1.611'
                                                  },
                                                  {
                                                    'date' => '2010-04-29T19:54:44',
                                                    'version' => '1.611'
                                                  },
                                                  {
                                                    'date' => '2010-05-28T10:29:17',
                                                    'version' => '1.612'
                                                  },
                                                  {
                                                    'date' => '2010-06-15T22:47:23',
                                                    'version' => '1.612'
                                                  },
                                                  {
                                                    'date' => '2010-06-16T19:18:05',
                                                    'version' => '1.612'
                                                  },
                                                  {
                                                    'date' => '2010-07-02T14:26:03',
                                                    'version' => '1.612'
                                                  },
                                                  {
                                                    'date' => '2010-07-15T15:00:53',
                                                    'version' => '1.612'
                                                  },
                                                  {
                                                    'date' => '2010-07-16T19:36:42',
                                                    'version' => '1.612'
                                                  },
                                                  {
                                                    'date' => '2010-07-22T17:34:16',
                                                    'version' => '1.613'
                                                  },
                                                  {
                                                    'date' => '2010-07-25T15:50:15',
                                                    'version' => '1.613'
                                                  },
                                                  {
                                                    'date' => '2010-07-30T14:17:33',
                                                    'version' => '1.614'
                                                  },
                                                  {
                                                    'date' => '2010-08-16T16:34:58',
                                                    'version' => '1.614'
                                                  },
                                                  {
                                                    'date' => '2010-08-30T20:11:00',
                                                    'version' => '1.614'
                                                  },
                                                  {
                                                    'date' => '2010-08-30T20:26:37',
                                                    'version' => '1.614'
                                                  },
                                                  {
                                                    'date' => '2010-08-30T20:56:09',
                                                    'version' => '1.614'
                                                  },
                                                  {
                                                    'date' => '2010-09-02T15:44:21',
                                                    'version' => '1.614'
                                                  },
                                                  {
                                                    'date' => '2010-09-09T10:24:11',
                                                    'version' => '1.614'
                                                  },
                                                  {
                                                    'date' => '2010-09-16T16:23:50',
                                                    'version' => '1.614'
                                                  },
                                                  {
                                                    'date' => '2010-09-17T09:48:02',
                                                    'version' => '1.614'
                                                  },
                                                  {
                                                    'date' => '2010-09-21T10:14:29',
                                                    'version' => '1.615'
                                                  },
                                                  {
                                                    'date' => '2010-09-22T12:28:20',
                                                    'version' => '1.615'
                                                  },
                                                  {
                                                    'date' => '2010-12-18T21:51:52',
                                                    'version' => '1.616'
                                                  },
                                                  {
                                                    'date' => '2010-12-21T23:26:46',
                                                    'version' => '1.616'
                                                  },
                                                  {
                                                    'date' => '2010-12-29T14:39:48',
                                                    'version' => '1.616'
                                                  },
                                                  {
                                                    'date' => '2010-12-30T10:26:51',
                                                    'version' => '1.616'
                                                  },
                                                  {
                                                    'date' => '2012-01-02T17:12:53',
                                                    'version' => '1.617'
                                                  },
                                                  {
                                                    'date' => '2012-01-28T09:34:18',
                                                    'version' => '1.617'
                                                  },
                                                  {
                                                    'date' => '2012-01-30T10:06:49',
                                                    'version' => '1.617'
                                                  },
                                                  {
                                                    'date' => '2012-02-07T22:54:02',
                                                    'version' => '1.618'
                                                  },
                                                  {
                                                    'date' => '2012-02-13T18:24:33',
                                                    'version' => '1.618'
                                                  },
                                                  {
                                                    'date' => '2012-02-23T11:05:45',
                                                    'version' => '1.618'
                                                  },
                                                  {
                                                    'date' => '2012-02-25T14:24:39',
                                                    'version' => '1.618'
                                                  },
                                                  {
                                                    'date' => '2012-04-18T11:57:55',
                                                    'version' => '1.619'
                                                  },
                                                  {
                                                    'date' => '2012-04-20T20:21:54',
                                                    'version' => '1.619'
                                                  },
                                                  {
                                                    'date' => '2012-04-23T22:09:14',
                                                    'version' => '1.619'
                                                  },
                                                  {
                                                    'date' => '2012-04-25T12:46:54',
                                                    'version' => '1.620'
                                                  },
                                                  {
                                                    'date' => '2012-05-21T13:06:09',
                                                    'version' => '1.621'
                                                  },
                                                  {
                                                    'date' => '2012-05-22T22:17:06',
                                                    'version' => '1.621'
                                                  },
                                                  {
                                                    'date' => '2012-06-06T16:51:00',
                                                    'version' => '1.622'
                                                  },
                                                  {
                                                    'date' => '2012-07-13T15:24:35',
                                                    'version' => '1.623'
                                                  },
                                                  {
                                                    'date' => '2012-10-30T13:01:14',
                                                    'version' => '1.623'
                                                  },
                                                  {
                                                    'date' => '2012-11-19T23:27:04',
                                                    'version' => '1.623'
                                                  },
                                                  {
                                                    'date' => '2012-12-13T16:26:23',
                                                    'version' => '1.623'
                                                  },
                                                  {
                                                    'date' => '2012-12-21T17:22:01',
                                                    'version' => '1.623'
                                                  },
                                                  {
                                                    'date' => '2013-01-02T10:09:42',
                                                    'version' => '1.623'
                                                  },
                                                  {
                                                    'date' => '2013-03-22T20:41:50',
                                                    'version' => '1.624'
                                                  },
                                                  {
                                                    'date' => '2013-03-28T21:59:38',
                                                    'version' => '1.625'
                                                  },
                                                  {
                                                    'date' => '2013-05-15T11:28:03',
                                                    'version' => '1.626'
                                                  },
                                                  {
                                                    'date' => '2013-05-16T20:30:50',
                                                    'version' => '1.627'
                                                  },
                                                  {
                                                    'date' => '2013-06-24T21:56:27',
                                                    'version' => '1.628'
                                                  },
                                                  {
                                                    'date' => '2013-06-24T22:12:23',
                                                    'version' => '1.628'
                                                  },
                                                  {
                                                    'date' => '2013-06-30T19:08:08',
                                                    'version' => '1.628'
                                                  },
                                                  {
                                                    'date' => '2013-07-02T11:27:23',
                                                    'version' => '1.628'
                                                  },
                                                  {
                                                    'date' => '2013-07-22T13:22:40',
                                                    'version' => '1.628'
                                                  },
                                                  {
                                                    'date' => '2013-10-11T12:28:12',
                                                    'version' => '1.629'
                                                  },
                                                  {
                                                    'date' => '2013-10-13T16:02:52',
                                                    'version' => '1.629'
                                                  },
                                                  {
                                                    'date' => '2013-10-15T12:24:53',
                                                    'version' => '1.629'
                                                  },
                                                  {
                                                    'date' => '2013-10-22T11:58:53',
                                                    'version' => '1.629_50'
                                                  },
                                                  {
                                                    'date' => '2013-10-28T12:51:39',
                                                    'version' => '1.630'
                                                  },
                                                  {
                                                    'date' => '2014-01-13T13:51:01',
                                                    'version' => '1.631'
                                                  },
                                                  {
                                                    'date' => '2014-01-16T11:34:34',
                                                    'version' => '1.631'
                                                  },
                                                  {
                                                    'date' => '2014-01-20T11:12:44',
                                                    'version' => '1.631'
                                                  },
                                                  {
                                                    'date' => '2014-10-23T14:08:22',
                                                    'version' => '1.631'
                                                  },
                                                  {
                                                    'date' => '2014-11-05T11:15:07',
                                                    'version' => '1.632'
                                                  },
                                                  {
                                                    'date' => '2015-01-08T14:31:52',
                                                    'version' => '1.632'
                                                  },
                                                  {
                                                    'date' => '2015-01-11T13:26:05',
                                                    'version' => '1.633'
                                                  },
                                                  {
                                                    'date' => '2015-07-18T13:16:07',
                                                    'version' => '1.633'
                                                  },
                                                  {
                                                    'date' => '2015-07-19T14:34:22',
                                                    'version' => '1.633_91'
                                                  },
                                                  {
                                                    'date' => '2015-07-22T15:27:59',
                                                    'version' => '1.633_92'
                                                  },
                                                  {
                                                    'date' => '2015-08-02T16:52:48',
                                                    'version' => '1.633_93'
                                                  },
                                                  {
                                                    'date' => '2015-08-03T14:52:56',
                                                    'version' => '1.634'
                                                  },
                                                  {
                                                    'date' => '2016-04-23T15:28:02',
                                                    'version' => '1.634'
                                                  },
                                                  {
                                                    'date' => '2016-04-24T11:57:03',
                                                    'version' => '1.635'
                                                  },
                                                  {
                                                    'date' => '2016-04-24T22:20:56',
                                                    'version' => '1.636'
                                                  },
                                                  {
                                                    'date' => '2017-08-14T10:10:55',
                                                    'version' => '1.637'
                                                  },
                                                  {
                                                    'date' => '2017-08-16T09:02:40',
                                                    'version' => '1.637'
                                                  },
                                                  {
                                                    'date' => '2017-12-28T14:40:44',
                                                    'version' => '1.639'
                                                  },
                                                  {
                                                    'date' => '2018-01-28T20:50:53',
                                                    'version' => '1.640'
                                                  },
                                                  {
                                                    'date' => '2018-03-19T18:06:08',
                                                    'version' => '1.641'
                                                  },
                                                  {
                                                    'date' => '2018-10-28T15:08:54',
                                                    'version' => '1.641_90'
                                                  },
                                                  {
                                                    'date' => '2018-10-29T10:43:41',
                                                    'version' => '1.642'
                                                  }
                                                ]
                                },
                       'DBIx-Custom' => {
                                          'advisories' => [
                                                            {
                                                              'affected_versions' => '<0.1641',
                                                              'description' => 'SQL injection when passing special column names.
',
                                                              'distribution' => 'DBIx-Custom',
                                                              'fixed_versions' => '>=0.1641',
                                                              'id' => 'CPANSA-DBIx-Custom-2011-01',
                                                              'references' => [
                                                                                'https://metacpan.org/changes/distribution/DBIx-Custom',
                                                                                'https://github.com/yuki-kimoto/DBIx-Custom/commit/5b00b9f9a966e7abecabd91710c8fa893784d919'
                                                                              ],
                                                              'reported' => '2011-01-27',
                                                              'severity' => 'high'
                                                            }
                                                          ],
                                          'main_module' => 'DBIx::Custom',
                                          'versions' => [
                                                          {
                                                            'date' => '2009-11-08T04:18:19',
                                                            'version' => '0.0101'
                                                          },
                                                          {
                                                            'date' => '2009-11-09T10:46:44',
                                                            'version' => '0.0201'
                                                          },
                                                          {
                                                            'date' => '2009-11-12T14:12:47',
                                                            'version' => '0.0301'
                                                          },
                                                          {
                                                            'date' => '2009-11-15T11:43:40',
                                                            'version' => '0.0401'
                                                          },
                                                          {
                                                            'date' => '2009-11-16T11:10:52',
                                                            'version' => '0.0501'
                                                          },
                                                          {
                                                            'date' => '2009-11-17T12:37:33',
                                                            'version' => '0.0502'
                                                          },
                                                          {
                                                            'date' => '2009-11-19T12:05:50',
                                                            'version' => '0.0601'
                                                          },
                                                          {
                                                            'date' => '2009-11-19T13:37:39',
                                                            'version' => '0.0602'
                                                          },
                                                          {
                                                            'date' => '2009-11-20T12:08:31',
                                                            'version' => '0.0603'
                                                          },
                                                          {
                                                            'date' => '2009-11-23T13:39:53',
                                                            'version' => '0.0604'
                                                          },
                                                          {
                                                            'date' => '2009-11-23T14:45:46',
                                                            'version' => '0.0605'
                                                          },
                                                          {
                                                            'date' => '2009-11-25T13:57:52',
                                                            'version' => '0.0701'
                                                          },
                                                          {
                                                            'date' => '2009-12-01T07:30:25',
                                                            'version' => '0.0702'
                                                          },
                                                          {
                                                            'date' => '2009-12-02T13:59:36',
                                                            'version' => '0.0801'
                                                          },
                                                          {
                                                            'date' => '2009-12-09T14:27:53',
                                                            'version' => '0.0901'
                                                          },
                                                          {
                                                            'date' => '2009-12-22T13:40:07',
                                                            'version' => '0.0902'
                                                          },
                                                          {
                                                            'date' => '2010-01-18T12:42:57',
                                                            'version' => '0.0903'
                                                          },
                                                          {
                                                            'date' => '2010-01-21T14:29:12',
                                                            'version' => '0.0904'
                                                          },
                                                          {
                                                            'date' => '2010-01-22T12:51:23',
                                                            'version' => '0.0905'
                                                          },
                                                          {
                                                            'date' => '2010-01-24T09:49:30',
                                                            'version' => '0.0906'
                                                          },
                                                          {
                                                            'date' => '2010-01-30T00:15:17',
                                                            'version' => '0.1001'
                                                          },
                                                          {
                                                            'date' => '2010-01-30T03:51:04',
                                                            'version' => '0.1101'
                                                          },
                                                          {
                                                            'date' => '2010-05-01T13:02:19',
                                                            'version' => '0.1301'
                                                          },
                                                          {
                                                            'date' => '2010-05-01T23:29:22',
                                                            'version' => '0.1401'
                                                          },
                                                          {
                                                            'date' => '2010-05-02T06:04:57',
                                                            'version' => '0.1402'
                                                          },
                                                          {
                                                            'date' => '2010-05-26T15:13:04',
                                                            'version' => '0.1501'
                                                          },
                                                          {
                                                            'date' => '2010-05-27T14:00:04',
                                                            'version' => '0.1502'
                                                          },
                                                          {
                                                            'date' => '2010-05-28T13:28:16',
                                                            'version' => '0.1503'
                                                          },
                                                          {
                                                            'date' => '2010-06-25T12:11:33',
                                                            'version' => '0.1602'
                                                          },
                                                          {
                                                            'date' => '2010-07-14T13:55:33',
                                                            'version' => '0.1603'
                                                          },
                                                          {
                                                            'date' => '2010-08-03T14:43:14',
                                                            'version' => '0.1604'
                                                          },
                                                          {
                                                            'date' => '2010-08-05T15:17:49',
                                                            'version' => '0.1605'
                                                          },
                                                          {
                                                            'date' => '2010-08-05T15:24:36',
                                                            'version' => '0.1606'
                                                          },
                                                          {
                                                            'date' => '2010-08-06T14:57:35',
                                                            'version' => '0.1607'
                                                          },
                                                          {
                                                            'date' => '2010-08-07T05:49:19',
                                                            'version' => '0.1608'
                                                          },
                                                          {
                                                            'date' => '2010-08-08T04:45:12',
                                                            'version' => '0.1609'
                                                          },
                                                          {
                                                            'date' => '2010-08-08T12:44:43',
                                                            'version' => '0.1610'
                                                          },
                                                          {
                                                            'date' => '2010-08-09T12:08:31',
                                                            'version' => '0.1611'
                                                          },
                                                          {
                                                            'date' => '2010-08-10T11:19:41',
                                                            'version' => '0.1612'
                                                          },
                                                          {
                                                            'date' => '2010-08-10T12:35:17',
                                                            'version' => '0.1613'
                                                          },
                                                          {
                                                            'date' => '2010-08-12T15:01:01',
                                                            'version' => '0.1614'
                                                          },
                                                          {
                                                            'date' => '2010-08-15T04:00:44',
                                                            'version' => '0.1615'
                                                          },
                                                          {
                                                            'date' => '2010-08-24T10:18:06',
                                                            'version' => '0.1616'
                                                          },
                                                          {
                                                            'date' => '2010-09-07T12:12:04',
                                                            'version' => '0.1617'
                                                          },
                                                          {
                                                            'date' => '2010-10-17T05:44:56',
                                                            'version' => '0.1618'
                                                          },
                                                          {
                                                            'date' => '2010-10-20T15:01:35',
                                                            'version' => '0.1619'
                                                          },
                                                          {
                                                            'date' => '2010-10-21T14:38:05',
                                                            'version' => '0.1620'
                                                          },
                                                          {
                                                            'date' => '2010-11-10T06:54:46',
                                                            'version' => '0.1621'
                                                          },
                                                          {
                                                            'date' => '2010-12-20T14:58:38',
                                                            'version' => '0.1622'
                                                          },
                                                          {
                                                            'date' => '2010-12-21T16:10:25',
                                                            'version' => '0.1623'
                                                          },
                                                          {
                                                            'date' => '2010-12-22T08:41:09',
                                                            'version' => '0.1624'
                                                          },
                                                          {
                                                            'date' => '2011-01-01T16:08:48',
                                                            'version' => '0.1625'
                                                          },
                                                          {
                                                            'date' => '2011-01-02T04:21:11',
                                                            'version' => '0.1626'
                                                          },
                                                          {
                                                            'date' => '2011-01-04T15:18:21',
                                                            'version' => '0.1627'
                                                          },
                                                          {
                                                            'date' => '2011-01-12T07:29:29',
                                                            'version' => '0.1628'
                                                          },
                                                          {
                                                            'date' => '2011-01-12T15:35:11',
                                                            'version' => '0.1629'
                                                          },
                                                          {
                                                            'date' => '2011-01-13T15:41:25',
                                                            'version' => '0.1630'
                                                          },
                                                          {
                                                            'date' => '2011-01-17T15:53:44',
                                                            'version' => '0.1631'
                                                          },
                                                          {
                                                            'date' => '2011-01-18T14:43:16',
                                                            'version' => '0.1632'
                                                          },
                                                          {
                                                            'date' => '2011-01-18T15:22:37',
                                                            'version' => '0.1633'
                                                          },
                                                          {
                                                            'date' => '2011-01-19T14:52:48',
                                                            'version' => '0.1634'
                                                          },
                                                          {
                                                            'date' => '2011-01-21T14:04:02',
                                                            'version' => '0.1635'
                                                          },
                                                          {
                                                            'date' => '2011-01-22T13:02:55',
                                                            'version' => '0.1636'
                                                          },
                                                          {
                                                            'date' => '2011-01-24T12:58:40',
                                                            'version' => '0.1637'
                                                          },
                                                          {
                                                            'date' => '2011-01-25T12:32:26',
                                                            'version' => '0.1638'
                                                          },
                                                          {
                                                            'date' => '2011-01-26T09:23:22',
                                                            'version' => '0.1639'
                                                          },
                                                          {
                                                            'date' => '2011-01-26T13:59:10',
                                                            'version' => '0.1640'
                                                          },
                                                          {
                                                            'date' => '2011-01-27T05:19:14',
                                                            'version' => '0.1641'
                                                          },
                                                          {
                                                            'date' => '2011-01-28T12:18:42',
                                                            'version' => '0.1642'
                                                          },
                                                          {
                                                            'date' => '2011-02-09T08:54:11',
                                                            'version' => '0.1643'
                                                          },
                                                          {
                                                            'date' => '2011-02-11T14:07:25',
                                                            'version' => '0.1644'
                                                          },
                                                          {
                                                            'date' => '2011-02-14T15:24:30',
                                                            'version' => '0.1645'
                                                          },
                                                          {
                                                            'date' => '2011-02-18T17:48:52',
                                                            'version' => '0.1646'
                                                          },
                                                          {
                                                            'date' => '2011-02-19T00:30:41',
                                                            'version' => '0.1647'
                                                          },
                                                          {
                                                            'date' => '2011-02-21T16:13:29',
                                                            'version' => '0.1648'
                                                          },
                                                          {
                                                            'date' => '2011-02-22T14:53:08',
                                                            'version' => '0.1649'
                                                          },
                                                          {
                                                            'date' => '2011-02-24T05:45:44',
                                                            'version' => '0.1650'
                                                          },
                                                          {
                                                            'date' => '2011-02-24T14:35:20',
                                                            'version' => '0.1651'
                                                          },
                                                          {
                                                            'date' => '2011-02-25T14:39:56',
                                                            'version' => '0.1652'
                                                          },
                                                          {
                                                            'date' => '2011-02-28T13:18:03',
                                                            'version' => '0.1653'
                                                          },
                                                          {
                                                            'date' => '2011-03-06T14:32:11',
                                                            'version' => '0.1654'
                                                          },
                                                          {
                                                            'date' => '2011-03-08T14:59:08',
                                                            'version' => '0.1655'
                                                          },
                                                          {
                                                            'date' => '2011-03-09T13:44:35',
                                                            'version' => '0.1656'
                                                          },
                                                          {
                                                            'date' => '2011-03-10T15:44:50',
                                                            'version' => '0.1657'
                                                          },
                                                          {
                                                            'date' => '2011-03-11T16:23:11',
                                                            'version' => '0.1658'
                                                          },
                                                          {
                                                            'date' => '2011-03-12T08:20:07',
                                                            'version' => '0.1659'
                                                          },
                                                          {
                                                            'date' => '2011-03-14T11:16:27',
                                                            'version' => '0.1660'
                                                          },
                                                          {
                                                            'date' => '2011-03-15T16:32:52',
                                                            'version' => '0.1661'
                                                          },
                                                          {
                                                            'date' => '2011-03-19T14:40:50',
                                                            'version' => '0.1662'
                                                          },
                                                          {
                                                            'date' => '2011-03-21T03:53:25',
                                                            'version' => '0.1663'
                                                          },
                                                          {
                                                            'date' => '2011-03-24T14:45:52',
                                                            'version' => '0.1664'
                                                          },
                                                          {
                                                            'date' => '2011-03-25T14:25:43',
                                                            'version' => '0.1665'
                                                          },
                                                          {
                                                            'date' => '2011-03-29T17:26:27',
                                                            'version' => '0.1666'
                                                          },
                                                          {
                                                            'date' => '2011-03-30T08:03:39',
                                                            'version' => '0.1667'
                                                          },
                                                          {
                                                            'date' => '2011-03-30T15:04:03',
                                                            'version' => '0.1668'
                                                          },
                                                          {
                                                            'date' => '2011-03-30T15:25:45',
                                                            'version' => '0.1669'
                                                          },
                                                          {
                                                            'date' => '2011-04-01T15:29:33',
                                                            'version' => '0.1670'
                                                          },
                                                          {
                                                            'date' => '2011-04-02T16:31:44',
                                                            'version' => '0.1671'
                                                          },
                                                          {
                                                            'date' => '2011-04-04T13:37:34',
                                                            'version' => '0.1672'
                                                          },
                                                          {
                                                            'date' => '2011-04-05T11:45:54',
                                                            'version' => '0.1673'
                                                          },
                                                          {
                                                            'date' => '2011-04-05T11:59:11',
                                                            'version' => '0.1674'
                                                          },
                                                          {
                                                            'date' => '2011-04-11T13:47:34',
                                                            'version' => '0.1675'
                                                          },
                                                          {
                                                            'date' => '2011-04-11T14:55:38',
                                                            'version' => '0.1676'
                                                          },
                                                          {
                                                            'date' => '2011-04-12T15:17:24',
                                                            'version' => '0.1677'
                                                          },
                                                          {
                                                            'date' => '2011-04-18T13:36:31',
                                                            'version' => '0.1678'
                                                          },
                                                          {
                                                            'date' => '2011-04-19T11:07:27',
                                                            'version' => '0.1679'
                                                          },
                                                          {
                                                            'date' => '2011-04-25T14:05:23',
                                                            'version' => '0.1680'
                                                          },
                                                          {
                                                            'date' => '2011-04-26T14:07:02',
                                                            'version' => '0.1681'
                                                          },
                                                          {
                                                            'date' => '2011-05-23T14:40:41',
                                                            'version' => '0.1682'
                                                          },
                                                          {
                                                            'date' => '2011-06-06T11:52:44',
                                                            'version' => '0.1683'
                                                          },
                                                          {
                                                            'date' => '2011-06-07T13:07:20',
                                                            'version' => '0.1684'
                                                          },
                                                          {
                                                            'date' => '2011-06-08T10:32:35',
                                                            'version' => '0.1685'
                                                          },
                                                          {
                                                            'date' => '2011-06-08T12:24:07',
                                                            'version' => '0.1686'
                                                          },
                                                          {
                                                            'date' => '2011-06-09T13:59:44',
                                                            'version' => '0.1687'
                                                          },
                                                          {
                                                            'date' => '2011-06-10T13:26:20',
                                                            'version' => '0.1688'
                                                          },
                                                          {
                                                            'date' => '2011-06-12T03:22:26',
                                                            'version' => '0.1689'
                                                          },
                                                          {
                                                            'date' => '2011-06-12T12:01:43',
                                                            'version' => '0.1690'
                                                          },
                                                          {
                                                            'date' => '2011-06-13T13:31:21',
                                                            'version' => '0.1691'
                                                          },
                                                          {
                                                            'date' => '2011-06-14T13:27:31',
                                                            'version' => '0.1692'
                                                          },
                                                          {
                                                            'date' => '2011-06-15T08:51:43',
                                                            'version' => '0.1693'
                                                          },
                                                          {
                                                            'date' => '2011-06-17T14:38:23',
                                                            'version' => '0.1694'
                                                          },
                                                          {
                                                            'date' => '2011-06-20T13:08:47',
                                                            'version' => '0.1695'
                                                          },
                                                          {
                                                            'date' => '2011-06-21T13:12:38',
                                                            'version' => '0.1696'
                                                          },
                                                          {
                                                            'date' => '2011-06-24T13:42:00',
                                                            'version' => '0.1697'
                                                          },
                                                          {
                                                            'date' => '2011-06-27T13:23:13',
                                                            'version' => '0.1698'
                                                          },
                                                          {
                                                            'date' => '2011-06-28T14:39:21',
                                                            'version' => '0.1699'
                                                          },
                                                          {
                                                            'date' => '2011-07-01T11:04:37',
                                                            'version' => '0.1700'
                                                          },
                                                          {
                                                            'date' => '2011-07-11T13:19:20',
                                                            'version' => '0.1701'
                                                          },
                                                          {
                                                            'date' => '2011-07-26T14:09:43',
                                                            'version' => '0.1702'
                                                          },
                                                          {
                                                            'date' => '2011-07-28T04:59:20',
                                                            'version' => '0.1703'
                                                          },
                                                          {
                                                            'date' => '2011-07-29T13:45:24',
                                                            'version' => '0.1704'
                                                          },
                                                          {
                                                            'date' => '2011-07-29T14:35:38',
                                                            'version' => '0.1705'
                                                          },
                                                          {
                                                            'date' => '2011-07-30T04:25:21',
                                                            'version' => '0.1706'
                                                          },
                                                          {
                                                            'date' => '2011-07-30T05:16:05',
                                                            'version' => '0.1707'
                                                          },
                                                          {
                                                            'date' => '2011-07-30T14:32:34',
                                                            'version' => '0.1708'
                                                          },
                                                          {
                                                            'date' => '2011-08-01T12:48:52',
                                                            'version' => '0.1709'
                                                          },
                                                          {
                                                            'date' => '2011-08-02T13:30:15',
                                                            'version' => '0.1710'
                                                          },
                                                          {
                                                            'date' => '2011-08-09T14:11:24',
                                                            'version' => '0.1711'
                                                          },
                                                          {
                                                            'date' => '2011-08-10T16:16:52',
                                                            'version' => '0.1712'
                                                          },
                                                          {
                                                            'date' => '2011-08-12T13:45:58',
                                                            'version' => '0.1713'
                                                          },
                                                          {
                                                            'date' => '2011-08-13T13:38:02',
                                                            'version' => '0.1714'
                                                          },
                                                          {
                                                            'date' => '2011-08-14T03:47:28',
                                                            'version' => '0.1715'
                                                          },
                                                          {
                                                            'date' => '2011-08-15T14:00:28',
                                                            'version' => '0.1716'
                                                          },
                                                          {
                                                            'date' => '2011-08-16T04:03:16',
                                                            'version' => '0.1717'
                                                          },
                                                          {
                                                            'date' => '2011-08-20T09:40:46',
                                                            'version' => '0.1718'
                                                          },
                                                          {
                                                            'date' => '2011-08-22T13:43:21',
                                                            'version' => '0.1720'
                                                          },
                                                          {
                                                            'date' => '2011-08-26T14:11:53',
                                                            'version' => '0.1721'
                                                          },
                                                          {
                                                            'date' => '2011-09-02T15:12:10',
                                                            'version' => '0.1722'
                                                          },
                                                          {
                                                            'date' => '2011-09-12T12:24:14',
                                                            'version' => '0.1723'
                                                          },
                                                          {
                                                            'date' => '2011-09-16T15:15:54',
                                                            'version' => '0.1724'
                                                          },
                                                          {
                                                            'date' => '2011-09-27T11:48:33',
                                                            'version' => '0.1725'
                                                          },
                                                          {
                                                            'date' => '2011-09-30T11:21:45',
                                                            'version' => '0.1726'
                                                          },
                                                          {
                                                            'date' => '2011-10-03T10:43:32',
                                                            'version' => '0.1727'
                                                          },
                                                          {
                                                            'date' => '2011-10-05T04:10:35',
                                                            'version' => '0.1728'
                                                          },
                                                          {
                                                            'date' => '2011-10-05T08:12:55',
                                                            'version' => '0.1729'
                                                          },
                                                          {
                                                            'date' => '2011-10-10T11:35:23',
                                                            'version' => '0.1730'
                                                          },
                                                          {
                                                            'date' => '2011-10-11T14:30:46',
                                                            'version' => '0.1731'
                                                          },
                                                          {
                                                            'date' => '2011-10-20T11:56:08',
                                                            'version' => '0.1732'
                                                          },
                                                          {
                                                            'date' => '2011-10-21T22:47:50',
                                                            'version' => '0.1733'
                                                          },
                                                          {
                                                            'date' => '2011-10-22T22:02:37',
                                                            'version' => '0.1734'
                                                          },
                                                          {
                                                            'date' => '2011-10-23T00:11:48',
                                                            'version' => '0.1735'
                                                          },
                                                          {
                                                            'date' => '2011-10-23T13:08:15',
                                                            'version' => '0.1736'
                                                          },
                                                          {
                                                            'date' => '2011-10-24T14:07:44',
                                                            'version' => '0.1737'
                                                          },
                                                          {
                                                            'date' => '2011-10-25T14:31:15',
                                                            'version' => '0.1738'
                                                          },
                                                          {
                                                            'date' => '2011-10-26T01:14:58',
                                                            'version' => '0.1739'
                                                          },
                                                          {
                                                            'date' => '2011-10-27T12:59:00',
                                                            'version' => '0.1740'
                                                          },
                                                          {
                                                            'date' => '2011-10-28T11:49:57',
                                                            'version' => '0.1741'
                                                          },
                                                          {
                                                            'date' => '2011-10-31T15:37:07',
                                                            'version' => '0.1742'
                                                          },
                                                          {
                                                            'date' => '2011-11-01T12:02:38',
                                                            'version' => '0.1743'
                                                          },
                                                          {
                                                            'date' => '2011-11-03T13:38:04',
                                                            'version' => '0.1744'
                                                          },
                                                          {
                                                            'date' => '2011-11-04T14:16:11',
                                                            'version' => '0.1745'
                                                          },
                                                          {
                                                            'date' => '2011-11-07T12:19:53',
                                                            'version' => '0.1746'
                                                          },
                                                          {
                                                            'date' => '2011-11-11T11:59:27',
                                                            'version' => '0.1747'
                                                          },
                                                          {
                                                            'date' => '2011-11-16T00:36:45',
                                                            'version' => '0.20_01'
                                                          },
                                                          {
                                                            'date' => '2011-11-16T08:50:11',
                                                            'version' => '0.2100'
                                                          },
                                                          {
                                                            'date' => '2011-11-21T11:05:36',
                                                            'version' => '0.2101'
                                                          },
                                                          {
                                                            'date' => '2011-11-25T14:34:26',
                                                            'version' => '0.2102'
                                                          },
                                                          {
                                                            'date' => '2011-11-28T10:38:56',
                                                            'version' => '0.2103'
                                                          },
                                                          {
                                                            'date' => '2011-11-29T13:48:49',
                                                            'version' => '0.2104'
                                                          },
                                                          {
                                                            'date' => '2012-01-14T13:39:10',
                                                            'version' => '0.2105'
                                                          },
                                                          {
                                                            'date' => '2012-01-20T15:16:34',
                                                            'version' => '0.2106'
                                                          },
                                                          {
                                                            'date' => '2012-01-25T08:56:44',
                                                            'version' => '0.2107'
                                                          },
                                                          {
                                                            'date' => '2012-01-29T14:30:53',
                                                            'version' => '0.2108'
                                                          },
                                                          {
                                                            'date' => '2012-02-07T13:31:49',
                                                            'version' => '0.2109'
                                                          },
                                                          {
                                                            'date' => '2012-02-10T14:51:17',
                                                            'version' => '0.2110'
                                                          },
                                                          {
                                                            'date' => '2012-02-11T14:45:41',
                                                            'version' => '0.2111'
                                                          },
                                                          {
                                                            'date' => '2012-02-28T14:33:03',
                                                            'version' => '0.22'
                                                          },
                                                          {
                                                            'date' => '2012-03-01T00:07:11',
                                                            'version' => '0.23'
                                                          },
                                                          {
                                                            'date' => '2012-03-02T14:57:03',
                                                            'version' => '0.24'
                                                          },
                                                          {
                                                            'date' => '2012-03-19T11:58:43',
                                                            'version' => '0.25'
                                                          },
                                                          {
                                                            'date' => '2012-07-11T08:20:53',
                                                            'version' => '0.26'
                                                          },
                                                          {
                                                            'date' => '2012-09-17T13:15:26',
                                                            'version' => '0.27'
                                                          },
                                                          {
                                                            'date' => '2013-03-04T11:25:17',
                                                            'version' => '0.28'
                                                          },
                                                          {
                                                            'date' => '2014-02-03T09:21:29',
                                                            'version' => '0.29'
                                                          },
                                                          {
                                                            'date' => '2014-02-04T00:17:32',
                                                            'version' => '0.30'
                                                          },
                                                          {
                                                            'date' => '2015-01-13T01:36:24',
                                                            'version' => '0.31'
                                                          },
                                                          {
                                                            'date' => '2015-01-13T05:24:10',
                                                            'version' => '0.32'
                                                          },
                                                          {
                                                            'date' => '2015-01-13T07:52:20',
                                                            'version' => '0.33'
                                                          },
                                                          {
                                                            'date' => '2015-01-15T02:04:26',
                                                            'version' => '0.34'
                                                          },
                                                          {
                                                            'date' => '2015-05-23T05:44:25',
                                                            'version' => '0.35'
                                                          },
                                                          {
                                                            'date' => '2015-05-25T02:52:16',
                                                            'version' => '0.36'
                                                          },
                                                          {
                                                            'date' => '2016-05-21T07:00:46',
                                                            'version' => '0.37'
                                                          },
                                                          {
                                                            'date' => '2017-03-16T07:48:58',
                                                            'version' => '0.38'
                                                          },
                                                          {
                                                            'date' => '2017-03-29T02:29:03',
                                                            'version' => '0.39'
                                                          },
                                                          {
                                                            'date' => '2017-03-30T01:41:11',
                                                            'version' => '0.40'
                                                          },
                                                          {
                                                            'date' => '2017-11-06T15:17:26',
                                                            'version' => '0.41'
                                                          }
                                                        ]
                                        },
                       'Dancer' => {
                                     'advisories' => [
                                                       {
                                                         'affected_versions' => '<1.3114',
                                                         'cves' => [
                                                                     'CVE-2012-5572'
                                                                   ],
                                                         'description' => 'CRLF injection vulnerability in the cookie method allows remote attackers to inject arbitrary HTTP headers and conduct HTTP response splitting attacks via a cookie name.
',
                                                         'distribution' => 'Dancer',
                                                         'fixed_versions' => '>=1.3114',
                                                         'id' => 'CPANSA-Dancer-2014-01',
                                                         'references' => [
                                                                           'https://metacpan.org/changes/distribution/Dancer',
                                                                           'https://github.com/PerlDancer/Dancer/commit/46ef9124f3149f697455061499ac7cee40930349'
                                                                         ],
                                                         'reported' => '2014-05-30'
                                                       },
                                                       {
                                                         'affected_versions' => '<1.3051',
                                                         'cves' => [
                                                                     'CVE-2011-1589'
                                                                   ],
                                                         'description' => 'Directory traversal vulnerability (Mojolicious report, but Dancer was vulnerable as well).
',
                                                         'distribution' => 'Dancer',
                                                         'fixed_versions' => '>=1.3051',
                                                         'id' => 'CPANSA-Dancer-2011-01',
                                                         'references' => [
                                                                           'https://metacpan.org/changes/distribution/Dancer',
                                                                           'https://github.com/PerlDancer/Dancer/commit/91d0bf6a36705b0971b18f7d38fa2f3df8c7b994'
                                                                         ],
                                                         'reported' => '2011-04-05'
                                                       }
                                                     ],
                                     'main_module' => 'Dancer',
                                     'versions' => [
                                                     {
                                                       'date' => '2009-07-27T13:18:07',
                                                       'version' => '20090727.1315'
                                                     },
                                                     {
                                                       'date' => '2009-07-27T14:14:13',
                                                       'version' => '0_0.99'
                                                     },
                                                     {
                                                       'date' => '2009-08-01T13:48:20',
                                                       'version' => '0.9901'
                                                     },
                                                     {
                                                       'date' => '2009-08-04T10:01:54',
                                                       'version' => '0.9902'
                                                     },
                                                     {
                                                       'date' => '2009-08-07T12:29:03',
                                                       'version' => '0.9003'
                                                     },
                                                     {
                                                       'date' => '2009-09-19T15:30:19',
                                                       'version' => '0.9904'
                                                     },
                                                     {
                                                       'date' => '2009-09-23T21:33:51',
                                                       'version' => '0.9905'
                                                     },
                                                     {
                                                       'date' => '2009-11-20T11:14:20',
                                                       'version' => '1.000'
                                                     },
                                                     {
                                                       'date' => '2010-01-06T13:53:28',
                                                       'version' => '1.100'
                                                     },
                                                     {
                                                       'date' => '2010-01-11T09:46:45',
                                                       'version' => '1.110'
                                                     },
                                                     {
                                                       'date' => '2010-01-15T16:03:35',
                                                       'version' => '1.120'
                                                     },
                                                     {
                                                       'date' => '2010-01-15T17:53:08',
                                                       'version' => '1.121'
                                                     },
                                                     {
                                                       'date' => '2010-01-20T07:48:38',
                                                       'version' => '1.122'
                                                     },
                                                     {
                                                       'date' => '2010-01-29T17:29:24',
                                                       'version' => '1.130'
                                                     },
                                                     {
                                                       'date' => '2010-02-09T07:55:18',
                                                       'version' => '1.140'
                                                     },
                                                     {
                                                       'date' => '2010-02-17T15:09:48',
                                                       'version' => '1.150'
                                                     },
                                                     {
                                                       'date' => '2010-03-07T17:50:01',
                                                       'version' => '1.160'
                                                     },
                                                     {
                                                       'date' => '2010-03-24T11:19:00',
                                                       'version' => '1.170'
                                                     },
                                                     {
                                                       'date' => '2010-03-24T13:44:04',
                                                       'version' => '1.171'
                                                     },
                                                     {
                                                       'date' => '2010-03-28T15:09:59',
                                                       'version' => '1.172'
                                                     },
                                                     {
                                                       'date' => '2010-04-01T14:13:30',
                                                       'version' => '1.173'
                                                     },
                                                     {
                                                       'date' => '2010-04-04T11:03:53',
                                                       'version' => '1.173_01'
                                                     },
                                                     {
                                                       'date' => '2010-04-08T13:49:39',
                                                       'version' => '1.174'
                                                     },
                                                     {
                                                       'date' => '2010-04-11T10:49:39',
                                                       'version' => '1.175'
                                                     },
                                                     {
                                                       'date' => '2010-04-19T08:43:22',
                                                       'version' => '1.175_01'
                                                     },
                                                     {
                                                       'date' => '2010-04-22T20:29:56',
                                                       'version' => '1.176'
                                                     },
                                                     {
                                                       'date' => '2010-05-05T12:21:26',
                                                       'version' => '1.178_01'
                                                     },
                                                     {
                                                       'date' => '2010-05-16T10:28:47',
                                                       'version' => '1.1800'
                                                     },
                                                     {
                                                       'date' => '2010-05-19T14:17:57',
                                                       'version' => '1.1801'
                                                     },
                                                     {
                                                       'date' => '2010-05-19T17:32:52',
                                                       'version' => '1.1802'
                                                     },
                                                     {
                                                       'date' => '2010-05-23T20:45:17',
                                                       'version' => '1.1803'
                                                     },
                                                     {
                                                       'date' => '2010-06-18T11:59:20',
                                                       'version' => '1.1804'
                                                     },
                                                     {
                                                       'date' => '2010-06-22T06:41:58',
                                                       'version' => '1.1805'
                                                     },
                                                     {
                                                       'date' => '2010-07-07T06:15:55',
                                                       'version' => '1.1806_01'
                                                     },
                                                     {
                                                       'date' => '2010-08-14T16:37:45',
                                                       'version' => '1.1806_02'
                                                     },
                                                     {
                                                       'date' => '2010-08-23T17:47:12',
                                                       'version' => '1.1807'
                                                     },
                                                     {
                                                       'date' => '2010-08-24T06:23:38',
                                                       'version' => '1.1808'
                                                     },
                                                     {
                                                       'date' => '2010-08-25T05:41:15',
                                                       'version' => '1.1809'
                                                     },
                                                     {
                                                       'date' => '2010-09-01T06:19:20',
                                                       'version' => '1.1810'
                                                     },
                                                     {
                                                       'date' => '2010-09-03T09:23:14',
                                                       'version' => '1.1811'
                                                     },
                                                     {
                                                       'date' => '2010-09-21T12:19:35',
                                                       'version' => '1.1812'
                                                     },
                                                     {
                                                       'date' => '2010-09-24T14:25:44',
                                                       'version' => '1.1901'
                                                     },
                                                     {
                                                       'date' => '2010-10-14T09:25:03',
                                                       'version' => '1.1999_01'
                                                     },
                                                     {
                                                       'date' => '2010-10-28T15:41:17',
                                                       'version' => '1.1999_02'
                                                     },
                                                     {
                                                       'date' => '2010-11-02T14:14:32',
                                                       'version' => '1.1902'
                                                     },
                                                     {
                                                       'date' => '2010-11-02T14:25:04',
                                                       'version' => '1.1902'
                                                     },
                                                     {
                                                       'date' => '2010-11-03T17:07:29',
                                                       'version' => '1.1903'
                                                     },
                                                     {
                                                       'date' => '2010-11-04T11:16:17',
                                                       'version' => '1.1904'
                                                     },
                                                     {
                                                       'date' => '2010-11-11T07:43:21',
                                                       'version' => '1.1999_03'
                                                     },
                                                     {
                                                       'date' => '2010-11-14T08:08:56',
                                                       'version' => '1.1999_04'
                                                     },
                                                     {
                                                       'date' => '2010-11-18T15:54:33',
                                                       'version' => '1.200'
                                                     },
                                                     {
                                                       'date' => '2010-11-18T16:52:47',
                                                       'version' => '1.2000'
                                                     },
                                                     {
                                                       'date' => '2010-11-29T22:05:38',
                                                       'version' => '1.2000_01'
                                                     },
                                                     {
                                                       'date' => '2010-11-30T10:00:23',
                                                       'version' => '1.2000_02'
                                                     },
                                                     {
                                                       'date' => '2010-11-30T19:59:09',
                                                       'version' => '1.2001'
                                                     },
                                                     {
                                                       'date' => '2010-12-02T12:18:12',
                                                       'version' => '1.2001_01'
                                                     },
                                                     {
                                                       'date' => '2010-12-03T20:28:56',
                                                       'version' => '1.2002'
                                                     },
                                                     {
                                                       'date' => '2010-12-07T18:05:50',
                                                       'version' => '1.2002_01'
                                                     },
                                                     {
                                                       'date' => '2010-12-08T21:38:17',
                                                       'version' => '1.2002_02'
                                                     },
                                                     {
                                                       'date' => '2010-12-10T18:28:16',
                                                       'version' => '1.2003'
                                                     },
                                                     {
                                                       'date' => '2010-12-22T17:57:55',
                                                       'version' => '1.3000_01'
                                                     },
                                                     {
                                                       'date' => '2011-01-03T15:17:14',
                                                       'version' => '1.3000_02'
                                                     },
                                                     {
                                                       'date' => '2011-01-27T10:00:22',
                                                       'version' => '1.2004'
                                                     },
                                                     {
                                                       'date' => '2011-01-27T10:09:31',
                                                       'version' => '1.3001'
                                                     },
                                                     {
                                                       'date' => '2011-02-02T15:42:28',
                                                       'version' => '1.3002'
                                                     },
                                                     {
                                                       'date' => '2011-02-05T17:07:15',
                                                       'version' => '1.2005'
                                                     },
                                                     {
                                                       'date' => '2011-02-06T13:12:28',
                                                       'version' => '1.3003'
                                                     },
                                                     {
                                                       'date' => '2011-02-10T20:48:48',
                                                       'version' => '1.3010'
                                                     },
                                                     {
                                                       'date' => '2011-02-12T12:50:18',
                                                       'version' => '1.3010_01'
                                                     },
                                                     {
                                                       'date' => '2011-02-14T15:58:10',
                                                       'version' => '1.3011'
                                                     },
                                                     {
                                                       'date' => '2011-03-01T19:00:52',
                                                       'version' => '1.3012'
                                                     },
                                                     {
                                                       'date' => '2011-03-03T08:41:00',
                                                       'version' => '1.3013'
                                                     },
                                                     {
                                                       'date' => '2011-03-04T12:56:36',
                                                       'version' => '1.3014'
                                                     },
                                                     {
                                                       'date' => '2011-03-10T14:16:24',
                                                       'version' => '1.3014_01'
                                                     },
                                                     {
                                                       'date' => '2011-03-13T13:17:43',
                                                       'version' => '1.3019_01'
                                                     },
                                                     {
                                                       'date' => '2011-03-14T07:44:57',
                                                       'version' => '1.3019_02'
                                                     },
                                                     {
                                                       'date' => '2011-03-21T13:44:17',
                                                       'version' => '1.3020'
                                                     },
                                                     {
                                                       'date' => '2011-04-01T15:22:58',
                                                       'version' => '1.3029_01'
                                                     },
                                                     {
                                                       'date' => '2011-04-08T20:07:26',
                                                       'version' => '1.3029_02'
                                                     },
                                                     {
                                                       'date' => '2011-04-10T08:18:44',
                                                       'version' => '1.3029_03'
                                                     },
                                                     {
                                                       'date' => '2011-04-13T08:26:50',
                                                       'version' => '1.3030'
                                                     },
                                                     {
                                                       'date' => '2011-04-27T14:58:57',
                                                       'version' => '1.3039_01'
                                                     },
                                                     {
                                                       'date' => '2011-05-01T14:55:49',
                                                       'version' => '1.3040'
                                                     },
                                                     {
                                                       'date' => '2011-05-14T15:03:00',
                                                       'version' => '1.3049_01'
                                                     },
                                                     {
                                                       'date' => '2011-05-20T10:57:10',
                                                       'version' => '1.3050'
                                                     },
                                                     {
                                                       'date' => '2011-05-27T12:57:27',
                                                       'version' => '1.3051'
                                                     },
                                                     {
                                                       'date' => '2011-05-27T13:07:51',
                                                       'version' => '1.3059_01'
                                                     },
                                                     {
                                                       'date' => '2011-05-29T14:06:24',
                                                       'version' => '1.3059_02'
                                                     },
                                                     {
                                                       'date' => '2011-06-11T14:02:50',
                                                       'version' => '1.3059_03'
                                                     },
                                                     {
                                                       'date' => '2011-06-12T17:31:55',
                                                       'version' => '1.3059_04'
                                                     },
                                                     {
                                                       'date' => '2011-06-15T10:35:07',
                                                       'version' => '1.3060'
                                                     },
                                                     {
                                                       'date' => '2011-07-07T13:19:45',
                                                       'version' => '1.3069_01'
                                                     },
                                                     {
                                                       'date' => '2011-07-10T16:14:53',
                                                       'version' => '1.3069_02'
                                                     },
                                                     {
                                                       'date' => '2011-07-14T13:47:19',
                                                       'version' => '1.3070'
                                                     },
                                                     {
                                                       'date' => '2011-07-26T16:21:51',
                                                       'version' => '1.3071'
                                                     },
                                                     {
                                                       'date' => '2011-08-17T15:27:53',
                                                       'version' => '1.3079_01'
                                                     },
                                                     {
                                                       'date' => '2011-08-23T09:55:46',
                                                       'version' => '1.3072'
                                                     },
                                                     {
                                                       'date' => '2011-08-28T14:13:40',
                                                       'version' => '1.3079_02'
                                                     },
                                                     {
                                                       'date' => '2011-09-10T15:10:29',
                                                       'version' => '1.3079_03'
                                                     },
                                                     {
                                                       'date' => '2011-10-02T16:07:02',
                                                       'version' => '1.3079_04'
                                                     },
                                                     {
                                                       'date' => '2011-10-18T14:43:22',
                                                       'version' => '1.3079_05'
                                                     },
                                                     {
                                                       'date' => '2011-10-25T21:16:42',
                                                       'version' => '1.3080'
                                                     },
                                                     {
                                                       'date' => '2011-11-27T06:51:43',
                                                       'version' => '1.3089_01'
                                                     },
                                                     {
                                                       'date' => '2011-12-13T14:41:24',
                                                       'version' => '1.3090'
                                                     },
                                                     {
                                                       'date' => '2011-12-17T11:09:48',
                                                       'version' => '1.3091'
                                                     },
                                                     {
                                                       'date' => '2012-01-27T14:38:05',
                                                       'version' => '1.3092'
                                                     },
                                                     {
                                                       'date' => '2012-02-29T14:34:55',
                                                       'version' => '1.3093'
                                                     },
                                                     {
                                                       'date' => '2012-03-31T09:57:40',
                                                       'version' => '1.3094'
                                                     },
                                                     {
                                                       'date' => '2012-04-01T19:22:56',
                                                       'version' => '1.3095'
                                                     },
                                                     {
                                                       'date' => '2012-06-22T20:18:54',
                                                       'version' => '1.3095_01'
                                                     },
                                                     {
                                                       'date' => '2012-07-03T07:27:28',
                                                       'version' => '1.3095_02'
                                                     },
                                                     {
                                                       'date' => '2012-07-05T23:09:20',
                                                       'version' => '1.3096'
                                                     },
                                                     {
                                                       'date' => '2012-07-08T18:36:14',
                                                       'version' => '1.3097'
                                                     },
                                                     {
                                                       'date' => '2012-07-28T14:40:15',
                                                       'version' => '1.3098'
                                                     },
                                                     {
                                                       'date' => '2012-08-11T13:54:49',
                                                       'version' => '1.3099'
                                                     },
                                                     {
                                                       'date' => '2012-08-25T19:42:47',
                                                       'version' => '1.3100'
                                                     },
                                                     {
                                                       'date' => '2012-10-06T13:24:53',
                                                       'version' => '1.3110'
                                                     },
                                                     {
                                                       'date' => '2012-12-24T13:17:58',
                                                       'version' => '1.9999_01'
                                                     },
                                                     {
                                                       'date' => '2012-12-24T13:48:35',
                                                       'version' => '1.9999_02'
                                                     },
                                                     {
                                                       'date' => '2013-01-22T21:38:11',
                                                       'version' => '2.0000_01'
                                                     },
                                                     {
                                                       'date' => '2013-02-22T15:33:14',
                                                       'version' => '2.000001'
                                                     },
                                                     {
                                                       'date' => '2013-02-24T22:51:59',
                                                       'version' => '1.3111'
                                                     },
                                                     {
                                                       'date' => '2013-03-30T16:33:05',
                                                       'version' => '1.3111_01'
                                                     },
                                                     {
                                                       'date' => '2013-04-01T22:31:08',
                                                       'version' => '1.3111_02'
                                                     },
                                                     {
                                                       'date' => '2013-04-11T01:04:37',
                                                       'version' => '1.3112'
                                                     },
                                                     {
                                                       'date' => '2013-05-09T00:36:16',
                                                       'version' => '1.3113'
                                                     },
                                                     {
                                                       'date' => '2013-06-02T16:49:58',
                                                       'version' => '1.3114'
                                                     },
                                                     {
                                                       'date' => '2013-06-09T23:54:16',
                                                       'version' => '1.3115'
                                                     },
                                                     {
                                                       'date' => '2013-07-04T01:35:27',
                                                       'version' => '1.3116'
                                                     },
                                                     {
                                                       'date' => '2013-07-31T22:40:52',
                                                       'version' => '1.3117'
                                                     },
                                                     {
                                                       'date' => '2013-09-01T16:45:13',
                                                       'version' => '1.3118'
                                                     },
                                                     {
                                                       'date' => '2013-10-26T19:42:59',
                                                       'version' => '1.3119'
                                                     },
                                                     {
                                                       'date' => '2013-12-24T16:23:20',
                                                       'version' => '1.3120'
                                                     },
                                                     {
                                                       'date' => '2014-02-02T22:26:53',
                                                       'version' => '1.3121'
                                                     },
                                                     {
                                                       'date' => '2014-04-10T23:16:40',
                                                       'version' => '1.3122'
                                                     },
                                                     {
                                                       'date' => '2014-04-12T15:47:53',
                                                       'version' => '1.3123'
                                                     },
                                                     {
                                                       'date' => '2014-05-10T16:15:17',
                                                       'version' => '1.3124'
                                                     },
                                                     {
                                                       'date' => '2014-07-12T17:19:08',
                                                       'version' => '1.3125'
                                                     },
                                                     {
                                                       'date' => '2014-07-15T02:01:21',
                                                       'version' => '1.3126'
                                                     },
                                                     {
                                                       'date' => '2014-09-09T00:49:19',
                                                       'version' => '1.3127'
                                                     },
                                                     {
                                                       'date' => '2014-09-09T11:47:21',
                                                       'version' => '1.3128'
                                                     },
                                                     {
                                                       'date' => '2014-09-10T00:50:37',
                                                       'version' => '1.3129'
                                                     },
                                                     {
                                                       'date' => '2014-09-16T01:21:25',
                                                       'version' => '1.3130'
                                                     },
                                                     {
                                                       'date' => '2014-10-11T18:59:22',
                                                       'version' => '1.3131_0'
                                                     },
                                                     {
                                                       'date' => '2014-10-13T23:25:36',
                                                       'version' => '1.3131_1'
                                                     },
                                                     {
                                                       'date' => '2014-10-20T23:14:23',
                                                       'version' => '1.3132'
                                                     },
                                                     {
                                                       'date' => '2014-11-26T22:20:35',
                                                       'version' => '1.3133'
                                                     },
                                                     {
                                                       'date' => '2015-02-23T01:33:08',
                                                       'version' => '1.3134'
                                                     },
                                                     {
                                                       'date' => '2015-04-23T01:54:25',
                                                       'version' => '1.3135'
                                                     },
                                                     {
                                                       'date' => '2015-05-24T15:48:19',
                                                       'version' => '1.3136'
                                                     },
                                                     {
                                                       'date' => '2015-06-05T20:05:21',
                                                       'version' => '1.3137'
                                                     },
                                                     {
                                                       'date' => '2015-06-12T20:55:50',
                                                       'version' => '1.3138'
                                                     },
                                                     {
                                                       'date' => '2015-06-25T20:13:45',
                                                       'version' => '1.3139'
                                                     },
                                                     {
                                                       'date' => '2015-07-03T13:56:32',
                                                       'version' => '1.3140'
                                                     },
                                                     {
                                                       'date' => '2015-09-07T15:15:26',
                                                       'version' => '1.3141'
                                                     },
                                                     {
                                                       'date' => '2015-09-15T00:52:23',
                                                       'version' => '1.3142'
                                                     },
                                                     {
                                                       'date' => '2015-10-26T21:15:31',
                                                       'version' => '1.3143'
                                                     },
                                                     {
                                                       'date' => '2015-11-04T12:36:07',
                                                       'version' => '1.3144'
                                                     },
                                                     {
                                                       'date' => '2015-11-06T22:12:42',
                                                       'version' => '1.3200'
                                                     },
                                                     {
                                                       'date' => '2015-11-07T19:27:25',
                                                       'version' => '1.3201'
                                                     },
                                                     {
                                                       'date' => '2015-11-07T21:52:17',
                                                       'version' => '1.3202'
                                                     },
                                                     {
                                                       'date' => '2016-02-15T21:33:45',
                                                       'version' => '1.3300'
                                                     },
                                                     {
                                                       'date' => '2016-02-16T22:42:44',
                                                       'version' => '1.3301'
                                                     },
                                                     {
                                                       'date' => '2018-05-20T19:52:07',
                                                       'version' => '1.3203'
                                                     },
                                                     {
                                                       'date' => '2018-05-23T13:43:34',
                                                       'version' => '1.3204'
                                                     },
                                                     {
                                                       'date' => '2018-06-13T22:02:36',
                                                       'version' => '1.3205'
                                                     },
                                                     {
                                                       'date' => '2018-06-15T22:11:45',
                                                       'version' => '1.3400'
                                                     },
                                                     {
                                                       'date' => '2018-10-01T11:53:31',
                                                       'version' => '1.3401'
                                                     },
                                                     {
                                                       'date' => '2018-10-10T10:44:29',
                                                       'version' => '1.3402'
                                                     },
                                                     {
                                                       'date' => '2018-10-11T22:45:37',
                                                       'version' => '1.3403'
                                                     },
                                                     {
                                                       'date' => '2018-10-12T20:33:54',
                                                       'version' => '1.3500'
                                                     }
                                                   ]
                                   },
                       'Dancer2' => {
                                      'advisories' => [
                                                        {
                                                          'affected_versions' => '<0.206000',
                                                          'description' => 'There is a potential RCE with regards to Storable. We have added session ID validation to the session engine so that session backends based on Storable can reject malformed session IDs that may lead to exploitation of the RCE.
',
                                                          'distribution' => 'Dancer2',
                                                          'fixed_versions' => '>=0.206000',
                                                          'id' => 'CPANSA-Dancer2-2018-01',
                                                          'references' => [
                                                                            'https://metacpan.org/changes/distribution/Dancer2',
                                                                            'http://lists.preshweb.co.uk/pipermail/dancer-users/2018-April/005952.html',
                                                                            'https://github.com/PerlDancer/Dancer2/commit/3580f5d0874a9abf5483528f73bda9a7fd9ec7f1'
                                                                          ],
                                                          'reported' => '2018-01-30',
                                                          'severity' => 'critical'
                                                        }
                                                      ],
                                      'main_module' => 'Dancer2',
                                      'versions' => [
                                                      {
                                                        'date' => '2013-02-22T15:39:46',
                                                        'version' => '0.01'
                                                      },
                                                      {
                                                        'date' => '2013-02-24T11:04:25',
                                                        'version' => '0.02'
                                                      },
                                                      {
                                                        'date' => '2013-03-07T17:30:37',
                                                        'version' => '0.03'
                                                      },
                                                      {
                                                        'date' => '2013-04-22T19:58:02',
                                                        'version' => '0.04'
                                                      },
                                                      {
                                                        'date' => '2013-07-20T16:53:37',
                                                        'version' => '0.05'
                                                      },
                                                      {
                                                        'date' => '2013-07-30T14:29:42',
                                                        'version' => '0.06'
                                                      },
                                                      {
                                                        'date' => '2013-08-03T22:17:54',
                                                        'version' => '0.07'
                                                      },
                                                      {
                                                        'date' => '2013-08-18T12:24:31',
                                                        'version' => '0.08'
                                                      },
                                                      {
                                                        'date' => '2013-09-01T21:19:26',
                                                        'version' => '0.09'
                                                      },
                                                      {
                                                        'date' => '2013-09-28T13:29:35',
                                                        'version' => '0.10'
                                                      },
                                                      {
                                                        'date' => '2013-12-15T13:21:28',
                                                        'version' => '0.11'
                                                      },
                                                      {
                                                        'date' => '2014-04-07T21:05:16',
                                                        'version' => '0.12'
                                                      },
                                                      {
                                                        'date' => '2014-04-13T17:20:22',
                                                        'version' => '0.13'
                                                      },
                                                      {
                                                        'date' => '2014-04-28T21:16:57',
                                                        'version' => '0.140000'
                                                      },
                                                      {
                                                        'date' => '2014-05-01T08:50:43',
                                                        'version' => '0.140001'
                                                      },
                                                      {
                                                        'date' => '2014-06-07T20:35:57',
                                                        'version' => '0.140900_01'
                                                      },
                                                      {
                                                        'date' => '2014-06-08T20:29:28',
                                                        'version' => '0.141000'
                                                      },
                                                      {
                                                        'date' => '2014-06-24T19:18:07',
                                                        'version' => '0.142000'
                                                      },
                                                      {
                                                        'date' => '2014-07-05T19:43:17',
                                                        'version' => '0.143000'
                                                      },
                                                      {
                                                        'date' => '2014-07-23T19:34:51',
                                                        'version' => '0.149000_01'
                                                      },
                                                      {
                                                        'date' => '2014-08-10T11:53:37',
                                                        'version' => '0.149000_02'
                                                      },
                                                      {
                                                        'date' => '2014-08-16T23:38:39',
                                                        'version' => '0.150000'
                                                      },
                                                      {
                                                        'date' => '2014-10-08T19:51:49',
                                                        'version' => '0.151000'
                                                      },
                                                      {
                                                        'date' => '2014-10-14T02:33:06',
                                                        'version' => '0.152000'
                                                      },
                                                      {
                                                        'date' => '2014-10-23T21:48:36',
                                                        'version' => '0.153000'
                                                      },
                                                      {
                                                        'date' => '2014-10-29T21:41:13',
                                                        'version' => '0.153001'
                                                      },
                                                      {
                                                        'date' => '2014-10-30T08:29:15',
                                                        'version' => '0.153002'
                                                      },
                                                      {
                                                        'date' => '2014-11-17T14:41:14',
                                                        'version' => '0.154000'
                                                      },
                                                      {
                                                        'date' => '2014-11-28T00:21:55',
                                                        'version' => '0.155000'
                                                      },
                                                      {
                                                        'date' => '2014-11-28T16:44:27',
                                                        'version' => '0.155001'
                                                      },
                                                      {
                                                        'date' => '2014-12-02T22:02:03',
                                                        'version' => '0.155002'
                                                      },
                                                      {
                                                        'date' => '2014-12-03T21:35:35',
                                                        'version' => '0.155003'
                                                      },
                                                      {
                                                        'date' => '2014-12-04T10:57:08',
                                                        'version' => '0.155004'
                                                      },
                                                      {
                                                        'date' => '2014-12-07T17:07:21',
                                                        'version' => '0.156000'
                                                      },
                                                      {
                                                        'date' => '2014-12-08T22:08:30',
                                                        'version' => '0.156001'
                                                      },
                                                      {
                                                        'date' => '2014-12-14T17:25:53',
                                                        'version' => '0.157000'
                                                      },
                                                      {
                                                        'date' => '2014-12-21T19:42:24',
                                                        'version' => '0.157001'
                                                      },
                                                      {
                                                        'date' => '2015-01-01T17:11:48',
                                                        'version' => '0.158000'
                                                      },
                                                      {
                                                        'date' => '2015-02-24T03:54:24',
                                                        'version' => '0.159000'
                                                      },
                                                      {
                                                        'date' => '2015-02-25T14:33:59',
                                                        'version' => '0.159001'
                                                      },
                                                      {
                                                        'date' => '2015-03-03T18:25:28',
                                                        'version' => '0.159002'
                                                      },
                                                      {
                                                        'date' => '2015-03-23T14:00:19',
                                                        'version' => '0.159003'
                                                      },
                                                      {
                                                        'date' => '2015-04-26T22:15:22',
                                                        'version' => '0.160000'
                                                      },
                                                      {
                                                        'date' => '2015-05-14T18:46:02',
                                                        'version' => '0.160001'
                                                      },
                                                      {
                                                        'date' => '2015-06-04T11:07:02',
                                                        'version' => '0.160002'
                                                      },
                                                      {
                                                        'date' => '2015-06-06T09:11:43',
                                                        'version' => '0.160003'
                                                      },
                                                      {
                                                        'date' => '2015-07-08T13:04:02',
                                                        'version' => '0.161000'
                                                      },
                                                      {
                                                        'date' => '2015-08-28T13:32:02',
                                                        'version' => '0.161000_01'
                                                      },
                                                      {
                                                        'date' => '2015-09-06T11:13:10',
                                                        'version' => '0.162000'
                                                      },
                                                      {
                                                        'date' => '2015-10-13T15:08:16',
                                                        'version' => '0.162000_01'
                                                      },
                                                      {
                                                        'date' => '2015-10-15T11:00:10',
                                                        'version' => '0.163000'
                                                      },
                                                      {
                                                        'date' => '2015-12-16T22:44:32',
                                                        'version' => '0.164000'
                                                      },
                                                      {
                                                        'date' => '2015-12-17T08:23:24',
                                                        'version' => '0.165000'
                                                      },
                                                      {
                                                        'date' => '2016-01-12T18:04:57',
                                                        'version' => '0.166000'
                                                      },
                                                      {
                                                        'date' => '2016-01-22T06:57:11',
                                                        'version' => '0.166001'
                                                      },
                                                      {
                                                        'date' => '2016-04-19T19:52:27',
                                                        'version' => '0.166001_01'
                                                      },
                                                      {
                                                        'date' => '2016-04-29T14:45:41',
                                                        'version' => '0.166001_02'
                                                      },
                                                      {
                                                        'date' => '2016-05-27T11:25:55',
                                                        'version' => '0.166001_03'
                                                      },
                                                      {
                                                        'date' => '2016-05-27T12:57:04',
                                                        'version' => '0.166001_04'
                                                      },
                                                      {
                                                        'date' => '2016-05-31T13:29:37',
                                                        'version' => '0.200000'
                                                      },
                                                      {
                                                        'date' => '2016-06-16T14:00:23',
                                                        'version' => '0.200001'
                                                      },
                                                      {
                                                        'date' => '2016-06-22T14:41:29',
                                                        'version' => '0.200002'
                                                      },
                                                      {
                                                        'date' => '2016-07-05T19:36:46',
                                                        'version' => '0.200003'
                                                      },
                                                      {
                                                        'date' => '2016-07-11T15:21:33',
                                                        'version' => '0.200003'
                                                      },
                                                      {
                                                        'date' => '2016-07-22T04:41:26',
                                                        'version' => '0.200004'
                                                      },
                                                      {
                                                        'date' => '2016-07-22T13:28:45',
                                                        'version' => '0.201000'
                                                      },
                                                      {
                                                        'date' => '2016-08-13T18:53:07',
                                                        'version' => '0.202000'
                                                      },
                                                      {
                                                        'date' => '2016-08-25T03:12:19',
                                                        'version' => '0.203000'
                                                      },
                                                      {
                                                        'date' => '2016-09-04T02:01:29',
                                                        'version' => '0.203001'
                                                      },
                                                      {
                                                        'date' => '2016-10-11T01:59:49',
                                                        'version' => '0.204000'
                                                      },
                                                      {
                                                        'date' => '2016-10-17T13:32:25',
                                                        'version' => '0.204001'
                                                      },
                                                      {
                                                        'date' => '2016-12-21T21:47:24',
                                                        'version' => '0.204002'
                                                      },
                                                      {
                                                        'date' => '2017-01-25T21:23:22',
                                                        'version' => '0.204003'
                                                      },
                                                      {
                                                        'date' => '2017-01-26T17:31:30',
                                                        'version' => '0.204004'
                                                      },
                                                      {
                                                        'date' => '2017-03-10T21:40:43',
                                                        'version' => '0.205000'
                                                      },
                                                      {
                                                        'date' => '2017-07-11T13:04:56',
                                                        'version' => '0.205001'
                                                      },
                                                      {
                                                        'date' => '2017-10-17T21:10:03',
                                                        'version' => '0.205002'
                                                      },
                                                      {
                                                        'date' => '2018-04-09T00:54:25',
                                                        'version' => '0.206000_01'
                                                      },
                                                      {
                                                        'date' => '2018-04-10T01:50:18',
                                                        'version' => '0.206000_02'
                                                      },
                                                      {
                                                        'date' => '2018-04-20T02:12:22',
                                                        'version' => '0.206000'
                                                      },
                                                      {
                                                        'date' => '2018-11-14T22:26:15',
                                                        'version' => '0.207000'
                                                      }
                                                    ]
                                    },
                       'Data-Dumper' => {
                                          'advisories' => [
                                                            {
                                                              'affected_versions' => '<2.154',
                                                              'cves' => [
                                                                          'CVE-2014-4330'
                                                                        ],
                                                              'description' => 'Infinite recursion.
',
                                                              'distribution' => 'Data-Dumper',
                                                              'fixed_versions' => '>=2.154',
                                                              'id' => 'CPANSA-Data-Dumper-2014-01',
                                                              'references' => [
                                                                                'https://metacpan.org/changes/distribution/Data-Dumper'
                                                                              ],
                                                              'reported' => '2014-09-30'
                                                            }
                                                          ],
                                          'main_module' => 'Data::Dumper',
                                          'versions' => [
                                                          {
                                                            'date' => '1995-11-19T22:29:08',
                                                            'version' => '1.21'
                                                          },
                                                          {
                                                            'date' => '1995-11-23T05:45:27',
                                                            'version' => '1.22'
                                                          },
                                                          {
                                                            'date' => '1995-12-04T03:12:16',
                                                            'version' => '1.23'
                                                          },
                                                          {
                                                            'date' => '1996-04-09T15:54:26',
                                                            'version' => '2.00'
                                                          },
                                                          {
                                                            'date' => '1996-04-10T04:25:17',
                                                            'version' => '2.01'
                                                          },
                                                          {
                                                            'date' => '1996-04-13T07:14:35',
                                                            'version' => '2.02'
                                                          },
                                                          {
                                                            'date' => '1996-08-26T14:36:59',
                                                            'version' => '2.03'
                                                          },
                                                          {
                                                            'date' => '1996-08-28T20:11:49',
                                                            'version' => '2.04'
                                                          },
                                                          {
                                                            'date' => '1996-12-02T13:42:49',
                                                            'version' => '2.05'
                                                          },
                                                          {
                                                            'date' => '1996-12-02T23:07:56',
                                                            'version' => '2.06'
                                                          },
                                                          {
                                                            'date' => '1996-12-07T17:28:27',
                                                            'version' => '2.07'
                                                          },
                                                          {
                                                            'date' => '1997-12-07T21:27:09',
                                                            'version' => '2.08'
                                                          },
                                                          {
                                                            'date' => '1998-01-15T20:36:46',
                                                            'version' => '2.081'
                                                          },
                                                          {
                                                            'date' => '1998-03-06T21:08:49',
                                                            'version' => '2.081'
                                                          },
                                                          {
                                                            'date' => '1998-07-17T05:23:08',
                                                            'version' => '2.09'
                                                          },
                                                          {
                                                            'date' => '1998-07-21T12:08:19',
                                                            'version' => '2.09'
                                                          },
                                                          {
                                                            'date' => '1998-10-31T12:10:30',
                                                            'version' => '2.10'
                                                          },
                                                          {
                                                            'date' => '1999-05-01T02:01:03',
                                                            'version' => '2.101'
                                                          },
                                                          {
                                                            'date' => '1999-06-02T01:30:55',
                                                            'version' => '2.101'
                                                          },
                                                          {
                                                            'date' => '2003-07-20T16:59:48',
                                                            'version' => '2.12_01'
                                                          },
                                                          {
                                                            'date' => '2003-07-31T19:12:44',
                                                            'version' => '2.12_02'
                                                          },
                                                          {
                                                            'date' => '2003-08-25T11:49:41',
                                                            'version' => '2.121'
                                                          },
                                                          {
                                                            'date' => '2009-06-06T14:45:36',
                                                            'version' => '2.121_20'
                                                          },
                                                          {
                                                            'date' => '2009-06-09T15:49:12',
                                                            'version' => '2.122'
                                                          },
                                                          {
                                                            'date' => '2009-06-11T08:07:01',
                                                            'version' => '2.123'
                                                          },
                                                          {
                                                            'date' => '2009-06-13T15:22:32',
                                                            'version' => '2.124'
                                                          },
                                                          {
                                                            'date' => '2009-08-08T10:33:01',
                                                            'version' => '2.125'
                                                          },
                                                          {
                                                            'date' => '2010-04-15T19:55:01',
                                                            'version' => '2.126'
                                                          },
                                                          {
                                                            'date' => '2010-09-06T14:28:10',
                                                            'version' => '2.126_01'
                                                          },
                                                          {
                                                            'date' => '2010-09-10T07:08:41',
                                                            'version' => '2.127'
                                                          },
                                                          {
                                                            'date' => '2010-09-10T07:11:52',
                                                            'version' => '2.128'
                                                          },
                                                          {
                                                            'date' => '2011-05-20T15:53:12',
                                                            'version' => '2.130_03'
                                                          },
                                                          {
                                                            'date' => '2011-05-27T14:19:03',
                                                            'version' => '2.131'
                                                          },
                                                          {
                                                            'date' => '2011-12-19T08:23:05',
                                                            'version' => '2.135_01'
                                                          },
                                                          {
                                                            'date' => '2011-12-29T17:09:49',
                                                            'version' => '2.135_02'
                                                          },
                                                          {
                                                            'date' => '2012-08-07T06:59:51',
                                                            'version' => '2.135_07'
                                                          },
                                                          {
                                                            'date' => '2012-10-04T07:35:07',
                                                            'version' => '2.136'
                                                          },
                                                          {
                                                            'date' => '2012-12-12T06:30:48',
                                                            'version' => '2.139'
                                                          },
                                                          {
                                                            'date' => '2013-02-26T06:57:29',
                                                            'version' => '2.143'
                                                          },
                                                          {
                                                            'date' => '2013-03-15T09:46:49',
                                                            'version' => '2.145'
                                                          },
                                                          {
                                                            'date' => '2014-03-07T09:28:44',
                                                            'version' => '2.151'
                                                          },
                                                          {
                                                            'date' => '2014-09-18T15:47:37',
                                                            'version' => '2.154'
                                                          },
                                                          {
                                                            'date' => '2016-07-03T19:17:57',
                                                            'version' => '2.160'
                                                          },
                                                          {
                                                            'date' => '2016-07-11T20:13:06',
                                                            'version' => '2.161'
                                                          },
                                                          {
                                                            'date' => '2017-07-31T15:31:28',
                                                            'version' => '2.167_01'
                                                          },
                                                          {
                                                            'date' => '2017-08-04T08:05:22',
                                                            'version' => '2.167_02'
                                                          },
                                                          {
                                                            'date' => '2018-09-19T14:41:58',
                                                            'version' => '2.172'
                                                          },
                                                          {
                                                            'date' => '2018-11-10T10:10:30',
                                                            'version' => '2.173'
                                                          }
                                                        ]
                                        },
                       'Dezi' => {
                                   'advisories' => [
                                                     {
                                                       'affected_versions' => '<0.002002',
                                                       'description' => 'Bypassing authentication on the /index URL app with non-idempotent requests to /search URL.
',
                                                       'distribution' => 'Dezi',
                                                       'fixed_versions' => '>=0.002002',
                                                       'id' => 'CPANSA-Dezi-2012-01',
                                                       'references' => [
                                                                         'https://metacpan.org/changes/distribution/Dezi',
                                                                         'https://github.com/karpet/Dezi/commit/f1ad292b4dd988d1a38202c804bb7a2a3bcca3c8'
                                                                       ],
                                                       'reported' => '2012-09-13'
                                                     }
                                                   ],
                                   'main_module' => 'Dezi',
                                   'versions' => [
                                                   {
                                                     'date' => '2011-06-22T04:53:57',
                                                     'version' => '0.001000'
                                                   },
                                                   {
                                                     'date' => '2011-08-03T02:42:22',
                                                     'version' => '0.001001'
                                                   },
                                                   {
                                                     'date' => '2011-09-30T03:35:08',
                                                     'version' => '0.001002'
                                                   },
                                                   {
                                                     'date' => '2011-10-23T02:12:02',
                                                     'version' => '0.001003'
                                                   },
                                                   {
                                                     'date' => '2012-03-17T02:40:15',
                                                     'version' => '0.001004'
                                                   },
                                                   {
                                                     'date' => '2012-07-11T03:20:40',
                                                     'version' => '0.001005'
                                                   },
                                                   {
                                                     'date' => '2012-08-18T02:43:23',
                                                     'version' => '0.001006'
                                                   },
                                                   {
                                                     'date' => '2012-08-22T03:58:33',
                                                     'version' => '0.001007'
                                                   },
                                                   {
                                                     'date' => '2012-09-04T02:05:34',
                                                     'version' => '0.001008'
                                                   },
                                                   {
                                                     'date' => '2012-09-12T03:51:13',
                                                     'version' => '0.002000'
                                                   },
                                                   {
                                                     'date' => '2012-09-13T01:50:59',
                                                     'version' => '0.002001'
                                                   },
                                                   {
                                                     'date' => '2012-09-13T14:10:02',
                                                     'version' => '0.002002'
                                                   },
                                                   {
                                                     'date' => '2012-10-16T00:57:46',
                                                     'version' => '0.002003'
                                                   },
                                                   {
                                                     'date' => '2012-10-18T03:15:21',
                                                     'version' => '0.002004'
                                                   },
                                                   {
                                                     'date' => '2012-12-19T05:25:13',
                                                     'version' => '0.002005'
                                                   },
                                                   {
                                                     'date' => '2013-02-03T02:49:07',
                                                     'version' => '0.002006'
                                                   },
                                                   {
                                                     'date' => '2013-02-05T15:02:54',
                                                     'version' => '0.002007'
                                                   },
                                                   {
                                                     'date' => '2013-02-09T05:37:41',
                                                     'version' => '0.002008'
                                                   },
                                                   {
                                                     'date' => '2013-02-13T02:30:33',
                                                     'version' => '0.002009'
                                                   },
                                                   {
                                                     'date' => '2013-02-13T04:31:49',
                                                     'version' => '0.002010'
                                                   },
                                                   {
                                                     'date' => '2013-11-13T17:08:03',
                                                     'version' => '0.002011'
                                                   },
                                                   {
                                                     'date' => '2014-02-27T18:08:30',
                                                     'version' => '0.002012'
                                                   },
                                                   {
                                                     'date' => '2014-06-05T06:59:12',
                                                     'version' => '0.002998_01'
                                                   },
                                                   {
                                                     'date' => '2014-06-08T04:59:17',
                                                     'version' => '0.003000'
                                                   },
                                                   {
                                                     'date' => '2014-07-30T20:40:24',
                                                     'version' => '0.004000'
                                                   },
                                                   {
                                                     'date' => '2014-09-02T02:45:00',
                                                     'version' => '0.004001'
                                                   },
                                                   {
                                                     'date' => '2015-04-30T22:01:11',
                                                     'version' => '0.004002'
                                                   },
                                                   {
                                                     'date' => '2018-05-16T02:24:24',
                                                     'version' => '0.004003'
                                                   }
                                                 ]
                                 },
                       'Email-Address' => {
                                            'advisories' => [
                                                              {
                                                                'affected_versions' => '<1.905',
                                                                'cves' => [
                                                                            'CVE-2014-0477'
                                                                          ],
                                                                'description' => 'Inefficient regular expression, which allows remote attackers to cause a denial of service (CPU consumption) via an empty quoted string in an RFC 2822 address.
',
                                                                'distribution' => 'Email-Address',
                                                                'fixed_versions' => '>=1.905',
                                                                'id' => 'CPANSA-Email-Address-2014-01',
                                                                'references' => [
                                                                                  'https://metacpan.org/changes/distribution/Email-Address'
                                                                                ],
                                                                'reported' => '2014-07-03'
                                                              }
                                                            ],
                                            'main_module' => 'Email::Address',
                                            'versions' => [
                                                            {
                                                              'date' => '2004-05-27T03:19:56',
                                                              'version' => '1.1'
                                                            },
                                                            {
                                                              'date' => '2004-06-02T16:35:30',
                                                              'version' => '1.2'
                                                            },
                                                            {
                                                              'date' => '2004-08-16T21:39:58',
                                                              'version' => '1.3'
                                                            },
                                                            {
                                                              'date' => '2004-10-05T18:10:42',
                                                              'version' => '1.5'
                                                            },
                                                            {
                                                              'date' => '2004-10-05T18:20:42',
                                                              'version' => '1.6'
                                                            },
                                                            {
                                                              'date' => '2004-10-13T10:21:17',
                                                              'version' => '1.7'
                                                            },
                                                            {
                                                              'date' => '2004-10-22T16:37:27',
                                                              'version' => '1.80'
                                                            },
                                                            {
                                                              'date' => '2006-07-11T15:04:28',
                                                              'version' => '1.85'
                                                            },
                                                            {
                                                              'date' => '2006-07-22T00:42:17',
                                                              'version' => '1.86'
                                                            },
                                                            {
                                                              'date' => '2006-08-10T16:48:44',
                                                              'version' => '1.870'
                                                            },
                                                            {
                                                              'date' => '2006-10-12T19:35:04',
                                                              'version' => '1.861'
                                                            },
                                                            {
                                                              'date' => '2006-10-12T22:16:28',
                                                              'version' => '1.871'
                                                            },
                                                            {
                                                              'date' => '2006-11-11T16:01:38',
                                                              'version' => '1.880'
                                                            },
                                                            {
                                                              'date' => '2006-11-19T21:19:02',
                                                              'version' => '1.881'
                                                            },
                                                            {
                                                              'date' => '2006-11-22T01:26:44',
                                                              'version' => '1.882'
                                                            },
                                                            {
                                                              'date' => '2006-11-25T13:53:46',
                                                              'version' => '1.883'
                                                            },
                                                            {
                                                              'date' => '2006-12-05T03:41:39',
                                                              'version' => '1.884'
                                                            },
                                                            {
                                                              'date' => '2007-03-01T01:08:16',
                                                              'version' => '1.885'
                                                            },
                                                            {
                                                              'date' => '2007-03-01T20:18:53',
                                                              'version' => '1.886'
                                                            },
                                                            {
                                                              'date' => '2007-04-01T19:15:49',
                                                              'version' => '1.887'
                                                            },
                                                            {
                                                              'date' => '2007-06-23T01:27:24',
                                                              'version' => '1.888'
                                                            },
                                                            {
                                                              'date' => '2007-12-19T22:14:37',
                                                              'version' => '1.889'
                                                            },
                                                            {
                                                              'date' => '2010-08-22T19:03:33',
                                                              'version' => '1.890'
                                                            },
                                                            {
                                                              'date' => '2010-08-31T00:56:53',
                                                              'version' => '1.891'
                                                            },
                                                            {
                                                              'date' => '2010-09-03T23:45:13',
                                                              'version' => '1.892'
                                                            },
                                                            {
                                                              'date' => '2012-01-03T03:55:12',
                                                              'version' => '1.893'
                                                            },
                                                            {
                                                              'date' => '2012-01-14T16:17:56',
                                                              'version' => '1.894'
                                                            },
                                                            {
                                                              'date' => '2012-01-15T18:41:33',
                                                              'version' => '1.895'
                                                            },
                                                            {
                                                              'date' => '2012-08-01T03:07:33',
                                                              'version' => '1.896'
                                                            },
                                                            {
                                                              'date' => '2012-12-17T15:16:33',
                                                              'version' => '1.897'
                                                            },
                                                            {
                                                              'date' => '2013-02-07T21:41:48',
                                                              'version' => '1.898'
                                                            },
                                                            {
                                                              'date' => '2013-08-02T14:54:13',
                                                              'version' => '1.899'
                                                            },
                                                            {
                                                              'date' => '2013-08-08T18:46:07',
                                                              'version' => '1.900'
                                                            },
                                                            {
                                                              'date' => '2014-01-29T03:43:28',
                                                              'version' => '1.901'
                                                            },
                                                            {
                                                              'date' => '2014-04-17T15:19:31',
                                                              'version' => '1.902'
                                                            },
                                                            {
                                                              'date' => '2014-04-18T01:07:10',
                                                              'version' => '1.903'
                                                            },
                                                            {
                                                              'date' => '2014-06-14T04:22:22',
                                                              'version' => '1.904'
                                                            },
                                                            {
                                                              'date' => '2014-06-18T02:55:59',
                                                              'version' => '1.905'
                                                            },
                                                            {
                                                              'date' => '2015-02-03T21:49:39',
                                                              'version' => '1.906'
                                                            },
                                                            {
                                                              'date' => '2015-02-03T22:48:46',
                                                              'version' => '1.907'
                                                            },
                                                            {
                                                              'date' => '2015-09-20T02:55:12',
                                                              'version' => '1.908'
                                                            },
                                                            {
                                                              'date' => '2018-03-05T03:26:56',
                                                              'version' => '1.909'
                                                            },
                                                            {
                                                              'date' => '2018-12-18T02:29:23',
                                                              'version' => '1.910'
                                                            },
                                                            {
                                                              'date' => '2018-12-22T16:31:37',
                                                              'version' => '1.911'
                                                            },
                                                            {
                                                              'date' => '2018-12-31T19:51:36',
                                                              'version' => '1.912'
                                                            }
                                                          ]
                                          },
                       'Encode' => {
                                     'advisories' => [
                                                       {
                                                         'affected_versions' => '<2.85',
                                                         'cves' => [
                                                                     'CVE-2016-1238'
                                                                   ],
                                                         'description' => 'Loading optional modules from . (current directory).
',
                                                         'distribution' => 'Encode',
                                                         'fixed_versions' => '>=2.85',
                                                         'id' => 'CPANSA-Encode-2016-01',
                                                         'references' => [
                                                                           'https://metacpan.org/changes/distribution/Encode',
                                                                           'https://github.com/dankogai/p5-encode/pull/58/commits/12be15d64ce089154c4367dc1842cd0dc0993ec6'
                                                                         ],
                                                         'reported' => '2016-07-27'
                                                       }
                                                     ],
                                     'main_module' => 'Encode',
                                     'versions' => [
                                                     {
                                                       'date' => '2002-03-20T08:30:40',
                                                       'version' => '0.93'
                                                     },
                                                     {
                                                       'date' => '2002-03-20T20:15:52',
                                                       'version' => '0.94'
                                                     },
                                                     {
                                                       'date' => '2002-03-21T16:07:21',
                                                       'version' => '0.95'
                                                     },
                                                     {
                                                       'date' => '2002-03-22T22:33:15',
                                                       'version' => '0.96'
                                                     },
                                                     {
                                                       'date' => '2002-03-23T20:36:05',
                                                       'version' => '0.97'
                                                     },
                                                     {
                                                       'date' => '2002-03-24T16:07:09',
                                                       'version' => '0.98'
                                                     },
                                                     {
                                                       'date' => '2002-03-25T19:45:16',
                                                       'version' => '0.99'
                                                     },
                                                     {
                                                       'date' => '2002-03-28T23:39:49',
                                                       'version' => '1.00'
                                                     },
                                                     {
                                                       'date' => '2002-03-29T21:43:17',
                                                       'version' => '1.01'
                                                     },
                                                     {
                                                       'date' => '2002-03-31T21:40:25',
                                                       'version' => '1.10'
                                                     },
                                                     {
                                                       'date' => '2002-03-31T22:27:07',
                                                       'version' => '1.11'
                                                     },
                                                     {
                                                       'date' => '2002-04-04T20:02:40',
                                                       'version' => '1.20'
                                                     },
                                                     {
                                                       'date' => '2002-04-07T15:36:48',
                                                       'version' => '1.26'
                                                     },
                                                     {
                                                       'date' => '2002-04-07T18:49:41',
                                                       'version' => '1.27'
                                                     },
                                                     {
                                                       'date' => '2002-04-07T19:05:34',
                                                       'version' => '1.28'
                                                     },
                                                     {
                                                       'date' => '2002-04-08T02:49:31',
                                                       'version' => '1.30'
                                                     },
                                                     {
                                                       'date' => '2002-04-08T18:51:14',
                                                       'version' => '1.31'
                                                     },
                                                     {
                                                       'date' => '2002-04-09T20:26:37',
                                                       'version' => '1.32'
                                                     },
                                                     {
                                                       'date' => '2002-04-10T22:44:19',
                                                       'version' => '1.33'
                                                     },
                                                     {
                                                       'date' => '2002-04-14T22:49:10',
                                                       'version' => '1.40'
                                                     },
                                                     {
                                                       'date' => '2002-04-16T23:47:16',
                                                       'version' => '1.41'
                                                     },
                                                     {
                                                       'date' => '2002-04-19T06:18:26',
                                                       'version' => '1.50'
                                                     },
                                                     {
                                                       'date' => '2002-04-20T10:08:39',
                                                       'version' => '1.51'
                                                     },
                                                     {
                                                       'date' => '2002-04-20T23:55:45',
                                                       'version' => '1.52'
                                                     },
                                                     {
                                                       'date' => '2002-04-22T09:56:04',
                                                       'version' => '1.56'
                                                     },
                                                     {
                                                       'date' => '2002-04-22T20:37:12',
                                                       'version' => '1.57'
                                                     },
                                                     {
                                                       'date' => '2002-04-23T00:22:06',
                                                       'version' => '1.58'
                                                     },
                                                     {
                                                       'date' => '2002-04-24T20:23:42',
                                                       'version' => '1.60'
                                                     },
                                                     {
                                                       'date' => '2002-04-26T03:19:40',
                                                       'version' => '1.61'
                                                     },
                                                     {
                                                       'date' => '2002-04-27T11:43:39',
                                                       'version' => '1.62'
                                                     },
                                                     {
                                                       'date' => '2002-04-27T19:52:51',
                                                       'version' => '1.63'
                                                     },
                                                     {
                                                       'date' => '2002-04-29T07:20:38',
                                                       'version' => '1.64'
                                                     },
                                                     {
                                                       'date' => '2002-04-30T16:40:07',
                                                       'version' => '1.65'
                                                     },
                                                     {
                                                       'date' => '2002-05-01T05:51:35',
                                                       'version' => '1.66'
                                                     },
                                                     {
                                                       'date' => '2002-05-02T07:43:35',
                                                       'version' => '1.67'
                                                     },
                                                     {
                                                       'date' => '2002-05-03T12:29:47',
                                                       'version' => '1.68'
                                                     },
                                                     {
                                                       'date' => '2002-05-04T16:50:40',
                                                       'version' => '1.69'
                                                     },
                                                     {
                                                       'date' => '2002-05-06T10:36:39',
                                                       'version' => '1.70'
                                                     },
                                                     {
                                                       'date' => '2002-05-07T16:30:42',
                                                       'version' => '1.71'
                                                     },
                                                     {
                                                       'date' => '2002-05-20T16:04:48',
                                                       'version' => '1.72'
                                                     },
                                                     {
                                                       'date' => '2002-05-28T18:41:36',
                                                       'version' => '1.74'
                                                     },
                                                     {
                                                       'date' => '2002-06-01T18:17:49',
                                                       'version' => '1.75'
                                                     },
                                                     {
                                                       'date' => '2002-08-25T15:18:49',
                                                       'version' => '1.76'
                                                     },
                                                     {
                                                       'date' => '2002-10-06T03:59:19',
                                                       'version' => '1.77'
                                                     },
                                                     {
                                                       'date' => '2002-10-20T15:55:16',
                                                       'version' => '1.78'
                                                     },
                                                     {
                                                       'date' => '2002-10-21T06:11:36',
                                                       'version' => '1.79'
                                                     },
                                                     {
                                                       'date' => '2002-10-21T20:42:56',
                                                       'version' => '1.80'
                                                     },
                                                     {
                                                       'date' => '2002-11-08T18:42:11',
                                                       'version' => '1.81'
                                                     },
                                                     {
                                                       'date' => '2002-11-14T23:17:11',
                                                       'version' => '1.82'
                                                     },
                                                     {
                                                       'date' => '2002-11-18T18:06:47',
                                                       'version' => '1.83'
                                                     },
                                                     {
                                                       'date' => '2003-01-10T12:09:05',
                                                       'version' => '1.84'
                                                     },
                                                     {
                                                       'date' => '2003-01-21T22:23:28',
                                                       'version' => '1.85'
                                                     },
                                                     {
                                                       'date' => '2003-01-22T03:36:42',
                                                       'version' => '1.86'
                                                     },
                                                     {
                                                       'date' => '2003-02-06T02:01:00',
                                                       'version' => '1.87'
                                                     },
                                                     {
                                                       'date' => '2003-02-20T14:46:12',
                                                       'version' => '1.88'
                                                     },
                                                     {
                                                       'date' => '2003-02-28T01:45:53',
                                                       'version' => '1.89'
                                                     },
                                                     {
                                                       'date' => '2003-03-09T17:54:26',
                                                       'version' => '1.90'
                                                     },
                                                     {
                                                       'date' => '2003-03-09T20:12:08',
                                                       'version' => '1.91'
                                                     },
                                                     {
                                                       'date' => '2003-03-31T03:51:31',
                                                       'version' => '1.92'
                                                     },
                                                     {
                                                       'date' => '2003-04-24T17:50:54',
                                                       'version' => '1.93'
                                                     },
                                                     {
                                                       'date' => '2003-05-10T18:31:48',
                                                       'version' => '1.94'
                                                     },
                                                     {
                                                       'date' => '2003-05-21T09:22:43',
                                                       'version' => '1.95'
                                                     },
                                                     {
                                                       'date' => '2003-06-18T09:41:21',
                                                       'version' => '1.96'
                                                     },
                                                     {
                                                       'date' => '2003-07-08T22:01:28',
                                                       'version' => '1.97'
                                                     },
                                                     {
                                                       'date' => '2003-08-25T11:47:32',
                                                       'version' => '1.98'
                                                     },
                                                     {
                                                       'date' => '2003-12-29T02:52:28',
                                                       'version' => '1.99'
                                                     },
                                                     {
                                                       'date' => '2004-05-16T21:05:06',
                                                       'version' => '2.00'
                                                     },
                                                     {
                                                       'date' => '2004-05-25T16:31:35',
                                                       'version' => '2.01'
                                                     },
                                                     {
                                                       'date' => '2004-08-31T11:01:51',
                                                       'version' => '2.02'
                                                     },
                                                     {
                                                       'date' => '2004-10-06T06:50:47',
                                                       'version' => '2.03'
                                                     },
                                                     {
                                                       'date' => '2004-10-16T21:26:58',
                                                       'version' => '2.04'
                                                     },
                                                     {
                                                       'date' => '2004-10-19T05:03:32',
                                                       'version' => '2.05'
                                                     },
                                                     {
                                                       'date' => '2004-10-22T06:29:14',
                                                       'version' => '2.06'
                                                     },
                                                     {
                                                       'date' => '2004-10-22T19:43:19',
                                                       'version' => '2.07'
                                                     },
                                                     {
                                                       'date' => '2004-10-24T13:04:29',
                                                       'version' => '2.08'
                                                     },
                                                     {
                                                       'date' => '2004-12-03T19:21:42',
                                                       'version' => '2.09'
                                                     },
                                                     {
                                                       'date' => '2005-05-16T18:54:53',
                                                       'version' => '2.10'
                                                     },
                                                     {
                                                       'date' => '2005-08-05T11:26:06',
                                                       'version' => '2.11'
                                                     },
                                                     {
                                                       'date' => '2005-09-08T14:23:38',
                                                       'version' => '2.12'
                                                     },
                                                     {
                                                       'date' => '2006-01-15T15:12:01',
                                                       'version' => '2.13'
                                                     },
                                                     {
                                                       'date' => '2006-01-15T15:57:41',
                                                       'version' => '2.14'
                                                     },
                                                     {
                                                       'date' => '2006-04-06T16:01:30',
                                                       'version' => '2.15'
                                                     },
                                                     {
                                                       'date' => '2006-05-03T18:38:44',
                                                       'version' => '2.16'
                                                     },
                                                     {
                                                       'date' => '2006-05-09T17:14:04',
                                                       'version' => '2.17'
                                                     },
                                                     {
                                                       'date' => '2006-06-03T20:34:08',
                                                       'version' => '2.18'
                                                     },
                                                     {
                                                       'date' => '2007-04-06T13:05:52',
                                                       'version' => '2.19'
                                                     },
                                                     {
                                                       'date' => '2007-04-22T15:17:34',
                                                       'version' => '2.20'
                                                     },
                                                     {
                                                       'date' => '2007-05-12T06:50:09',
                                                       'version' => '2.21'
                                                     },
                                                     {
                                                       'date' => '2007-05-29T07:43:07',
                                                       'version' => '2.22'
                                                     },
                                                     {
                                                       'date' => '2007-05-29T18:21:25',
                                                       'version' => '2.23'
                                                     },
                                                     {
                                                       'date' => '2008-03-12T10:12:18',
                                                       'version' => '2.24'
                                                     },
                                                     {
                                                       'date' => '2008-05-07T21:06:08',
                                                       'version' => '2.25'
                                                     },
                                                     {
                                                       'date' => '2008-07-01T21:03:33',
                                                       'version' => '2.26'
                                                     },
                                                     {
                                                       'date' => '2009-01-21T23:01:50',
                                                       'version' => '2.27'
                                                     },
                                                     {
                                                       'date' => '2009-02-01T13:16:44',
                                                       'version' => '2.29'
                                                     },
                                                     {
                                                       'date' => '2009-02-15T17:48:01',
                                                       'version' => '2.30'
                                                     },
                                                     {
                                                       'date' => '2009-02-16T06:25:32',
                                                       'version' => '2.31'
                                                     },
                                                     {
                                                       'date' => '2009-03-07T07:45:00',
                                                       'version' => '2.32'
                                                     },
                                                     {
                                                       'date' => '2009-03-25T08:01:10',
                                                       'version' => '2.33'
                                                     },
                                                     {
                                                       'date' => '2009-07-08T13:53:25',
                                                       'version' => '2.34'
                                                     },
                                                     {
                                                       'date' => '2009-07-13T02:32:45',
                                                       'version' => '2.35'
                                                     },
                                                     {
                                                       'date' => '2009-09-06T09:20:21',
                                                       'version' => '2.36'
                                                     },
                                                     {
                                                       'date' => '2009-09-06T14:37:23',
                                                       'version' => '2.37'
                                                     },
                                                     {
                                                       'date' => '2009-11-16T14:34:43',
                                                       'version' => '2.38'
                                                     },
                                                     {
                                                       'date' => '2009-11-26T09:31:02',
                                                       'version' => '2.39'
                                                     },
                                                     {
                                                       'date' => '2010-09-18T18:47:17',
                                                       'version' => '2.40'
                                                     },
                                                     {
                                                       'date' => '2010-12-23T11:12:33',
                                                       'version' => '2.41'
                                                     },
                                                     {
                                                       'date' => '2010-12-31T22:52:35',
                                                       'version' => '2.42'
                                                     },
                                                     {
                                                       'date' => '2011-05-21T23:21:24',
                                                       'version' => '2.43'
                                                     },
                                                     {
                                                       'date' => '2011-08-09T08:01:30',
                                                       'version' => '2.44'
                                                     },
                                                     {
                                                       'date' => '2012-08-05T23:15:11',
                                                       'version' => '2.45'
                                                     },
                                                     {
                                                       'date' => '2012-08-12T05:52:45',
                                                       'version' => '2.46'
                                                     },
                                                     {
                                                       'date' => '2012-08-15T05:40:21',
                                                       'version' => '2.47'
                                                     },
                                                     {
                                                       'date' => '2013-02-18T02:43:35',
                                                       'version' => '2.48'
                                                     },
                                                     {
                                                       'date' => '2013-03-05T03:19:15',
                                                       'version' => '2.49'
                                                     },
                                                     {
                                                       'date' => '2013-04-26T18:36:59',
                                                       'version' => '2.50'
                                                     },
                                                     {
                                                       'date' => '2013-04-29T22:21:31',
                                                       'version' => '2.51'
                                                     },
                                                     {
                                                       'date' => '2013-08-14T02:33:46',
                                                       'version' => '2.52'
                                                     },
                                                     {
                                                       'date' => '2013-08-29T15:27:02',
                                                       'version' => '2.53'
                                                     },
                                                     {
                                                       'date' => '2013-08-29T16:50:08',
                                                       'version' => '2.54'
                                                     },
                                                     {
                                                       'date' => '2013-09-14T07:58:54',
                                                       'version' => '2.55'
                                                     },
                                                     {
                                                       'date' => '2013-12-22T04:12:07',
                                                       'version' => '2.56'
                                                     },
                                                     {
                                                       'date' => '2014-01-03T04:55:36',
                                                       'version' => '2.57'
                                                     },
                                                     {
                                                       'date' => '2014-03-28T02:41:54',
                                                       'version' => '2.58'
                                                     },
                                                     {
                                                       'date' => '2014-04-06T17:41:19',
                                                       'version' => '2.59'
                                                     },
                                                     {
                                                       'date' => '2014-04-29T16:34:10',
                                                       'version' => '2.60'
                                                     },
                                                     {
                                                       'date' => '2014-05-31T09:55:56',
                                                       'version' => '2.61'
                                                     },
                                                     {
                                                       'date' => '2014-05-31T12:20:28',
                                                       'version' => '2.62'
                                                     },
                                                     {
                                                       'date' => '2014-10-19T07:13:44',
                                                       'version' => '2.63'
                                                     },
                                                     {
                                                       'date' => '2014-10-29T15:42:04',
                                                       'version' => '2.64'
                                                     },
                                                     {
                                                       'date' => '2014-11-27T14:12:57',
                                                       'version' => '2.65'
                                                     },
                                                     {
                                                       'date' => '2014-12-02T23:37:28',
                                                       'version' => '2.66'
                                                     },
                                                     {
                                                       'date' => '2014-12-04T20:28:33',
                                                       'version' => '2.67'
                                                     },
                                                     {
                                                       'date' => '2015-01-22T10:29:46',
                                                       'version' => '2.68'
                                                     },
                                                     {
                                                       'date' => '2015-02-05T10:43:34',
                                                       'version' => '2.69'
                                                     },
                                                     {
                                                       'date' => '2015-02-05T10:56:52',
                                                       'version' => '2.70'
                                                     },
                                                     {
                                                       'date' => '2015-03-12T00:14:19',
                                                       'version' => '2.71'
                                                     },
                                                     {
                                                       'date' => '2015-03-14T02:51:25',
                                                       'version' => '2.72'
                                                     },
                                                     {
                                                       'date' => '2015-04-15T23:27:13',
                                                       'version' => '2.73'
                                                     },
                                                     {
                                                       'date' => '2015-06-25T00:59:20',
                                                       'version' => '2.74'
                                                     },
                                                     {
                                                       'date' => '2015-06-30T10:10:03',
                                                       'version' => '2.75'
                                                     },
                                                     {
                                                       'date' => '2015-07-31T02:26:51',
                                                       'version' => '2.76'
                                                     },
                                                     {
                                                       'date' => '2015-09-15T14:03:35',
                                                       'version' => '2.77'
                                                     },
                                                     {
                                                       'date' => '2015-09-24T02:29:52',
                                                       'version' => '2.78'
                                                     },
                                                     {
                                                       'date' => '2016-01-22T07:08:25',
                                                       'version' => '2.79'
                                                     },
                                                     {
                                                       'date' => '2016-01-25T15:04:42',
                                                       'version' => '2.80'
                                                     },
                                                     {
                                                       'date' => '2016-02-06T19:34:58',
                                                       'version' => '2.81'
                                                     },
                                                     {
                                                       'date' => '2016-02-06T20:21:37',
                                                       'version' => '2.82'
                                                     },
                                                     {
                                                       'date' => '2016-03-24T08:00:30',
                                                       'version' => '2.83'
                                                     },
                                                     {
                                                       'date' => '2016-04-11T07:24:26',
                                                       'version' => '2.84'
                                                     },
                                                     {
                                                       'date' => '2016-08-04T03:37:23',
                                                       'version' => '2.85'
                                                     },
                                                     {
                                                       'date' => '2016-08-10T18:25:39',
                                                       'version' => '2.86'
                                                     },
                                                     {
                                                       'date' => '2016-10-28T05:15:33',
                                                       'version' => '2.87'
                                                     },
                                                     {
                                                       'date' => '2016-11-29T23:38:19',
                                                       'version' => '2.88'
                                                     },
                                                     {
                                                       'date' => '2017-04-21T05:24:59',
                                                       'version' => '2.89'
                                                     },
                                                     {
                                                       'date' => '2017-06-10T17:46:11',
                                                       'version' => '2.90'
                                                     },
                                                     {
                                                       'date' => '2017-06-22T08:18:22',
                                                       'version' => '2.91'
                                                     },
                                                     {
                                                       'date' => '2017-07-18T07:23:39',
                                                       'version' => '2.92'
                                                     },
                                                     {
                                                       'date' => '2017-10-06T22:33:35',
                                                       'version' => '2.93'
                                                     },
                                                     {
                                                       'date' => '2018-01-09T06:04:38',
                                                       'version' => '2.94'
                                                     },
                                                     {
                                                       'date' => '2018-02-08T00:41:02',
                                                       'version' => '2.95'
                                                     },
                                                     {
                                                       'date' => '2018-02-11T05:41:37',
                                                       'version' => '2.96'
                                                     },
                                                     {
                                                       'date' => '2018-02-21T12:30:05',
                                                       'version' => '2.97'
                                                     },
                                                     {
                                                       'date' => '2018-04-22T09:14:59',
                                                       'version' => '2.98'
                                                     },
                                                     {
                                                       'date' => '2019-01-21T03:28:35',
                                                       'version' => '2.99'
                                                     }
                                                   ]
                                   },
                       'ExtUtils-MakeMaker' => {
                                                 'advisories' => [
                                                                   {
                                                                     'affected_versions' => '<7.22',
                                                                     'cves' => [
                                                                                 'CVE-2016-1238'
                                                                               ],
                                                                     'description' => 'Loading modules from . (current directory).
',
                                                                     'distribution' => 'ExtUtils-MakeMaker',
                                                                     'fixed_versions' => '>=7.22',
                                                                     'id' => 'CPANSA-ExtUtils-MakeMaker-2016-01',
                                                                     'references' => [
                                                                                       'https://metacpan.org/changes/distribution/ExtUtils-MakeMaker',
                                                                                       'https://github.com/Perl-Toolchain-Gang/ExtUtils-MakeMaker/commit/3e9df17d11c40f2561c23ec79693c8c390e0ae88'
                                                                                     ],
                                                                     'reported' => '2016-08-07'
                                                                   }
                                                                 ],
                                                 'main_module' => 'ExtUtils::MakeMaker',
                                                 'versions' => [
                                                                 {
                                                                   'date' => '2001-07-06T08:23:56',
                                                                   'version' => '5.47_01'
                                                                 },
                                                                 {
                                                                   'date' => '2002-01-16T20:19:18',
                                                                   'version' => '5.48_01'
                                                                 },
                                                                 {
                                                                   'date' => '2002-01-18T04:56:33',
                                                                   'version' => '5.48_03'
                                                                 },
                                                                 {
                                                                   'date' => '2002-01-22T00:33:31',
                                                                   'version' => '5.48_04'
                                                                 },
                                                                 {
                                                                   'date' => '2002-02-04T08:46:04',
                                                                   'version' => '5.49_01'
                                                                 },
                                                                 {
                                                                   'date' => '2002-03-05T04:53:40',
                                                                   'version' => '5.50_01'
                                                                 },
                                                                 {
                                                                   'date' => '2002-03-25T07:53:14',
                                                                   'version' => '5.51_01'
                                                                 },
                                                                 {
                                                                   'date' => '2002-03-26T05:56:07',
                                                                   'version' => '5.52_01'
                                                                 },
                                                                 {
                                                                   'date' => '2002-03-31T03:55:52',
                                                                   'version' => '5.54_01'
                                                                 },
                                                                 {
                                                                   'date' => '2002-04-05T05:01:52',
                                                                   'version' => '5.55_01'
                                                                 },
                                                                 {
                                                                   'date' => '2002-04-06T08:29:20',
                                                                   'version' => '5.55_02'
                                                                 },
                                                                 {
                                                                   'date' => '2002-04-07T03:04:18',
                                                                   'version' => '5.55_03'
                                                                 },
                                                                 {
                                                                   'date' => '2002-04-11T05:32:04',
                                                                   'version' => '5.90_01'
                                                                 },
                                                                 {
                                                                   'date' => '2002-04-24T04:21:44',
                                                                   'version' => '5.91_01'
                                                                 },
                                                                 {
                                                                   'date' => '2002-04-30T03:43:53',
                                                                   'version' => '5.92_01'
                                                                 },
                                                                 {
                                                                   'date' => '2002-05-06T06:02:08',
                                                                   'version' => '5.93_01'
                                                                 },
                                                                 {
                                                                   'date' => '2002-05-17T19:04:41',
                                                                   'version' => '5.94_01'
                                                                 },
                                                                 {
                                                                   'date' => '2002-05-17T21:24:13',
                                                                   'version' => '5.94_02'
                                                                 },
                                                                 {
                                                                   'date' => '2002-05-18T18:43:02',
                                                                   'version' => '5.95_01'
                                                                 },
                                                                 {
                                                                   'date' => '2002-05-23T21:01:02',
                                                                   'version' => '5.96_01'
                                                                 },
                                                                 {
                                                                   'date' => '2002-05-26T01:25:25',
                                                                   'version' => '6.00'
                                                                 },
                                                                 {
                                                                   'date' => '2002-05-30T19:02:20',
                                                                   'version' => '6.01'
                                                                 },
                                                                 {
                                                                   'date' => '2002-06-16T05:41:28',
                                                                   'version' => '6.02'
                                                                 },
                                                                 {
                                                                   'date' => '2002-06-19T21:24:32',
                                                                   'version' => '6.03'
                                                                 },
                                                                 {
                                                                   'date' => '2002-08-27T01:42:36',
                                                                   'version' => '6.04'
                                                                 },
                                                                 {
                                                                   'date' => '2002-08-27T23:24:30',
                                                                   'version' => '6.05'
                                                                 },
                                                                 {
                                                                   'date' => '2002-12-19T08:42:01',
                                                                   'version' => '6.06_01'
                                                                 },
                                                                 {
                                                                   'date' => '2002-12-24T04:54:53',
                                                                   'version' => '6.06_02'
                                                                 },
                                                                 {
                                                                   'date' => '2003-03-30T03:49:59',
                                                                   'version' => '6.06_03'
                                                                 },
                                                                 {
                                                                   'date' => '2003-03-31T04:37:55',
                                                                   'version' => '6.06_04'
                                                                 },
                                                                 {
                                                                   'date' => '2003-03-31T10:50:00',
                                                                   'version' => '6.06_05'
                                                                 },
                                                                 {
                                                                   'date' => '2003-04-07T02:46:10',
                                                                   'version' => '6.10_01'
                                                                 },
                                                                 {
                                                                   'date' => '2003-04-07T08:33:23',
                                                                   'version' => '6.10_02'
                                                                 },
                                                                 {
                                                                   'date' => '2003-04-11T07:27:36',
                                                                   'version' => '6.10_03'
                                                                 },
                                                                 {
                                                                   'date' => '2003-05-23T09:05:27',
                                                                   'version' => '6.10_04'
                                                                 },
                                                                 {
                                                                   'date' => '2003-06-07T01:32:29',
                                                                   'version' => '6.10_05'
                                                                 },
                                                                 {
                                                                   'date' => '2003-06-07T08:00:14',
                                                                   'version' => '6.10_06'
                                                                 },
                                                                 {
                                                                   'date' => '2003-07-05T23:40:34',
                                                                   'version' => '6.10_07'
                                                                 },
                                                                 {
                                                                   'date' => '2003-07-22T01:23:46',
                                                                   'version' => '6.10_08'
                                                                 },
                                                                 {
                                                                   'date' => '2003-07-28T04:00:19',
                                                                   'version' => '6.11'
                                                                 },
                                                                 {
                                                                   'date' => '2003-07-30T05:28:47',
                                                                   'version' => '6.12'
                                                                 },
                                                                 {
                                                                   'date' => '2003-07-31T23:51:40',
                                                                   'version' => '6.13'
                                                                 },
                                                                 {
                                                                   'date' => '2003-08-03T23:27:51',
                                                                   'version' => '6.14'
                                                                 },
                                                                 {
                                                                   'date' => '2003-08-03T23:46:11',
                                                                   'version' => '6.15'
                                                                 },
                                                                 {
                                                                   'date' => '2003-08-18T08:43:08',
                                                                   'version' => '6.16'
                                                                 },
                                                                 {
                                                                   'date' => '2003-09-15T22:23:01',
                                                                   'version' => '6.17'
                                                                 },
                                                                 {
                                                                   'date' => '2003-11-04T04:12:53',
                                                                   'version' => '6.18'
                                                                 },
                                                                 {
                                                                   'date' => '2003-11-04T07:03:30',
                                                                   'version' => '6.19'
                                                                 },
                                                                 {
                                                                   'date' => '2003-11-06T10:37:47',
                                                                   'version' => '6.20'
                                                                 },
                                                                 {
                                                                   'date' => '2003-11-11T08:26:17',
                                                                   'version' => '6.21'
                                                                 },
                                                                 {
                                                                   'date' => '2004-04-03T21:33:45',
                                                                   'version' => '6.21_03'
                                                                 },
                                                                 {
                                                                   'date' => '2004-11-24T04:06:20',
                                                                   'version' => '6.22'
                                                                 },
                                                                 {
                                                                   'date' => '2004-11-26T21:15:45',
                                                                   'version' => '6.23'
                                                                 },
                                                                 {
                                                                   'date' => '2004-11-30T20:42:14',
                                                                   'version' => '6.24'
                                                                 },
                                                                 {
                                                                   'date' => '2004-12-09T06:00:53',
                                                                   'version' => '6.24_01'
                                                                 },
                                                                 {
                                                                   'date' => '2004-12-15T12:05:50',
                                                                   'version' => '6.25'
                                                                 },
                                                                 {
                                                                   'date' => '2004-12-18T02:34:56',
                                                                   'version' => '6.25_01'
                                                                 },
                                                                 {
                                                                   'date' => '2004-12-20T08:36:56',
                                                                   'version' => '6.25_02'
                                                                 },
                                                                 {
                                                                   'date' => '2004-12-21T04:17:27',
                                                                   'version' => '6.25_03'
                                                                 },
                                                                 {
                                                                   'date' => '2004-12-21T05:58:10',
                                                                   'version' => '6.25_04'
                                                                 },
                                                                 {
                                                                   'date' => '2004-12-22T13:05:53',
                                                                   'version' => '6.25_05'
                                                                 },
                                                                 {
                                                                   'date' => '2004-12-26T22:26:26',
                                                                   'version' => '6.25_06'
                                                                 },
                                                                 {
                                                                   'date' => '2004-12-31T08:53:31',
                                                                   'version' => '6.25_07'
                                                                 },
                                                                 {
                                                                   'date' => '2005-02-08T14:21:17',
                                                                   'version' => '6.25_08'
                                                                 },
                                                                 {
                                                                   'date' => '2005-03-12T18:29:26',
                                                                   'version' => '6.25_09'
                                                                 },
                                                                 {
                                                                   'date' => '2005-03-14T00:17:26',
                                                                   'version' => '6.25_10'
                                                                 },
                                                                 {
                                                                   'date' => '2005-03-15T10:05:07',
                                                                   'version' => '6.25_11'
                                                                 },
                                                                 {
                                                                   'date' => '2005-03-19T00:19:47',
                                                                   'version' => '6.25_12'
                                                                 },
                                                                 {
                                                                   'date' => '2005-03-22T22:50:34',
                                                                   'version' => '6.26'
                                                                 },
                                                                 {
                                                                   'date' => '2005-03-29T05:48:40',
                                                                   'version' => '6.26_01'
                                                                 },
                                                                 {
                                                                   'date' => '2005-04-04T23:55:46',
                                                                   'version' => '6.27'
                                                                 },
                                                                 {
                                                                   'date' => '2005-04-12T23:23:53',
                                                                   'version' => '6.28'
                                                                 },
                                                                 {
                                                                   'date' => '2005-05-19T21:22:00',
                                                                   'version' => '6.29'
                                                                 },
                                                                 {
                                                                   'date' => '2005-05-20T23:14:45',
                                                                   'version' => '6.30'
                                                                 },
                                                                 {
                                                                   'date' => '2005-08-17T06:59:11',
                                                                   'version' => '6.30_01'
                                                                 },
                                                                 {
                                                                   'date' => '2006-09-01T19:07:28',
                                                                   'version' => '6.30_02'
                                                                 },
                                                                 {
                                                                   'date' => '2006-09-01T21:06:57',
                                                                   'version' => '6.30_03'
                                                                 },
                                                                 {
                                                                   'date' => '2006-09-11T20:20:27',
                                                                   'version' => '6.30_04'
                                                                 },
                                                                 {
                                                                   'date' => '2006-10-10T01:04:44',
                                                                   'version' => '6.31'
                                                                 },
                                                                 {
                                                                   'date' => '2007-02-21T16:02:09',
                                                                   'version' => '6.32'
                                                                 },
                                                                 {
                                                                   'date' => '2007-06-29T22:18:15',
                                                                   'version' => '6.33'
                                                                 },
                                                                 {
                                                                   'date' => '2007-06-30T16:10:15',
                                                                   'version' => '6.34'
                                                                 },
                                                                 {
                                                                   'date' => '2007-07-02T03:56:25',
                                                                   'version' => '6.35'
                                                                 },
                                                                 {
                                                                   'date' => '2007-07-03T08:10:57',
                                                                   'version' => '6.36'
                                                                 },
                                                                 {
                                                                   'date' => '2007-11-26T01:10:14',
                                                                   'version' => '6.37_01'
                                                                 },
                                                                 {
                                                                   'date' => '2007-11-26T07:35:50',
                                                                   'version' => '6.37_02'
                                                                 },
                                                                 {
                                                                   'date' => '2007-11-26T22:18:55',
                                                                   'version' => '6.37_03'
                                                                 },
                                                                 {
                                                                   'date' => '2007-11-29T00:04:35',
                                                                   'version' => '6.38'
                                                                 },
                                                                 {
                                                                   'date' => '2007-12-06T11:08:15',
                                                                   'version' => '6.40'
                                                                 },
                                                                 {
                                                                   'date' => '2007-12-08T01:02:26',
                                                                   'version' => '6.42'
                                                                 },
                                                                 {
                                                                   'date' => '2008-01-02T00:09:23',
                                                                   'version' => '6.43_01'
                                                                 },
                                                                 {
                                                                   'date' => '2008-02-29T00:08:42',
                                                                   'version' => '6.44'
                                                                 },
                                                                 {
                                                                   'date' => '2008-09-06T10:22:44',
                                                                   'version' => '6.45_01'
                                                                 },
                                                                 {
                                                                   'date' => '2008-09-07T21:18:05',
                                                                   'version' => '6.45_02'
                                                                 },
                                                                 {
                                                                   'date' => '2008-09-27T21:37:54',
                                                                   'version' => '6.46'
                                                                 },
                                                                 {
                                                                   'date' => '2008-10-14T16:41:49',
                                                                   'version' => '6.47_01'
                                                                 },
                                                                 {
                                                                   'date' => '2008-10-16T23:18:52',
                                                                   'version' => '6.47_02'
                                                                 },
                                                                 {
                                                                   'date' => '2008-10-20T18:20:40',
                                                                   'version' => '6.48'
                                                                 },
                                                                 {
                                                                   'date' => '2009-02-20T01:11:08',
                                                                   'version' => '6.49_01'
                                                                 },
                                                                 {
                                                                   'date' => '2009-03-22T19:30:00',
                                                                   'version' => '6.50'
                                                                 },
                                                                 {
                                                                   'date' => '2009-04-10T21:33:29',
                                                                   'version' => '6.51_01'
                                                                 },
                                                                 {
                                                                   'date' => '2009-04-14T04:22:58',
                                                                   'version' => '6.51_02'
                                                                 },
                                                                 {
                                                                   'date' => '2009-05-24T05:41:35',
                                                                   'version' => '6.51_03'
                                                                 },
                                                                 {
                                                                   'date' => '2009-05-24T21:07:28',
                                                                   'version' => '6.51_04'
                                                                 },
                                                                 {
                                                                   'date' => '2009-05-30T18:41:35',
                                                                   'version' => '6.52'
                                                                 },
                                                                 {
                                                                   'date' => '2009-06-08T02:05:24',
                                                                   'version' => '6.53_01'
                                                                 },
                                                                 {
                                                                   'date' => '2009-06-08T02:28:24',
                                                                   'version' => '6.53_02'
                                                                 },
                                                                 {
                                                                   'date' => '2009-07-02T21:55:25',
                                                                   'version' => '6.53_03'
                                                                 },
                                                                 {
                                                                   'date' => '2009-07-07T23:53:09',
                                                                   'version' => '6.54'
                                                                 },
                                                                 {
                                                                   'date' => '2009-07-14T23:02:39',
                                                                   'version' => '6.55_01'
                                                                 },
                                                                 {
                                                                   'date' => '2009-08-05T07:40:59',
                                                                   'version' => '6.55_02'
                                                                 },
                                                                 {
                                                                   'date' => '2009-12-05T07:09:23',
                                                                   'version' => '6.55_03'
                                                                 },
                                                                 {
                                                                   'date' => '2009-12-17T22:06:47',
                                                                   'version' => '6.56'
                                                                 },
                                                                 {
                                                                   'date' => '2010-08-24T08:38:36',
                                                                   'version' => '6.57_01'
                                                                 },
                                                                 {
                                                                   'date' => '2010-09-07T23:43:49',
                                                                   'version' => '6.57_02'
                                                                 },
                                                                 {
                                                                   'date' => '2010-09-08T22:33:36',
                                                                   'version' => '6.57_03'
                                                                 },
                                                                 {
                                                                   'date' => '2010-09-09T23:52:37',
                                                                   'version' => '6.57_04'
                                                                 },
                                                                 {
                                                                   'date' => '2010-09-11T20:25:23',
                                                                   'version' => '6.57_05'
                                                                 },
                                                                 {
                                                                   'date' => '2010-10-06T10:53:43',
                                                                   'version' => '6.57_06'
                                                                 },
                                                                 {
                                                                   'date' => '2011-03-25T03:41:39',
                                                                   'version' => '6.57_07'
                                                                 },
                                                                 {
                                                                   'date' => '2011-03-27T11:00:41',
                                                                   'version' => '6.57_08'
                                                                 },
                                                                 {
                                                                   'date' => '2011-03-28T00:15:59',
                                                                   'version' => '6.57_09'
                                                                 },
                                                                 {
                                                                   'date' => '2011-04-04T05:33:46',
                                                                   'version' => '6.57_10'
                                                                 },
                                                                 {
                                                                   'date' => '2011-05-20T00:34:23',
                                                                   'version' => '6.57_11'
                                                                 },
                                                                 {
                                                                   'date' => '2011-07-06T21:22:27',
                                                                   'version' => '6.58'
                                                                 },
                                                                 {
                                                                   'date' => '2011-08-03T20:25:34',
                                                                   'version' => '6.58_01'
                                                                 },
                                                                 {
                                                                   'date' => '2011-08-05T13:07:58',
                                                                   'version' => '6.59'
                                                                 },
                                                                 {
                                                                   'date' => '2011-09-25T05:23:43',
                                                                   'version' => '6.61_01'
                                                                 },
                                                                 {
                                                                   'date' => '2011-10-23T23:48:06',
                                                                   'version' => '6.62'
                                                                 },
                                                                 {
                                                                   'date' => '2011-10-24T00:40:49',
                                                                   'version' => '6.63_01'
                                                                 },
                                                                 {
                                                                   'date' => '2011-11-02T00:07:43',
                                                                   'version' => '6.63_02'
                                                                 },
                                                                 {
                                                                   'date' => '2012-11-02T03:58:40',
                                                                   'version' => '6.63_03'
                                                                 },
                                                                 {
                                                                   'date' => '2012-11-22T21:25:35',
                                                                   'version' => '6.63_04'
                                                                 },
                                                                 {
                                                                   'date' => '2012-12-17T02:35:20',
                                                                   'version' => '6.64'
                                                                 },
                                                                 {
                                                                   'date' => '2013-03-18T23:21:28',
                                                                   'version' => '6.65_01'
                                                                 },
                                                                 {
                                                                   'date' => '2013-04-14T09:59:15',
                                                                   'version' => '6.65_02'
                                                                 },
                                                                 {
                                                                   'date' => '2013-04-15T12:50:31',
                                                                   'version' => '6.65_03'
                                                                 },
                                                                 {
                                                                   'date' => '2013-04-19T17:52:08',
                                                                   'version' => '6.66'
                                                                 },
                                                                 {
                                                                   'date' => '2013-04-25T20:08:31',
                                                                   'version' => '6.67_01'
                                                                 },
                                                                 {
                                                                   'date' => '2013-06-02T17:31:16',
                                                                   'version' => '6.67_02'
                                                                 },
                                                                 {
                                                                   'date' => '2013-06-05T21:09:00',
                                                                   'version' => '6.67_03'
                                                                 },
                                                                 {
                                                                   'date' => '2013-06-10T19:25:22',
                                                                   'version' => '6.67_04'
                                                                 },
                                                                 {
                                                                   'date' => '2013-06-13T20:55:25',
                                                                   'version' => '6.67_05'
                                                                 },
                                                                 {
                                                                   'date' => '2013-06-14T22:35:24',
                                                                   'version' => '6.68'
                                                                 },
                                                                 {
                                                                   'date' => '2013-06-20T12:00:00',
                                                                   'version' => '6.69_01'
                                                                 },
                                                                 {
                                                                   'date' => '2013-07-02T12:16:23',
                                                                   'version' => '6.69_02'
                                                                 },
                                                                 {
                                                                   'date' => '2013-07-09T21:47:07',
                                                                   'version' => '6.69_03'
                                                                 },
                                                                 {
                                                                   'date' => '2013-07-10T10:50:08',
                                                                   'version' => '6.69_04'
                                                                 },
                                                                 {
                                                                   'date' => '2013-07-11T21:20:53',
                                                                   'version' => '6.69_05'
                                                                 },
                                                                 {
                                                                   'date' => '2013-07-12T13:51:50',
                                                                   'version' => '6.69_06'
                                                                 },
                                                                 {
                                                                   'date' => '2013-07-16T14:34:32',
                                                                   'version' => '6.69_07'
                                                                 },
                                                                 {
                                                                   'date' => '2013-07-16T23:40:44',
                                                                   'version' => '6.69_08'
                                                                 },
                                                                 {
                                                                   'date' => '2013-07-21T08:26:44',
                                                                   'version' => '6.69_09'
                                                                 },
                                                                 {
                                                                   'date' => '2013-07-23T21:42:47',
                                                                   'version' => '6.70'
                                                                 },
                                                                 {
                                                                   'date' => '2013-07-24T08:33:58',
                                                                   'version' => '6.71_01'
                                                                 },
                                                                 {
                                                                   'date' => '2013-07-24T17:42:20',
                                                                   'version' => '6.72'
                                                                 },
                                                                 {
                                                                   'date' => '2013-07-24T22:53:41',
                                                                   'version' => '6.73_01'
                                                                 },
                                                                 {
                                                                   'date' => '2013-07-26T12:34:19',
                                                                   'version' => '6.73_02'
                                                                 },
                                                                 {
                                                                   'date' => '2013-07-30T21:12:02',
                                                                   'version' => '6.73_03'
                                                                 },
                                                                 {
                                                                   'date' => '2013-08-01T21:41:12',
                                                                   'version' => '6.73_04'
                                                                 },
                                                                 {
                                                                   'date' => '2013-08-05T16:45:38',
                                                                   'version' => '6.73_05'
                                                                 },
                                                                 {
                                                                   'date' => '2013-08-05T23:52:18',
                                                                   'version' => '6.73_06'
                                                                 },
                                                                 {
                                                                   'date' => '2013-08-07T15:09:12',
                                                                   'version' => '6.73_07'
                                                                 },
                                                                 {
                                                                   'date' => '2013-08-09T18:52:24',
                                                                   'version' => '6.73_08'
                                                                 },
                                                                 {
                                                                   'date' => '2013-08-09T19:00:18',
                                                                   'version' => '6.73_09'
                                                                 },
                                                                 {
                                                                   'date' => '2013-08-16T15:43:35',
                                                                   'version' => '6.73_10'
                                                                 },
                                                                 {
                                                                   'date' => '2013-08-17T21:57:55',
                                                                   'version' => '6.73_11'
                                                                 },
                                                                 {
                                                                   'date' => '2013-08-23T09:52:43',
                                                                   'version' => '6.73_12'
                                                                 },
                                                                 {
                                                                   'date' => '2013-08-27T11:45:55',
                                                                   'version' => '6.74'
                                                                 },
                                                                 {
                                                                   'date' => '2013-08-29T14:09:22',
                                                                   'version' => '6.75_01'
                                                                 },
                                                                 {
                                                                   'date' => '2013-09-01T20:52:29',
                                                                   'version' => '6.75_02'
                                                                 },
                                                                 {
                                                                   'date' => '2013-09-02T23:26:56',
                                                                   'version' => '6.75_03'
                                                                 },
                                                                 {
                                                                   'date' => '2013-09-05T11:10:20',
                                                                   'version' => '6.75_04'
                                                                 },
                                                                 {
                                                                   'date' => '2013-09-06T12:40:59',
                                                                   'version' => '6.76'
                                                                 },
                                                                 {
                                                                   'date' => '2013-09-10T14:22:45',
                                                                   'version' => '6.77_01'
                                                                 },
                                                                 {
                                                                   'date' => '2013-09-12T20:23:49',
                                                                   'version' => '6.77_02'
                                                                 },
                                                                 {
                                                                   'date' => '2013-09-16T11:23:59',
                                                                   'version' => '6.77_03'
                                                                 },
                                                                 {
                                                                   'date' => '2013-09-18T18:25:33',
                                                                   'version' => '6.77_04'
                                                                 },
                                                                 {
                                                                   'date' => '2013-09-19T13:12:32',
                                                                   'version' => '6.77_05'
                                                                 },
                                                                 {
                                                                   'date' => '2013-09-19T14:43:24',
                                                                   'version' => '6.77_06'
                                                                 },
                                                                 {
                                                                   'date' => '2013-09-21T08:48:44',
                                                                   'version' => '6.77_07'
                                                                 },
                                                                 {
                                                                   'date' => '2013-09-22T17:46:50',
                                                                   'version' => '6.77_08'
                                                                 },
                                                                 {
                                                                   'date' => '2013-09-23T12:47:39',
                                                                   'version' => '6.78'
                                                                 },
                                                                 {
                                                                   'date' => '2013-10-01T14:01:33',
                                                                   'version' => '6.79_01'
                                                                 },
                                                                 {
                                                                   'date' => '2013-10-11T12:01:23',
                                                                   'version' => '6.79_02'
                                                                 },
                                                                 {
                                                                   'date' => '2013-10-11T13:00:29',
                                                                   'version' => '6.79_03'
                                                                 },
                                                                 {
                                                                   'date' => '2013-10-11T17:59:30',
                                                                   'version' => '6.79_04'
                                                                 },
                                                                 {
                                                                   'date' => '2013-10-15T15:08:06',
                                                                   'version' => '6.80'
                                                                 },
                                                                 {
                                                                   'date' => '2013-10-16T08:04:29',
                                                                   'version' => '6.81_01'
                                                                 },
                                                                 {
                                                                   'date' => '2013-10-17T11:24:19',
                                                                   'version' => '6.81_02'
                                                                 },
                                                                 {
                                                                   'date' => '2013-10-24T19:54:34',
                                                                   'version' => '6.81_03'
                                                                 },
                                                                 {
                                                                   'date' => '2013-11-01T19:56:13',
                                                                   'version' => '6.81_04'
                                                                 },
                                                                 {
                                                                   'date' => '2013-11-02T21:44:06',
                                                                   'version' => '6.81_05'
                                                                 },
                                                                 {
                                                                   'date' => '2013-11-04T19:24:38',
                                                                   'version' => '6.82'
                                                                 },
                                                                 {
                                                                   'date' => '2013-11-05T11:45:54',
                                                                   'version' => '6.83_01'
                                                                 },
                                                                 {
                                                                   'date' => '2013-11-12T11:15:21',
                                                                   'version' => '6.83_02'
                                                                 },
                                                                 {
                                                                   'date' => '2013-11-15T09:49:39',
                                                                   'version' => '6.83_03'
                                                                 },
                                                                 {
                                                                   'date' => '2013-11-17T11:44:01',
                                                                   'version' => '6.83_04'
                                                                 },
                                                                 {
                                                                   'date' => '2013-11-25T22:52:46',
                                                                   'version' => '6.83_05'
                                                                 },
                                                                 {
                                                                   'date' => '2013-11-29T21:55:40',
                                                                   'version' => '6.83_06'
                                                                 },
                                                                 {
                                                                   'date' => '2013-11-30T15:27:01',
                                                                   'version' => '6.84'
                                                                 },
                                                                 {
                                                                   'date' => '2013-12-16T13:18:35',
                                                                   'version' => '6.85_01'
                                                                 },
                                                                 {
                                                                   'date' => '2013-12-17T10:17:50',
                                                                   'version' => '6.85_02'
                                                                 },
                                                                 {
                                                                   'date' => '2013-12-23T14:59:36',
                                                                   'version' => '6.85_03'
                                                                 },
                                                                 {
                                                                   'date' => '2013-12-23T15:02:38',
                                                                   'version' => '6.85_04'
                                                                 },
                                                                 {
                                                                   'date' => '2013-12-29T11:28:14',
                                                                   'version' => '6.85_05'
                                                                 },
                                                                 {
                                                                   'date' => '2013-12-30T23:18:09',
                                                                   'version' => '6.85_06'
                                                                 },
                                                                 {
                                                                   'date' => '2014-01-01T19:00:36',
                                                                   'version' => '6.85_07'
                                                                 },
                                                                 {
                                                                   'date' => '2014-01-04T12:21:05',
                                                                   'version' => '6.86'
                                                                 },
                                                                 {
                                                                   'date' => '2014-01-12T10:34:38',
                                                                   'version' => '6.87_01'
                                                                 },
                                                                 {
                                                                   'date' => '2014-01-18T13:30:15',
                                                                   'version' => '6.87_02'
                                                                 },
                                                                 {
                                                                   'date' => '2014-01-19T17:53:19',
                                                                   'version' => '6.87_03'
                                                                 },
                                                                 {
                                                                   'date' => '2014-01-26T19:33:34',
                                                                   'version' => '6.87_04'
                                                                 },
                                                                 {
                                                                   'date' => '2014-01-28T14:00:44',
                                                                   'version' => '6.87_05'
                                                                 },
                                                                 {
                                                                   'date' => '2014-01-31T20:59:13',
                                                                   'version' => '6.88'
                                                                 },
                                                                 {
                                                                   'date' => '2014-02-17T16:23:55',
                                                                   'version' => '6.89_01'
                                                                 },
                                                                 {
                                                                   'date' => '2014-02-20T20:49:24',
                                                                   'version' => '6.90'
                                                                 },
                                                                 {
                                                                   'date' => '2014-03-06T13:52:24',
                                                                   'version' => '6.91_01'
                                                                 },
                                                                 {
                                                                   'date' => '2014-03-13T16:34:37',
                                                                   'version' => '6.92'
                                                                 },
                                                                 {
                                                                   'date' => '2014-03-24T16:57:01',
                                                                   'version' => '6.93_01'
                                                                 },
                                                                 {
                                                                   'date' => '2014-03-25T20:38:21',
                                                                   'version' => '6.94'
                                                                 },
                                                                 {
                                                                   'date' => '2014-04-02T20:52:53',
                                                                   'version' => '6.95_01'
                                                                 },
                                                                 {
                                                                   'date' => '2014-04-07T14:29:26',
                                                                   'version' => '6.95_02'
                                                                 },
                                                                 {
                                                                   'date' => '2014-04-11T21:09:21',
                                                                   'version' => '6.96'
                                                                 },
                                                                 {
                                                                   'date' => '2014-04-24T13:29:12',
                                                                   'version' => '6.97_01'
                                                                 },
                                                                 {
                                                                   'date' => '2014-04-28T10:55:44',
                                                                   'version' => '6.97_02'
                                                                 },
                                                                 {
                                                                   'date' => '2014-04-29T20:41:00',
                                                                   'version' => '6.98'
                                                                 },
                                                                 {
                                                                   'date' => '2014-06-03T21:19:42',
                                                                   'version' => '6.99_01'
                                                                 },
                                                                 {
                                                                   'date' => '2014-06-05T11:18:25',
                                                                   'version' => '6.99_02'
                                                                 },
                                                                 {
                                                                   'date' => '2014-07-04T10:15:23',
                                                                   'version' => '6.99_03'
                                                                 },
                                                                 {
                                                                   'date' => '2014-07-12T11:54:35',
                                                                   'version' => '6.99_04'
                                                                 },
                                                                 {
                                                                   'date' => '2014-07-22T11:42:12',
                                                                   'version' => '6.99_05'
                                                                 },
                                                                 {
                                                                   'date' => '2014-07-28T14:07:14',
                                                                   'version' => '6.99_06'
                                                                 },
                                                                 {
                                                                   'date' => '2014-07-30T16:44:02',
                                                                   'version' => '6.99_07'
                                                                 },
                                                                 {
                                                                   'date' => '2014-08-18T13:19:18',
                                                                   'version' => '6.99_08'
                                                                 },
                                                                 {
                                                                   'date' => '2014-08-28T10:13:30',
                                                                   'version' => '6.99_09'
                                                                 },
                                                                 {
                                                                   'date' => '2014-09-04T14:04:55',
                                                                   'version' => '6.99_10'
                                                                 },
                                                                 {
                                                                   'date' => '2014-09-08T13:39:46',
                                                                   'version' => '6.99_11'
                                                                 },
                                                                 {
                                                                   'date' => '2014-09-11T14:32:19',
                                                                   'version' => '6.99_12'
                                                                 },
                                                                 {
                                                                   'date' => '2014-09-15T19:11:34',
                                                                   'version' => '6.99_13'
                                                                 },
                                                                 {
                                                                   'date' => '2014-09-19T14:06:14',
                                                                   'version' => '6.99_14'
                                                                 },
                                                                 {
                                                                   'date' => '2014-09-21T12:23:58',
                                                                   'version' => '6.99_15'
                                                                 },
                                                                 {
                                                                   'date' => '2014-10-02T18:50:08',
                                                                   'version' => '6.99_16'
                                                                 },
                                                                 {
                                                                   'date' => '2014-10-12T18:41:24',
                                                                   'version' => '6.99_17'
                                                                 },
                                                                 {
                                                                   'date' => '2014-10-20T09:14:39',
                                                                   'version' => '6.99_18'
                                                                 },
                                                                 {
                                                                   'date' => '2014-10-22T19:48:56',
                                                                   'version' => '7.00'
                                                                 },
                                                                 {
                                                                   'date' => '2014-10-25T12:49:55',
                                                                   'version' => '7.01_01'
                                                                 },
                                                                 {
                                                                   'date' => '2014-10-25T16:49:40',
                                                                   'version' => '7.01_02'
                                                                 },
                                                                 {
                                                                   'date' => '2014-10-30T19:48:04',
                                                                   'version' => '7.01_03'
                                                                 },
                                                                 {
                                                                   'date' => '2014-10-31T10:13:56',
                                                                   'version' => '7.01_04'
                                                                 },
                                                                 {
                                                                   'date' => '2014-11-03T12:53:43',
                                                                   'version' => '7.01_05'
                                                                 },
                                                                 {
                                                                   'date' => '2014-11-03T20:55:23',
                                                                   'version' => '7.01_06'
                                                                 },
                                                                 {
                                                                   'date' => '2014-11-04T19:40:07',
                                                                   'version' => '7.01_07'
                                                                 },
                                                                 {
                                                                   'date' => '2014-11-04T20:29:00',
                                                                   'version' => '7.01_08'
                                                                 },
                                                                 {
                                                                   'date' => '2014-11-06T21:59:55',
                                                                   'version' => '7.01_09'
                                                                 },
                                                                 {
                                                                   'date' => '2014-11-08T10:39:16',
                                                                   'version' => '7.02'
                                                                 },
                                                                 {
                                                                   'date' => '2014-11-18T21:47:11',
                                                                   'version' => '7.03_01'
                                                                 },
                                                                 {
                                                                   'date' => '2014-11-24T13:26:46',
                                                                   'version' => '7.03_02'
                                                                 },
                                                                 {
                                                                   'date' => '2014-11-25T16:43:06',
                                                                   'version' => '7.03_03'
                                                                 },
                                                                 {
                                                                   'date' => '2014-11-27T14:42:51',
                                                                   'version' => '7.03_04'
                                                                 },
                                                                 {
                                                                   'date' => '2014-11-28T18:32:48',
                                                                   'version' => '7.03_05'
                                                                 },
                                                                 {
                                                                   'date' => '2014-12-01T15:37:46',
                                                                   'version' => '7.03_06'
                                                                 },
                                                                 {
                                                                   'date' => '2014-12-02T12:56:02',
                                                                   'version' => '7.04'
                                                                 },
                                                                 {
                                                                   'date' => '2014-12-06T16:58:07',
                                                                   'version' => '7.05_01'
                                                                 },
                                                                 {
                                                                   'date' => '2014-12-15T20:13:08',
                                                                   'version' => '7.05_02'
                                                                 },
                                                                 {
                                                                   'date' => '2014-12-24T12:12:00',
                                                                   'version' => '7.05_03'
                                                                 },
                                                                 {
                                                                   'date' => '2014-12-24T14:49:46',
                                                                   'version' => '7.05_04'
                                                                 },
                                                                 {
                                                                   'date' => '2014-12-31T23:21:05',
                                                                   'version' => '7.05_05'
                                                                 },
                                                                 {
                                                                   'date' => '2015-01-08T19:09:29',
                                                                   'version' => '7.05_06'
                                                                 },
                                                                 {
                                                                   'date' => '2015-01-09T16:23:43',
                                                                   'version' => '7.05_07'
                                                                 },
                                                                 {
                                                                   'date' => '2015-01-20T10:13:21',
                                                                   'version' => '7.05_08'
                                                                 },
                                                                 {
                                                                   'date' => '2015-01-23T10:51:30',
                                                                   'version' => '7.05_09'
                                                                 },
                                                                 {
                                                                   'date' => '2015-01-26T15:19:01',
                                                                   'version' => '7.05_10'
                                                                 },
                                                                 {
                                                                   'date' => '2015-01-31T16:40:19',
                                                                   'version' => '7.05_11'
                                                                 },
                                                                 {
                                                                   'date' => '2015-02-07T15:19:11',
                                                                   'version' => '7.05_12'
                                                                 },
                                                                 {
                                                                   'date' => '2015-02-18T22:49:29',
                                                                   'version' => '7.05_13'
                                                                 },
                                                                 {
                                                                   'date' => '2015-02-20T17:32:55',
                                                                   'version' => '7.05_14'
                                                                 },
                                                                 {
                                                                   'date' => '2015-03-05T19:44:02',
                                                                   'version' => '7.05_15'
                                                                 },
                                                                 {
                                                                   'date' => '2015-03-09T11:35:12',
                                                                   'version' => '7.05_16'
                                                                 },
                                                                 {
                                                                   'date' => '2015-03-24T12:27:52',
                                                                   'version' => '7.05_17'
                                                                 },
                                                                 {
                                                                   'date' => '2015-03-27T12:20:03',
                                                                   'version' => '7.05_18'
                                                                 },
                                                                 {
                                                                   'date' => '2015-03-27T16:59:34',
                                                                   'version' => '7.05_19'
                                                                 },
                                                                 {
                                                                   'date' => '2015-04-04T15:53:36',
                                                                   'version' => '7.05_20'
                                                                 },
                                                                 {
                                                                   'date' => '2015-06-13T14:19:26',
                                                                   'version' => '7.05_21'
                                                                 },
                                                                 {
                                                                   'date' => '2015-06-14T13:44:56',
                                                                   'version' => '7.05_22'
                                                                 },
                                                                 {
                                                                   'date' => '2015-06-24T19:51:24',
                                                                   'version' => '7.05_23'
                                                                 },
                                                                 {
                                                                   'date' => '2015-07-01T18:30:38',
                                                                   'version' => '7.05_24'
                                                                 },
                                                                 {
                                                                   'date' => '2015-07-07T17:18:36',
                                                                   'version' => '7.05_25'
                                                                 },
                                                                 {
                                                                   'date' => '2015-08-04T19:41:25',
                                                                   'version' => '7.05_26'
                                                                 },
                                                                 {
                                                                   'date' => '2015-08-05T09:35:40',
                                                                   'version' => '7.05_27'
                                                                 },
                                                                 {
                                                                   'date' => '2015-08-19T18:10:20',
                                                                   'version' => '7.05_28'
                                                                 },
                                                                 {
                                                                   'date' => '2015-08-24T15:26:22',
                                                                   'version' => '7.05_29'
                                                                 },
                                                                 {
                                                                   'date' => '2015-08-31T18:06:48',
                                                                   'version' => '7.06'
                                                                 },
                                                                 {
                                                                   'date' => '2015-09-02T11:55:33',
                                                                   'version' => '7.07_01'
                                                                 },
                                                                 {
                                                                   'date' => '2015-09-08T19:59:05',
                                                                   'version' => '7.08'
                                                                 },
                                                                 {
                                                                   'date' => '2015-09-10T18:55:41',
                                                                   'version' => '7.10'
                                                                 },
                                                                 {
                                                                   'date' => '2015-11-12T12:35:03',
                                                                   'version' => '7.11_01'
                                                                 },
                                                                 {
                                                                   'date' => '2015-11-21T20:23:22',
                                                                   'version' => '7.11_02'
                                                                 },
                                                                 {
                                                                   'date' => '2015-11-25T15:40:06',
                                                                   'version' => '7.11_03'
                                                                 },
                                                                 {
                                                                   'date' => '2016-02-15T11:40:55',
                                                                   'version' => '7.11_04'
                                                                 },
                                                                 {
                                                                   'date' => '2016-03-19T10:07:11',
                                                                   'version' => '7.11_05'
                                                                 },
                                                                 {
                                                                   'date' => '2016-03-29T18:44:47',
                                                                   'version' => '7.11_06'
                                                                 },
                                                                 {
                                                                   'date' => '2016-04-19T11:41:10',
                                                                   'version' => '7.12'
                                                                 },
                                                                 {
                                                                   'date' => '2016-04-23T16:35:56',
                                                                   'version' => '7.13_01'
                                                                 },
                                                                 {
                                                                   'date' => '2016-04-24T13:20:40',
                                                                   'version' => '7.14'
                                                                 },
                                                                 {
                                                                   'date' => '2016-04-27T18:27:25',
                                                                   'version' => '7.15_01'
                                                                 },
                                                                 {
                                                                   'date' => '2016-04-28T12:15:28',
                                                                   'version' => '7.15_02'
                                                                 },
                                                                 {
                                                                   'date' => '2016-05-01T13:29:10',
                                                                   'version' => '7.15_03'
                                                                 },
                                                                 {
                                                                   'date' => '2016-05-07T10:28:49',
                                                                   'version' => '7.16'
                                                                 },
                                                                 {
                                                                   'date' => '2016-05-09T19:14:54',
                                                                   'version' => '7.17_01'
                                                                 },
                                                                 {
                                                                   'date' => '2016-05-09T23:07:33',
                                                                   'version' => '7.17_02'
                                                                 },
                                                                 {
                                                                   'date' => '2016-05-11T18:22:21',
                                                                   'version' => '7.17_03'
                                                                 },
                                                                 {
                                                                   'date' => '2016-05-23T15:39:08',
                                                                   'version' => '7.18'
                                                                 },
                                                                 {
                                                                   'date' => '2016-06-02T14:01:28',
                                                                   'version' => '7.19_01'
                                                                 },
                                                                 {
                                                                   'date' => '2016-06-13T09:11:52',
                                                                   'version' => '7.19_02'
                                                                 },
                                                                 {
                                                                   'date' => '2016-06-13T13:44:33',
                                                                   'version' => '7.19_03'
                                                                 },
                                                                 {
                                                                   'date' => '2016-06-14T11:35:43',
                                                                   'version' => '7.19_04'
                                                                 },
                                                                 {
                                                                   'date' => '2016-06-20T14:40:57',
                                                                   'version' => '7.19_05'
                                                                 },
                                                                 {
                                                                   'date' => '2016-06-27T12:04:29',
                                                                   'version' => '7.19_06'
                                                                 },
                                                                 {
                                                                   'date' => '2016-07-03T14:30:23',
                                                                   'version' => '7.19_07'
                                                                 },
                                                                 {
                                                                   'date' => '2016-07-28T12:26:56',
                                                                   'version' => '7.19_08'
                                                                 },
                                                                 {
                                                                   'date' => '2016-08-05T08:57:09',
                                                                   'version' => '7.20'
                                                                 },
                                                                 {
                                                                   'date' => '2016-08-07T09:54:04',
                                                                   'version' => '7.21_01'
                                                                 },
                                                                 {
                                                                   'date' => '2016-08-08T08:42:10',
                                                                   'version' => '7.22'
                                                                 },
                                                                 {
                                                                   'date' => '2016-08-19T09:24:06',
                                                                   'version' => '7.23_01'
                                                                 },
                                                                 {
                                                                   'date' => '2016-08-20T12:35:27',
                                                                   'version' => '7.24'
                                                                 },
                                                                 {
                                                                   'date' => '2017-02-03T15:21:22',
                                                                   'version' => '7.25_01'
                                                                 },
                                                                 {
                                                                   'date' => '2017-05-11T11:19:49',
                                                                   'version' => '7.25_02'
                                                                 },
                                                                 {
                                                                   'date' => '2017-05-11T17:09:16',
                                                                   'version' => '7.25_03'
                                                                 },
                                                                 {
                                                                   'date' => '2017-05-12T12:25:54',
                                                                   'version' => '7.25_04'
                                                                 },
                                                                 {
                                                                   'date' => '2017-05-15T09:41:49',
                                                                   'version' => '7.25_05'
                                                                 },
                                                                 {
                                                                   'date' => '2017-05-23T19:31:28',
                                                                   'version' => '7.25_06'
                                                                 },
                                                                 {
                                                                   'date' => '2017-05-27T20:21:06',
                                                                   'version' => '7.26'
                                                                 },
                                                                 {
                                                                   'date' => '2017-05-28T10:50:55',
                                                                   'version' => '7.27_01'
                                                                 },
                                                                 {
                                                                   'date' => '2017-05-30T08:56:32',
                                                                   'version' => '7.27_02'
                                                                 },
                                                                 {
                                                                   'date' => '2017-05-30T21:26:23',
                                                                   'version' => '7.28'
                                                                 },
                                                                 {
                                                                   'date' => '2017-05-31T08:32:44',
                                                                   'version' => '7.29_01'
                                                                 },
                                                                 {
                                                                   'date' => '2017-06-11T11:17:55',
                                                                   'version' => '7.29_02'
                                                                 },
                                                                 {
                                                                   'date' => '2017-06-12T12:31:08',
                                                                   'version' => '7.30'
                                                                 },
                                                                 {
                                                                   'date' => '2017-06-14T15:10:23',
                                                                   'version' => '7.31_01'
                                                                 },
                                                                 {
                                                                   'date' => '2017-06-26T13:14:10',
                                                                   'version' => '7.31_02'
                                                                 },
                                                                 {
                                                                   'date' => '2017-07-10T09:02:35',
                                                                   'version' => '7.31_03'
                                                                 },
                                                                 {
                                                                   'date' => '2017-10-05T12:19:00',
                                                                   'version' => '7.31_04'
                                                                 },
                                                                 {
                                                                   'date' => '2017-11-25T09:37:04',
                                                                   'version' => '7.31_05'
                                                                 },
                                                                 {
                                                                   'date' => '2018-01-16T13:28:46',
                                                                   'version' => '7.31_06'
                                                                 },
                                                                 {
                                                                   'date' => '2018-01-16T16:24:23',
                                                                   'version' => '7.31_07'
                                                                 },
                                                                 {
                                                                   'date' => '2018-02-12T12:32:45',
                                                                   'version' => '7.31_08'
                                                                 },
                                                                 {
                                                                   'date' => '2018-02-16T20:25:44',
                                                                   'version' => '7.32'
                                                                 },
                                                                 {
                                                                   'date' => '2018-02-20T10:44:19',
                                                                   'version' => '7.33_01'
                                                                 },
                                                                 {
                                                                   'date' => '2018-02-24T14:05:00',
                                                                   'version' => '7.33_02'
                                                                 },
                                                                 {
                                                                   'date' => '2018-02-24T20:21:42',
                                                                   'version' => '7.33_03'
                                                                 },
                                                                 {
                                                                   'date' => '2018-03-19T10:51:54',
                                                                   'version' => '7.34'
                                                                 },
                                                                 {
                                                                   'date' => '2018-04-19T12:46:01',
                                                                   'version' => '7.35_01'
                                                                 },
                                                                 {
                                                                   'date' => '2018-04-24T11:01:35',
                                                                   'version' => '7.35_02'
                                                                 },
                                                                 {
                                                                   'date' => '2018-04-27T13:59:23',
                                                                   'version' => '7.35_03'
                                                                 },
                                                                 {
                                                                   'date' => '2018-07-09T09:50:43',
                                                                   'version' => '7.35_04'
                                                                 },
                                                                 {
                                                                   'date' => '2018-07-10T09:18:31',
                                                                   'version' => '7.35_05'
                                                                 },
                                                                 {
                                                                   'date' => '2018-07-19T19:49:08',
                                                                   'version' => '7.35_06'
                                                                 },
                                                                 {
                                                                   'date' => '2018-11-23T11:59:44',
                                                                   'version' => '7.35_07'
                                                                 },
                                                                 {
                                                                   'date' => '2018-12-06T10:56:33',
                                                                   'version' => '7.35_08'
                                                                 }
                                                               ]
                                               },
                       'FCGI' => {
                                   'advisories' => [
                                                     {
                                                       'affected_versions' => '<0.74',
                                                       'cves' => [
                                                                   'CVE-2011-2766'
                                                                 ],
                                                       'description' => 'Leaking information across requests when using the deprecated and undocumented old FCGI interface.
',
                                                       'distribution' => 'FCGI',
                                                       'fixed_versions' => '>=0.74',
                                                       'id' => 'CPANSA-FCGI-2011-01',
                                                       'references' => [
                                                                         'https://metacpan.org/changes/distribution/FCGI',
                                                                         'https://github.com/perl-catalyst/FCGI/commit/297693dc8362d25bb25e473899c72508a0f71d2e'
                                                                       ],
                                                       'reported' => '2011-09-24'
                                                     }
                                                   ],
                                   'main_module' => 'FCGI',
                                   'versions' => [
                                                   {
                                                     'date' => '1996-09-25T17:48:57',
                                                     'version' => '0.25'
                                                   },
                                                   {
                                                     'date' => '1996-10-15T21:51:06',
                                                     'version' => '0.26'
                                                   },
                                   