# Generated by default/object.tt
package Paws::MediaConvert::VorbisSettings;
  use Moose;
  has Channels => (is => 'ro', isa => 'Int', request_name => 'channels', traits => ['NameInRequest']);
  has SampleRate => (is => 'ro', isa => 'Int', request_name => 'sampleRate', traits => ['NameInRequest']);
  has VbrQuality => (is => 'ro', isa => 'Int', request_name => 'vbrQuality', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::MediaConvert::VorbisSettings

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::MediaConvert::VorbisSettings object:

  $service_obj->Method(Att1 => { Channels => $value, ..., VbrQuality => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::MediaConvert::VorbisSettings object:

  $result = $service_obj->Method(...);
  $result->Att1->Channels

=head1 DESCRIPTION

Required when you set Codec, under AudioDescriptionsE<gt>CodecSettings,
to the value Vorbis.

=head1 ATTRIBUTES


=head2 Channels => Int

Optional. Specify the number of channels in this output audio track.
Choosing Mono on the console gives you 1 output channel; choosing
Stereo gives you 2. In the API, valid values are 1 and 2. The default
value is 2.


=head2 SampleRate => Int

Optional. Specify the audio sample rate in Hz. Valid values are 22050,
32000, 44100, and 48000. The default value is 48000.


=head2 VbrQuality => Int

Optional. Specify the variable audio quality of this Vorbis output from
-1 (lowest quality, ~45 kbit/s) to 10 (highest quality, ~500 kbit/s).
The default value is 4 (~128 kbit/s). Values 5 and 6 are approximately
160 and 192 kbit/s, respectively.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::MediaConvert>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

