use 5.14.0;
use strict;
use warnings;

package Dist::Zilla::Plugin::Author::CSSON::GithubActions::BaseWorkflow;

# ABSTRACT: An example Github Actions workflow
our $AUTHORITY = 'cpan:CSSON'; # AUTHORITY
our $VERSION = '0.0101';

use Moose;
with qw/
    Dist::Zilla::Plugin::Author::CSSON::GithubActions::Role::Workflow
/;

sub main_module { 'Dist::Zilla::Plugin::Author::CSSON::GithubActions' }

sub filepath { 'base-workflow.yml' }

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Dist::Zilla::Plugin::Author::CSSON::GithubActions::BaseWorkflow - An example Github Actions workflow

=head1 VERSION

Version 0.0101, released 2020-12-25.

=head1 SYNOPSIS

In dist.ini:

    [Author::CSSON::GithubActions]
    workflow_class = Author::CSSON::GithubActions::BaseWorkflow

=head1 DESCRIPTION

This is an example workflow for L<Dist::Zilla::Plugin::Author::CSSON::GithubActions>. It is based
on L<https://perlmaven.com/setup-github-actions>.

The actual workflow is defined in C<share/base-workflow.yml>.

=head1 SOURCE

L<https://github.com/Csson/p5-Dist-Zilla-Plugin-Author-CSSON-GithubActions>

=head1 HOMEPAGE

L<https://metacpan.org/release/Dist-Zilla-Plugin-Author-CSSON-GithubActions>

=head1 AUTHOR

Erik Carlsson <info@code301.com>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2020 by Erik Carlsson.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
