/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.catalog.TypeDescriptor;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.compile.TypeCompiler;
import org.apache.derby.iapi.sql.compile.TypeCompilerFactory;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.impl.sql.compile.AggregateDefinition;

public class SumAvgAggregateDefinition
implements AggregateDefinition {
    private boolean isSum;

    public final TypeDescriptor getAggregator(TypeDescriptor typeDescriptor, StringBuffer stringBuffer) {
        try {
            LanguageConnectionContext languageConnectionContext = (LanguageConnectionContext)ContextService.getContext("LanguageConnectionContext");
            DataTypeDescriptor dataTypeDescriptor = new DataTypeDescriptor((DataTypeDescriptor)typeDescriptor, typeDescriptor.isNullable());
            TypeId typeId = dataTypeDescriptor.getTypeId();
            CompilerContext compilerContext = (CompilerContext)ContextService.getContext("CompilerContext");
            TypeCompilerFactory typeCompilerFactory = compilerContext.getTypeCompilerFactory();
            TypeCompiler typeCompiler = typeCompilerFactory.getTypeCompiler(typeId);
            if (typeId.isNumericTypeId()) {
                stringBuffer.append(this.getAggregatorClassName());
                DataTypeDescriptor dataTypeDescriptor2 = typeCompiler.resolveArithmeticOperation(dataTypeDescriptor, dataTypeDescriptor, this.getOperator());
                dataTypeDescriptor2.setNullability(true);
                return dataTypeDescriptor2;
            }
        }
        catch (StandardException standardException) {
            // empty catch block
        }
        return null;
    }

    private String getAggregatorClassName() {
        if (this.isSum) {
            return "org.apache.derby.impl.sql.execute.SumAggregator";
        }
        return "org.apache.derby.impl.sql.execute.AvgAggregator";
    }

    protected String getOperator() {
        if (this.isSum) {
            return "sum";
        }
        return "avg";
    }

    public final void setSumOrAvg(boolean bl) {
        this.isSum = bl;
    }
}

