use lib '../lib';
use v5.36;
use Acme::Insult::Pirate;
use Getopt::Long;
use Pod::Usage;
use open qw[:std :encoding(UTF-8)];

# Test
#~ @ARGV = qw[];
#~ @ARGV = qw[-json];
#~ @ARGV = qw[-h];
#
my $raw = 0;

sub _echo ($insult) {
    $raw && eval 'require JSON::Tiny' ? JSON::Tiny::encode_json( {%$insult} ) : $insult;
}
GetOptions( \my %h, 'help' => sub { pod2usage( -exitval => 1 ) }, 'json!' => \$raw );
my $shade = Acme::Insult::Pirate::insult(%h);
exit !( $shade ? say _echo($shade) : !say( $raw ? 'null' : '' ) );
__END__

=head1 NAME

evil_insult - Generate evil insults on the terminal

=head1 SYNOPSIS

    evil_insult                                  # generate a random insult
    evil_insult -json                            # insult someone if you're a robot
    evil_insult -help                            # get help

=head1 OPTIONS

    -json               Echo raw JSON encoded data
    -help               Display this help message

=head1 DESCRIPTION

This script wraps Acme::Insult::Pirate.

=head1 LICENSE & LEGAL

Copyright (C) Sanko Robinson.

This library is free software; you can redistribute it and/or modify it under the terms found in the Artistic License
2. Other copyrights, terms, and conditions may apply to data transmitted through this module.

Insults are generated by the L<Evil Insult Generator|https://evilinsult.com/>.

=head1 AUTHOR

Sanko Robinson E<lt>sanko@cpan.orgE<gt>

=cut
