package main;

use strict;
use warnings;

use Test::More tests => 1;
use cppAdaptive2;

my ( $obsVector, $futVector, $betaVector, $n_observed ) = (    #
    '313312221112123223322132223313312131221123212113221111213232',
    '323133332131332223321221232122221331123313333213311113231233333322133312331123322211232222212312131221133121232212232111233332223221131132112121332212123211313111211',
    '-0.26425,0.648666,-0.0565359,-0.373203,-0.107654,0.228433,-0.339707,0.663967,0.0600106,0.0828479',
    4,
);

my ( $newFutVector, $newBetaVector ) = cppAdaptive2::update( $obsVector, $futVector, $betaVector, $n_observed );

ok( $newFutVector eq '-0.216451,0.636178,-0.00126307,-0.52607,-0.275814,0.681716,0.0171322,0.51263,0.0473715,0.09243', 'newFutVector' );

1;
## -----SOURCE FILTER LOG BEGIN-----
##
## PerlCritic profile "common" policy violations:
## +------+----------------------+----------------------------------------------------------------------------------------------------------------+
## | Sev. | Lines                | Policy                                                                                                         |
## |======+======================+================================================================================================================|
## |    2 | 1                    | Modules::RequireVersionVar - No package-scoped "$VERSION" variable found                                       |
## +------+----------------------+----------------------------------------------------------------------------------------------------------------+
##
## -----SOURCE FILTER LOG END-----
