# -*- cperl -*-
# ABSTRACT: LaTeX square (or n-) root


use strict;
use warnings;
package SpeL::Object::Squareroot;

use parent 'Exporter';
use Carp;

use SpeL::I18n;
use Data::Dumper;



sub read {
  my $self = shift;
  my ( $level ) = @_;

  my $N = 2;
  if ( exists $self->{N} ) {
    $N = $self->{N}->read( $level + 1 );
    $N =~ s/^\s*(\w+)\s*$/$1/;
  }

  return $SpeL::I18n::lh->maketext('Squareroot',
					    $N,
					    $self->{Argument}->read( $level + 1 ) ) . ', ';
}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

SpeL::Object::Squareroot - LaTeX square (or n-) root

=head1 VERSION

version 20250511.1428

=head1 METHODS

=head2 new()

We keep the default method, as the object is generated by the parser.

=head2 read( level )

returns a string with the spoken version of the node

=over 4

=item level: parsing level

=back

=head1 SYNOPSYS

Represents a LaTeX square (or n-root)

=head1 AUTHOR

Walter Daems <wdaems@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2025 by Walter Daems.

This is free software, licensed under:

  The GNU General Public License, Version 3, June 2007

=head1 CONTRIBUTOR

=for stopwords Paul Levrie

Paul Levrie

=cut
