/*
 * Decompiled with CFR 0.152.
 */
package opennlp.grok.parse;

import gnu.trove.THashSet;
import gnu.trove.TIntIntHashMap;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import opennlp.common.parse.LexException;
import opennlp.common.parse.Lexicon;
import opennlp.common.parse.ParseException;
import opennlp.common.parse.RuleGroup;
import opennlp.common.synsem.Category;
import opennlp.common.synsem.CategoryFcn;
import opennlp.common.synsem.Sign;
import opennlp.common.unify.FeatureStructure;
import opennlp.common.unify.Indexed;
import opennlp.common.unify.ModFcn;
import opennlp.common.unify.Mutable;
import opennlp.common.xml.NLPDocument;
import opennlp.grok.expression.CategoryFcnAdapter;
import opennlp.grok.expression.SignHash;
import opennlp.grok.parse.Chart;
import opennlp.grok.parse.ParserAdapter;
import opennlp.grok.util.Debug;
import opennlp.grok.util.Params;

public class CKY
extends ParserAdapter {
    ArrayList result;
    private static int UNIQUE;
    private static ModFcn uniqueFcn;
    private Set _catFeatStrucs;
    private TIntIntHashMap _reindexed;
    private int _fsIndex = 1;
    private CategoryFcn indexFcn = new CategoryFcnAdapter(){

        public void forall(Category c) {
            FeatureStructure fs = c.getFeatureStructure();
            if (fs != null) {
                CKY.this._catFeatStrucs.add(fs);
                int index = fs.getIndex();
                if (index > 0) {
                    int $index = CKY.this._fsIndex++;
                    fs.setIndex($index);
                    CKY.this._reindexed.put(index, $index);
                }
            }
        }
    };

    public CKY(String lex, String rule) throws FileNotFoundException, IOException, LexException {
        super(lex, rule);
    }

    public CKY(Lexicon l, RuleGroup r) {
        super(l, r);
    }

    public void createResult(Chart table, int size) throws ParseException {
        this.result = new ArrayList();
        Iterator e = table.get(0, size - 1).values().iterator();
        while (e.hasNext()) {
            this.result.add(e.next());
        }
        this.debug(table);
        if (this.result.size() == 0) {
            throw new ParseException("Unable to parse");
        }
    }

    public void parse(Chart table, int size) throws ParseException {
        int i = 0;
        while (i < size) {
            table.insertCell(i, i);
            ++i;
        }
        int j = 1;
        while (j < size) {
            int i2 = j - 1;
            while (i2 >= 0) {
                int k = i2;
                while (k < j) {
                    table.insertCell(i2, k, k + 1, j, i2, j);
                    ++k;
                }
                table.insertCell(i2, j);
                --i2;
            }
            ++j;
        }
        this.createResult(table, size);
    }

    protected Chart getChart(int size, RuleGroup r) {
        return new Chart(size, r);
    }

    public Chart getInitializedTable(List entries) {
        UNIQUE = 0;
        this._fsIndex = 1;
        Chart table = this.getChart(entries.size(), this.R);
        int i = 0;
        Iterator entryIt = entries.iterator();
        while (entryIt.hasNext()) {
            SignHash wh = (SignHash)((Object)entryIt.next());
            Iterator whI = wh.values().iterator();
            while (whI.hasNext()) {
                Category cat = ((Sign)whI.next()).getCategory();
                this.reindexFeatureStructures(cat);
                cat.deepMap(uniqueFcn);
                ++UNIQUE;
            }
            table.set(i, i, wh);
            ++i;
        }
        return table;
    }

    private void reindexFeatureStructures(Category c) {
        this._catFeatStrucs = new THashSet();
        this._reindexed = new TIntIntHashMap();
        c.forall(this.indexFcn);
        Iterator fsIt = this._catFeatStrucs.iterator();
        while (fsIt.hasNext()) {
            int $inheritorId;
            FeatureStructure fs = (FeatureStructure)fsIt.next();
            int inheritorId = fs.getInheritorIndex();
            if (inheritorId <= 0 || ($inheritorId = this._reindexed.get(inheritorId)) <= 0) continue;
            fs.setInheritorIndex($inheritorId);
        }
    }

    private void debug(Chart table) {
        if (Params.getBoolean("Display:CKY Chart")) {
            table.printChart();
            System.out.println(table);
        }
    }

    public void parse(String s) throws ParseException {
        try {
            List entries = this.L.getWords(s);
            Chart table = this.getInitializedTable(entries);
            this.parse(table, entries.size());
            this.debug(table);
        }
        catch (LexException e) {
            throw new ParseException("Unable to retrieve lexical entries.");
        }
    }

    public void parse(NLPDocument d) throws ParseException {
        try {
            List entries = this.L.getWords(d);
            Chart table = this.getInitializedTable(entries);
            this.parse(table, entries.size());
            this.debug(table);
        }
        catch (LexException e) {
            throw new ParseException("Unable to retrieve lexical entries.");
        }
    }

    public void parse(Sign[] inits) throws ParseException {
        Chart table = this.getChart(inits.length, this.R);
        int i = 0;
        while (i < inits.length) {
            table.set(i, i, new SignHash(inits[i]));
            ++i;
        }
        this.parse(table, inits.length);
    }

    public ArrayList getResult() {
        return this.result;
    }

    static {
        Debug.Register("Chart Parser", false);
        Params.register("Display:CKY Chart", "false");
        UNIQUE = 0;
        uniqueFcn = new ModFcn(){

            public void modify(Mutable m) {
                if (m instanceof Indexed) {
                    ((Indexed)m).setIndex(UNIQUE);
                }
            }
        };
    }
}

