/*
 * Decompiled with CFR 0.152.
 */
package opennlp.grok.lexicon;

import java.util.Collection;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import opennlp.common.morph.MorphAnalyzer;
import opennlp.common.preprocess.Pipelink;
import opennlp.common.xml.NLPDocument;
import opennlp.grok.lexicon.MorphData;
import opennlp.grok.lexicon.XtagMorphDataDB;
import opennlp.grok.lexicon.XtagMorphDataFlat;
import opennlp.grok.lexicon.XtagMorphDataIntf;
import opennlp.grok.util.Cache;
import opennlp.grok.util.ParamListener;
import opennlp.grok.util.Params;

public class XtagMorphData
implements MorphData,
ParamListener,
MorphAnalyzer,
Pipelink {
    XtagMorphDataIntf xtag;
    Cache macroCache = new Cache("XtagDataMorphs", 100, 2);
    Cache headCache = new Cache("XtagDataHeads", 100, 2);
    Properties gram;
    static /* synthetic */ Class class$opennlp$common$preprocess$Tokenizer;

    public XtagMorphData(Properties g) {
        this.gram = g;
        this.init();
        Params.addParamListener(this);
    }

    private void init() {
        boolean useDB = Params.getBoolean("Enable:Databases");
        if (useDB) {
            this.xtag = new XtagMorphDataDB();
            useDB = this.xtag.init(this.gram);
        }
        if (!useDB) {
            this.xtag = new XtagMorphDataFlat();
            this.xtag.init(this.gram);
        }
    }

    public String analyze(String word) {
        return this.getMorphItems(word).toString();
    }

    public String[] getPrefixes(String word) {
        return new String[0];
    }

    public String[] getSuffixes(String word) {
        return new String[0];
    }

    public Collection getMorphItems(String word) {
        Collection c = (Collection)this.macroCache.get(word);
        if (c == null) {
            c = this.xtag.getMorphItems(word);
            this.macroCache.put(word, c);
        }
        return c;
    }

    public Collection getHeadMorphs(String word) {
        Collection c = (Collection)this.headCache.get(word);
        if (c == null) {
            c = this.xtag.getHeadMorphs(word);
            this.headCache.put(word, c);
        }
        return c;
    }

    public void paramRegistered(String param, String value) {
    }

    public void paramSaving() {
    }

    public void paramChanged(String param, String value) {
        if (param.equals("Enable:Databases")) {
            this.init();
        }
    }

    public void process(NLPDocument doc) {
    }

    public Set requires() {
        HashSet<Class> set = new HashSet<Class>();
        set.add(class$opennlp$common$preprocess$Tokenizer == null ? (class$opennlp$common$preprocess$Tokenizer = XtagMorphData.class$("opennlp.common.preprocess.Tokenizer")) : class$opennlp$common$preprocess$Tokenizer);
        return set;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

