#!perl -T
use 5.006;
use strict;
use warnings;
use Data::Dumper;
use Test::More tests => 8;

use Deep::Hash::Exists qw( key_exists );

my $arr_ref = [];
my $hash_ref = {
        A => 'one',
        B => [ 'one', 'two' ],
        C => { 
            'one' => 1, 
            'two' => 2, 
            $arr_ref => 3
        },
};

ok( key_exists( $hash_ref, [ 'A' ] ), q(Key 'A' is exists) );
ok( key_exists( $hash_ref, [ 'B' ] ), q(Key 'B' is exists) );
ok( ! key_exists( $hash_ref, [ 'B', '0' ] ), q(Key 'B'->'0' isn't exists) );
ok( key_exists( $hash_ref, [ 'C', 'one' ] ), q(Key 'C'->'one' is exists) );
ok( key_exists( $hash_ref, [ 'C', $arr_ref ] ), q(Key 'C'->$arr_ref is exists) );
ok( ! key_exists( $hash_ref, [ 'C', 'three' ] ), q(Key 'C'->'three' isn't exists) );
ok( ! key_exists( $hash_ref, [ 'C', 'three', 'PI', '0' ] ), q(Key 'C'->'three'->'PI'->'0' isn't exists) );
unlike( Dumper( $hash_ref ), qr(PI), q(Subroutine does not create new keys) );


