package WWW::Marvel::Client;
use base qw/ WWW::Marvel /;
use Carp;
use Digest::MD5;
use URI;
__PACKAGE__->follow_best_practice;
__PACKAGE__->mk_accessors(qw/ timestamp /);


# ref: https://developer.marvel.com/documentation/authorization
sub hash {
	my ($self, $time) = @_;

	if (!defined $time) {
		croak "need a timestamp to create a md5 hash" if !defined $self->get_timestamp;
		$time = $self->get_timestamp;
	}

	my $md5 = Digest::MD5->new;
	$md5->add( $time, $self->get_private_key, $self->get_public_key );
	return $md5->hexdigest;
}

sub uri {
	my ($self) = @_;

	my %params = (
		ts     => $self->get_timestamp,
		hash   => $self->hash,
		apikey => $self->get_public_key,
	);

	my $uri = URI->new();
	$uri->query_form(%params);
	return $uri;
}


1;
