package Business::EDI::CodeList::SpecialConditionCode;

use base 'Business::EDI::CodeList';
my $VERSION     = 0.02;
sub list_number {4183;}
my $usage       = 'C';

# *    4183  Special condition code                                  [C]
# Desc: Code specifying a special condition.
# Repr: an..3

my %code_hash = (
'1' => [ 'Item for national preference',
    'Item concerned is applicable to national preference calculation.' ],
'2' => [ 'Item qualifying for payment discount',
    'Item concerned is applicable for settlement/payment discount calculation.' ],
'3' => [ 'Item not qualifying for payment discount',
    'Item concerned is not applicable for settlement/payment discount calculation.' ],
'4' => [ 'Urgent delivery of reserved goods',
    'Urgent delivery of goods for which a reservation was made.' ],
'5' => [ 'Item not to be included in bonus calculation',
    'Item concerned is not applicable for bonus calculation.' ],
'6' => [ 'Subject to bonus',
    'Item concerned is applicable for bonus calculation.' ],
'7' => [ 'Subject to commission',
    'Item concerned is applicable for commission calculation.' ],
'8' => [ 'Subject to discount',
    'Item concerned is applicable for discount calculation.' ],
'9' => [ 'Freely available in EEC',
    'Item should be available freely within the European Economic Community.' ],
'10' => [ 'Subject to settlement discount',
    'Item concerned is applicable for the overall settlement discount.' ],
'11' => [ 'Price includes excise',
    'The stated price is inclusive of excise.' ],
'12' => [ 'Price includes tax',
    'The stated price is inclusive of tax.' ],
'13' => [ 'Price include duty',
    'The stated price is inclusive of duty.' ],
'14' => [ 'Not subject to commission',
    'Item concerned is not applicable for commission calculation.' ],
'15' => [ 'Not subject to discount',
    'Item concerned is not applicable for discount calculation.' ],
'16' => [ 'Subject to embargo restriction',
    'Item concerned is subject to embargo restriction.' ],
'17' => [ 'Item not subject to embargo restrictions',
    'Item concerned is not subject to embargo restriction.' ],
'18' => [ 'Item subject to national export restrictions',
    'Item concerned requires export declaration.' ],
'19' => [ 'Item not subject to national export restrictions',
    'Item concerned does not require export declaration.' ],
'20' => [ 'Item subject to import restrictions',
    'Item concerned is liable to import restrictions defined by relevant national authority.' ],
'21' => [ 'Item not subject to import restrictions',
    'Item concerned is not liable to import restrictions defined by relevant national authority.' ],
'22' => [ 'Signed',
    'Document has to be signed.' ],
'23' => [ 'Authenticated',
    'Document/message has to have official or regulatory approval.' ],
'24' => [ 'Original(s) to be certified',
    'Original document/message is to be certified by an official, or otherwise qualified, organization or person.' ],
'25' => [ 'Original(s) to be legalized',
    'Original document/message is to be issued under the legal requirements of a governmental authority.' ],
'26' => [ 'Quote documentary credit number',
    'The documentary credit number of the issuing bank must be quoted on the document.' ],
'27' => [ 'Full set bill of lading',
    'Full set of bill of lading is required.' ],
'28' => [ 'Full set bill of lading less one original',
    'Full set of bill of lading, less one original bill of lading, is required.' ],
'29' => [ 'Full set bill of lading less two originals',
    'Full set of bill of lading, less two originals bill of lading, is required.' ],
'30' => [ 'Shipped on board',
    'Transport document is to be marked "shipped on board".' ],
'31' => [ 'Freight prepaid to be marked',
    'Transport document is to be marked "freight prepaid".' ],
'32' => [ 'Freight collect to be marked',
    'Transport document is to be marked "freight collect".' ],
'33' => [ 'Issued to order and blank endorsed',
    'Document is to be issued to order and must be blank endorsed.' ],
'34' => [ 'Issued and/or endorsed to the order of',
    'Document is to be issued and/or endorsed to the order of a specific party.' ],
'35' => [ 'Consigned to',
    'Transport document is to be consigned to a specified party.' ],
'36' => [ 'Notify',
    'Transport document is to be marked "notify party".' ],
'37' => [ 'Issued by',
    'Document is to be issued by a specified party.' ],
'38' => [ 'Charter party allowed',
    'Charter party bill of lading is allowed.' ],
'39' => [ 'Loading on deck allowed',
    'Loading of goods on deck is allowed.' ],
'40' => [ 'Quote actual flight date and flight number',
    'Document/message must evidence the actual flight date and the flight number certifying air transportation and countersigned by the respective airline company.' ],
'41' => [ 'House AWB allowed',
    'House air waybill is allowed.' ],
'42' => [ 'Express post receipt',
    'Express post receipt is required.' ],
'43' => [ 'Air parcel post receipt',
    'Air parcel post receipt is required.' ],
'44' => [ 'Parcel post receipt',
    'Parcel post receipt is required.' ],
'45' => [ 'Issued to bearer',
    'Document is to be issued to bearer.' ],
'46' => [ 'Full set of insurance certificate',
    'Full set of insurance certificate is required.' ],
'47' => [ 'Full set of insurance policy',
    'Full set of insurance policy is required.' ],
'48' => [ 'Addressed to',
    'Document is to be addressed to a specified party.' ],
'49' => [ 'Transmission by telecommunication',
    'Document is to be transmitted by telecommunication.' ],
'50' => [ 'Bill of exchange drawn on',
    'Bill of exchange is to be drawn on "party".' ],
'51' => [ 'Bill of exchange in duplicate',
    'Bill of exchange is to be issued as drawn in duplicate.' ],
'52' => [ 'Insurance certificate alternative',
    'Alternative to insurance certificate.' ],
'53' => [ 'Insurance policy alternative',
    'Alternative to insurance policy.' ],
'54' => [ 'Original(s) and copies to be certified',
    'Original and copies of document/message is to be certified by an official, or otherwise qualified, organization or person.' ],
'55' => [ 'Original(s) and copies to be legalized',
    'Original and copies of document/message is to be issued under the legal requirements or a governmental authority.' ],
'56' => [ 'Consolidators AWB allowed',
    'Consolidators air waybill is allowed.' ],
'57' => [ 'Full set',
    'Full set of a document is required.' ],
'58' => [ 'Full set less one original',
    'Full set of a document, less one original, is required.' ],
'59' => [ 'Full set less two originals',
    'Full set of a document, less two originals, is required.' ],
'60' => [ 'Goods despatched to',
    'Document must show that the goods have been despatched to a specified party.' ],
'61' => [ 'Insurance certificate allowed',
    'Presentation of an insurance certificate instead of an insurance policy is allowed.' ],
'62' => [ 'Issued to',
    'Document is to be issued to a specified party.' ],
'63' => [ 'Original(s) and copy(ies) signed',
    'Original(s) and copy(ies) of the document must be signed.' ],
'64' => [ 'Original(s) signed',
    'Original(s) of the document must be signed.' ],
'65' => [ 'No disposal clause',
    'The shipper hereby irrevocably renounces any right to vary the identity of the consignee of these goods during transit.' ],
'66' => [ 'Delivery without change of ownership',
    'There is no change of ownership of the goods after they are received by the consignee.' ],
'67' => [ 'Delivery with change of ownership',
    'There is a change of ownership of the goods after they are received by the consignee.' ],
'68' => [ 'Supply for outright purchase/sale',
    'Goods are supplied under outright purchase/sale condition.' ],
'69' => [ 'Supply for consignment',
    'Goods are supplied for consignment purposes.' ],
'70' => [ "Supply for sale 'on approval' or after trial",
    'The sale of the goods will only be finalised after trial or approval.' ],
'71' => [ 'Exchange of goods compensated in kind',
    'Goods are delivered on the basis of a compensation kind.' ],
'72' => [ 'Sale for export by foreigner travelling in member state',
    'concerned A cross border delivery of goods to be sold by a foreigner travelling in the European Economic Community member state concerned.' ],
'73' => [ 'Samples',
    'The delivered goods are samples.' ],
'74' => [ 'Temporary export, loan or hire',
    'Loaned or hired goods delivered on a temporary export basis.' ],
'75' => [ 'Temporary export, leasing',
    'Leased goods delivered on a temporary export basis.' ],
'76' => [ 'Temporary export, operation for job processing',
    'Goods temporarily exported for operation for job processing.' ],
'77' => [ 'Temporary export, repair and maintenance against payment',
    'Goods temporarily exported for a chargeable repair or maintenance reason.' ],
'78' => [ 'Temporary export, repair and maintenance free of charge',
    'Goods temporarily exported for a free of charge repair or maintenance reason.' ],
'79' => [ 'Reimport following job processing',
    'Goods reimported after they have been used for job processing.' ],
'80' => [ 'Reimport following repair and maintenance against payment',
    'Goods reimported after a temporary export for a chargeable repair or maintenance reason.' ],
'81' => [ 'Reimport following repair and maintenance free of charge',
    'Goods reimported after a temporary export for a free of charge repair or maintenance reason.' ],
'82' => [ 'Supply of goods under joint production contract for defence',
    'purposes Goods supplied under joint production contact for defence purposes condition.' ],
'83' => [ 'Supply of goods under joint production contract for civil',
    'purposes Goods supplied under joint production contact for civil purposes condition.' ],
'84' => [ 'Supply of goods for warehousing for foreign account',
    'Goods supplied for warehousing for foreign account.' ],
'85' => [ 'Supply of goods as gifts by country of despatch and food',
    'aid under European Economic Community regulation Goods supplied as gifts by country of despatch and food aid under European Economic Community regulation.' ],
'86' => [ 'Supply of goods for disaster relief equipment',
    'Goods supplied as disaster relief equipment.' ],
'87' => [ 'Supply of goods as transactions without compensation',
    'Goods supplied as transactions without compensation (financial or otherwise) involving goods which will not be re-exported or compensated by the importation of equivalent goods.' ],
'88' => [ 'Supply of goods as returned consignment on which payment',
    'has been made Goods supplied as returned consignment on which payment has been made.' ],
'89' => [ 'Supply of goods as returned consignment on which no payment',
    'has been made Goods supplied as returned consignment on which no payment has been made.' ],
'90' => [ 'Supply of goods in standard exchange giving rise to payment',
    'Goods supplied in standard exchange giving rise to payment.' ],
'91' => [ 'Supply of goods in standard exchange not giving rise to',
    'payment Goods supplied in standard exchange not giving rise to payment.' ],
'92' => [ 'Supply of goods/services in standard exchange under',
    'warranty Goods/services provided in standard exchange under warranty.' ],
'93' => [ 'Goods',
    'The special conditions for the tax declaration are linked to the fact that the line item relates to goods.' ],
'94' => [ 'Service',
    'The special conditions for the tax declaration are linked to the fact that the line item is a service.' ],
'95' => [ 'Financial regulation',
    'The special conditions are linked to the fact that the line item is a financial regulation.' ],
'96' => [ 'Promotional advertising',
    'A media press communication informing about a promotion.' ],
'97' => [ 'Promotional price',
    'Reduction in price for a specified period of time for promotional purposes.' ],
'98' => [ 'Promotional shelf display',
    'Product in promotion is displayed in a special shelf or display.' ],
'99' => [ 'Safety data sheet required to accompany goods when moved',
    'Material safety data sheet is required to accompany the goods when they are moved.' ],
'100' => [ 'Multiple delivery points',
    'An order that has more than one specified delivery point.' ],
'101' => [ 'Provisional settlement',
    'Provides an indication that the settlement may be subject to further potential adjustment.' ],
'102' => [ 'Hire purchase',
    'Indicates that an item is supplied under the special condition of hire purchase.' ],
'103' => [ 'Loan',
    'Indicates that an item is supplied under the special condition of a loan.' ],
'104' => [ 'Rental',
    'Indicates that an item is supplied under the special condition of rental.' ],
'105' => [ 'Processing',
    'Indicates that the predominant operation is an administrative or technical process.' ],
'106' => [ 'Exchange',
    'Indicates that an item is supplied under the special condition as an exchange.' ],
'107' => [ 'Sale on commission',
    'Indicates that an item is supplied under the special condition of sale on commission.' ],
'108' => [ 'Financial compensation',
    'Indicates that an item is supplied under the special condition as financial compensation.' ],
'109' => [ 'Sale or return',
    'Item concerned may be returned to supplier or otherwise disposed of if it remains unsold after a pre-determined period of time.' ],
'110' => [ 'Final settlement',
    'Settlement will not be subject to further adjustment.' ],
'111' => [ 'Requires national pricing authority agreement',
    'Provides an indication to the receiving party that the information provided requires national pricing authority agreement.' ],
'112' => [ 'National pricing authority approved price',
    'Provides an indication to the receiving party that the price provided has been agreed by the national pricing authority.' ],
'113' => [ 'Not subject to national pricing authority approval',
    'Provides an indication to the receiving party that the price provided is not subject to approval by the national pricing authority.' ],
'114' => [ 'Agency approved price',
    'Provides an indication to the receiving party that the price has been approved by an agreed agency.' ],
'115' => [ 'Exempt from tax',
    'To indicate that the product, goods, or services is exempt from taxes.' ],
'116' => [ 'Subject to postponed discount',
    'The item concerned is applicable for postponed discount which will be refunded via a later credit.' ],
'117' => [ 'Repair',
    'The special conditions are related to repairs.' ],
'118' => [ 'Illustration affected by provisioning change',
    'Indication that a change to provisioning data affects the related illustrations but not the technical content.' ],
'119' => [ 'Product genetically modified',
    'An indication that a product has been genetically modified during its production process.' ],
'120' => [ 'Subject to price recalculation without negotiation',
    'The price may be recalculated without negotiation.' ],
'121' => [ 'Not subject to price recalculation without negotiation',
    'The price may not be recalculated without negotiation.' ],
'122' => [ 'Bonded',
    'A code to indicate that the product is bonded.' ],
'123' => [ 'Pharmacy sales only',
    'A special condition limiting the sale of a product to a pharmacy.' ],
'124' => [ 'Sale requires medical prescription',
    'The sale of the product requires a medical prescription.' ],
'125' => [ 'New item, not yet available',
    'The item is new and not yet available.' ],
'126' => [ 'New, available',
    'The item is new and available.' ],
'127' => [ 'Obsolete',
    'The item is obsolete.' ],
'128' => [ 'Prototype',
    'The item is a prototype and is not yet in normal production.' ],
'129' => [ 'Non-standard product',
    'This item is not a standard product.' ],
'130' => [ 'Discontinued',
    'The item is no longer available.' ],
'131' => [ 'Expired catalogue prices provisionally allowed',
    'The use of prices from an expired catalogue is provisionally allowed.' ],
'132' => [ 'Not subject to automated processing',
    'The conditions to be applied are of a complex nature and are not subject to automated processing.' ],
'133' => [ 'Gift supplied with purchase',
    'Product made available as a gift to a customer when purchasing an accompanying product.' ],
'134' => [ 'Sale from promotional stock',
    'An indication that products sold came from promotional stock.' ],
'135' => [ 'Sale from obsolete stock',
    'An indication that products sold came from obsolete stock.' ],
'136' => [ 'Buying group conditions',
    'A code indicating that buying group conditions apply.' ],
'137' => [ 'Cancel order unless complete delivery possible on requested',
    'date and or time Code indicating that the order is to be cancelled if complete delivery is not possible on the date and or time requested in the order.' ],
'138' => [ 'Delivery subject to final authorisation from supplier',
    "Delivery of an order should not be made until the final authorisation from the supplier or supplier's agent has been received." ],
'139' => [ 'Special promotional conditions applicable to only this',
    'invoice A code indicating that special promotional conditions are in force which only apply to the current invoice.' ],
'140' => [ 'Return of goods',
    'Special conditions related to the return of goods.' ],
'141' => [ 'Subject to annual bonus',
    'Item concerned is applicable for annual bonus calculation.' ],
'142' => [ 'Invoiced but not replenished',
    'A special condition indicating the fact that goods which have not yet been replenished have been invoiced.' ],
'143' => [ 'Replenished but not invoiced',
    'A special condition indicating the fact that goods which have been replenished have not yet been invoiced.' ],
'144' => [ 'Deliver full order',
    'A special condition indicating that delivery of the order will only be accepted in full.' ],
'145' => [ 'Roll pattern side out',
    'An instruction to roll a product with the pattern side facing out.' ],
'146' => [ 'Roll pattern side in',
    'An instruction to roll a product with the pattern side facing in.' ],
'147' => [ 'Special handling requirements at point of receipt',
    'An indication that the product requires special handling at the point of receipt.' ],
'148' => [ 'Supply direct delivery',
    'Goods to be supplied direct delivery to the delivery store and not through a distribution centre or a warehouse.' ],
'149' => [ 'Single item pallet',
    'Goods to be supplied on single item pallet.' ],
'150' => [ 'Mixed item pallet',
    'Goods to be supplied on mixed item pallet.' ],
'151' => [ 'Items from the same dye lot',
    'The items should be supplied from the same dye lot.' ],
'152' => [ 'Awaiting credit clearance',
    'Processing of the referenced document is delayed while credit clearance is obtained.' ],
'153' => [ 'Return publication full copies',
    'Return the full copies of a publication.' ],
'154' => [ 'Return publication headings only',
    'Return only the heading of a publication.' ],
'155' => [ 'Destroy publication',
    'Destroy the publication by whatever means, but in such a way that it cannot be read afterwards.' ],
'156' => [ 'Await further product instructions',
    'Wait for further instructions as to what to do with the products.' ],
'157' => [ 'Not subject to sale or return',
    'Product supplied not subject to sale or return.' ],
'158' => [ 'Item to be sold in both domestic and export markets',
    'The item will be sold in both the domestic and export markets.' ],
'159' => [ 'Item to be sold only in export markets',
    'The item will be sold only in export markets.' ],
'160' => [ 'No back orders',
    'Indication that no back orders are permitted.' ],
'161' => [ 'Back orders permitted',
    'Indication that back orders are permitted.' ],
'162' => [ 'At home repair',
    'The repair is carried out at the house of the client.' ],
'163' => [ 'At service centre repair',
    'The repair is carried out at a service centre.' ],
'164' => [ 'Shipment completes order',
    'There will be no further shipments for this order as it is considered complete.' ],
'165' => [ 'Split shipment',
    'Subsequent shipment(s) will arrive for this order as it has been split over more than one shipment.' ],
'166' => [ 'Include in continuous replenishment calculation',
    'An indication that a product or group of products are to be included in the continuous replenishment calculation.' ],
'167' => [ 'Remove from continuous replenishment calculation',
    'An indication that a product or group of products are to be removed from the continuous replenishment calculation.' ],
'168' => [ 'Standard pack shipment',
    'The shipment contains only standard packs.' ],
'169' => [ 'Pick pack shipment',
    'The shipment contains only packages resulting from a pick and pack operation.' ],
'170' => [ 'Goods for retail outlet shelf',
    'Goods to be placed on a retail outlet shelf.' ],
'171' => [ 'Security stock',
    'The goods are required to maintain the security stock.' ],
'172' => [ 'Production batch number allocated',
    'A batch number is allocated by the manufacturer to the item.' ],
'173' => [ 'Production batch number allocated as required by law',
    'A batch number is allocated by the manufacturer to the item as required by law.' ],
'174' => [ 'Product not genetically modified',
    'An indication that a product has not been genetically modified during its production process.' ],
'175' => [ 'Suspended',
    'An item whose production or distribution has been suspended.' ],
'176' => [ 'No re-ordering',
    'The item will not be re-ordered.' ],
'177' => [ 'Product irradiated for preservation',
    'An indication that a product has had radioactive rays directed onto it to preserve it.' ],
'178' => [ 'Services taxable at customer location',
    'Services which, for taxation purposes, are considered to be supplied at the customer location, as per the 6th European Council directive of 17 May, 1997 Article 9.2 (e).' ],
'179' => [ 'Product gluten-free',
    'An indication that a product does not contain any gluten.' ],
'180' => [ 'Product contains gluten',
    'An indication that a product contains gluten.' ],
'181' => [ 'Product lactose-free',
    'An indication that a product does not contain any lactose.' ],
'182' => [ 'Product contains lactose',
    'An indication that a product contains lactose.' ],
'183' => [ 'CH, compliant with Genetically Modified Food law',
    'An indication that a product complies with the Swiss law on genetically modified food.' ],
'184' => [ 'CH, non-compliant with Genetically Modified Food law',
    'An indication that a product does not comply with the Swiss law on genetically modified food.' ],
'185' => [ 'CH, compliant with General Food law',
    'An indication that a product complies with the Swiss general food law.' ],
'186' => [ 'CH, non-compliant with General Food law',
    'An indication that a product does not comply with the Swiss general food law.' ],
'187' => [ 'Store may not order',
    'The store is not allowed to order.' ],
'188' => [ 'Distribution centre may not order',
    'Distribution centre is not allowed to order.' ],
'189' => [ 'Net content declaration indicated',
    "A declaration of a trade item's net content is on the product label." ],
'190' => [ 'Net content declaration not indicated',
    "A declaration of a trade item's net content is not on the product label." ],
'191' => [ 'Not irradiated',
    'Radiation has not been applied.' ],
'192' => [ 'Batch or lot number not allocated',
    'The trade item has no batch or lot number.' ],
'193' => [ 'Unsold trade item not returnable',
    'A trade item that is not sold cannot be returned.' ],
'194' => [ 'Ingredient irradiated',
    "Radiation has been applied to a trade item's ingredient." ],
'195' => [ 'Ingredients not irradiated',
    "Radiation has not been applied to any trade item's ingredient." ],
'196' => [ 'Raw material irradiated',
    "Radiation has been applied to a trade item's raw material." ],
'197' => [ 'Raw material not irradiated',
    "Radiation has not been applied to any trade item's raw material." ],
'198' => [ 'Re-orderable',
    'The item may be re-ordered.' ],
'199' => [ 'Receipt advice, fully detailed',
    'Includes qualitative and/or quantitative details regarding everything received (all line items) whether or not there were exceptions between what was received and what was advised as being sent.' ],
'200' => [ 'Receipt advice, only exceptions',
    'Includes only qualitative and/or quantitative exceptions between what was received and what was advised as being sent.' ],
'201' => [ 'Ingredient is irradiated not applicable',
    'The indication that an ingredient of a trade item is irradiated is not applicable.' ],
'202' => [ 'Raw material is irradiated not applicable',
    'The indication that raw material of a trade item is irradiated is not applicable.' ],
'203' => [ 'Trade item is genetically modified not applicable',
    'The indication that a product has not been genetically modified is not applicable.' ],
'204' => [ 'Trade item is irradiated not applicable',
    'The indication that a trade item is irradiated is not applicable.' ],
'205' => [ 'Size dependent pricing',
    'An item price may be different depending on the size.' ],
'206' => [ 'Size independent pricing',
    'An item price is independent of the size.' ],
'ZZZ' => [ 'Mutually defined',
    'Special condition mutually agreed between interchanging parties.' ],
);
sub get_codes { return \%code_hash; }

1;
