# Generated by default/object.tt
package Paws::Lightsail::ContainerServiceEndpoint;
  use Moose;
  has ContainerName => (is => 'ro', isa => 'Str', request_name => 'containerName', traits => ['NameInRequest']);
  has ContainerPort => (is => 'ro', isa => 'Int', request_name => 'containerPort', traits => ['NameInRequest']);
  has HealthCheck => (is => 'ro', isa => 'Paws::Lightsail::ContainerServiceHealthCheckConfig', request_name => 'healthCheck', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Lightsail::ContainerServiceEndpoint

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Lightsail::ContainerServiceEndpoint object:

  $service_obj->Method(Att1 => { ContainerName => $value, ..., HealthCheck => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Lightsail::ContainerServiceEndpoint object:

  $result = $service_obj->Method(...);
  $result->Att1->ContainerName

=head1 DESCRIPTION

Describes the public endpoint configuration of a deployment of an
Amazon Lightsail container service.

=head1 ATTRIBUTES


=head2 ContainerName => Str

The name of the container entry of the deployment that the endpoint
configuration applies to.


=head2 ContainerPort => Int

The port of the specified container to which traffic is forwarded to.


=head2 HealthCheck => L<Paws::Lightsail::ContainerServiceHealthCheckConfig>

An object that describes the health check configuration of the
container.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Lightsail>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

