
use Test;
use strict;
use Math::Business::ADX;

# SYK from 5/31/06 -> 5/30/08 {{{
my @data_points = (
    [ 44.1800, 43.6500, 43.9000 ],
    [ 44.4300, 43.8900, 44.3100 ],
    [ 44.7000, 44.0900, 44.6500 ],
    [ 44.6400, 43.5900, 43.6100 ],
    [ 43.8500, 43.1600, 43.6700 ],
    [ 44.3500, 43.5800, 43.9500 ],
    [ 44.2400, 43.4800, 44.2100 ],
    [ 44.3200, 43.6700, 43.9300 ],
    [ 44.1500, 43.5500, 43.6300 ],
    [ 44.2900, 43.3000, 43.6300 ],
    [ 44.4100, 43.4200, 44.3200 ],
    [ 45.7200, 44.3000, 45.5500 ],
    [ 45.6000, 44.8100, 45.0600 ],
    [ 45.5000, 44.5600, 44.8200 ],
    [ 44.8100, 44.3400, 44.5500 ],
    [ 44.9500, 44.3300, 44.8200 ],
    [ 44.9800, 44.5900, 44.8700 ],
    [ 45.3000, 44.3100, 44.8800 ],
    [ 43.6000, 41.8800, 42.2000 ],
    [ 41.9900, 40.7700, 40.8800 ],
    [ 42.1700, 41.3800, 42.1200 ],
    [ 42.8200, 41.9900, 42.6100 ],
    [ 42.9400, 41.9400, 42.1100 ],
    [ 42.8100, 42.2800, 42.6400 ],
    [ 42.7000, 42.2500, 42.4500 ],
    [ 43.1900, 42.2500, 43.0300 ],
    [ 43.5200, 42.7000, 43.1500 ],
    [ 43.4200, 43.1100, 43.3200 ],
    [ 43.4700, 42.8400, 43.3200 ],
    [ 43.5900, 43.2300, 43.2300 ],
    [ 43.2300, 42.8100, 42.9300 ],
    [ 42.9900, 42.0600, 42.6200 ],
    [ 43.5400, 42.4500, 43.1300 ],
    [ 43.4800, 43.0100, 43.3300 ],
    [ 44.4900, 43.1200, 44.2500 ],
    [ 44.2300, 43.0100, 43.2000 ],
    [ 44.4900, 39.7700, 44.1300 ],
    [ 45.2100, 44.1000, 45.0100 ],
    [ 45.5700, 44.5800, 45.2000 ],
    [ 45.5500, 44.8500, 45.1900 ],
    [ 45.4900, 44.5400, 44.8100 ],
    [ 46.1900, 45.0000, 46.1100 ],
    [ 45.9700, 45.4500, 45.5100 ],
    [ 45.9300, 44.8600, 45.7500 ],
    [ 47.4500, 46.3200, 46.7300 ],
    [ 46.6300, 45.6900, 46.3100 ],
    [ 46.8100, 46.0800, 46.2800 ],
    [ 46.2800, 45.7300, 46.1800 ],
    [ 47.8700, 46.0700, 47.0500 ],
    [ 47.6300, 47.0000, 47.1700 ],
    [ 47.5500, 46.9500, 47.0700 ],
    [ 47.1300, 46.4100, 46.5800 ],
    [ 47.2000, 46.4300, 46.4800 ],
    [ 46.9700, 46.3900, 46.8100 ],
    [ 47.2900, 46.6900, 47.2000 ],
    [ 48.0700, 46.7400, 47.6400 ],
    [ 47.6400, 46.8000, 47.3800 ],
    [ 47.8600, 47.0600, 47.6800 ],
    [ 47.6000, 47.1200, 47.4900 ],
    [ 47.4500, 45.9900, 46.0400 ],
    [ 47.0600, 46.2500, 46.7700 ],
    [ 47.6300, 46.6900, 47.6000 ],
    [ 48.5900, 47.3900, 48.2800 ],
    [ 48.5800, 48.0100, 48.2700 ],
    [ 48.3600, 47.8400, 48.1000 ],
    [ 48.0300, 47.6900, 48.0300 ],
    [ 48.2800, 47.8000, 48.0500 ],
    [ 48.1400, 47.7400, 47.8200 ],
    [ 48.2300, 47.4600, 47.8400 ],
    [ 48.2000, 47.8000, 48.0300 ],
    [ 48.9500, 47.7600, 48.8200 ],
    [ 49.4400, 48.6600, 49.3800 ],
    [ 49.9400, 49.1700, 49.9000 ],
    [ 50.1500, 49.0400, 49.8300 ],
    [ 50.2500, 49.4500, 50.2400 ],
    [ 51.0000, 50.1800, 50.9200 ],
    [ 51.0000, 50.5500, 50.7000 ],
    [ 50.9000, 50.3900, 50.6200 ],
    [ 50.7700, 49.9500, 50.6300 ],
    [ 50.8700, 49.9800, 50.3600 ],
    [ 50.3500, 49.7000, 50.1200 ],
    [ 50.4200, 49.5100, 50.0600 ],
    [ 50.7500, 49.8200, 49.9600 ],
    [ 50.1000, 49.3700, 50.0300 ],
    [ 50.0500, 49.2200, 49.6200 ],
    [ 50.0000, 49.2900, 49.5900 ],
    [ 49.7900, 48.8700, 49.1400 ],
    [ 49.6900, 48.8300, 49.5200 ],
    [ 50.5000, 49.2100, 50.1700 ],
    [ 51.3500, 50.5600, 51.2400 ],
    [ 51.2200, 50.5800, 50.7200 ],
    [ 51.1700, 50.5600, 50.8900 ],
    [ 51.1500, 50.4000, 50.7500 ],
    [ 51.4100, 50.4000, 50.6800 ],
    [ 51.4000, 50.7600, 51.3000 ],
    [ 51.2500, 50.3100, 50.4100 ],
    [ 50.8500, 50.1300, 50.2700 ],
    [ 50.2500, 49.0000, 49.8100 ],
    [ 52.8500, 51.2000, 52.7300 ],
    [ 52.9000, 51.9400, 52.4300 ],
    [ 52.9300, 52.0600, 52.7300 ],
    [ 54.0000, 52.2000, 53.7200 ],
    [ 54.3500, 53.1700, 53.9200 ],
    [ 54.1000, 53.2500, 53.7000 ],
    [ 53.3300, 52.6400, 53.1100 ],
    [ 53.1200, 52.4100, 52.6500 ],
    [ 53.1300, 52.2100, 52.3300 ],
    [ 52.5600, 51.5600, 52.2900 ],
    [ 52.7500, 51.6700, 51.8500 ],
    [ 52.1300, 51.4000, 51.9500 ],
    [ 52.1900, 51.2900, 51.4400 ],
    [ 52.6500, 51.6900, 52.5200 ],
    [ 52.6300, 52.2000, 52.4200 ],
    [ 52.1000, 51.4900, 51.9000 ],
    [ 51.9000, 50.4500, 50.6400 ],
    [ 51.1200, 50.1500, 51.0300 ],
    [ 51.3300, 50.6000, 50.9600 ],
    [ 51.4500, 50.7700, 51.3500 ],
    [ 52.8900, 51.8700, 52.0800 ],
    [ 52.5000, 51.9300, 52.2700 ],
    [ 52.2900, 51.7600, 52.2200 ],
    [ 52.0400, 51.2500, 51.2600 ],
    [ 52.0000, 51.2000, 51.7800 ],
    [ 52.5100, 51.7000, 52.3200 ],
    [ 53.0000, 51.7500, 52.2000 ],
    [ 52.2000, 51.7400, 52.0000 ],
    [ 52.1000, 51.2000, 51.5200 ],
    [ 51.9600, 51.4300, 51.9500 ],
    [ 52.2000, 51.5200, 51.8600 ],
    [ 52.7600, 51.9000, 52.4300 ],
    [ 53.5400, 52.6300, 53.4200 ],
    [ 53.9600, 53.0000, 53.9600 ],
    [ 54.1800, 53.2800, 53.8500 ],
    [ 54.1400, 53.1500, 53.3300 ],
    [ 53.9200, 53.0000, 53.6100 ],
    [ 54.3700, 53.8300, 54.3200 ],
    [ 55.5500, 54.0100, 55.0800 ],
    [ 55.5000, 55.1100, 55.4500 ],
    [ 55.9200, 54.9300, 55.1100 ],
    [ 55.1900, 54.7800, 54.8700 ],
    [ 55.5900, 54.8800, 55.1300 ],
    [ 55.4500, 54.8800, 55.3300 ],
    [ 55.5300, 55.0100, 55.4400 ],
    [ 55.5200, 54.8900, 55.2000 ],
    [ 55.1900, 54.6200, 54.8300 ],
    [ 55.2300, 54.6400, 55.1400 ],
    [ 55.4800, 55.0900, 55.3300 ],
    [ 55.5500, 55.1000, 55.4500 ],
    [ 55.3200, 54.9000, 55.1100 ],
    [ 55.7500, 54.8900, 55.1200 ],
    [ 55.6900, 55.0100, 55.6000 ],
    [ 55.9300, 55.3200, 55.8300 ],
    [ 56.7800, 55.8500, 56.0900 ],
    [ 56.9600, 56.2100, 56.8700 ],
    [ 57.6400, 56.3000, 57.6400 ],
    [ 59.0200, 57.6300, 58.9500 ],
    [ 59.3400, 58.4300, 58.7700 ],
    [ 59.0000, 58.5000, 58.7700 ],
    [ 58.9600, 58.4600, 58.4900 ],
    [ 59.1800, 58.4300, 59.0000 ],
    [ 59.0000, 58.0200, 58.9500 ],
    [ 59.0100, 58.2400, 58.2400 ],
    [ 58.3800, 57.6600, 58.3000 ],
    [ 58.8600, 57.8500, 58.7800 ],
    [ 59.1200, 58.1200, 58.8400 ],
    [ 60.9500, 59.0600, 60.8100 ],
    [ 62.1700, 60.7200, 61.7800 ],
    [ 62.3000, 61.0000, 61.8600 ],
    [ 62.3700, 61.3400, 61.9400 ],
    [ 63.5000, 61.8400, 62.4600 ],
    [ 62.8700, 62.1600, 62.4100 ],
    [ 62.6500, 62.0500, 62.3900 ],
    [ 62.5400, 61.9500, 61.9500 ],
    [ 62.4200, 61.7000, 62.4000 ],
    [ 62.9700, 61.7200, 62.5100 ],
    [ 62.8100, 61.7400, 62.1100 ],
    [ 62.5000, 61.8900, 61.9400 ],
    [ 62.7500, 61.9000, 62.6500 ],
    [ 62.7000, 61.3200, 61.8200 ],
    [ 62.2700, 61.7900, 62.1300 ],
    [ 62.5700, 61.6200, 62.0500 ],
    [ 62.6600, 61.5200, 62.2800 ],
    [ 62.4900, 61.8700, 62.2500 ],
    [ 64.2700, 61.4500, 63.4500 ],
    [ 64.2500, 63.4900, 64.1300 ],
    [ 63.6200, 62.2300, 62.3000 ],
    [ 62.3600, 59.4400, 60.5200 ],
    [ 62.2800, 60.0000, 62.0200 ],
    [ 62.0000, 59.0100, 61.3700 ],
    [ 61.6500, 60.6700, 61.0000 ],
    [ 61.4200, 58.0500, 60.8900 ],
    [ 61.8200, 60.5300, 61.6500 ],
    [ 62.1600, 61.3300, 61.9100 ],
    [ 63.0100, 62.1000, 62.6900 ],
    [ 63.3400, 62.3800, 63.0800 ],
    [ 64.1800, 62.8100, 64.0300 ],
    [ 64.3500, 63.4900, 63.6800 ],
    [ 64.5000, 63.5000, 64.3500 ],
    [ 64.8700, 64.0400, 64.6100 ],
    [ 65.4800, 64.4900, 65.2200 ],
    [ 65.8000, 65.3100, 65.5500 ],
    [ 66.8100, 65.2500, 66.7000 ],
    [ 67.1400, 65.6200, 66.6100 ],
    [ 66.8500, 65.7500, 65.9400 ],
    [ 66.0800, 65.1400, 65.2600 ],
    [ 65.6600, 64.5700, 65.5900 ],
    [ 65.7900, 65.0000, 65.5200 ],
    [ 65.9900, 65.0200, 65.6800 ],
    [ 66.1800, 65.2500, 65.8100 ],
    [ 66.5100, 65.4800, 66.3200 ],
    [ 67.2500, 66.2500, 67.2300 ],
    [ 67.8200, 67.1800, 67.6400 ],
    [ 67.9700, 66.9500, 67.6700 ],
    [ 68.2800, 67.1200, 68.2800 ],
    [ 69.0000, 68.0500, 68.4900 ],
    [ 68.8100, 67.6200, 67.8700 ],
    [ 68.1000, 67.0100, 67.6800 ],
    [ 68.1600, 67.5700, 67.9100 ],
    [ 68.1500, 67.1800, 67.9600 ],
    [ 68.9600, 68.0000, 68.9600 ],
    [ 70.2600, 68.9300, 70.0600 ],
    [ 70.0600, 68.9300, 69.1000 ],
    [ 68.7000, 63.0000, 66.0100 ],
    [ 67.2900, 65.2700, 66.8200 ],
    [ 67.1000, 66.3900, 66.8300 ],
    [ 67.0900, 66.1800, 66.7600 ],
    [ 66.9300, 66.2100, 66.7200 ],
    [ 66.6800, 65.8600, 66.0800 ],
    [ 66.2800, 65.4100, 65.4200 ],
    [ 65.6400, 64.5100, 64.9400 ],
    [ 65.6000, 64.6300, 65.2300 ],
    [ 65.4500, 64.8500, 65.1500 ],
    [ 65.4700, 64.7300, 65.0900 ],
    [ 66.2700, 65.1700, 65.8600 ],
    [ 66.3400, 65.6500, 65.9600 ],
    [ 65.9300, 64.9900, 65.6100 ],
    [ 65.8100, 64.9400, 65.4000 ],
    [ 65.3100, 64.3100, 64.5400 ],
    [ 64.8800, 64.1300, 64.5400 ],
    [ 64.8600, 63.7500, 64.4100 ],
    [ 65.0700, 64.1500, 64.4400 ],
    [ 66.4900, 64.4000, 66.4600 ],
    [ 67.2100, 66.3200, 66.9000 ],
    [ 67.4800, 66.5400, 67.3600 ],
    [ 67.9300, 66.9400, 67.1600 ],
    [ 67.7300, 66.9000, 67.3700 ],
    [ 68.2800, 67.2200, 67.3200 ],
    [ 67.9000, 66.8000, 66.9100 ],
    [ 67.1900, 66.5000, 66.9700 ],
    [ 67.0700, 66.2800, 66.6100 ],
    [ 67.0200, 66.0800, 67.0200 ],
    [ 67.5200, 66.9000, 67.3100 ],
    [ 67.6000, 66.8600, 67.1400 ],
    [ 67.8500, 66.9400, 67.6700 ],
    [ 67.6200, 66.9400, 67.3000 ],
    [ 67.2000, 66.1100, 66.5800 ],
    [ 66.4600, 64.9100, 65.0400 ],
    [ 65.4800, 64.5300, 65.2700 ],
    [ 65.9500, 65.0500, 65.3900 ],
    [ 65.2900, 64.0700, 64.1300 ],
    [ 64.9800, 63.5400, 64.9200 ],
    [ 65.5000, 64.9000, 64.9000 ],
    [ 66.5000, 65.2400, 66.3600 ],
    [ 67.0300, 65.8000, 66.4700 ],
    [ 67.0600, 65.8600, 66.2800 ],
    [ 66.6100, 65.3400, 65.3600 ],
    [ 65.6500, 64.9600, 65.1200 ],
    [ 65.0600, 63.0800, 63.5300 ],
    [ 64.1700, 62.9500, 63.1600 ],
    [ 64.2700, 63.1900, 63.9700 ],
    [ 64.4000, 63.5500, 64.3700 ],
    [ 64.3100, 60.8600, 63.7500 ],
    [ 64.0400, 62.7800, 63.0900 ],
    [ 63.5000, 62.9000, 63.4600 ],
    [ 63.9700, 63.4500, 63.9500 ],
    [ 63.9400, 62.9400, 63.7600 ],
    [ 65.4900, 63.7700, 65.3100 ],
    [ 65.3900, 64.5900, 65.2500 ],
    [ 65.0300, 64.0000, 64.0700 ],
    [ 65.2100, 64.0700, 65.2100 ],
    [ 66.5700, 64.9800, 66.5700 ],
    [ 66.7300, 65.4500, 66.6000 ],
    [ 67.8500, 66.7500, 67.4900 ],
    [ 68.9000, 67.0000, 67.5300 ],
    [ 67.7600, 66.7900, 67.3200 ],
    [ 67.8900, 67.1000, 67.5900 ],
    [ 68.4500, 66.6200, 67.1600 ],
    [ 68.1600, 66.9100, 66.9700 ],
    [ 67.4900, 66.3800, 66.5100 ],
    [ 66.6500, 65.3500, 66.0200 ],
    [ 65.4900, 63.5100, 64.3600 ],
    [ 64.4900, 62.8300, 63.0000 ],
    [ 64.2500, 61.8500, 64.2500 ],
    [ 64.2300, 62.4300, 62.4300 ],
    [ 63.4600, 62.2200, 63.1400 ],
    [ 63.9200, 62.6900, 63.6800 ],
    [ 63.9700, 62.4300, 62.4300 ],
    [ 65.5000, 62.8500, 65.1400 ],
    [ 67.2200, 64.3600, 66.6200 ],
    [ 68.9000, 65.9500, 68.9000 ],
    [ 70.1100, 67.5600, 67.5600 ],
    [ 68.6300, 65.8500, 66.0800 ],
    [ 66.3800, 64.5200, 65.3600 ],
    [ 65.7500, 64.1300, 64.1300 ],
    [ 65.2300, 64.0700, 64.4100 ],
    [ 65.1600, 63.5100, 64.9100 ],
    [ 67.3400, 64.5000, 67.2700 ],
    [ 67.8500, 66.4200, 66.8600 ],
    [ 66.8700, 65.5000, 66.3200 ],
    [ 67.3400, 66.3800, 67.2900 ],
    [ 67.9800, 66.5200, 66.9500 ],
    [ 67.3400, 66.7500, 67.1900 ],
    [ 67.8500, 67.0900, 67.0900 ],
    [ 67.3700, 65.6900, 65.7500 ],
    [ 66.8000, 65.5900, 66.7500 ],
    [ 67.2000, 65.8700, 66.6300 ],
    [ 67.5000, 66.4300, 66.8000 ],
    [ 67.4800, 66.5000, 67.2100 ],
    [ 67.0000, 66.3900, 66.6300 ],
    [ 68.2100, 66.3400, 68.1800 ],
    [ 68.4100, 67.1600, 67.2800 ],
    [ 67.9400, 66.8800, 67.5400 ],
    [ 68.9800, 67.9000, 68.9400 ],
    [ 69.4600, 68.6100, 68.8700 ],
    [ 69.7700, 69.1300, 69.4500 ],
    [ 70.4900, 69.1500, 70.0900 ],
    [ 69.7500, 66.9100, 67.2000 ],
    [ 68.3700, 66.6000, 68.1800 ],
    [ 68.8600, 67.8000, 68.6800 ],
    [ 69.0200, 68.1000, 68.2400 ],
    [ 68.8900, 67.6800, 68.0100 ],
    [ 68.0800, 66.9900, 67.2800 ],
    [ 68.1100, 67.0100, 67.6700 ],
    [ 68.1500, 67.5700, 67.9000 ],
    [ 69.4000, 67.8100, 68.8800 ],
    [ 69.0500, 68.5200, 68.7600 ],
    [ 70.1300, 68.9400, 70.1300 ],
    [ 71.3000, 69.6600, 70.5400 ],
    [ 71.8900, 70.2200, 71.7900 ],
    [ 72.8100, 71.5300, 72.6000 ],
    [ 73.4700, 72.5100, 73.1400 ],
    [ 73.4000, 72.3500, 72.4800 ],
    [ 73.4700, 72.6700, 73.4700 ],
    [ 73.6300, 72.9000, 73.3300 ],
    [ 74.6700, 73.0400, 73.1300 ],
    [ 74.0700, 72.9000, 73.9200 ],
    [ 74.5000, 72.1600, 72.8000 ],
    [ 72.7300, 71.7900, 72.2700 ],
    [ 73.4800, 71.8200, 72.1900 ],
    [ 74.5000, 72.4800, 74.5000 ],
    [ 74.2700, 71.8800, 71.8800 ],
    [ 71.6300, 70.6900, 71.0600 ],
    [ 72.0000, 71.2600, 71.5800 ],
    [ 71.7300, 70.4500, 71.5100 ],
    [ 71.0200, 69.1500, 70.6100 ],
    [ 71.4600, 70.7800, 70.9500 ],
    [ 72.0100, 71.0300, 71.2700 ],
    [ 71.6400, 70.7600, 70.9100 ],
    [ 71.4100, 70.3200, 71.0000 ],
    [ 71.0200, 69.4900, 69.5700 ],
    [ 72.9300, 68.9500, 69.5300 ],
    [ 70.0200, 68.8800, 69.7500 ],
    [ 70.1000, 69.1700, 70.0000 ],
    [ 69.3500, 67.6100, 67.6500 ],
    [ 68.7500, 67.7100, 68.7000 ],
    [ 70.5300, 67.9300, 70.0400 ],
    [ 70.4600, 69.5700, 70.0500 ],
    [ 70.9500, 69.3300, 70.8700 ],
    [ 71.5000, 70.7200, 70.7800 ],
    [ 71.6900, 70.4500, 70.8200 ],
    [ 71.5500, 69.6200, 69.8700 ],
    [ 70.5000, 69.2900, 70.1600 ],
    [ 72.6500, 70.3700, 71.8700 ],
    [ 72.0500, 70.2300, 70.2800 ],
    [ 70.8700, 70.0300, 70.6400 ],
    [ 71.2100, 69.5200, 69.5200 ],
    [ 71.5900, 69.9400, 71.5100 ],
    [ 72.9300, 71.0500, 72.7900 ],
    [ 72.7000, 71.7500, 72.2300 ],
    [ 73.2300, 72.2400, 72.6300 ],
    [ 73.0800, 72.0300, 72.5600 ],
    [ 73.5000, 71.7000, 72.9000 ],
    [ 74.2300, 73.2200, 74.0600 ],
    [ 75.0000, 73.6400, 75.0000 ],
    [ 75.0200, 74.4200, 74.6700 ],
    [ 76.0200, 74.7300, 75.4800 ],
    [ 75.5800, 73.8500, 73.9100 ],
    [ 75.5100, 73.9400, 74.7000 ],
    [ 75.0200, 74.0500, 74.9700 ],
    [ 75.2000, 74.2100, 74.2700 ],
    [ 74.5700, 72.5000, 73.4400 ],
    [ 74.4500, 73.0300, 74.0800 ],
    [ 75.0500, 73.9600, 74.8500 ],
    [ 75.5900, 74.7100, 75.2600 ],
    [ 76.8000, 75.1000, 76.2100 ],
    [ 76.8900, 75.8000, 76.1600 ],
    [ 76.7500, 76.0100, 76.4800 ],
    [ 76.6500, 75.3500, 75.3500 ],
    [ 76.2900, 75.2500, 75.7300 ],
    [ 75.7300, 74.6000, 74.7200 ],
    [ 74.8200, 73.2500, 73.6000 ],
    [ 74.9400, 73.6100, 73.8300 ],
    [ 73.3900, 72.2600, 72.2600 ],
    [ 73.2200, 72.3300, 72.7100 ],
    [ 73.6000, 72.1200, 72.4000 ],
    [ 72.6700, 70.5600, 70.9500 ],
    [ 70.5600, 68.7500, 69.6400 ],
    [ 72.4700, 68.9300, 72.1000 ],
    [ 72.9000, 71.7000, 72.4600 ],
    [ 72.6600, 70.3000, 71.1100 ],
    [ 70.6600, 68.9000, 69.7500 ],
    [ 70.6700, 68.5500, 68.6200 ],
    [ 69.0000, 65.3300, 65.8600 ],
    [ 65.8600, 58.8600, 64.7500 ],
    [ 66.9100, 63.1000, 66.6900 ],
    [ 71.2500, 67.7700, 68.3500 ],
    [ 69.1200, 66.3100, 66.4200 ],
    [ 66.8300, 65.6500, 66.3700 ],
    [ 68.4600, 66.9100, 67.4500 ],
    [ 67.7200, 66.5900, 66.6700 ],
    [ 67.2300, 65.2500, 66.9700 ],
    [ 68.0000, 66.5600, 67.8800 ],
    [ 68.2700, 67.4300, 67.5800 ],
    [ 67.2400, 65.8300, 65.9100 ],
    [ 66.5800, 65.5600, 66.2200 ],
    [ 68.1400, 66.0000, 68.1400 ],
    [ 68.4800, 67.2400, 67.9500 ],
    [ 68.1400, 67.4000, 67.8000 ],
    [ 69.2500, 67.7500, 69.0800 ],
    [ 70.2400, 69.1400, 70.0600 ],
    [ 70.5600, 68.7300, 68.8300 ],
    [ 68.7300, 67.4000, 68.3100 ],
    [ 69.4200, 68.2300, 68.5400 ],
    [ 68.3200, 66.4600, 67.3500 ],
    [ 68.0700, 66.4300, 66.6900 ],
    [ 67.5300, 65.7400, 66.8200 ],
    [ 67.9500, 66.5000, 67.8000 ],
    [ 67.9300, 67.0000, 67.5900 ],
    [ 67.3900, 66.2700, 66.3400 ],
    [ 66.6700, 65.5400, 66.0400 ],
    [ 65.9900, 64.5500, 65.1100 ],
    [ 65.3000, 64.5000, 65.3000 ],
    [ 65.8400, 64.5900, 65.6900 ],
    [ 66.6600, 65.3000, 65.7300 ],
    [ 65.5000, 64.5000, 64.5200 ],
    [ 64.3000, 62.6300, 62.7200 ],
    [ 62.8800, 59.6000, 59.7400 ],
    [ 62.3900, 59.5000, 61.2100 ],
    [ 62.3600, 60.8300, 61.1300 ],
    [ 60.4100, 58.4500, 60.0300 ],
    [ 61.4500, 59.9700, 60.7800 ],
    [ 61.0100, 58.5000, 60.4600 ],
    [ 62.8000, 60.1500, 62.7800 ],
    [ 64.6600, 62.0600, 62.0600 ],
    [ 64.2100, 62.2500, 64.2100 ],
    [ 64.9900, 64.1500, 64.8500 ],
    [ 65.9200, 64.8100, 65.5000 ],
    [ 65.5200, 63.6700, 64.1200 ],
    [ 65.7300, 62.9000, 65.2300 ],
    [ 66.3100, 64.5800, 64.7500 ],
    [ 65.3300, 64.2900, 65.0500 ],
    [ 67.1100, 65.1400, 67.1100 ],
    [ 67.5000, 66.3200, 66.6000 ],
    [ 67.0200, 65.0500, 65.6300 ],
    [ 66.1700, 65.5300, 65.8900 ],
    [ 67.5100, 65.5400, 65.8500 ],
    [ 66.2100, 65.5000, 66.0500 ],
    [ 66.4800, 65.5900, 65.8900 ],
    [ 65.9800, 65.2200, 65.5400 ],
    [ 65.4000, 63.9600, 64.0600 ],
    [ 64.1900, 63.3800, 63.5200 ],
    [ 63.9200, 62.5000, 62.7600 ],
    [ 63.5800, 62.4800, 63.4100 ],
    [ 64.4800, 62.8200, 63.9500 ],
    [ 66.4600, 64.8500, 65.3000 ],
    [ 66.5400, 64.8200, 65.0300 ],
    [ 64.5000, 63.3100, 63.8600 ],
    [ 65.2500, 63.7600, 64.8600 ],
    [ 64.7300, 63.6400, 64.0300 ],
    [ 64.9500, 64.2000, 64.4200 ],
    [ 64.7100, 64.1600, 64.3000 ],
    [ 65.9000, 64.1000, 65.4600 ],
    [ 65.9900, 64.6200, 64.8300 ],
    [ 65.7400, 63.8800, 65.6800 ],
    [ 66.0500, 62.5700, 63.6600 ],
    [ 63.7000, 61.2800, 62.1300 ],
    [ 62.7000, 61.2200, 62.6000 ],
    [ 63.0700, 62.0900, 62.1000 ],
    [ 64.6100, 62.1900, 64.6100 ],
    [ 64.9800, 63.6500, 64.4800 ],
    [ 64.5500, 63.6600, 64.3800 ],
    [ 64.5500, 63.3500, 63.9600 ],
    [ 64.9900, 63.9600, 64.1900 ],
    [ 64.1000, 62.6000, 62.8800 ],
    [ 63.6200, 62.5600, 63.2400 ],
    [ 63.2400, 62.3800, 62.5900 ],
    [ 62.9200, 61.9700, 62.3000 ],
    [ 63.3800, 62.1000, 62.4800 ],
    [ 63.1500, 62.1300, 62.9700 ],
    [ 62.8600, 62.0000, 62.1200 ],
    [ 62.9200, 62.0700, 62.6500 ],
    [ 63.3100, 62.4500, 63.1300 ],
    [ 63.9900, 62.8900, 63.7600 ],
    [ 64.6000, 63.6900, 64.5500 ],
);
# }}}

my $adx = recommended Math::Business::ADX;

my $EP = 20;
plan tests => 3*$EP + @data_points; $EP *= -1;

my $m = 14;
my @q;
for my $p (@data_points) {
    $adx->insert($p);

    my $q = $adx->query;
    my @a = $adx->query;

    if( defined $q ) {
        ok( $q>=0 and $q<=1 );
        push @q, \@a;

    } else {
        $m --;
        ok( $m >= 0 );
    }
}

my @ADX = (qw(12 13 13 14 13 12 12 11 11 11 11 10 11 11 10 11 10 10 10 10))[ $EP .. -1 ];
my @PDI = (qw(21 19 17 18 23 23 22 21 22 20 19 19 18 19 18 17 17 18 21 23))[ $EP .. -1 ];
my @MDI = (qw(24 27 26 25 22 21 20 20 19 24 23 23 24 23 21 21 20 19 18 17))[ $EP .. -1 ];

my @QT = @q[ $EP .. -1 ];
die "grrr argh" unless @QT == @ADX;

# NOTE: the numbers differ some what based on rounding errors (probably)
# a) the sample numbers have been rounded; b) they may calculate DM or DI inits differently
for my $i (0 .. $#QT) {
    ok( abs( (100* $QT[$i][0]) - $PDI[$i] ) < 2.2 );
    ok( abs( (100* $QT[$i][1]) - $MDI[$i] ) < 2.2 );
    ok( abs( (100* $QT[$i][2]) - $ADX[$i] ) < 2.2 );
}
