#!/usr/bin/perl

use strict;
use warnings FATAL => 'all';


package MyApp::Controller::A;
{

    use GX::Controller;

    sub action_1 :Action {}

} 


package main;

use GX::Action;
use GX::Route::Dynamic;


use Test::More tests => 88;


my $Action = GX::Action->new(
    controller => MyApp::Controller::A->new,
    method     => 'action_1'
);


# host_regex compilation
{

    my @data = (

        [ 'a',     qr!^a$!,       [] ],
        [ 'a.b',   qr!^a\.b$!,    [] ],
        [ 'a.b.c', qr!^a\.b\.c$!, [] ],

        [ '{a}',     qr!^([^.]+)$!,          [ 'a' ]      ],
        [ '{a}.b',   qr!^([^.]+)\.b$!,       [ 'a' ]      ],
        [ '{a}.{b}', qr!^([^.]+)\.([^.]+)$!, [ 'a', 'b' ] ],
        [ 'a.{b}',   qr!^a\.([^.]+)$!,       [ 'b' ]      ],

        [ '{a:\d+}',            qr!^(\d+)$!,           [ 'a' ]      ],
        [ '{a:\d+}.b',          qr!^(\d+)\.b$!,        [ 'a' ]      ],
        [ '{a:\d+}.{b:[a-z]+}', qr!^(\d+)\.([a-z]+)$!, [ 'a', 'b' ] ],
        [ 'a.{b:\d+}',          qr!^a\.(\d+)$!,        [ 'b' ]      ],

        [ '{a:\d{2}}',                qr!^(\d{2})$!,               [ 'a' ]      ],
        [ '{a:\d{2,4}}.b',            qr!^(\d{2,4})\.b$!,          [ 'a' ]      ],
        [ '{a:\d{2}}.{b:[a-z]{2,4}}', qr!^(\d{2})\.([a-z]{2,4})$!, [ 'a', 'b' ] ],
        [ 'a.{b:\d{2}}',              qr!^a\.(\d{2})$!,            [ 'b' ]      ],

        [ '*',         qr!^(?:[^.]+)$!,                   []           ],
        [ '*.b',       qr!^(?:[^.]+)\.b$!,                []           ],
        [ '*.*',       qr!^(?:[^.]+)\.(?:[^.]+)$!,        []           ],
        [ 'a.*',       qr!^a\.(?:[^.]+)$!,                []           ],
        [ '{a}.*',     qr!^([^.]+)\.(?:[^.]+)$!,          [ 'a' ]      ],
        [ '{a}.*.b',   qr!^([^.]+)\.(?:[^.]+)\.b$!,       [ 'a' ]      ],
        [ '{a}.*.{b}', qr!^([^.]+)\.(?:[^.]+)\.([^.]+)$!, [ 'a', 'b' ] ],

        [ 'a:80',     qr!^a\:80$!,       [] ],
        [ 'a.b:80',   qr!^a\.b\:80$!,    [] ],
        [ 'a.b.c:80', qr!^a\.b\.c\:80$!, [] ],

        [ '{a}:80',     qr!^([^.]+)\:80$!,          [ 'a' ]      ],
        [ '{a}.b:80',   qr!^([^.]+)\.b\:80$!,       [ 'a' ]      ],
        [ '{a}.{b}:80', qr!^([^.]+)\.([^.]+)\:80$!, [ 'a', 'b' ] ],
        [ 'a.{b}:80',   qr!^a\.([^.]+)\:80$!,       [ 'b' ]      ],

        [ '{a:\d+}:80',            qr!^(\d+)\:80$!,           [ 'a' ]      ],
        [ '{a:\d+}.b:80',          qr!^(\d+)\.b\:80$!,        [ 'a' ]      ],
        [ '{a:\d+}.{b:[a-z]+}:80', qr!^(\d+)\.([a-z]+)\:80$!, [ 'a', 'b' ] ],
        [ 'a.{b:\d+}:80',          qr!^a\.(\d+)\:80$!,        [ 'b' ]      ],

        [ '{a:\d{2}}:80',                qr!^(\d{2})\:80$!,               [ 'a' ]      ],
        [ '{a:\d{2,4}}.b:80',            qr!^(\d{2,4})\.b\:80$!,          [ 'a' ]      ],
        [ '{a:\d{2}}.{b:[a-z]{2,4}}:80', qr!^(\d{2})\.([a-z]{2,4})\:80$!, [ 'a', 'b' ] ],
        [ 'a.{b:\d{2}}:80',              qr!^a\.(\d{2})\:80$!,            [ 'b' ]      ],

        [ '*:80',         qr!^(?:[^.]+)\:80$!,                   []           ],
        [ '*.b:80',       qr!^(?:[^.]+)\.b\:80$!,                []           ],
        [ '*.*:80',       qr!^(?:[^.]+)\.(?:[^.]+)\:80$!,        []           ],
        [ 'a.*:80',       qr!^a\.(?:[^.]+)\:80$!,                []           ],
        [ '{a}.*:80',     qr!^([^.]+)\.(?:[^.]+)\:80$!,          [ 'a' ]      ],
        [ '{a}.*.b:80',   qr!^([^.]+)\.(?:[^.]+)\.b\:80$!,       [ 'a' ]      ],
        [ '{a}.*.{b}:80', qr!^([^.]+)\.(?:[^.]+)\.([^.]+)\:80$!, [ 'a', 'b' ] ]

    );

    for ( @data ) {

        my ( $host, $host_regex, $host_variables ) = @{$_};

        my $route = GX::Route::Dynamic->new(
            action => $Action,
            host   => $host
        );

        is( $route->host_regex, $host_regex, "Host regex for \"$host\"" );

        is_deeply( [ $route->host_variables ], $host_variables, "Host variables for \"$host\"" );

    }

}

