use v6.c;

use Method::Also;

use NativeCall;

use GLib::Raw::Traits;
use GIO::Raw::Types;
use GIO::Raw::DesktopAppInfo;

use GIO::Roles::AppInfo;
use GLib::Roles::Object;

our subset GDesktopAppInfoAncestry is export of Mu
  where GDesktopAppInfo | GObject;

class GIO::DesktopAppInfo {
  also does GLib::Roles::Object;

  has GDesktopAppInfo $!dai is implementor;

  submethod BUILD ( :$desktop-info ) {
    self.setGDesktopAppInfo($desktop-info) if $desktop-info
  }

  method setGDesktopAppInfo (GDesktopAppInfoAncestry $_) {
    my $to-parent;

    $!dai = do {
      when GDesktopAppInfo {
        $to-parent = cast(GObject, $_);
        $_;
      }

      default {
        $to-parent = $_;
        cast(GDesktopAppInfo, $_);
      }
    }
    self!setObject($to-parent);
  }

  method GIO::Raw::Definitions::GDesktopAppInfo
    is also<GDesktopAppInfo>
  { $!dai }


  multi method new (GDesktopAppInfoAncestry $desktop-info, :$ref = True) {
    return unless $desktop-info;

    my $o = self.bless( :$desktop-info );
    $o.ref if $ref;
    $o;
  }
  multi method new (Str $desktop_id) {
    my $desktop-info = g_desktop_app_info_new($desktop_id);

    $desktop-info ?? self.bless( :$desktop-info ) !! Nil;
  }

  method new_from_filename (Str() $filename) is also<new-from-filename> {
    my $desktop-info = g_desktop_app_info_new_from_filename($filename);

    $desktop-info ?? self.bless( :$desktop-info ) !! Nil;
  }

  method new_from_keyfile (GKeyFile() $keyfile) is also<new-from-keyfile> {
    my $desktop-info = g_desktop_app_info_new_from_keyfile($keyfile);

    $desktop-info ?? self.bless( :$desktop-info ) !! Nil;
  }

  method get_action_name (Str() $action_name) is also<get-action-name> {
    g_desktop_app_info_get_action_name($!dai, $action_name);
  }

  method get_boolean (Str() $key) is also<get-boolean> {
    so g_desktop_app_info_get_boolean($!dai, $key);
  }

  method get_categories is also<get-categories> {
    g_desktop_app_info_get_categories($!dai);
  }

  method get_filename is also<get-filename> {
    g_desktop_app_info_get_filename($!dai);
  }

  method get_generic_name is also<get-generic-name> {
    g_desktop_app_info_get_generic_name($!dai);
  }

  method get_implementations (
    GIO::DesktopAppInfo:U:
    Str()                  $interface,
                           :$glist    = False,
                           :$raw      = False
  )
    is also<get-implementations>
  {
    my $il = g_desktop_app_info_get_implementations($interface);

    return Nil unless $il;
    return $il if     $glist && $raw;

    $il = $il but GLib::Roles::ListData[GDesktopAppInfo];
    return $il if $glist;

    $raw ?? $il.Array !! $il.Array.map({ GIO::DesktopAppInfo.new($_) });
  }

  method get_is_hidden is also<get-is-hidden> {
    so g_desktop_app_info_get_is_hidden($!dai);
  }

  method get_keywords is also<get-keywords> {
    CStringArrayToArray( g_desktop_app_info_get_keywords($!dai) );
  }

  method get_locale_string (Str() $key) is also<get-locale-string> {
    g_desktop_app_info_get_locale_string($!dai, $key);
  }

  method get_nodisplay is also<get-nodisplay> {
    so g_desktop_app_info_get_nodisplay($!dai);
  }

  method get_show_in (Str() $desktop_env) is also<get-show-in> {
    g_desktop_app_info_get_show_in($!dai, $desktop_env);
  }

  method get_startup_wm_class is also<get-startup-wm-class> {
    g_desktop_app_info_get_startup_wm_class($!dai);
  }

  method get_string (Str() $key) is also<get-string> {
    g_desktop_app_info_get_string($!dai, $key);
  }

  method get_string_list (Str() $key, Int() $length) is also<get-string-list> {
    my gsize $l = $length;

    g_desktop_app_info_get_string_list($!dai, $key, $l);
  }

  method get_type is also<get-type> {
    state ($n, $t);

    unstable_get_type( self.^name, &g_desktop_app_info_get_type, $n, $t );
  }

  method has_key (Str() $key) is also<has-key> {
    so g_desktop_app_info_has_key($!dai, $key);
  }

  method launch_action (
    Str()               $action_name,
    GAppLaunchContext() $launch_context
  )
    is also<launch-action>
  {
    g_desktop_app_info_launch_action($!dai, $action_name, $launch_context);
  }

  proto method launch_uris_as_manager (|)
    is also<launch-uris-as-manager>
  { * }

  multi method launch_uris_as_manager (
                            @uris,
    GAppLaunchContext()     $launch_context,
    Int()                   $spawn_flags,
                            &pid_callback      = Callable,
    gpointer                $pid_callback_data = gpointer,
    CArray[Pointer[GError]] $error             = gerror
  ) {
    samewith(
      GLib::GList.new(@uris),
      $launch_context,
      $spawn_flags,
      &pid_callback,
      $pid_callback_data,
      $error
    );
  }
  multi method launch_uris_as_manager (
    GList()                   $uris,
    GAppLaunchContext()       $launch_context,
    GSpawnFlags               $spawn_flags,
    GDesktopAppLaunchCallback &pid_callback      = Callable,
    gpointer                  $pid_callback_data = gpointer,
    CArray[Pointer[GError]]   $error             = gerror
  ) {
    samewith(
      $uris,
      $launch_context,
      $spawn_flags,
      Callable,
      gpointer,
      &pid_callback,
      $pid_callback_data,
      $error
    );
  }
  multi method launch_uris_as_manager (
    GList()                 $uris,
    GAppLaunchContext()     $launch_context,
    Int()                   $spawn_flags,
                            &user_setup        = Callable,
    gpointer                $user_setup_data   = gpointer,
                            &pid_callback      = Callable,
    gpointer                $pid_callback_data = gpointer,
    CArray[Pointer[GError]] $error             = gerror
  ) {
    my GSpawnFlags $s = $spawn_flags;

    clear_error;
    my $rv = so g_desktop_app_info_launch_uris_as_manager(
      $!dai,
      $uris,
      $launch_context,
      $s,
      &user_setup,
      $user_setup_data,
      &pid_callback,
      $pid_callback_data,
      $error
    );
    set_error($error);
    $rv;
  }

  proto method launch_uris_as_manager_with_fds (|)
    is also<launch-uris-as-manager-with-fds>
  { * }

  multi method launch_uris_as_manager_with_fds (
                              @uris,
    GAppLaunchContext()       $launch_context,
    Int()                     $spawn_flags,
    Int()                     $stdin_fd       = -1,
    Int()                     $stdout_fd      = -1,
    Int()                     $stderr_fd      = -1,
    CArray[Pointer[GError]]   $error          = gerror
  ) {
    samewith(
      GLib::GList.new(@uris),
      $launch_context,
      $spawn_flags,
      $stdin_fd,
      $stdout_fd,
      $stderr_fd,
      $error
    )
  }
  multi method launch_uris_as_manager_with_fds (
    GList()                   $uris,
    GAppLaunchContext()       $launch_context,
    Int()                     $spawn_flags,
    Int()                     $stdin_fd       = -1,
    Int()                     $stdout_fd      = -1,
    Int()                     $stderr_fd      = -1,
    CArray[Pointer[GError]]   $error          = gerror
  ) {
    samewith(
      $uris,
      $launch_context,
      $spawn_flags,
      Callable,
      gpointer,
      $stdin_fd,
      $stdout_fd,
      $stderr_fd,
      $error
    );
  }
  multi method launch_uris_as_manager_with_fds (
                            @uris,
    GAppLaunchContext()     $launch_context,
    Int()                   $spawn_flags,
                            &pid_callback,
    gpointer                $pid_callback_data,
    Int()                   $stdin_fd          = -1,
    Int()                   $stdout_fd         = -1,
    Int()                   $stderr_fd         = -1,
    CArray[Pointer[GError]] $error             = gerror
  ) {
    samewith(
      GLib::GList.new(@uris),
      $launch_context,
      $spawn_flags,
      &pid_callback,
      $pid_callback_data,
      $stdin_fd,
      $stdout_fd,
      $stderr_fd,
      $error
    );
  }
  multi method launch_uris_as_manager_with_fds (
    GList()                 $uris,
    GAppLaunchContext()     $launch_context,
    Int()                   $spawn_flags,
                            &pid_callback,
    gpointer                $pid_callback_data,
    Int()                   $stdin_fd          = -1,
    Int()                   $stdout_fd         = -1,
    Int()                   $stderr_fd         = -1,
    CArray[Pointer[GError]] $error             = gerror
  ) {
    samewith(
      $uris,
      $launch_context,
      $spawn_flags,
      Callable,
      gpointer,
      &pid_callback,
      $pid_callback_data,
      $stdin_fd,
      $stdout_fd,
      $stderr_fd,
      $error
    );
  }
  multi method launch_uris_as_manager_with_fds (
                            @uris,
    GAppLaunchContext()     $launch_context,
    Int()                   $spawn_flags,
                            &user_setup,
    gpointer                $user_setup_data,
                            &pid_callback,
    gpointer                $pid_callback_data,
    Int()                   $stdin_fd          = -1,
    Int()                   $stdout_fd         = -1,
    Int()                   $stderr_fd         = -1,
    CArray[Pointer[GError]] $error             = gerror
  ) {
    samewith(
      GLib::GList.new(@uris),
      $launch_context,
      $spawn_flags,
      &user_setup,
      $user_setup_data,
      &pid_callback,
      $pid_callback_data,
      $stdin_fd,
      $stdout_fd,
      $stderr_fd,
      $error
    );
  }
  multi method launch_uris_as_manager_with_fds (
    GList()                 $uris,
    GAppLaunchContext()     $launch_context,
    Int()                   $spawn_flags,
                            &user_setup,
    gpointer                $user_setup_data,
                            &pid_callback,
    gpointer                $pid_callback_data,
    Int()                   $stdin_fd          = -1,
    Int()                   $stdout_fd         = -1,
    Int()                   $stderr_fd         = -1,
    CArray[Pointer[GError]] $error             = gerror
  ) {
    my GSpawnFlags $s = $spawn_flags,
    my gint ($si, $so, $se) = ($stdin_fd, $stdout_fd, $stderr_fd);

    clear_error;
    my $rv = so g_desktop_app_info_launch_uris_as_manager_with_fds(
      $!dai,
      $uris,
      $launch_context,
      $s,
      &user_setup,
      $user_setup_data,
      &pid_callback,
      $pid_callback_data,
      $si,
      $so,
      $se,
      $error
    );
    set_error($error);
    $rv;
  }

  method list_actions is also<list-actions> {
    CStringArrayToArray( g_desktop_app_info_list_actions($!dai) );
  }

  method lookup_get_default_for_uri_scheme (
    Str()  $uri_scheme,
          :$raw = False
  )
    is static
    is also<lookup-get-default-for-uri-scheme>
  {
    my $ai = g_desktop_app_info_lookup_get_default_for_uri_scheme($uri_scheme);

    $ai ??
      ( $raw ?? $ai !! GIO::AppInfo.new($ai, :!ref) )
      !!
      Nil;
  }

  method lookup_get_type is static is also<lookup-get-type> {
    g_desktop_app_info_lookup_get_type();
  }

  method search (Str() $search_string) is static {
    CStringArrayToArray( g_desktop_app_info_search($search_string) );
  }

  # method set_desktop_env {
  #   g_desktop_app_info_set_desktop_env($!dai);
  # }

}
