/*
 * Decompiled with CFR 0.152.
 */
package com.javonet.utils;

import java.lang.reflect.Type;

public class TypesConverter {
    public static String convertTypeToJType(Type type) {
        if (type == Boolean.class || type == Boolean.TYPE) {
            return "JType.Boolean";
        }
        if (type == Byte.class || type == Byte.TYPE) {
            return "JType.Byte";
        }
        if (type == Character.class || type == Character.TYPE) {
            return "JType.Char";
        }
        if (type == Float.class || type == Float.TYPE) {
            return "JType.Float";
        }
        if (type == Double.class || type == Double.TYPE) {
            return "JType.Double";
        }
        if (type == Short.class || type == Short.TYPE) {
            return "JType.Integer";
        }
        if (type == Integer.class || type == Integer.TYPE) {
            return "JType.Integer";
        }
        if (type == Long.class || type == Long.TYPE) {
            return "JType.Long";
        }
        if (type == String.class) {
            return "JType.String";
        }
        if (type == Void.TYPE) {
            return "JType.Null";
        }
        return type.getTypeName();
    }

    public static Type convertJTypeToType(String jtype) {
        switch (jtype) {
            case "JType.Boolean": {
                return Boolean.class;
            }
            case "JType.Byte": {
                return Byte.class;
            }
            case "JType.Char": {
                return Character.class;
            }
            case "JType.Float": {
                return Float.class;
            }
            case "JType.Double": {
                return Double.class;
            }
            case "JType.Integer": {
                return Integer.class;
            }
            case "JType.Long": {
                return Long.class;
            }
            case "JType.String": {
                return String.class;
            }
            case "JType.UnsignedInteger": {
                return Integer.class;
            }
            case "JType.UnsignedLongLong": {
                return Long.class;
            }
        }
        try {
            return Class.forName(jtype);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Unsupported JType: " + jtype, e);
        }
    }
}

