=begin comment

Copyright (c) 2019 Aspose Pty Ltd

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.

=end comment

=cut

package AsposeSlidesCloud::Object::LineFormat;

require 5.6.0;
use strict;
use warnings;
use utf8;
use JSON qw(decode_json);
use Data::Dumper;
use Module::Runtime qw(use_module);
use Log::Any qw($log);
use Date::Parse;
use DateTime;

use AsposeSlidesCloud::Object::ArrowHeadProperties;
use AsposeSlidesCloud::Object::CustomDashPattern;
use AsposeSlidesCloud::Object::FillFormat;

use base ("Class::Accessor", "Class::Data::Inheritable");


#
#Line format.
#
# NOTE: This class is auto generated by the swagger code generator program. Do not edit the class manually.
# REF: https://github.com/swagger-api/swagger-codegen
#

#
# NOTE: This class is auto generated by the swagger code generator program. 
# Do not edit the class manually.
# Ref: https://github.com/swagger-api/swagger-codegen
#
__PACKAGE__->mk_classdata('attribute_map' => {});
__PACKAGE__->mk_classdata('swagger_types' => {});
__PACKAGE__->mk_classdata('method_documentation' => {}); 
__PACKAGE__->mk_classdata('class_documentation' => {});

# new object
sub new { 
    my ($class, %args) = @_; 

	my $self = bless {}, $class;
	
	foreach my $attribute (keys %{$class->attribute_map}) {
		my $args_key = $class->attribute_map->{$attribute};
		$self->$attribute( $args{ $args_key } );
	}
	return $self;
}  

# used by JSON for serialization
sub TO_JSON { 
    my $self = shift;
    my $_data = {};
    foreach my $_key (keys %{$self->attribute_map}) {
        if (defined $self->{$_key}) {
            $_data->{$self->attribute_map->{$_key}} = $self->{$_key};
        }
    }
    return $_data;
}


__PACKAGE__->class_documentation({description => 'Line format.',
                                  class => 'LineFormat',
                                  required => [], # TODO
}                                 );

__PACKAGE__->method_documentation({
    'alignment' => {
    	datatype => 'string',
    	base_name => 'Alignment',
    	description => 'Alignment.',
    	format => '',
    	read_only => '',
    		},
    'cap_style' => {
    	datatype => 'string',
    	base_name => 'CapStyle',
    	description => 'Cap style.',
    	format => '',
    	read_only => '',
    		},
    'dash_style' => {
    	datatype => 'string',
    	base_name => 'DashStyle',
    	description => 'Dash style.',
    	format => '',
    	read_only => '',
    		},
    'join_style' => {
    	datatype => 'string',
    	base_name => 'JoinStyle',
    	description => 'Join style.',
    	format => '',
    	read_only => '',
    		},
    'style' => {
    	datatype => 'string',
    	base_name => 'Style',
    	description => 'Style.',
    	format => '',
    	read_only => '',
    		},
    'sketch_type' => {
    	datatype => 'string',
    	base_name => 'SketchType',
    	description => 'Sketch type.',
    	format => '',
    	read_only => '',
    		},
    'begin_arrow_head' => {
    	datatype => 'ArrowHeadProperties',
    	base_name => 'BeginArrowHead',
    	description => 'Begin arrowhead.',
    	format => '',
    	read_only => '',
    		},
    'end_arrow_head' => {
    	datatype => 'ArrowHeadProperties',
    	base_name => 'EndArrowHead',
    	description => 'End arrowhead.',
    	format => '',
    	read_only => '',
    		},
    'custom_dash_pattern' => {
    	datatype => 'CustomDashPattern',
    	base_name => 'CustomDashPattern',
    	description => 'Custom dash pattern.',
    	format => '',
    	read_only => '',
    		},
    'fill_format' => {
    	datatype => 'FillFormat',
    	base_name => 'FillFormat',
    	description => 'Fill format.',
    	format => '',
    	read_only => '',
    		},
    'miter_limit' => {
    	datatype => 'double',
    	base_name => 'MiterLimit',
    	description => 'Miter limit.',
    	format => '',
    	read_only => '',
    		},
    'width' => {
    	datatype => 'double',
    	base_name => 'Width',
    	description => 'Width.',
    	format => '',
    	read_only => '',
    		},
});

__PACKAGE__->swagger_types( {
    'alignment' => 'string',
    'cap_style' => 'string',
    'dash_style' => 'string',
    'join_style' => 'string',
    'style' => 'string',
    'sketch_type' => 'string',
    'begin_arrow_head' => 'ArrowHeadProperties',
    'end_arrow_head' => 'ArrowHeadProperties',
    'custom_dash_pattern' => 'CustomDashPattern',
    'fill_format' => 'FillFormat',
    'miter_limit' => 'double',
    'width' => 'double'
} );

__PACKAGE__->attribute_map( {
    'alignment' => 'Alignment',
    'cap_style' => 'CapStyle',
    'dash_style' => 'DashStyle',
    'join_style' => 'JoinStyle',
    'style' => 'Style',
    'sketch_type' => 'SketchType',
    'begin_arrow_head' => 'BeginArrowHead',
    'end_arrow_head' => 'EndArrowHead',
    'custom_dash_pattern' => 'CustomDashPattern',
    'fill_format' => 'FillFormat',
    'miter_limit' => 'MiterLimit',
    'width' => 'Width'
} );

__PACKAGE__->mk_accessors(keys %{__PACKAGE__->attribute_map});


1;
