/*
 * Decompiled with CFR 0.152.
 */
package org.virtualbox_7_1;

import org.virtualbox_7_1.DeviceType;
import org.virtualbox_7_1.IBandwidthGroup;
import org.virtualbox_7_1.IMachine;
import org.virtualbox_7_1.IMedium;
import org.virtualbox_7_1.ObjectRefManager;
import org.virtualbox_7_1.jaxws.VboxPortType;

public class IMediumAttachment {
    private org.virtualbox_7_1.jaxws.IMediumAttachment real;
    private VboxPortType port;
    private ObjectRefManager objMgr;
    private IMachine machine;
    private IMedium medium;
    private IBandwidthGroup bandwidthGroup;

    public IMediumAttachment(org.virtualbox_7_1.jaxws.IMediumAttachment iMediumAttachment, ObjectRefManager objectRefManager, VboxPortType vboxPortType) {
        this.real = iMediumAttachment;
        this.port = vboxPortType;
        this.objMgr = objectRefManager;
        this.machine = iMediumAttachment.getMachine().length() > 0 ? new IMachine(iMediumAttachment.getMachine(), this.getObjMgr(), vboxPortType) : null;
        this.medium = iMediumAttachment.getMedium().length() > 0 ? new IMedium(iMediumAttachment.getMedium(), this.getObjMgr(), vboxPortType) : null;
        this.bandwidthGroup = iMediumAttachment.getBandwidthGroup().length() > 0 ? new IBandwidthGroup(iMediumAttachment.getBandwidthGroup(), this.getObjMgr(), vboxPortType) : null;
    }

    private ObjectRefManager getObjMgr() {
        return this.objMgr;
    }

    public IMachine getMachine() {
        return this.machine;
    }

    public IMedium getMedium() {
        return this.medium;
    }

    public String getController() {
        String string = this.real.getController();
        return string;
    }

    public Integer getPort() {
        Integer n = this.real.getPort();
        return n;
    }

    public Integer getDevice() {
        Integer n = this.real.getDevice();
        return n;
    }

    public DeviceType getType() {
        org.virtualbox_7_1.jaxws.DeviceType deviceType = this.real.getType();
        return DeviceType.fromValue(deviceType.value());
    }

    public Boolean getPassthrough() {
        Boolean bl = this.real.isPassthrough();
        return bl;
    }

    public Boolean getTemporaryEject() {
        Boolean bl = this.real.isTemporaryEject();
        return bl;
    }

    public Boolean getIsEjected() {
        Boolean bl = this.real.isIsEjected();
        return bl;
    }

    public Boolean getNonRotational() {
        Boolean bl = this.real.isNonRotational();
        return bl;
    }

    public Boolean getDiscard() {
        Boolean bl = this.real.isDiscard();
        return bl;
    }

    public Boolean getHotPluggable() {
        Boolean bl = this.real.isHotPluggable();
        return bl;
    }

    public IBandwidthGroup getBandwidthGroup() {
        return this.bandwidthGroup;
    }
}

