/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.webresources;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.catalina.WebResource;
import org.apache.catalina.WebResourceRoot;
import org.apache.catalina.util.ResourceSet;
import org.apache.catalina.webresources.AbstractResourceSet;
import org.apache.catalina.webresources.EmptyResource;
import org.apache.catalina.webresources.JarContents;
import org.apache.catalina.webresources.JarResourceRoot;
import org.apache.tomcat.util.compat.JreCompat;

public abstract class AbstractArchiveResourceSet
extends AbstractResourceSet {
    private URL baseUrl;
    private String baseUrlString;
    private JarFile archive = null;
    protected Map<String, JarEntry> archiveEntries = null;
    protected final Object archiveLock = new Object();
    private long archiveUseCount = 0L;
    private JarContents jarContents;
    private boolean retainBloomFilterForArchives = false;

    protected final void setBaseUrl(URL uRL) {
        this.baseUrl = uRL;
        this.baseUrlString = uRL == null ? null : uRL.toString();
    }

    @Override
    public final URL getBaseUrl() {
        return this.baseUrl;
    }

    protected final String getBaseUrlString() {
        return this.baseUrlString;
    }

    @Override
    public final String[] list(String string) {
        this.checkPath(string);
        String string2 = this.getWebAppMount();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.isPathMounted(string, string2)) {
            String string3 = this.getInternalPath() + string.substring(string2.length());
            if (!string3.isEmpty() && string3.charAt(0) == '/') {
                string3 = string3.substring(1);
            }
            for (String string4 : this.getArchiveEntries(false).keySet()) {
                if (string4.length() <= string3.length() || !string4.startsWith(string3) || (string4 = string4.charAt(string4.length() - 1) == '/' ? string4.substring(string3.length(), string4.length() - 1) : string4.substring(string3.length())).isEmpty()) continue;
                if (string4.charAt(0) == '/') {
                    string4 = string4.substring(1);
                }
                if (string4.isEmpty() || string4.lastIndexOf(47) != -1) continue;
                arrayList.add(string4);
            }
        } else {
            if (!string.endsWith("/")) {
                string = string + "/";
            }
            if (string2.startsWith(string)) {
                int n = string2.indexOf(47, string.length());
                if (n == -1) {
                    return new String[]{string2.substring(string.length())};
                }
                return new String[]{string2.substring(string.length(), n)};
            }
        }
        return arrayList.toArray(new String[0]);
    }

    @Override
    public final Set<String> listWebAppPaths(String string) {
        this.checkPath(string);
        String string2 = this.getWebAppMount();
        ResourceSet<String> resourceSet = new ResourceSet<String>();
        if (this.isPathMounted(string, string2)) {
            String string3 = this.getInternalPath() + string.substring(string2.length());
            if (!string3.isEmpty()) {
                if (string3.charAt(string3.length() - 1) != '/') {
                    string3 = string3.substring(1) + '/';
                }
                if (string3.charAt(0) == '/') {
                    string3 = string3.substring(1);
                }
            }
            for (String string4 : this.getArchiveEntries(false).keySet()) {
                if (string4.length() <= string3.length() || !string4.startsWith(string3)) continue;
                int n = string4.indexOf(47, string3.length());
                if (n != -1 && n != string4.length() - 1) {
                    string4 = string4.substring(0, n + 1);
                }
                resourceSet.add(string2 + '/' + string4.substring(this.getInternalPath().length()));
            }
        } else {
            if (!string.endsWith("/")) {
                string = string + "/";
            }
            if (string2.startsWith(string)) {
                int n = string2.indexOf(47, string.length());
                if (n == -1) {
                    resourceSet.add(string2 + "/");
                } else {
                    resourceSet.add(string2.substring(0, n + 1));
                }
            }
        }
        resourceSet.setLocked(true);
        return resourceSet;
    }

    protected abstract Map<String, JarEntry> getArchiveEntries(boolean var1);

    protected abstract JarEntry getArchiveEntry(String var1);

    @Override
    public final boolean mkdir(String string) {
        this.checkPath(string);
        return false;
    }

    @Override
    public final boolean write(String string, InputStream inputStream, boolean bl) {
        this.checkPath(string);
        if (inputStream == null) {
            throw new NullPointerException(sm.getString("dirResourceSet.writeNpe"));
        }
        return false;
    }

    @Override
    public final WebResource getResource(String string) {
        this.checkPath(string);
        String string2 = this.getWebAppMount();
        WebResourceRoot webResourceRoot = this.getRoot();
        if (this.jarContents != null && !this.jarContents.mightContainResource(this.getInternalPath().isEmpty() ? string : this.getInternalPath() + string, string2)) {
            return new EmptyResource(webResourceRoot, string);
        }
        if (this.isPathMounted(string, string2)) {
            String string3 = this.getInternalPath() + string.substring(string2.length());
            if (!string3.isEmpty() && string3.charAt(0) == '/') {
                string3 = string3.substring(1);
            }
            if (string3.isEmpty()) {
                if (!string.endsWith("/")) {
                    string = string + "/";
                }
                return new JarResourceRoot(webResourceRoot, new File(this.getBase()), this.baseUrlString, string);
            }
            JarEntry jarEntry = null;
            if (this.isMultiRelease()) {
                jarEntry = this.getArchiveEntry(string3);
            } else {
                Map<String, JarEntry> map = this.getArchiveEntries(true);
                if (string3.charAt(string3.length() - 1) != '/' && (jarEntry = map == null ? this.getArchiveEntry(string3 + '/') : map.get(string3 + '/')) != null) {
                    string = string + '/';
                }
                if (jarEntry == null) {
                    jarEntry = map == null ? this.getArchiveEntry(string3) : map.get(string3);
                }
            }
            if (jarEntry == null) {
                return new EmptyResource(webResourceRoot, string);
            }
            return this.createArchiveResource(jarEntry, string, this.getManifest());
        }
        return new EmptyResource(webResourceRoot, string);
    }

    protected abstract boolean isMultiRelease();

    protected abstract WebResource createArchiveResource(JarEntry var1, String var2, Manifest var3);

    @Override
    public final boolean isReadOnly() {
        return true;
    }

    @Override
    public void setReadOnly(boolean bl) {
        if (bl) {
            return;
        }
        throw new IllegalArgumentException(sm.getString("abstractArchiveResourceSet.setReadOnlyFalse"));
    }

    @Override
    public void setAllowLinking(boolean bl) {
    }

    @Override
    public boolean getAllowLinking() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JarFile openJarFile() throws IOException {
        Object object = this.archiveLock;
        synchronized (object) {
            if (this.archive == null) {
                this.archive = JreCompat.getInstance().jarFileNewInstance(this.getBase());
                WebResourceRoot webResourceRoot = this.getRoot();
                if (webResourceRoot.getArchiveIndexStrategyEnum().getUsesBloom() || webResourceRoot.getContext() != null && webResourceRoot.getContext().getUseBloomFilterForArchives()) {
                    this.jarContents = new JarContents(this.archive);
                    this.retainBloomFilterForArchives = webResourceRoot.getArchiveIndexStrategyEnum().getRetain();
                }
            }
            ++this.archiveUseCount;
            return this.archive;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeJarFile() {
        Object object = this.archiveLock;
        synchronized (object) {
            --this.archiveUseCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void gc() {
        Object object = this.archiveLock;
        synchronized (object) {
            if (this.archive != null && this.archiveUseCount == 0L) {
                try {
                    this.archive.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.archive = null;
                this.archiveEntries = null;
                if (!this.retainBloomFilterForArchives) {
                    this.jarContents = null;
                }
            }
        }
    }
}

