/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.text.formatter.schema;

import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.schema.ColumnDataType;
import schemacrawler.schema.DatabaseInfo;
import schemacrawler.schema.DatabaseObject;
import schemacrawler.schema.JdbcDriverInfo;
import schemacrawler.schema.Routine;
import schemacrawler.schema.Sequence;
import schemacrawler.schema.Synonym;
import schemacrawler.schema.Table;
import schemacrawler.schemacrawler.Identifiers;
import schemacrawler.tools.command.text.schema.options.HideDatabaseObjectsType;
import schemacrawler.tools.command.text.schema.options.SchemaTextDetailType;
import schemacrawler.tools.command.text.schema.options.SchemaTextOptions;
import schemacrawler.tools.options.OutputOptions;
import schemacrawler.tools.text.formatter.base.BaseTabularFormatter;
import schemacrawler.tools.text.formatter.base.helper.TextFormattingHelper;
import schemacrawler.tools.traversal.SchemaTraversalHandler;
import us.fatehi.utility.string.StringFormat;

public final class SchemaListFormatter
extends BaseTabularFormatter<SchemaTextOptions>
implements SchemaTraversalHandler {
    private static final Logger LOGGER = Logger.getLogger(SchemaListFormatter.class.getName());

    public SchemaListFormatter(SchemaTextDetailType schemaTextDetailType, SchemaTextOptions options, OutputOptions outputOptions, Identifiers identifiers) {
        super(schemaTextDetailType, options, outputOptions, identifiers);
    }

    @Override
    public void handle(ColumnDataType columnDataType) {
    }

    @Override
    public void handleInfo(DatabaseInfo dbInfo) {
    }

    @Override
    public void handleInfo(JdbcDriverInfo driverInfo) {
    }

    @Override
    public void handle(Routine routine) {
        if (routine == null || ((SchemaTextOptions)this.options).is(HideDatabaseObjectsType.hideRoutines)) {
            LOGGER.log(Level.FINER, new StringFormat("Not showing routine <%s>", routine));
            return;
        }
        String routineTypeDetail = String.format("%s, %s", new Object[]{routine.getRoutineType(), routine.getReturnType()});
        String routineName = this.quoteName(routine);
        String routineType = "[" + routineTypeDetail + "]";
        this.formattingHelper.writeNameRow(routineName, routineType);
        this.printRemarks(routine);
    }

    @Override
    public void handle(Sequence sequence) {
        if (sequence == null || ((SchemaTextOptions)this.options).is(HideDatabaseObjectsType.hideSequences)) {
            LOGGER.log(Level.FINER, new StringFormat("Not showing sequence <%s>", sequence));
            return;
        }
        String sequenceName = this.quoteName(sequence);
        String sequenceType = "[sequence]";
        this.formattingHelper.writeNameRow(sequenceName, "[sequence]");
        this.printRemarks(sequence);
    }

    @Override
    public void handle(Synonym synonym) {
        if (synonym == null || ((SchemaTextOptions)this.options).is(HideDatabaseObjectsType.hideSynonyms)) {
            LOGGER.log(Level.FINER, new StringFormat("Not showing synonym <%s>", synonym));
            return;
        }
        String synonymName = this.quoteName(synonym);
        String synonymType = "[synonym]";
        this.formattingHelper.writeNameRow(synonymName, "[synonym]");
        this.printRemarks(synonym);
    }

    @Override
    public void handle(Table table) {
        if (((SchemaTextOptions)this.options).is(HideDatabaseObjectsType.hideTables)) {
            LOGGER.log(Level.FINER, new StringFormat("Not showing table <%s>", table));
            return;
        }
        String tableName = this.quoteName(table);
        String tableType = "[" + table.getTableType() + "]";
        this.formattingHelper.writeNameRow(tableName, tableType);
        this.printRemarks(table);
    }

    @Override
    public void handleColumnDataTypesEnd() {
    }

    @Override
    public void handleColumnDataTypesStart() {
    }

    @Override
    public void handleInfoEnd() {
    }

    @Override
    public void handleInfoStart() {
    }

    @Override
    public void handleRoutinesEnd() {
        if (((SchemaTextOptions)this.options).is(HideDatabaseObjectsType.hideRoutines)) {
            LOGGER.log(Level.FINER, "Not showing tables");
            return;
        }
        this.formattingHelper.writeObjectEnd();
    }

    @Override
    public void handleRoutinesStart() {
        if (((SchemaTextOptions)this.options).is(HideDatabaseObjectsType.hideRoutines)) {
            LOGGER.log(Level.FINER, "Not showing routines");
            return;
        }
        this.formattingHelper.writeHeader(TextFormattingHelper.DocumentHeaderType.subTitle, "Routines");
        this.formattingHelper.writeObjectStart();
    }

    @Override
    public void handleSequencesEnd() {
        if (((SchemaTextOptions)this.options).is(HideDatabaseObjectsType.hideSequences)) {
            LOGGER.log(Level.FINER, "Not showing sequences");
            return;
        }
        this.formattingHelper.writeObjectEnd();
    }

    @Override
    public void handleSequencesStart() {
        if (((SchemaTextOptions)this.options).is(HideDatabaseObjectsType.hideSequences)) {
            LOGGER.log(Level.FINER, "Not showing sequences");
            return;
        }
        this.formattingHelper.writeHeader(TextFormattingHelper.DocumentHeaderType.subTitle, "Sequences");
        this.formattingHelper.writeObjectStart();
    }

    @Override
    public void handleSynonymsEnd() {
        if (((SchemaTextOptions)this.options).is(HideDatabaseObjectsType.hideSynonyms)) {
            LOGGER.log(Level.FINER, "Not showing synonyms");
            return;
        }
        this.formattingHelper.writeObjectEnd();
    }

    @Override
    public void handleSynonymsStart() {
        if (((SchemaTextOptions)this.options).is(HideDatabaseObjectsType.hideSynonyms)) {
            LOGGER.log(Level.FINER, "Not showing synonyms");
            return;
        }
        this.formattingHelper.writeHeader(TextFormattingHelper.DocumentHeaderType.subTitle, "Synonyms");
        this.formattingHelper.writeObjectStart();
    }

    @Override
    public void handleTablesEnd() {
        if (((SchemaTextOptions)this.options).is(HideDatabaseObjectsType.hideTables)) {
            LOGGER.log(Level.FINER, "Not showing tables");
            return;
        }
        this.formattingHelper.writeObjectEnd();
    }

    @Override
    public void handleTablesStart() {
        if (((SchemaTextOptions)this.options).is(HideDatabaseObjectsType.hideTables)) {
            LOGGER.log(Level.FINER, "Not showing tables");
            return;
        }
        this.formattingHelper.writeHeader(TextFormattingHelper.DocumentHeaderType.subTitle, "Tables");
        this.formattingHelper.writeObjectStart();
    }

    private void printRemarks(DatabaseObject object) {
        if (object == null || !object.hasRemarks() || ((SchemaTextOptions)this.options).isHideRemarks()) {
            return;
        }
        this.formattingHelper.writeDescriptionRow(object.getRemarks());
    }
}

