/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.wire;

import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.firebirdsql.gds.ng.FbDatabase;
import org.firebirdsql.gds.ng.FbTransaction;
import org.firebirdsql.gds.ng.LockCloseable;
import org.firebirdsql.gds.ng.TransactionState;
import org.firebirdsql.gds.ng.listeners.DatabaseListener;
import org.firebirdsql.gds.ng.listeners.TransactionListener;
import org.firebirdsql.gds.ng.wire.InlineBlob;

public final class InlineBlobCache
implements DatabaseListener,
TransactionListener {
    private final FbDatabase database;
    private final int maxSize;
    private long size;
    private Map<Integer, Map<Long, InlineBlob>> transactionToBlobIdToBlob = new HashMap<Integer, Map<Long, InlineBlob>>(4);
    private static final Set<TransactionState> CLEAN_CACHE_ON_TRANSACTION_STATES = Collections.unmodifiableSet(EnumSet.of(TransactionState.PREPARED, TransactionState.COMMITTED, TransactionState.ROLLED_BACK));

    public InlineBlobCache(FbDatabase database) {
        this.database = database;
        int maxBlobCacheSize = database.getConnectionProperties().getMaxBlobCacheSize();
        this.maxSize = maxBlobCacheSize > 0 ? maxBlobCacheSize : -1;
        database.addDatabaseListener(this);
    }

    public int maxSize() {
        return this.maxSize;
    }

    public int size() {
        try (LockCloseable ignored = this.withLock();){
            int n = Math.toIntExact(this.size);
            return n;
        }
    }

    boolean contains(int transactionHandle, long blobId) {
        try (LockCloseable ignored = this.withLock();){
            Map<Long, InlineBlob> blobIdToBlob = this.transactionToBlobIdToBlob.get(transactionHandle);
            if (blobIdToBlob == null) {
                boolean bl = false;
                return bl;
            }
            boolean bl = blobIdToBlob.containsKey(blobId);
            return bl;
        }
    }

    public Optional<InlineBlob> getAndRemove(FbTransaction transaction, long blobId) {
        return this.getAndRemove(transaction.getHandle(), blobId);
    }

    Optional<InlineBlob> getAndRemove(int transactionHandle, long blobId) {
        try (LockCloseable ignored = this.withLock();){
            Map<Long, InlineBlob> blobIdToBlob = this.transactionToBlobIdToBlob.get(transactionHandle);
            if (blobIdToBlob == null) {
                Optional<InlineBlob> optional = Optional.empty();
                return optional;
            }
            InlineBlob blob = blobIdToBlob.remove(blobId);
            if (blob == null) {
                Optional<InlineBlob> optional = Optional.empty();
                return optional;
            }
            this.size = Math.max(0L, this.size - blob.length());
            Optional<InlineBlob> optional = Optional.of(blob);
            return optional;
        }
    }

    public boolean add(FbTransaction transaction, InlineBlob blob) {
        int transactionHandle = blob.getTransactionHandle();
        if (transaction.getState() != TransactionState.ACTIVE || transaction.getHandle() != transactionHandle) {
            return false;
        }
        try (LockCloseable ignored = this.withLock();){
            long newSize = this.size + blob.length();
            if (newSize > (long)this.maxSize) {
                boolean bl = false;
                return bl;
            }
            InlineBlob previous = this.transactionToBlobIdToBlob.computeIfAbsent(transactionHandle, tr -> new HashMap()).putIfAbsent(blob.getBlobId(), blob);
            if (previous != null) {
                boolean bl = false;
                return bl;
            }
            this.size = newSize;
            transaction.addTransactionListener(this);
            boolean bl = true;
            return bl;
        }
    }

    @Override
    public void transactionStateChanged(FbTransaction transaction, TransactionState newState, TransactionState previousState) {
        if (CLEAN_CACHE_ON_TRANSACTION_STATES.contains((Object)newState)) {
            Integer transactionHandle = transaction.getHandle();
            try (LockCloseable ignored = this.withLock();){
                Map<Long, InlineBlob> blobIdToInlineBlob = this.transactionToBlobIdToBlob.remove(transactionHandle);
                if (blobIdToInlineBlob == null || blobIdToInlineBlob.isEmpty()) {
                    return;
                }
                long removedSize = blobIdToInlineBlob.values().stream().mapToLong(InlineBlob::length).sum();
                this.size = Math.max(0L, this.size - removedSize);
            }
        }
    }

    @Override
    public void detached(FbDatabase database) {
        try (LockCloseable ignored = this.withLock();){
            this.transactionToBlobIdToBlob = Collections.emptyMap();
            this.size = 0L;
        }
    }

    private LockCloseable withLock() {
        return this.database.withLock();
    }
}

