\name{AdditiveGaussianNoiseImageFilter}
\alias{AdditiveGaussianNoiseImageFilter}
\title{AdditiveGaussianNoiseImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Alter an image with additive Gaussian white noise.
AdditiveGaussianNoiseImageFilter}
\details{
Additive Gaussian white noise can be modeled as:
 \eqn{ I = I_0 + N }
where \eqn{ I } is the observed image, \eqn{ I_0 } is the noise-free image and \eqn{ N } is a normally distributed random variable of mean \eqn{ \mu } and variance \eqn{ \sigma^2 } :
 \eqn{ N \sim \mathcal{N}(\mu, \sigma^2) }
 The noise is independent of the pixel intensities.
Gaetan Lehmann
 This code was contributed in the Insight Journal paper "Noise
Simulation". https://www.insight-journal.org/browse/publication/721
See:
AdditiveGaussianNoise for the procedural interface
itk::AdditiveGaussianNoiseImageFilter for the Doxygen on the original ITK class.
AdditiveGaussianNoiseImageFilter}
%C++ includes: sitkAdditiveGaussianNoiseImageFilter.h
\section{Methods}{
\describe{
\item{ AdditiveGaussianNoiseImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{Image Execute(const Image &image1):}{}
\item{Image Execute(Image &&image1):}{
Execute the filter on the input image
}
\item{double GetMean() const:}{
Set/Get the mean of the Gaussian distribution. Defaults to 0.0.
}
\item{std::string GetName() const:}{
Name of this class
}
\item{uint32_t GetSeed() const:}{}
\item{double GetStandardDeviation() const:}{
Set/Get the standard deviation of the Gaussian distribution. Defaults
to 1.0.
}
\item{Self SetMean(double Mean):}{
Set/Get the mean of the Gaussian distribution. Defaults to 0.0.
}
\item{Self SetSeed(uint32_t Seed):}{}
\item{Self SetStandardDeviation(double StandardDeviation):}{
Set/Get the standard deviation of the Gaussian distribution. Defaults
to 1.0.
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~AdditiveGaussianNoiseImageFilter():}{
Destructor
}
}
}
