/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.klimt.creole.command;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.klimt.font.FontStyle;
import net.sourceforge.plantuml.regex.Matcher2;
import net.sourceforge.plantuml.regex.Pattern2;

public class Splitter {
    static final String endFontPattern = "\\</font\\>|\\</color\\>|\\</size\\>|\\</text\\>";
    static final String endSupSub = "\\</sup\\>|\\</sub\\>";
    public static final String fontPattern = "\\<font(\\s+size[%s]*=[%s]*[%g]?\\d+[%g]?|[%s]+color[%s]*=\\s*[%g]?(#[0-9a-fA-F]{1,6}|\\w+)[%g]?)+[%s]*\\>";
    public static final String fontColorPattern = "\\<color[\\s:]+(#[0-9a-fA-F]{1,6}|#?\\w+)[%s]*\\>";
    public static final String fontSizePattern = "\\<size[\\s:]+(\\d+)[%s]*\\>";
    static final String fontSup = "\\<sup\\>";
    static final String fontSub = "\\<sub\\>";
    public static final String qrcodePattern = "\\<qrcode[\\s:]+([^>{}]+)(\\{scale=(?:[0-9.]+)\\})?\\>";
    static final String imgPattern = "\\<img\\s+(src[%s]*=[%s]*[%q%g]?[^\\s%g>]+[%q%g]?[%s]*|vspace\\s*=\\s*[%q%g]?\\d+[%q%g]?\\s*|valign[%s]*=[%s]*[%q%g]?(top|middle|bottom)[%q%g]?[%s]*)+\\>";
    public static final String imgPatternNoSrcColon = "\\<img[\\s:]+([^>{}]+)(\\{scale=(?:[0-9.]+)\\})?\\>";
    public static final String fontFamilyPattern = "\\<font[\\s:]+([^>]+)/?\\>";
    public static final String svgAttributePattern = "\\<text[\\s:]+([^>]+)/?\\>";
    private static final String scaleOrColor = "([\\{,]?(?:(?:scale=|\\*)[0-9.]+)?(?:,?color[= :](?:#[0-9a-fA-F]{1,8}|\\w+))?\\}?)?";
    public static final String emojiPattern = "\\<(#\\w+)?:([0-9a-z][0-9_a-z]*):([\\{,]?(?:(?:scale=|\\*)[0-9.]+)?(?:,?color[= :](?:#[0-9a-fA-F]{1,8}|\\w+))?\\}?)?\\>";
    public static final String openiconPattern = "\\<(#\\w+)?&([-\\w]+)([\\{,]?(?:(?:scale=|\\*)[0-9.]+)?(?:,?color[= :](?:#[0-9a-fA-F]{1,8}|\\w+))?\\}?)?\\>";
    public static final String spritePattern = "\\<(#\\w+)?\\$([-\\p{L}0-9_/]+)([\\{,]?(?:(?:scale=|\\*)[0-9.]+)?(?:,?color[= :](?:#[0-9a-fA-F]{1,8}|\\w+))?\\}?)?\\>";
    static final String htmlTag;
    static final String linkPattern = "\\[\\[([^\\[\\]]+)\\]\\]";
    public static final String mathPattern = "\\<math\\>(.+?)\\</math\\>";
    public static final String latexPattern = "\\<latex\\>(.+?)\\</latex\\>";
    private static final Pattern2 tagOrText;
    private final List<String> splitted = new ArrayList<String>();

    public Splitter(String s) {
        Matcher2 matcher = tagOrText.matcher(s);
        while (matcher.find()) {
            String part = matcher.group(0);
            part = StringUtils.showComparatorCharacters(part);
            this.splitted.add(part);
        }
    }

    List<String> getSplittedInternal() {
        return this.splitted;
    }

    public static String purgeAllTag(String s) {
        return s.replaceAll(htmlTag, "");
    }

    static {
        StringBuilder sb = new StringBuilder();
        for (FontStyle style : EnumSet.allOf(FontStyle.class)) {
            sb.append(style.getActivationPattern());
            sb.append('|');
            sb.append(style.getDeactivationPattern());
            sb.append('|');
        }
        sb.append(fontPattern);
        sb.append('|');
        sb.append(fontColorPattern);
        sb.append('|');
        sb.append(fontSizePattern);
        sb.append('|');
        sb.append(fontSup);
        sb.append('|');
        sb.append(fontSub);
        sb.append('|');
        sb.append(endFontPattern);
        sb.append('|');
        sb.append(endSupSub);
        sb.append('|');
        sb.append(qrcodePattern);
        sb.append('|');
        sb.append(imgPattern);
        sb.append('|');
        sb.append(imgPatternNoSrcColon);
        sb.append('|');
        sb.append(fontFamilyPattern);
        sb.append('|');
        sb.append(linkPattern);
        sb.append('|');
        sb.append(svgAttributePattern);
        htmlTag = sb.toString();
        tagOrText = Pattern2.cmpile(htmlTag + "|.+?(?=" + htmlTag + ")|.+$");
    }
}

