/*
 * Decompiled with CFR 0.152.
 */
package com.plantuml.ubrex;

import com.plantuml.ubrex.Capture;
import com.plantuml.ubrex.Challenge;
import com.plantuml.ubrex.ChallengeResult;
import com.plantuml.ubrex.TextNavigator;
import java.util.Collections;
import java.util.List;

public class CompositeNamed
implements Challenge {
    private final String name;
    private final List<Challenge> challenges;

    public String toString() {
        return "(" + this.name + ") " + this.challenges.toString();
    }

    public CompositeNamed(String name, Challenge challenge) {
        this.name = name;
        this.challenges = Collections.singletonList(challenge);
    }

    public CompositeNamed(String name, List<Challenge> challenges) {
        this.name = name;
        this.challenges = challenges;
    }

    @Override
    public ChallengeResult runChallenge(TextNavigator string, int position) {
        Capture capture = Capture.EMPTY;
        String value = null;
        Capture nonMergeableCapture = Capture.EMPTY;
        int current = position;
        for (Challenge challenge : this.challenges) {
            ChallengeResult shallWePass = challenge.runChallenge(string, current);
            if (shallWePass.getFullCaptureLength() < 0) {
                return new ChallengeResult(Integer.MIN_VALUE, capture);
            }
            current += shallWePass.getFullCaptureLength();
            capture = capture.merge(shallWePass.getCapture());
            if (value != null) continue;
            int onlyNameLength = shallWePass.getOnlyNameLength();
            int endIndex = position + onlyNameLength;
            value = string.subSequence(position, endIndex).toString();
            nonMergeableCapture = shallWePass.getNonMergeableCapture();
        }
        capture = capture.withPrefixedKeys(this.name);
        capture = capture.withEntry(this.name, value);
        capture = capture.merge(nonMergeableCapture);
        return new ChallengeResult(current - position, capture);
    }
}

