/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.ingest;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch.ingest.Processor;
import org.opensearch.client.opensearch.ingest.ProcessorBase;
import org.opensearch.client.opensearch.ingest.ProcessorVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class DissectProcessor
extends ProcessorBase
implements ProcessorVariant,
ToCopyableBuilder<Builder, DissectProcessor> {
    @Nullable
    private final String appendSeparator;
    @Nonnull
    private final String field;
    @Nullable
    private final Boolean ignoreMissing;
    @Nonnull
    private final String pattern;
    public static final JsonpDeserializer<DissectProcessor> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DissectProcessor::setupDissectProcessorDeserializer);

    private DissectProcessor(Builder builder) {
        super(builder);
        this.appendSeparator = builder.appendSeparator;
        this.field = ApiTypeHelper.requireNonNull(builder.field, this, "field");
        this.ignoreMissing = builder.ignoreMissing;
        this.pattern = ApiTypeHelper.requireNonNull(builder.pattern, this, "pattern");
    }

    public static DissectProcessor of(Function<Builder, ObjectBuilder<DissectProcessor>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Processor.Kind _processorKind() {
        return Processor.Kind.Dissect;
    }

    @Nullable
    public final String appendSeparator() {
        return this.appendSeparator;
    }

    @Nonnull
    public final String field() {
        return this.field;
    }

    @Nullable
    public final Boolean ignoreMissing() {
        return this.ignoreMissing;
    }

    @Nonnull
    public final String pattern() {
        return this.pattern;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.appendSeparator != null) {
            generator.writeKey("append_separator");
            generator.write(this.appendSeparator);
        }
        generator.writeKey("field");
        generator.write(this.field);
        if (this.ignoreMissing != null) {
            generator.writeKey("ignore_missing");
            generator.write(this.ignoreMissing.booleanValue());
        }
        generator.writeKey("pattern");
        generator.write(this.pattern);
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupDissectProcessorDeserializer(ObjectDeserializer<Builder> op) {
        DissectProcessor.setupProcessorBaseDeserializer(op);
        op.add(Builder::appendSeparator, JsonpDeserializer.stringDeserializer(), "append_separator");
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field");
        op.add(Builder::ignoreMissing, JsonpDeserializer.booleanDeserializer(), "ignore_missing");
        op.add(Builder::pattern, JsonpDeserializer.stringDeserializer(), "pattern");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.appendSeparator);
        result = 31 * result + this.field.hashCode();
        result = 31 * result + Objects.hashCode(this.ignoreMissing);
        result = 31 * result + this.pattern.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DissectProcessor other = (DissectProcessor)o;
        return Objects.equals(this.appendSeparator, other.appendSeparator) && this.field.equals(other.field) && Objects.equals(this.ignoreMissing, other.ignoreMissing) && this.pattern.equals(other.pattern);
    }

    public static class Builder
    extends ProcessorBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, DissectProcessor> {
        @Nullable
        private String appendSeparator;
        private String field;
        @Nullable
        private Boolean ignoreMissing;
        private String pattern;

        public Builder() {
        }

        private Builder(DissectProcessor o) {
            super(o);
            this.appendSeparator = o.appendSeparator;
            this.field = o.field;
            this.ignoreMissing = o.ignoreMissing;
            this.pattern = o.pattern;
        }

        private Builder(Builder o) {
            super(o);
            this.appendSeparator = o.appendSeparator;
            this.field = o.field;
            this.ignoreMissing = o.ignoreMissing;
            this.pattern = o.pattern;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder appendSeparator(@Nullable String value) {
            this.appendSeparator = value;
            return this;
        }

        @Nonnull
        public final Builder field(String value) {
            this.field = value;
            return this;
        }

        @Nonnull
        public final Builder ignoreMissing(@Nullable Boolean value) {
            this.ignoreMissing = value;
            return this;
        }

        @Nonnull
        public final Builder pattern(String value) {
            this.pattern = value;
            return this;
        }

        @Override
        @Nonnull
        public DissectProcessor build() {
            this._checkSingleUse();
            return new DissectProcessor(this);
        }
    }
}

