/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.indices.stats;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch.indices.stats.IndexShardStats;
import org.opensearch.client.opensearch.indices.stats.IndexStats;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class IndicesStats
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, IndicesStats> {
    @Nonnull
    private final IndexStats primaries;
    @Nonnull
    private final Map<String, List<IndexShardStats>> shards;
    @Nonnull
    private final IndexStats total;
    @Nonnull
    private final String uuid;
    public static final JsonpDeserializer<IndicesStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, IndicesStats::setupIndicesStatsDeserializer);

    private IndicesStats(Builder builder) {
        this.primaries = ApiTypeHelper.requireNonNull(builder.primaries, this, "primaries");
        this.shards = ApiTypeHelper.unmodifiable(builder.shards);
        this.total = ApiTypeHelper.requireNonNull(builder.total, this, "total");
        this.uuid = ApiTypeHelper.requireNonNull(builder.uuid, this, "uuid");
    }

    public static IndicesStats of(Function<Builder, ObjectBuilder<IndicesStats>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final IndexStats primaries() {
        return this.primaries;
    }

    @Nonnull
    public final Map<String, List<IndexShardStats>> shards() {
        return this.shards;
    }

    @Nonnull
    public final IndexStats total() {
        return this.total;
    }

    @Nonnull
    public final String uuid() {
        return this.uuid;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("primaries");
        this.primaries.serialize(generator, mapper);
        if (ApiTypeHelper.isDefined(this.shards)) {
            generator.writeKey("shards");
            generator.writeStartObject();
            for (Map.Entry<String, List<IndexShardStats>> item0 : this.shards.entrySet()) {
                generator.writeKey(item0.getKey());
                generator.writeStartArray();
                if (item0.getValue() != null) {
                    for (IndexShardStats item1 : item0.getValue()) {
                        item1.serialize(generator, mapper);
                    }
                }
                generator.writeEnd();
            }
            generator.writeEnd();
        }
        generator.writeKey("total");
        this.total.serialize(generator, mapper);
        generator.writeKey("uuid");
        generator.write(this.uuid);
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupIndicesStatsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::primaries, IndexStats._DESERIALIZER, "primaries");
        op.add(Builder::shards, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.arrayDeserializer(IndexShardStats._DESERIALIZER)), "shards");
        op.add(Builder::total, IndexStats._DESERIALIZER, "total");
        op.add(Builder::uuid, JsonpDeserializer.stringDeserializer(), "uuid");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.primaries.hashCode();
        result = 31 * result + Objects.hashCode(this.shards);
        result = 31 * result + this.total.hashCode();
        result = 31 * result + this.uuid.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndicesStats other = (IndicesStats)o;
        return this.primaries.equals(other.primaries) && Objects.equals(this.shards, other.shards) && this.total.equals(other.total) && this.uuid.equals(other.uuid);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, IndicesStats> {
        private IndexStats primaries;
        @Nullable
        private Map<String, List<IndexShardStats>> shards;
        private IndexStats total;
        private String uuid;

        public Builder() {
        }

        private Builder(IndicesStats o) {
            this.primaries = o.primaries;
            this.shards = Builder._mapCopy(o.shards);
            this.total = o.total;
            this.uuid = o.uuid;
        }

        private Builder(Builder o) {
            this.primaries = o.primaries;
            this.shards = Builder._mapCopy(o.shards);
            this.total = o.total;
            this.uuid = o.uuid;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder primaries(IndexStats value) {
            this.primaries = value;
            return this;
        }

        @Nonnull
        public final Builder primaries(Function<IndexStats.Builder, ObjectBuilder<IndexStats>> fn) {
            return this.primaries(fn.apply(new IndexStats.Builder()).build());
        }

        @Nonnull
        public final Builder shards(Map<String, List<IndexShardStats>> map) {
            this.shards = Builder._mapPutAll(this.shards, map);
            return this;
        }

        @Nonnull
        public final Builder shards(String key, List<IndexShardStats> value) {
            this.shards = Builder._mapPut(this.shards, key, value);
            return this;
        }

        @Nonnull
        public final Builder total(IndexStats value) {
            this.total = value;
            return this;
        }

        @Nonnull
        public final Builder total(Function<IndexStats.Builder, ObjectBuilder<IndexStats>> fn) {
            return this.total(fn.apply(new IndexStats.Builder()).build());
        }

        @Nonnull
        public final Builder uuid(String value) {
            this.uuid = value;
            return this;
        }

        @Override
        @Nonnull
        public IndicesStats build() {
            this._checkSingleUse();
            return new IndicesStats(this);
        }
    }
}

