/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.core.bulk;

import jakarta.json.stream.JsonGenerator;
import java.util.Iterator;
import java.util.function.Function;
import org.opensearch.client.json.JsonEnum;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.JsonpSerializable;
import org.opensearch.client.json.NdJsonpSerializable;
import org.opensearch.client.opensearch.core.bulk.BulkOperationVariant;
import org.opensearch.client.opensearch.core.bulk.CreateOperation;
import org.opensearch.client.opensearch.core.bulk.DeleteOperation;
import org.opensearch.client.opensearch.core.bulk.IndexOperation;
import org.opensearch.client.opensearch.core.bulk.UpdateOperation;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.TaggedUnion;
import org.opensearch.client.util.TaggedUnionUtils;

public class BulkOperation
implements TaggedUnion<Kind, Object>,
NdJsonpSerializable,
JsonpSerializable {
    private final Kind _kind;
    private final Object _value;

    @Override
    public final Kind _kind() {
        return this._kind;
    }

    @Override
    public final Object _get() {
        return this._value;
    }

    public BulkOperation(BulkOperationVariant value) {
        this._kind = ApiTypeHelper.requireNonNull(value._bulkOperationKind(), this, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(value, this, "<variant value>");
    }

    private BulkOperation(Builder builder) {
        this._kind = ApiTypeHelper.requireNonNull(builder._kind, builder, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(builder._value, builder, "<variant value>");
    }

    public static BulkOperation of(Function<Builder, ObjectBuilder<BulkOperation>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Iterator<?> _serializables() {
        return TaggedUnionUtils.ndJsonIterator(this);
    }

    public boolean isIndex() {
        return this._kind == Kind.Index;
    }

    public <TDocument> IndexOperation<TDocument> index() {
        return (IndexOperation)TaggedUnionUtils.get(this, Kind.Index);
    }

    public boolean isCreate() {
        return this._kind == Kind.Create;
    }

    public <TDocument> CreateOperation<TDocument> create() {
        return (CreateOperation)TaggedUnionUtils.get(this, Kind.Create);
    }

    public boolean isUpdate() {
        return this._kind == Kind.Update;
    }

    public <TDocument> UpdateOperation<TDocument> update() {
        return (UpdateOperation)TaggedUnionUtils.get(this, Kind.Update);
    }

    public boolean isDelete() {
        return this._kind == Kind.Delete;
    }

    public DeleteOperation delete() {
        return (DeleteOperation)TaggedUnionUtils.get(this, Kind.Delete);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        generator.writeKey(this._kind.jsonValue());
        if (this._value instanceof JsonpSerializable) {
            ((JsonpSerializable)this._value).serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<BulkOperation> {
        private Kind _kind;
        private Object _value;

        public <TDocument> ObjectBuilder<BulkOperation> index(IndexOperation<TDocument> v) {
            this._kind = Kind.Index;
            this._value = v;
            return this;
        }

        public <TDocument> ObjectBuilder<BulkOperation> index(Function<IndexOperation.Builder<TDocument>, ObjectBuilder<IndexOperation<TDocument>>> fn) {
            return this.index(fn.apply(new IndexOperation.Builder()).build());
        }

        public <TDocument> ObjectBuilder<BulkOperation> create(CreateOperation<TDocument> v) {
            this._kind = Kind.Create;
            this._value = v;
            return this;
        }

        public <TDocument> ObjectBuilder<BulkOperation> create(Function<CreateOperation.Builder<TDocument>, ObjectBuilder<CreateOperation<TDocument>>> fn) {
            return this.create(fn.apply(new CreateOperation.Builder()).build());
        }

        public <TDocument> ObjectBuilder<BulkOperation> update(UpdateOperation<TDocument> v) {
            this._kind = Kind.Update;
            this._value = v;
            return this;
        }

        public <TDocument> ObjectBuilder<BulkOperation> update(Function<UpdateOperation.Builder<TDocument>, ObjectBuilder<UpdateOperation<TDocument>>> fn) {
            return this.update(fn.apply(new UpdateOperation.Builder()).build());
        }

        public ObjectBuilder<BulkOperation> delete(DeleteOperation v) {
            this._kind = Kind.Delete;
            this._value = v;
            return this;
        }

        public ObjectBuilder<BulkOperation> delete(Function<DeleteOperation.Builder, ObjectBuilder<DeleteOperation>> fn) {
            return this.delete(fn.apply(new DeleteOperation.Builder()).build());
        }

        @Override
        public BulkOperation build() {
            this._checkSingleUse();
            return new BulkOperation(this);
        }
    }

    public static enum Kind implements JsonEnum
    {
        Index("index"),
        Create("create"),
        Update("update"),
        Delete("delete");

        private final String jsonValue;

        private Kind(String jsonValue) {
            this.jsonValue = jsonValue;
        }

        @Override
        public String jsonValue() {
            return this.jsonValue;
        }
    }
}

