/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.rollup;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.ExceptionsHelper;
import org.opensearch.action.DocWriteRequest;
import org.opensearch.action.bulk.BackoffPolicy;
import org.opensearch.action.bulk.BulkItemResponse;
import org.opensearch.action.bulk.BulkRequest;
import org.opensearch.action.bulk.BulkResponse;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.indexmanagement.opensearchapi.OpenSearchExtensionsKt;
import org.opensearch.indexmanagement.rollup.RollupIndexResult;
import org.opensearch.indexmanagement.rollup.RollupIndexer;
import org.opensearch.indexmanagement.rollup.model.Rollup;
import org.opensearch.indexmanagement.rollup.model.RollupStats;
import org.opensearch.indexmanagement.rollup.settings.RollupSettings;
import org.opensearch.indexmanagement.rollup.util.RollupFieldValueExpressionResolver;
import org.opensearch.indexmanagement.rollup.util.RollupUtilsKt;
import org.opensearch.indexmanagement.util.IndexUtils;
import org.opensearch.search.aggregations.Aggregation;
import org.opensearch.search.aggregations.Aggregations;
import org.opensearch.search.aggregations.bucket.composite.InternalComposite;
import org.opensearch.search.aggregations.metrics.InternalAvg;
import org.opensearch.search.aggregations.metrics.InternalMax;
import org.opensearch.search.aggregations.metrics.InternalMin;
import org.opensearch.search.aggregations.metrics.InternalSum;
import org.opensearch.search.aggregations.metrics.InternalValueCount;
import org.opensearch.transport.RemoteTransportException;
import org.opensearch.transport.client.Client;
import org.opensearch.transport.client.OpenSearchClient;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ \u0010\u000e\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u001e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0086@\u00a2\u0006\u0002\u0010\u0018R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \u000b*\u0004\u0018\u00010\r0\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/opensearch/indexmanagement/rollup/RollupIndexer;", "", "settings", "Lorg/opensearch/common/settings/Settings;", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "client", "Lorg/opensearch/transport/client/Client;", "(Lorg/opensearch/common/settings/Settings;Lorg/opensearch/cluster/service/ClusterService;Lorg/opensearch/transport/client/Client;)V", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "retryIngestPolicy", "Lorg/opensearch/action/bulk/BackoffPolicy;", "convertResponseToRequests", "", "Lorg/opensearch/action/DocWriteRequest;", "job", "Lorg/opensearch/indexmanagement/rollup/model/Rollup;", "internalComposite", "Lorg/opensearch/search/aggregations/bucket/composite/InternalComposite;", "indexRollups", "Lorg/opensearch/indexmanagement/rollup/RollupIndexResult;", "rollup", "(Lorg/opensearch/indexmanagement/rollup/model/Rollup;Lorg/opensearch/search/aggregations/bucket/composite/InternalComposite;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "opensearch-index-management"})
@SourceDebugExtension(value={"SMAP\nRollupIndexer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RollupIndexer.kt\norg/opensearch/indexmanagement/rollup/RollupIndexer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,147:1\n1855#2:148\n1855#2,2:149\n1855#2,2:151\n1856#2:153\n*S KotlinDebug\n*F\n+ 1 RollupIndexer.kt\norg/opensearch/indexmanagement/rollup/RollupIndexer\n*L\n109#1:148\n115#1:149,2\n116#1:151,2\n109#1:153\n*E\n"})
public final class RollupIndexer {
    @NotNull
    private final Client client;
    private final Logger logger;
    private volatile BackoffPolicy retryIngestPolicy;

    public RollupIndexer(@NotNull Settings settings, @NotNull ClusterService clusterService, @NotNull Client client) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        this.client = client;
        this.logger = LogManager.getLogger(this.getClass());
        TimeValue timeValue = (TimeValue)RollupSettings.Companion.getROLLUP_INGEST_BACKOFF_MILLIS().get(settings);
        Object object = RollupSettings.Companion.getROLLUP_INGEST_BACKOFF_COUNT().get(settings);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        this.retryIngestPolicy = BackoffPolicy.constantBackoff((TimeValue)timeValue, (int)((Number)object).intValue());
        clusterService.getClusterSettings().addSettingsUpdateConsumer(RollupSettings.Companion.getROLLUP_INGEST_BACKOFF_MILLIS(), RollupSettings.Companion.getROLLUP_INGEST_BACKOFF_COUNT(), (arg_0, arg_1) -> RollupIndexer._init_$lambda$0(this, arg_0, arg_1));
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object indexRollups(@NotNull Rollup var1_1, @NotNull InternalComposite var2_2, @NotNull Continuation<? super RollupIndexResult> var3_3) {
        if (!(var3_3 instanceof indexRollups.1)) ** GOTO lbl-1000
        var8_4 = var3_3;
        if ((var8_4.label & -2147483648) != 0) {
            var8_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ RollupIndexer this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.indexRollups(null, null, (Continuation<? super RollupIndexResult>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var9_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                requestsToRetry = new Ref.ObjectRef();
                requestsToRetry.element = this.convertResponseToRequests((Rollup)rollup, (InternalComposite)internalComposite);
                stats = new Ref.ObjectRef();
                stats.element = new RollupStats(0L, 0L, ((List)requestsToRetry.element).size(), 0L, 0L);
                nonRetryableFailures = new ArrayList<E>();
                if (!(((Collection)requestsToRetry.element).isEmpty() == false)) ** GOTO lbl40
                v0 = this.retryIngestPolicy;
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"retryIngestPolicy");
                v1 = this.logger;
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"logger");
                $continuation.L$0 = this;
                $continuation.L$1 = stats;
                $continuation.L$2 = nonRetryableFailures;
                $continuation.label = 1;
                v2 = OpenSearchExtensionsKt.retry(v0, v1, CollectionsKt.listOf((Object)RestStatus.TOO_MANY_REQUESTS), (Function2)new Function2<TimeValue, Continuation<? super Unit>, Object>(requestsToRetry, this, (Ref.ObjectRef<RollupStats>)stats, (List<BulkItemResponse>)nonRetryableFailures, null){
                    int label;
                    /* synthetic */ Object L$0;
                    final /* synthetic */ Ref.ObjectRef<List<DocWriteRequest<?>>> $requestsToRetry;
                    final /* synthetic */ RollupIndexer this$0;
                    final /* synthetic */ Ref.ObjectRef<RollupStats> $stats;
                    final /* synthetic */ List<BulkItemResponse> $nonRetryableFailures;
                    {
                        this.$requestsToRetry = $requestsToRetry;
                        this.this$0 = $receiver;
                        this.$stats = $stats;
                        this.$nonRetryableFailures = $nonRetryableFailures;
                        super(2, $completion);
                    }

                    /*
                     * Unable to fully structure code
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object var1_1) {
                        var18_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)var1_1);
                                it = (TimeValue)this.L$0;
                                if (it.getSeconds() >= 900L) {
                                    v0 = ExceptionsHelper.convertToOpenSearchException((Exception)new IllegalStateException("Cannot retry ingestion with a delay more than half of the rollup lock TTL"));
                                    Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"convertToOpenSearchException(...)");
                                    throw (Throwable)v0;
                                }
                                bulkRequest = new BulkRequest().add((Iterable)this.$requestsToRetry.element);
                                this.L$0 = bulkRequest;
                                this.label = 1;
                                v1 = OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)RollupIndexer.access$getClient$p(this.this$0), (Function2)new Function2<Client, ActionListener<BulkResponse>, Unit>(bulkRequest){
                                    final /* synthetic */ BulkRequest $bulkRequest;
                                    {
                                        this.$bulkRequest = $bulkRequest;
                                        super(2);
                                    }

                                    public final void invoke(@NotNull Client $this$suspendUntil, @NotNull ActionListener<BulkResponse> it) {
                                        Intrinsics.checkNotNullParameter((Object)$this$suspendUntil, (String)"$this$suspendUntil");
                                        Intrinsics.checkNotNullParameter(it, (String)"it");
                                        $this$suspendUntil.bulk(this.$bulkRequest, it);
                                    }
                                }, (Continuation)this);
                                if (v1 == var18_2) {
                                    return var18_2;
                                }
                                ** GOTO lbl21
                            }
                            case 1: {
                                bulkRequest = (BulkRequest)this.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v1 = $result;
lbl21:
                                // 2 sources

                                bulkResponse = (BulkResponse)v1;
                                this.$stats.element = RollupStats.copy$default((RollupStats)this.$stats.element, 0L, 0L, 0L, ((RollupStats)this.$stats.element).getIndexTimeInMillis() + bulkResponse.getTook().getMillis(), 0L, 23, null);
                                retryableFailures = new ArrayList<E>();
                                v2 = bulkResponse.getItems();
                                if (v2 == null) {
                                    v2 = new BulkItemResponse[]{};
                                }
                                $this$filter$iv = v2;
                                $i$f$filter = false;
                                var8_11 = $this$filter$iv;
                                destination$iv$iv = new ArrayList<E>();
                                $i$f$filterTo = false;
                                for (BulkItemResponse element$iv$iv : $this$filterTo$iv$iv) {
                                    it = element$iv$iv;
                                    $i$a$-filter-RollupIndexer$indexRollups$2$1 = false;
                                    if (!it.isFailed()) continue;
                                    destination$iv$iv.add(element$iv$iv);
                                }
                                $this$forEach$iv = (List)destination$iv$iv;
                                $i$f$filter = this.$nonRetryableFailures;
                                $i$f$forEach = false;
                                for (E element$iv : $this$forEach$iv) {
                                    failedResponse = (BulkItemResponse)element$iv;
                                    $i$a$-forEach-RollupIndexer$indexRollups$2$2 = false;
                                    if (failedResponse.status() == RestStatus.TOO_MANY_REQUESTS) {
                                        Intrinsics.checkNotNull((Object)failedResponse);
                                        retryableFailures.add(failedResponse);
                                        continue;
                                    }
                                    Intrinsics.checkNotNull((Object)failedResponse);
                                    $i$f$filter.add(failedResponse);
                                }
                                $this$forEach$iv = retryableFailures;
                                var16_26 = this.$requestsToRetry;
                                $i$f$map = false;
                                $i$f$forEach = $this$map$iv;
                                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                                $i$f$mapTo = false;
                                for (T item$iv$iv : $this$mapTo$iv$iv) {
                                    element$iv$iv = (BulkItemResponse)item$iv$iv;
                                    var17_27 = destination$iv$iv;
                                    $i$a$-map-RollupIndexer$indexRollups$2$3 = false;
                                    v3 = bulkRequest.requests().get(retryableFailure.getItemId());
                                    Intrinsics.checkNotNull(v3, (String)"null cannot be cast to non-null type org.opensearch.action.index.IndexRequest");
                                    var17_27.add((IndexRequest)v3);
                                }
                                var16_26.element = (List)destination$iv$iv;
                                if (((Collection)this.$requestsToRetry.element).isEmpty() == false) {
                                    retryCause = ((BulkItemResponse)CollectionsKt.first((List)retryableFailures)).getFailure().getCause();
                                    v4 = ExceptionsHelper.convertToOpenSearchException((Exception)retryCause);
                                    Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"convertToOpenSearchException(...)");
                                    throw (Throwable)v4;
                                }
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        var var3_3 = new /* invalid duplicate definition of identical inner class */;
                        var3_3.L$0 = value;
                        return (Continuation)var3_3;
                    }

                    @Nullable
                    public final Object invoke(@NotNull TimeValue p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }, $continuation);
                ** if (v2 != var9_6) goto lbl31
lbl30:
                // 1 sources

                return var9_6;
lbl31:
                // 1 sources

                ** GOTO lbl40
            }
            case 1: {
                nonRetryableFailures = (List)$continuation.L$2;
                stats = (Ref.ObjectRef)$continuation.L$1;
                this = (RollupIndexer)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = $result;
lbl40:
                    // 3 sources

                    if (((Collection)nonRetryableFailures).isEmpty() == false) {
                        this.logger.error("Failed to index " + nonRetryableFailures.size() + " documents");
                        v3 = ExceptionsHelper.convertToOpenSearchException((Exception)((BulkItemResponse)CollectionsKt.first((List)nonRetryableFailures)).getFailure().getCause());
                        Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"convertToOpenSearchException(...)");
                        throw (Throwable)v3;
                    }
                    return new RollupIndexResult.Success((RollupStats)stats.element);
                }
                catch (RemoteTransportException e) {
                    this.logger.error(e.getMessage(), e.getCause());
                    v4 = ExceptionsHelper.unwrapCause((Throwable)e);
                    Intrinsics.checkNotNull((Object)v4, (String)"null cannot be cast to non-null type java.lang.Exception{ kotlin.TypeAliasesKt.Exception }");
                    return new RollupIndexResult.Failure(null, (Exception)v4, 1, null);
                }
                catch (Exception e) {
                    this.logger.error(e.getMessage(), e.getCause());
                    return new RollupIndexResult.Failure(null, e, 1, null);
                }
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @NotNull
    public final List<DocWriteRequest<?>> convertResponseToRequests(@NotNull Rollup job, @NotNull InternalComposite internalComposite) {
        Intrinsics.checkNotNullParameter((Object)job, (String)"job");
        Intrinsics.checkNotNullParameter((Object)internalComposite, (String)"internalComposite");
        List requests = new ArrayList();
        List list = internalComposite.getBuckets();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getBuckets(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object object;
            Object object2;
            Object object3;
            Map.Entry it;
            InternalComposite.InternalBucket it2 = (InternalComposite.InternalBucket)element$iv;
            boolean bl = false;
            String docId2 = job.getId() + "#" + CollectionsKt.joinToString$default((Iterable)it2.getKey().entrySet(), (CharSequence)"#", null, null, (int)0, null, (Function1)convertResponseToRequests.1.docId.1.INSTANCE, (int)30, null);
            String documentId = IndexUtils.Companion.hashToFixedSize(docId2);
            Map<String, Object> mapOfKeyValues = RollupUtilsKt.getInitialDocValues(job, it2.getDocCount());
            Map aggResults = new LinkedHashMap();
            Iterable $this$forEach$iv2 = it2.getKey().entrySet();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                it = (Map.Entry)element$iv2;
                boolean bl2 = false;
                object3 = aggResults;
                Intrinsics.checkNotNullExpressionValue(it.getKey(), (String)"<get-key>(...)");
                object2 = it.getValue();
                object3.put(object, object2);
            }
            Aggregations aggregations = it2.getAggregations();
            Intrinsics.checkNotNullExpressionValue((Object)aggregations, (String)"getAggregations(...)");
            $this$forEach$iv2 = (Iterable)aggregations;
            $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Number number;
                it = (Aggregation)element$iv2;
                boolean bl3 = false;
                object3 = it;
                if (object3 instanceof InternalSum) {
                    object = aggResults;
                    Intrinsics.checkNotNullExpressionValue((Object)((InternalSum)it).getName(), (String)"getName(...)");
                    number = ((InternalSum)it).getValue();
                    object.put(object2, (Double)number);
                    continue;
                }
                if (object3 instanceof InternalMax) {
                    if (Double.isInfinite(((InternalMax)it).getValue())) {
                        object = aggResults;
                        Intrinsics.checkNotNullExpressionValue((Object)((InternalMax)it).getName(), (String)"getName(...)");
                        number = null;
                        object.put(object2, number);
                        continue;
                    }
                    object = aggResults;
                    Intrinsics.checkNotNullExpressionValue((Object)((InternalMax)it).getName(), (String)"getName(...)");
                    number = ((InternalMax)it).getValue();
                    object.put(object2, number);
                    continue;
                }
                if (object3 instanceof InternalMin) {
                    if (Double.isInfinite(((InternalMin)it).getValue())) {
                        object = aggResults;
                        Intrinsics.checkNotNullExpressionValue((Object)((InternalMin)it).getName(), (String)"getName(...)");
                        number = null;
                        object.put(object2, number);
                        continue;
                    }
                    object = aggResults;
                    Intrinsics.checkNotNullExpressionValue((Object)((InternalMin)it).getName(), (String)"getName(...)");
                    number = ((InternalMin)it).getValue();
                    object.put(object2, number);
                    continue;
                }
                if (object3 instanceof InternalValueCount) {
                    object = aggResults;
                    Intrinsics.checkNotNullExpressionValue((Object)((InternalValueCount)it).getName(), (String)"getName(...)");
                    number = ((InternalValueCount)it).getValue();
                    object.put(object2, number);
                    continue;
                }
                if (object3 instanceof InternalAvg) {
                    object = aggResults;
                    Intrinsics.checkNotNullExpressionValue((Object)((InternalAvg)it).getName(), (String)"getName(...)");
                    number = ((InternalAvg)it).getValue();
                    object.put(object2, number);
                    continue;
                }
                throw new IllegalStateException(("Found aggregation in composite result that is not supported [" + it.getType() + " - " + it.getName() + "]").toString());
            }
            mapOfKeyValues.putAll(aggResults);
            String targetIndexResolvedName = RollupFieldValueExpressionResolver.INSTANCE.resolve(job, job.getTargetIndex());
            IndexRequest indexRequest = new IndexRequest(targetIndexResolvedName).id(documentId).source(mapOfKeyValues, (MediaType)XContentType.JSON);
            Intrinsics.checkNotNull((Object)indexRequest);
            requests.add(indexRequest);
        }
        return requests;
    }

    private static final void _init_$lambda$0(RollupIndexer this$0, TimeValue millis, Integer count) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNull((Object)count);
        this$0.retryIngestPolicy = BackoffPolicy.constantBackoff((TimeValue)millis, (int)count);
    }

    public static final /* synthetic */ Client access$getClient$p(RollupIndexer $this) {
        return $this.client;
    }
}

