import * as React from "react";
interface Props {
    /**
     * The HTML string that will be rendered.
     */
    data: string;
    /**
     * The media type associated with the HTML
     * string. This defaults to text/html.
     */
    mediaType: "text/html";
}
export declare class HTML extends React.PureComponent<Props> {
    static defaultProps: {
        data: string;
        mediaType: string;
    };
    el?: HTMLElement | null;
    componentDidMount(): void;
    componentDidUpdate(): void;
    render(): JSX.Element;
}
export default HTML;
