/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.CollectionTerminatedException;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.ScoreMode;
import org.opensearch.core.indices.breaker.CircuitBreakerService;
import org.opensearch.search.SearchShardTarget;
import org.opensearch.search.aggregations.Aggregator;
import org.opensearch.search.aggregations.AggregatorFactories;
import org.opensearch.search.aggregations.BucketCollector;
import org.opensearch.search.aggregations.CardinalityUpperBound;
import org.opensearch.search.aggregations.InternalAggregation;
import org.opensearch.search.aggregations.InternalAggregations;
import org.opensearch.search.aggregations.LeafBucketCollector;
import org.opensearch.search.aggregations.MultiBucketCollector;
import org.opensearch.search.aggregations.support.ValuesSourceConfig;
import org.opensearch.search.internal.SearchContext;
import org.opensearch.search.query.QueryPhaseExecutionException;

public abstract class AggregatorBase
extends Aggregator {
    public static final int DEFAULT_WEIGHT = 5120;
    protected final String name;
    protected final Aggregator parent;
    protected final SearchContext context;
    private final Map<String, Object> metadata;
    protected final Aggregator[] subAggregators;
    protected BucketCollector collectableSubAggregators;
    private Map<String, Aggregator> subAggregatorbyName;
    private final CircuitBreakerService breakerService;
    private long requestBytesUsed;

    protected AggregatorBase(String name, AggregatorFactories factories, SearchContext context, Aggregator parent, CardinalityUpperBound subAggregatorCardinality, Map<String, Object> metadata) throws IOException {
        this.name = name;
        this.metadata = metadata;
        this.parent = parent;
        this.context = context;
        this.breakerService = context.bigArrays().breakerService();
        assert (factories != null) : "sub-factories provided to BucketAggregator must not be null, use AggragatorFactories.EMPTY instead";
        this.subAggregators = factories.createSubAggregators(context, this, subAggregatorCardinality);
        context.addReleasable(this);
        final SearchShardTarget shardTarget = context.shardTarget();
        this.collectableSubAggregators = new BucketCollector(this){

            void badState() {
                throw new QueryPhaseExecutionException(shardTarget, "preCollection not called on new Aggregator before use", null);
            }

            @Override
            public LeafBucketCollector getLeafCollector(LeafReaderContext reader) {
                this.badState();
                assert (false);
                return null;
            }

            @Override
            public void preCollection() throws IOException {
                this.badState();
            }

            @Override
            public void postCollection() throws IOException {
                this.badState();
            }

            public ScoreMode scoreMode() {
                this.badState();
                return ScoreMode.COMPLETE;
            }
        };
        this.addRequestCircuitBreakerBytes(5120L);
    }

    public final Function<byte[], Number> pointReaderIfAvailable(ValuesSourceConfig config) {
        if (this.context.query() != null && this.context.query().getClass() != MatchAllDocsQuery.class) {
            return null;
        }
        if (this.parent != null) {
            return null;
        }
        return config.getPointReaderOrNull();
    }

    protected long addRequestCircuitBreakerBytes(long bytes) {
        if (bytes > 0L) {
            this.breakerService.getBreaker("request").addEstimateBytesAndMaybeBreak(bytes, "<agg [" + this.name + "]>");
        } else {
            this.breakerService.getBreaker("request").addWithoutBreaking(bytes);
        }
        this.requestBytesUsed += bytes;
        return this.requestBytesUsed;
    }

    public ScoreMode scoreMode() {
        for (Aggregator agg : this.subAggregators) {
            if (!agg.scoreMode().needsScores()) continue;
            return ScoreMode.COMPLETE;
        }
        return ScoreMode.COMPLETE_NO_SCORES;
    }

    public Map<String, Object> metadata() {
        return this.metadata;
    }

    protected abstract LeafBucketCollector getLeafCollector(LeafReaderContext var1, LeafBucketCollector var2) throws IOException;

    @Override
    public final LeafBucketCollector getLeafCollector(LeafReaderContext ctx) throws IOException {
        if (this.tryPrecomputeAggregationForLeaf(ctx)) {
            throw new CollectionTerminatedException();
        }
        this.preGetSubLeafCollectors(ctx);
        LeafBucketCollector sub = this.collectableSubAggregators.getLeafCollector(ctx);
        return this.getLeafCollector(ctx, sub);
    }

    protected void preGetSubLeafCollectors(LeafReaderContext ctx) throws IOException {
    }

    protected void doPreCollection() throws IOException {
    }

    protected boolean tryPrecomputeAggregationForLeaf(LeafReaderContext ctx) throws IOException {
        return false;
    }

    @Override
    public final void preCollection() throws IOException {
        List<Aggregator> collectors = Arrays.asList(this.subAggregators);
        this.collectableSubAggregators = MultiBucketCollector.wrap(collectors);
        this.doPreCollection();
        this.collectableSubAggregators.preCollection();
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Aggregator parent() {
        return this.parent;
    }

    public Aggregator[] subAggregators() {
        return this.subAggregators;
    }

    @Override
    public Aggregator subAggregator(String aggName) {
        if (this.subAggregatorbyName == null) {
            this.subAggregatorbyName = new HashMap<String, Aggregator>(this.subAggregators.length);
            for (Aggregator subAggregator : this.subAggregators) {
                this.subAggregatorbyName.put(subAggregator.name(), subAggregator);
            }
        }
        return this.subAggregatorbyName.get(aggName);
    }

    @Override
    public SearchContext context() {
        return this.context;
    }

    @Override
    public void postCollection() throws IOException {
        this.doPostCollection();
        this.collectableSubAggregators.postCollection();
    }

    public void close() {
        try {
            this.doClose();
        }
        finally {
            this.breakerService.getBreaker("request").addWithoutBreaking(-this.requestBytesUsed);
        }
    }

    protected void doClose() {
    }

    protected void doPostCollection() throws IOException {
    }

    protected final InternalAggregations buildEmptySubAggregations() {
        ArrayList<InternalAggregation> aggs = new ArrayList<InternalAggregation>();
        for (Aggregator aggregator : this.subAggregators) {
            aggs.add(aggregator.buildEmptyAggregation());
        }
        return InternalAggregations.from(aggs);
    }

    public String toString() {
        return this.name;
    }
}

