# Copyright (C) 2020-2023 by the Free Software Foundation, Inc.
#
# This file is part of GNU Mailman.
#
# GNU Mailman is free software: you can redistribute it and/or modify it under
# the terms of the GNU General Public License as published by the Free
# Software Foundation, either version 3 of the License, or (at your option)
# any later version.
#
# GNU Mailman is distributed in the hope that it will be useful, but WITHOUT
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
# FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
# more details.
#
# You should have received a copy of the GNU General Public License along with
# GNU Mailman.  If not, see <https://www.gnu.org/licenses/>.

"""add_domain_webhost

Revision ID: 729a8f2045da
Revises: 2156fc3f6f7d
Create Date: 2024-03-23 20:40:52.500161

"""
import mailman
import sqlalchemy as sa

from alembic import op


# revision identifiers, used by Alembic.
revision = '729a8f2045da'
down_revision = '2156fc3f6f7d'


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table('domain', schema=None) as batch_op:
        batch_op.add_column(sa.Column(
            'base_url', mailman.database.types.SAUnicode(), nullable=True))
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table('domain', schema=None) as batch_op:
        batch_op.drop_column('base_url')

    # ### end Alembic commands ###
