/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tools;

import org.apache.commons.lang3.StringUtils;
import org.languagetool.tools.StringTools;

public class ContextTools {
    private int contextSize = 40;
    private boolean escapeHtml = true;
    private String errorMarkerStart = "<b><font bgcolor=\"#ff8b8b\">";
    private String errorMarkerEnd = "</font></b>";

    public String getContext(int fromPos, int toPos, String contents) {
        int textLength;
        int endContent;
        int startContent = fromPos - this.contextSize;
        String prefix = "...";
        String postfix = "...";
        if (startContent < 0) {
            prefix = "";
            startContent = 0;
        }
        if ((endContent = toPos + this.contextSize) > (textLength = contents.length())) {
            postfix = "";
            endContent = textLength;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(prefix);
        sb.append(contents.substring(startContent, endContent).replace('\n', ' '));
        String markerStr = ContextTools.getMarker(fromPos, toPos, startContent, endContent, prefix);
        sb.append(postfix);
        int startMark = markerStr.indexOf(94);
        int endMark = markerStr.lastIndexOf(94);
        Object result = sb.toString();
        if (this.escapeHtml) {
            String escapedErrorPart = StringTools.escapeHTML(((String)result).substring(startMark, endMark + 1)).replace(" ", "&nbsp;");
            result = StringTools.escapeHTML(((String)result).substring(0, startMark)) + this.errorMarkerStart + escapedErrorPart + this.errorMarkerEnd + StringTools.escapeHTML(((String)result).substring(endMark + 1));
        } else {
            result = ((String)result).substring(0, startMark) + this.errorMarkerStart + ((String)result).substring(startMark, endMark + 1) + this.errorMarkerEnd + ((String)result).substring(endMark + 1);
        }
        return result;
    }

    public String getPlainTextContext(int fromPos, int toPos, String contents) {
        int endContent;
        int startContent = fromPos - this.contextSize;
        String prefix = "...";
        String postfix = "...";
        if (startContent < 0) {
            prefix = "";
            startContent = 0;
        }
        if ((endContent = toPos + this.contextSize) > contents.length()) {
            postfix = "";
            endContent = contents.length();
        }
        return prefix + contents.substring(startContent, endContent).replace('\n', ' ').replace('\r', ' ').replace('\t', ' ') + postfix + "\n" + ContextTools.getMarker(fromPos, toPos, startContent, endContent, prefix);
    }

    public void setErrorMarker(String start, String end) {
        this.errorMarkerStart = start;
        this.errorMarkerEnd = end;
    }

    public void setErrorMarkerStart(String errorMarkerStart) {
        this.errorMarkerStart = errorMarkerStart;
    }

    public void setErrorMarkerEnd(String errorMarkerEnd) {
        this.errorMarkerEnd = errorMarkerEnd;
    }

    public void setContextSize(int contextSize) {
        this.contextSize = contextSize;
    }

    public void setEscapeHtml(boolean escapeHtml) {
        this.escapeHtml = escapeHtml;
    }

    private static String getMarker(int fromPos, int toPos, int startContent, int endContent, String prefix) {
        return StringUtils.repeat((char)' ', (int)(prefix.length() + fromPos - startContent)) + StringUtils.repeat((char)'^', (int)(toPos - fromPos)) + StringUtils.repeat((char)' ', (int)(endContent - toPos));
    }
}

