/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.util.Collection;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class SizeBoundedQueue<T> {
    protected final Lock lock;
    protected final Condition not_full;
    protected final Condition not_empty;
    protected final int max_size;
    protected final Queue<El<T>> queue = new ConcurrentLinkedQueue<El<T>>();
    protected int count;
    protected int waiters;
    protected boolean done;

    public SizeBoundedQueue(int max_size) {
        this(max_size, new ReentrantLock(true));
    }

    public SizeBoundedQueue(int max_size, Lock lock) {
        this.lock = lock;
        this.max_size = max_size;
        if (lock == null) {
            throw new IllegalArgumentException("lock must not be null");
        }
        this.not_full = lock.newCondition();
        this.not_empty = lock.newCondition();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(T element, int size) throws InterruptedException {
        if (element == null) {
            throw new IllegalArgumentException("element cannot be null");
        }
        boolean incremented = false;
        this.lock.lockInterruptibly();
        try {
            while (!this.done && this.max_size - this.count - size < 0) {
                if (!incremented) {
                    incremented = true;
                    ++this.waiters;
                }
                this.not_full.await();
            }
            if (this.done) {
                return;
            }
            this.queue.add(new El<T>(element, size));
            boolean signal = this.count == 0;
            this.count += size;
            if (signal) {
                this.not_empty.signalAll();
            }
        }
        finally {
            if (incremented) {
                --this.waiters;
            }
            this.lock.unlock();
        }
    }

    public T remove() {
        this.lock.lock();
        try {
            if (this.done || this.queue.isEmpty()) {
                T t = null;
                return t;
            }
            El<T> el = this.queue.poll();
            this.count -= el.size;
            this.not_full.signalAll();
            Object t = el.el;
            return t;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int drainTo(Collection<T> c, int max_bytes) {
        if (c == null) {
            throw new IllegalArgumentException("collection to drain elements to must not be null");
        }
        if (max_bytes <= 0) {
            return 0;
        }
        int bytes = 0;
        boolean at_least_one_removed = false;
        this.lock.lock();
        try {
            El<T> el;
            while (!(this.done || (el = this.queue.peek()) == null && this.waiters <= 0)) {
                if (el != null) {
                    if (bytes + el.size > max_bytes) break;
                    el = this.queue.poll();
                    at_least_one_removed = true;
                    this.count -= el.size;
                    bytes += el.size;
                    c.add(el.el);
                    continue;
                }
                this.not_full.signalAll();
                try {
                    this.not_empty.await();
                }
                catch (InterruptedException e) {
                    // empty catch block
                    break;
                }
            }
            if (at_least_one_removed) {
                this.not_full.signalAll();
            }
            int n = bytes;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void clear(boolean done) {
        this.lock.lock();
        try {
            this.done = done;
            this.queue.clear();
            this.count = 0;
            this.not_full.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    public int getElements() {
        return this.queue.size();
    }

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public int getWaiters() {
        return this.waiters;
    }

    public boolean hasWaiters() {
        return this.waiters > 0;
    }

    public boolean isDone() {
        this.lock.lock();
        try {
            boolean bl = this.done;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public int queueSize() {
        return this.queue.stream().map(el -> el.size).reduce(0, Integer::sum);
    }

    public String toString() {
        return String.format("%d elements / %d bytes (%d waiters): %s", this.getElements(), this.size(), this.waiters, this.queue);
    }

    protected static class El<T> {
        protected final T el;
        protected final int size;

        public El(T el, int size) {
            this.el = el;
            this.size = size;
        }

        public String toString() {
            return String.format("%s (%d bytes)", this.el, this.size);
        }
    }
}

