/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.property.access.spi;

import java.io.Serializable;
import java.lang.reflect.Field;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hibernate.Internal;
import org.hibernate.property.access.internal.AbstractFieldSerialForm;
import org.hibernate.property.access.internal.AccessStrategyHelper;
import org.hibernate.property.access.spi.SetterFieldImpl;

@Internal
public class EnhancedSetterImpl
extends SetterFieldImpl {
    private final @UnknownKeyFor @NonNull @Initialized String propertyName;
    private final @UnknownKeyFor @NonNull @Initialized int enhancementState;

    public EnhancedSetterImpl(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> containerClass, @UnknownKeyFor @NonNull @Initialized String propertyName, @UnknownKeyFor @NonNull @Initialized Field field) {
        super(containerClass, propertyName, field);
        this.propertyName = propertyName;
        this.enhancementState = AccessStrategyHelper.determineEnhancementState(containerClass, field.getType());
    }

    @Override
    public void set(@UnknownKeyFor @NonNull @Initialized Object target, @Nullable @UnknownKeyFor @Initialized Object value) {
        super.set(target, value);
        AccessStrategyHelper.handleEnhancedInjection(target, value, this.enhancementState, this.propertyName);
    }

    private @UnknownKeyFor @NonNull @Initialized Object writeReplace() {
        return new SerialForm(this.getContainerClass(), this.propertyName, this.getField());
    }

    private static class SerialForm
    extends AbstractFieldSerialForm
    implements Serializable {
        private final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> containerClass;
        private final @UnknownKeyFor @NonNull @Initialized String propertyName;

        private SerialForm(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> containerClass, @UnknownKeyFor @NonNull @Initialized String propertyName, @UnknownKeyFor @NonNull @Initialized Field field) {
            super(field);
            this.containerClass = containerClass;
            this.propertyName = propertyName;
        }

        private @UnknownKeyFor @NonNull @Initialized Object readResolve() {
            return new EnhancedSetterImpl(this.containerClass, this.propertyName, this.resolveField());
        }
    }
}

