/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.painter.noise;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.DataBufferInt;
import java.awt.image.Kernel;
import org.jvnet.substance.api.SubstanceColorScheme;
import org.jvnet.substance.api.SubstanceSkin;
import org.jvnet.substance.painter.noise.NoiseFilter;
import org.jvnet.substance.utils.PerlinNoiseGenerator;
import org.jvnet.substance.utils.SubstanceColorUtilities;
import org.jvnet.substance.utils.SubstanceCoreUtilities;

public class NoiseFactory {
    public static BufferedImage getNoiseImage(SubstanceSkin skin, int width, int height, double xFactor, double yFactor, boolean hasConstantZ, NoiseFilter noiseFilter, boolean toBlur, boolean isPreview) {
        SubstanceColorScheme scheme = skin.getWatermarkColorScheme();
        Color c1 = scheme.getWatermarkDarkColor();
        Color c3 = scheme.getWatermarkLightColor();
        BufferedImage dst = SubstanceCoreUtilities.getBlankImage(width, height);
        int[] dstBuffer = ((DataBufferInt)dst.getRaster().getDataBuffer()).getData();
        double m2 = xFactor * (double)width * xFactor * (double)width + yFactor * (double)height * yFactor * (double)height;
        int pos = 0;
        for (int j = 0; j < height; ++j) {
            double jj = yFactor * (double)j;
            for (int i = 0; i < width; ++i) {
                double ii = xFactor * (double)i;
                double z = hasConstantZ ? 1.0 : Math.sqrt(m2 - ii * ii - jj * jj);
                double noise = 0.5 + 0.5 * PerlinNoiseGenerator.noise(ii, jj, z);
                if (noiseFilter != null) {
                    noise = noiseFilter.apply(i, j, z, noise);
                }
                double likeness = Math.max(0.0, Math.min(1.0, 2.0 * noise));
                dstBuffer[pos++] = SubstanceColorUtilities.getInterpolatedRGB(c3, c1, likeness);
            }
        }
        if (toBlur) {
            ConvolveOp convolve = new ConvolveOp(new Kernel(3, 3, new float[]{0.08f, 0.08f, 0.08f, 0.08f, 0.38f, 0.08f, 0.08f, 0.08f, 0.08f}), 1, null);
            dst = convolve.filter(dst, null);
        }
        return dst;
    }
}

