/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.3.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

A simplified wrapper around a variety of ITK transforms.


The interface to ITK transform objects to be used with the ImageRegistrationMethod, ResampleImageFilter and other SimpleITK process objects. The transforms are designed to
have a serialized array of parameters to facilitate optimization for
registration.

Provides a base class interface to any type of ITK transform. Objects
of this type may have their interface converted to a derived interface
while keeping the same reference to the ITK object.

Additionally, this class provides a basic interface to a composite
transforms.


See:
 itk::CompositeTransform


C++ includes: sitkTransform.h
*/
public class Transform {
  private transient long swigCPtr;
  protected transient boolean swigCMemOwn;

  protected Transform(long cPtr, boolean cMemoryOwn) {
    swigCMemOwn = cMemoryOwn;
    swigCPtr = cPtr;
  }

  protected static long getCPtr(Transform obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(Transform obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::Transform::~Transform()
*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_Transform(swigCPtr);
      }
      swigCPtr = 0;
    }
  }

  /**
itk::simple::Transform::Transform(unsigned int dimensions, TransformEnum type)

Construct a specific transformation.


Deprecated
This constructor will be removed in future releases.


*/
public  Transform() {
    this(SimpleITKJNI.new_Transform__SWIG_0(), true);
  }

  /**
itk::simple::Transform::Transform(unsigned int dimensions, TransformEnum type)

Construct a specific transformation.


Deprecated
This constructor will be removed in future releases.


*/
public  Transform(SWIGTYPE_p_itk__TransformBaseTemplateT_double_t transform) {
    this(SimpleITKJNI.new_Transform__SWIG_1(SWIGTYPE_p_itk__TransformBaseTemplateT_double_t.getCPtr(transform)), true);
  }

  /**
itk::simple::Transform::Transform(unsigned int dimensions, TransformEnum type)

Construct a specific transformation.


Deprecated
This constructor will be removed in future releases.


*/
public  Transform(long dimensions, TransformEnum type) {
    this(SimpleITKJNI.new_Transform__SWIG_2(dimensions, type.swigValue()), true);
  }

  /**
itk::simple::Transform::Transform(unsigned int dimensions, TransformEnum type)

Construct a specific transformation.


Deprecated
This constructor will be removed in future releases.


*/
public  Transform(Image displacement, TransformEnum type) {
    this(SimpleITKJNI.new_Transform__SWIG_3(Image.getCPtr(displacement), displacement, type.swigValue()), true);
  }

  /**
itk::simple::Transform::Transform(unsigned int dimensions, TransformEnum type)

Construct a specific transformation.


Deprecated
This constructor will be removed in future releases.


*/
public  Transform(Image displacement) {
    this(SimpleITKJNI.new_Transform__SWIG_4(Image.getCPtr(displacement), displacement), true);
  }

  /**
itk::simple::Transform::Transform(unsigned int dimensions, TransformEnum type)

Construct a specific transformation.


Deprecated
This constructor will be removed in future releases.


*/
public  Transform(Transform arg0) {
    this(SimpleITKJNI.new_Transform__SWIG_5(Transform.getCPtr(arg0), arg0), true);
  }

  public SWIGTYPE_p_itk__TransformBaseTemplateT_double_t getITKBase() {
    long cPtr = SimpleITKJNI.Transform_getITKBase__SWIG_0(swigCPtr, this);
    return (cPtr == 0) ? null : new SWIGTYPE_p_itk__TransformBaseTemplateT_double_t(cPtr, false);
  }

  /**
unsigned int itk::simple::Transform::GetDimension() const

Return the dimension of the Transform ( 2D or 3D )

*/
public  long getDimension() {
    return SimpleITKJNI.Transform_getDimension(swigCPtr, this);
  }

  public void setParameters(VectorDouble parameters) {
    SimpleITKJNI.Transform_setParameters(swigCPtr, this, VectorDouble.getCPtr(parameters), parameters);
  }

  public VectorDouble getParameters() {
    return new VectorDouble(SimpleITKJNI.Transform_getParameters(swigCPtr, this), true);
  }

  /**
unsigned int itk::simple::Transform::GetNumberOfParameters() const

Return the number of optimizable parameters

*/
public  long getNumberOfParameters() {
    return SimpleITKJNI.Transform_getNumberOfParameters(swigCPtr, this);
  }

  public void setFixedParameters(VectorDouble parameters) {
    SimpleITKJNI.Transform_setFixedParameters(swigCPtr, this, VectorDouble.getCPtr(parameters), parameters);
  }

  public VectorDouble getFixedParameters() {
    return new VectorDouble(SimpleITKJNI.Transform_getFixedParameters(swigCPtr, this), true);
  }

  /**
unsigned int itk::simple::Transform::GetNumberOfFixedParameters() const

Get the number of fixed parameters

*/
public  long getNumberOfFixedParameters() {
    return SimpleITKJNI.Transform_getNumberOfFixedParameters(swigCPtr, this);
  }

  /**
std::vector&lt;double&gt; itk::simple::Transform::TransformPoint(const std::vector&lt; double &gt; &amp;point) const

Apply transform to a point.

The dimension of the point must match the transform.

*/
public  VectorDouble transformPoint(VectorDouble point) {
    return new VectorDouble(SimpleITKJNI.Transform_transformPoint(swigCPtr, this, VectorDouble.getCPtr(point), point), true);
  }

  /**
std::vector&lt;double&gt; itk::simple::Transform::TransformVector(const std::vector&lt; double &gt; &amp;vector, const std::vector&lt;
double &gt; &amp;point) const

Apply transform to a vector at a point.

The ITK concept of a vector is a direction at a specific point, for
example the difference between two points is a vector.

For linear transforms the point does not matter, in general the vector
is transformed by the Jacobian with respect to point position.

The dimension of the vector and point must match the transform.

*/
public  VectorDouble transformVector(VectorDouble vector, VectorDouble point) {
    return new VectorDouble(SimpleITKJNI.Transform_transformVector(swigCPtr, this, VectorDouble.getCPtr(vector), vector, VectorDouble.getCPtr(point), point), true);
  }

  /**
void itk::simple::Transform::WriteTransform(const std::string &amp;filename) const
*/
public  void writeTransform(String filename) {
    SimpleITKJNI.Transform_writeTransform(swigCPtr, this, filename);
  }

  /**
virtual bool itk::simple::Transform::IsLinear() const
*/
public  boolean isLinear() {
    return SimpleITKJNI.Transform_isLinear(swigCPtr, this);
  }

  /**
virtual void itk::simple::Transform::SetIdentity()
*/
public  void setIdentity() {
    SimpleITKJNI.Transform_setIdentity(swigCPtr, this);
  }

  /**
virtual bool itk::simple::Transform::SetInverse()

Try to change the current transform to it's inverse.


If the transform has an inverse, i.e. non-singular linear transforms,
then a new ITK transform is created of the same type and this object
is set to it.

However not all transform have a direct inverse, if the inverse does
not exist or fails false will be returned and this transform will not
be modified.

*/
public  boolean setInverse() {
    return SimpleITKJNI.Transform_setInverse(swigCPtr, this);
  }

  /**
Transform itk::simple::Transform::GetInverse() const

Return a new inverse transform of the same type as this.


Creates a new transform object and tries to set the value to the
inverse. As not all transform types have inverse and some transforms
are not invertible, an exception will be throw is there is no inverse.

*/
public  Transform getInverse() {
    return new Transform(SimpleITKJNI.Transform_getInverse(swigCPtr, this), true);
  }

  /**
std::string itk::simple::Transform::ToString() const
*/
public  String toString() {
    return SimpleITKJNI.Transform_toString(swigCPtr, this);
  }

  /**
virtual std::string itk::simple::Transform::GetName() const

return user readable name for the SimpleITK transform

*/
public  String getName() {
    return SimpleITKJNI.Transform_getName(swigCPtr, this);
  }

  /**
void itk::simple::Transform::MakeUnique()

Performs actually coping if needed to make object unique.


The Transform class by default performs lazy coping and assignment. This method
make sure that coping actually happens to the itk::Transform pointed to is only pointed to by this object.

*/
public  void makeUnique() {
    SimpleITKJNI.Transform_makeUnique(swigCPtr, this);
  }

  /**
TransformEnum itk::simple::Transform::GetTransformEnum() const

Get the TransformEnum of the underlying Transform.


A SimpleITK Transform object can internally hold any ITK transform. This method returns the
TransformEnum representing the internal ITK transform. This value may
be used to identify which SimpleITK class the transform can be
converted to.

*/
public  TransformEnum getTransformEnum() {
    return TransformEnum.swigToEnum(SimpleITKJNI.Transform_getTransformEnum(swigCPtr, this));
  }

}
