/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.3.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Simple Linear Iterative Clustering (SLIC) super-pixel segmentation.


The Simple Linear Iterative Clustering (SLIC) algorithm groups pixels
into a set of labeled regions or super-pixels. Super-pixels follow
natural image boundaries, are compact, and are nearly uniform regions
which can be used as a larger primitive for more efficient
computation. The SLIC algorithm can be viewed as a spatially
constrained iterative k-means method.

The original algorithm was designed to cluster on the joint domain of
the images index space and its CIELAB color space. This implementation
works with images of arbitrary dimension as well as scalar, single
channel, images and most multi-component image types including ITK's
arbitrary length VectorImage .

The distance between a pixel and a cluster is the sum of squares of
the difference between their joint range and domains ( index and value
). The computation is done in index space with scales provided by the
SpatialProximityWeight parameters.

The output is a label image with each label representing a superpixel
cluster. Every pixel in the output is labeled, and the starting label
id is zero.

This code was contributed in the Insight Journal paper: "Scalable
Simple Linear Iterative Clustering (SSLIC) Using a Generic and
Parallel Approach" by Lowekamp B. C., Chen D. T., Yaniv Z., Yoo T. S. https://doi.org/10.54294/8hic7f
See:
 itk::simple::SLIC for the procedural interface

 itk::SLICImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkSLICImageFilter.h
*/
public class SLICImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected SLICImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.SLICImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(SLICImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(SLICImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::SLICImageFilter::~SLICImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_SLICImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::SLICImageFilter::SLICImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  SLICImageFilter() {
    this(SimpleITKJNI.new_SLICImageFilter(), true);
  }

  /**
Self&amp; itk::simple::SLICImageFilter::SetSuperGridSize(std::vector&lt; unsigned int &gt; SuperGridSize)
*/
public  void setSuperGridSize(VectorUInt32 SuperGridSize) {
    SimpleITKJNI.SLICImageFilter_setSuperGridSize(swigCPtr, this, VectorUInt32.getCPtr(SuperGridSize), SuperGridSize);
  }

  /**
std::vector&lt;unsigned int&gt; itk::simple::SLICImageFilter::GetSuperGridSize() const
*/
public  VectorUInt32 getSuperGridSize() {
    return new VectorUInt32(SimpleITKJNI.SLICImageFilter_getSuperGridSize(swigCPtr, this), true);
  }

  /**
Self&amp; itk::simple::SLICImageFilter::SetSpatialProximityWeight(double SpatialProximityWeight)

The spatial weight for the distance function. Increasing this value
makes the superpixel shape more regular, but more varied in image
values. The range of the pixel values and image dimension can effect
the appropriate value.

*/
public  void setSpatialProximityWeight(double SpatialProximityWeight) {
    SimpleITKJNI.SLICImageFilter_setSpatialProximityWeight(swigCPtr, this, SpatialProximityWeight);
  }

  /**
double itk::simple::SLICImageFilter::GetSpatialProximityWeight() const
*/
public  double getSpatialProximityWeight() {
    return SimpleITKJNI.SLICImageFilter_getSpatialProximityWeight(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::SLICImageFilter::SetMaximumNumberOfIterations(uint32_t MaximumNumberOfIterations)

Number of iterations to run. Specify the number of iterations to run
when optimizing the clusters.

*/
public  void setMaximumNumberOfIterations(long MaximumNumberOfIterations) {
    SimpleITKJNI.SLICImageFilter_setMaximumNumberOfIterations(swigCPtr, this, MaximumNumberOfIterations);
  }

  /**
uint32_t itk::simple::SLICImageFilter::GetMaximumNumberOfIterations() const
*/
public  long getMaximumNumberOfIterations() {
    return SimpleITKJNI.SLICImageFilter_getMaximumNumberOfIterations(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::SLICImageFilter::SetEnforceConnectivity(bool EnforceConnectivity)

Post processing step to enforce superpixel morphology. Enable an
additional computation which ensures all label pixels of the same
value are spatially connected. Disconnected labeled components are
assigned a new value if of sufficient size, or are relabeled to the
previously encountered value if small.

*/
public  void setEnforceConnectivity(boolean EnforceConnectivity) {
    SimpleITKJNI.SLICImageFilter_setEnforceConnectivity(swigCPtr, this, EnforceConnectivity);
  }

  /**
Self&amp; itk::simple::SLICImageFilter::EnforceConnectivityOn()

Set the value of EnforceConnectivity to true or false respectfully.

*/
public  void enforceConnectivityOn() {
    SimpleITKJNI.SLICImageFilter_enforceConnectivityOn(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::SLICImageFilter::EnforceConnectivityOff()
*/
public  void enforceConnectivityOff() {
    SimpleITKJNI.SLICImageFilter_enforceConnectivityOff(swigCPtr, this);
  }

  /**
bool itk::simple::SLICImageFilter::GetEnforceConnectivity() const
*/
public  boolean getEnforceConnectivity() {
    return SimpleITKJNI.SLICImageFilter_getEnforceConnectivity(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::SLICImageFilter::SetInitializationPerturbation(bool InitializationPerturbation)

Enable perturbation of initial cluster center location. After grid
based initialization, this option enables moving the initial cluster
center location to the minimum gradient in a small neighborhood. If
the grid size is less than three this is automatically disabled.

*/
public  void setInitializationPerturbation(boolean InitializationPerturbation) {
    SimpleITKJNI.SLICImageFilter_setInitializationPerturbation(swigCPtr, this, InitializationPerturbation);
  }

  /**
Self&amp; itk::simple::SLICImageFilter::InitializationPerturbationOn()

Set the value of InitializationPerturbation to true or false
respectfully.

*/
public  void initializationPerturbationOn() {
    SimpleITKJNI.SLICImageFilter_initializationPerturbationOn(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::SLICImageFilter::InitializationPerturbationOff()
*/
public  void initializationPerturbationOff() {
    SimpleITKJNI.SLICImageFilter_initializationPerturbationOff(swigCPtr, this);
  }

  /**
bool itk::simple::SLICImageFilter::GetInitializationPerturbation() const
*/
public  boolean getInitializationPerturbation() {
    return SimpleITKJNI.SLICImageFilter_getInitializationPerturbation(swigCPtr, this);
  }

  /**
double itk::simple::SLICImageFilter::GetAverageResidual() const

Get the current average cluster residual. After each iteration the
residual is computed as the distance between the current clusters and
the previous. This is averaged so that the value is independent of the
number of clusters.


This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public  double getAverageResidual() {
    return SimpleITKJNI.SLICImageFilter_getAverageResidual(swigCPtr, this);
  }

  /**
std::string itk::simple::SLICImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.SLICImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::SLICImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.SLICImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::SLICImageFilter::Execute(const Image &amp;image1)

Execute the filter on the input image

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.SLICImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

}
