/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.3.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Deconvolve an image using the projected Landweber deconvolution
algorithm.


This filter performs the same calculation per iteration as the LandweberDeconvolutionImageFilter . However, at each iteration, negative pixels in the intermediate
result are projected (set) to zero. This is useful if the solution is
assumed to always be non-negative, which is the case when dealing with
images formed by counting photons, for example.

This code was adapted from the Insight Journal contribution:

"Deconvolution: infrastructure and reference algorithms" by Gaetan
Lehmann https://doi.org/10.54294/tvgfv1


Gaetan Lehmann, Biologie du Developpement et de la Reproduction, INRA
de Jouy-en-Josas, France

Cory Quammen, The University of North Carolina at Chapel Hill

See:
 IterativeDeconvolutionImageFilter

 RichardsonLucyDeconvolutionImageFilter

 LandweberDeconvolutionImageFilter

 itk::simple::ProjectedLandweberDeconvolution for the procedural interface

 itk::ProjectedLandweberDeconvolutionImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkProjectedLandweberDeconvolutionImageFilter.h
*/
public class ProjectedLandweberDeconvolutionImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected ProjectedLandweberDeconvolutionImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.ProjectedLandweberDeconvolutionImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(ProjectedLandweberDeconvolutionImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(ProjectedLandweberDeconvolutionImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::ProjectedLandweberDeconvolutionImageFilter::~ProjectedLandweberDeconvolutionImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_ProjectedLandweberDeconvolutionImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::ProjectedLandweberDeconvolutionImageFilter::ProjectedLandweberDeconvolutionImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  ProjectedLandweberDeconvolutionImageFilter() {
    this(SimpleITKJNI.new_ProjectedLandweberDeconvolutionImageFilter(), true);
  }

  /**
Self&amp; itk::simple::ProjectedLandweberDeconvolutionImageFilter::SetAlpha(double Alpha)

Set the relaxation factor.

*/
public  void setAlpha(double Alpha) {
    SimpleITKJNI.ProjectedLandweberDeconvolutionImageFilter_setAlpha(swigCPtr, this, Alpha);
  }

  /**
double itk::simple::ProjectedLandweberDeconvolutionImageFilter::GetAlpha() const

Get the relaxation factor.

*/
public  double getAlpha() {
    return SimpleITKJNI.ProjectedLandweberDeconvolutionImageFilter_getAlpha(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::ProjectedLandweberDeconvolutionImageFilter::SetNumberOfIterations(int NumberOfIterations)

Set the number of iterations.

*/
public  void setNumberOfIterations(int NumberOfIterations) {
    SimpleITKJNI.ProjectedLandweberDeconvolutionImageFilter_setNumberOfIterations(swigCPtr, this, NumberOfIterations);
  }

  /**
int itk::simple::ProjectedLandweberDeconvolutionImageFilter::GetNumberOfIterations() const

Get the number of iterations.

*/
public  int getNumberOfIterations() {
    return SimpleITKJNI.ProjectedLandweberDeconvolutionImageFilter_getNumberOfIterations(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::ProjectedLandweberDeconvolutionImageFilter::SetNormalize(bool Normalize)

Normalize the output image by the sum of the kernel components

*/
public  void setNormalize(boolean Normalize) {
    SimpleITKJNI.ProjectedLandweberDeconvolutionImageFilter_setNormalize(swigCPtr, this, Normalize);
  }

  /**
Self&amp; itk::simple::ProjectedLandweberDeconvolutionImageFilter::NormalizeOn()

Set the value of Normalize to true or false respectfully.

*/
public  void normalizeOn() {
    SimpleITKJNI.ProjectedLandweberDeconvolutionImageFilter_normalizeOn(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::ProjectedLandweberDeconvolutionImageFilter::NormalizeOff()
*/
public  void normalizeOff() {
    SimpleITKJNI.ProjectedLandweberDeconvolutionImageFilter_normalizeOff(swigCPtr, this);
  }

  /**
bool itk::simple::ProjectedLandweberDeconvolutionImageFilter::GetNormalize() const
*/
public  boolean getNormalize() {
    return SimpleITKJNI.ProjectedLandweberDeconvolutionImageFilter_getNormalize(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::ProjectedLandweberDeconvolutionImageFilter::SetBoundaryCondition(BoundaryConditionType BoundaryCondition)
*/
public  void setBoundaryCondition(ProjectedLandweberDeconvolutionImageFilter.BoundaryConditionType BoundaryCondition) {
    SimpleITKJNI.ProjectedLandweberDeconvolutionImageFilter_setBoundaryCondition(swigCPtr, this, BoundaryCondition.swigValue());
  }

  /**
BoundaryConditionType itk::simple::ProjectedLandweberDeconvolutionImageFilter::GetBoundaryCondition() const
*/
public  ProjectedLandweberDeconvolutionImageFilter.BoundaryConditionType getBoundaryCondition() {
    return ProjectedLandweberDeconvolutionImageFilter.BoundaryConditionType.swigToEnum(SimpleITKJNI.ProjectedLandweberDeconvolutionImageFilter_getBoundaryCondition(swigCPtr, this));
  }

  /**
Self&amp; itk::simple::ProjectedLandweberDeconvolutionImageFilter::SetOutputRegionMode(OutputRegionModeType OutputRegionMode)
*/
public  void setOutputRegionMode(ProjectedLandweberDeconvolutionImageFilter.OutputRegionModeType OutputRegionMode) {
    SimpleITKJNI.ProjectedLandweberDeconvolutionImageFilter_setOutputRegionMode(swigCPtr, this, OutputRegionMode.swigValue());
  }

  /**
OutputRegionModeType itk::simple::ProjectedLandweberDeconvolutionImageFilter::GetOutputRegionMode() const
*/
public  ProjectedLandweberDeconvolutionImageFilter.OutputRegionModeType getOutputRegionMode() {
    return ProjectedLandweberDeconvolutionImageFilter.OutputRegionModeType.swigToEnum(SimpleITKJNI.ProjectedLandweberDeconvolutionImageFilter_getOutputRegionMode(swigCPtr, this));
  }

  /**
std::string itk::simple::ProjectedLandweberDeconvolutionImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.ProjectedLandweberDeconvolutionImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::ProjectedLandweberDeconvolutionImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.ProjectedLandweberDeconvolutionImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::ProjectedLandweberDeconvolutionImageFilter::Execute(const Image &amp;image1, const Image &amp;image2)

Execute the filter on the input images

*/
public  Image execute(Image image1, Image image2) {
    return new Image(SimpleITKJNI.ProjectedLandweberDeconvolutionImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1, Image.getCPtr(image2), image2), true);
  }

  public final static class BoundaryConditionType {
    public final static ProjectedLandweberDeconvolutionImageFilter.BoundaryConditionType ZERO_PAD = new ProjectedLandweberDeconvolutionImageFilter.BoundaryConditionType("ZERO_PAD");
    public final static ProjectedLandweberDeconvolutionImageFilter.BoundaryConditionType ZERO_FLUX_NEUMANN_PAD = new ProjectedLandweberDeconvolutionImageFilter.BoundaryConditionType("ZERO_FLUX_NEUMANN_PAD");
    public final static ProjectedLandweberDeconvolutionImageFilter.BoundaryConditionType PERIODIC_PAD = new ProjectedLandweberDeconvolutionImageFilter.BoundaryConditionType("PERIODIC_PAD");

    public final int swigValue() {
      return swigValue;
    }

    public String toString() {
      return swigName;
    }

    public static BoundaryConditionType swigToEnum(int swigValue) {
      if (swigValue < swigValues.length && swigValue >= 0 && swigValues[swigValue].swigValue == swigValue)
        return swigValues[swigValue];
      for (int i = 0; i < swigValues.length; i++)
        if (swigValues[i].swigValue == swigValue)
          return swigValues[i];
      throw new IllegalArgumentException("No enum " + BoundaryConditionType.class + " with value " + swigValue);
    }

    private BoundaryConditionType(String swigName) {
      this.swigName = swigName;
      this.swigValue = swigNext++;
    }

    private BoundaryConditionType(String swigName, int swigValue) {
      this.swigName = swigName;
      this.swigValue = swigValue;
      swigNext = swigValue+1;
    }

    private BoundaryConditionType(String swigName, BoundaryConditionType swigEnum) {
      this.swigName = swigName;
      this.swigValue = swigEnum.swigValue;
      swigNext = this.swigValue+1;
    }

    private static BoundaryConditionType[] swigValues = { ZERO_PAD, ZERO_FLUX_NEUMANN_PAD, PERIODIC_PAD };
    private static int swigNext = 0;
    private final int swigValue;
    private final String swigName;
  }

  public final static class OutputRegionModeType {
    public final static ProjectedLandweberDeconvolutionImageFilter.OutputRegionModeType SAME = new ProjectedLandweberDeconvolutionImageFilter.OutputRegionModeType("SAME");
    public final static ProjectedLandweberDeconvolutionImageFilter.OutputRegionModeType VALID = new ProjectedLandweberDeconvolutionImageFilter.OutputRegionModeType("VALID");

    public final int swigValue() {
      return swigValue;
    }

    public String toString() {
      return swigName;
    }

    public static OutputRegionModeType swigToEnum(int swigValue) {
      if (swigValue < swigValues.length && swigValue >= 0 && swigValues[swigValue].swigValue == swigValue)
        return swigValues[swigValue];
      for (int i = 0; i < swigValues.length; i++)
        if (swigValues[i].swigValue == swigValue)
          return swigValues[i];
      throw new IllegalArgumentException("No enum " + OutputRegionModeType.class + " with value " + swigValue);
    }

    private OutputRegionModeType(String swigName) {
      this.swigName = swigName;
      this.swigValue = swigNext++;
    }

    private OutputRegionModeType(String swigName, int swigValue) {
      this.swigName = swigName;
      this.swigValue = swigValue;
      swigNext = swigValue+1;
    }

    private OutputRegionModeType(String swigName, OutputRegionModeType swigEnum) {
      this.swigName = swigName;
      this.swigValue = swigEnum.swigValue;
      swigNext = this.swigValue+1;
    }

    private static OutputRegionModeType[] swigValues = { SAME, VALID };
    private static int swigNext = 0;
    private final int swigValue;
    private final String swigName;
  }

}
