/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.3.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Grayscale erosion of an image.


Erode an image using grayscale morphology. Erosion takes the maximum
of all the pixels identified by the structuring element.

The structuring element is assumed to be composed of binary values
(zero or one). Only elements of the structuring element having values
&gt; 0 are candidates for affecting the center pixel.


See:
 MorphologyImageFilter , GrayscaleFunctionErodeImageFilter , BinaryErodeImageFilter

 itk::simple::GrayscaleErode for the procedural interface

 itk::GrayscaleErodeImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkGrayscaleErodeImageFilter.h
*/
public class GrayscaleErodeImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected GrayscaleErodeImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.GrayscaleErodeImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(GrayscaleErodeImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(GrayscaleErodeImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::GrayscaleErodeImageFilter::~GrayscaleErodeImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_GrayscaleErodeImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::GrayscaleErodeImageFilter::GrayscaleErodeImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  GrayscaleErodeImageFilter() {
    this(SimpleITKJNI.new_GrayscaleErodeImageFilter(), true);
  }

  /**
Self&amp; itk::simple::GrayscaleErodeImageFilter::SetKernelRadius(unsigned int value)

Set the values of the KernelRadius vector all to value

*/
public  void setKernelRadius(VectorUInt32 KernelRadius) {
    SimpleITKJNI.GrayscaleErodeImageFilter_setKernelRadius__SWIG_0(swigCPtr, this, VectorUInt32.getCPtr(KernelRadius), KernelRadius);
  }

  /**
Self&amp; itk::simple::GrayscaleErodeImageFilter::SetKernelRadius(unsigned int value)

Set the values of the KernelRadius vector all to value

*/
public  void setKernelRadius(long value) {
    SimpleITKJNI.GrayscaleErodeImageFilter_setKernelRadius__SWIG_1(swigCPtr, this, value);
  }

  /**
std::vector&lt;unsigned int&gt; itk::simple::GrayscaleErodeImageFilter::GetKernelRadius() const

Get the radius of the kernel structuring element.

*/
public  VectorUInt32 getKernelRadius() {
    return new VectorUInt32(SimpleITKJNI.GrayscaleErodeImageFilter_getKernelRadius(swigCPtr, this), true);
  }

  /**
Self&amp; itk::simple::GrayscaleErodeImageFilter::SetKernelType(KernelEnum KernelType)

Set the kernel or structuring element used for the morphology.

*/
public  void setKernelType(KernelEnum KernelType) {
    SimpleITKJNI.GrayscaleErodeImageFilter_setKernelType(swigCPtr, this, KernelType.swigValue());
  }

  /**
KernelEnum itk::simple::GrayscaleErodeImageFilter::GetKernelType() const

Get the kernel or structuring element used for the morphology.

*/
public  KernelEnum getKernelType() {
    return KernelEnum.swigToEnum(SimpleITKJNI.GrayscaleErodeImageFilter_getKernelType(swigCPtr, this));
  }

  /**
std::string itk::simple::GrayscaleErodeImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.GrayscaleErodeImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::GrayscaleErodeImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.GrayscaleErodeImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::GrayscaleErodeImageFilter::Execute(const Image &amp;image1)

Execute the filter on the input image

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.GrayscaleErodeImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

}
